/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.collection;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringKeyedMapAdapter
extends AbstractMap<String, Object> {
    private Set<Map.Entry<String, Object>> entries;

    protected abstract Object getAttribute(String var1);

    protected abstract void setAttribute(String var1, Object var2);

    protected abstract void removeAttribute(String var1);

    protected abstract Iterator<String> getAttributeNames();

    @Override
    public void clear() {
        this.entries = null;
        Iterator<String> keys = this.getAttributeNames();
        while (keys.hasNext()) {
            this.removeAttribute(keys.next());
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.entries == null) {
            this.entries = new HashSet<Map.Entry<String, Object>>();
            Iterator<String> iterator = this.getAttributeNames();
            while (iterator.hasNext()) {
                final String key = iterator.next();
                final Object value = this.getAttribute(key);
                this.entries.add(new Map.Entry<String, Object>(){

                    @Override
                    public boolean equals(Object obj) {
                        Map.Entry entry = (Map.Entry)obj;
                        return (key == null ? entry.getKey() == null : key.equals(entry.getKey())) && (value == null ? entry.getValue() == null : value.equals(entry.getValue()));
                    }

                    @Override
                    public int hashCode() {
                        return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
                    }

                    @Override
                    public String getKey() {
                        return key;
                    }

                    @Override
                    public Object getValue() {
                        return value;
                    }

                    @Override
                    public Object setValue(Object obj) {
                        StringKeyedMapAdapter.this.setAttribute(key, obj);
                        return value;
                    }
                });
            }
        }
        return this.entries;
    }

    @Override
    public Object get(Object key) {
        return this.getAttribute(key.toString());
    }

    @Override
    public Object put(String key, Object value) {
        this.entries = null;
        Object previous = this.get(key);
        this.setAttribute(key, value);
        return previous;
    }

    @Override
    public Object remove(Object key) {
        this.entries = null;
        Object value = this.get(key);
        this.removeAttribute(key.toString());
        return value;
    }
}

