/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.ui;

import java.util.concurrent.TimeUnit;
import org.apache.commons.text.StringEscapeUtils;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

public final class UIUtils$ {
    public static final UIUtils$ MODULE$ = new UIUtils$();

    public String shortTimeUnitString(TimeUnit unit) {
        String string;
        TimeUnit timeUnit = unit;
        if (((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)timeUnit)) {
            string = "ns";
        } else if (((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)timeUnit)) {
            string = "us";
        } else if (((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)timeUnit)) {
            string = "ms";
        } else if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit)) {
            string = "sec";
        } else if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit)) {
            string = "min";
        } else if (((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit)) {
            string = "hrs";
        } else if (((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit)) {
            string = "days";
        } else {
            throw new MatchError((Object)timeUnit);
        }
        return string;
    }

    public Tuple2<Object, TimeUnit> normalizeDuration(long milliseconds) {
        if (milliseconds < 1000L) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)milliseconds), (Object)TimeUnit.MILLISECONDS);
        }
        double seconds = (double)milliseconds / (double)1000;
        if (seconds < (double)60) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)seconds), (Object)TimeUnit.SECONDS);
        }
        double minutes = seconds / (double)60;
        if (minutes < (double)60) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)minutes), (Object)TimeUnit.MINUTES);
        }
        double hours = minutes / (double)60;
        if (hours < (double)24) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)hours), (Object)TimeUnit.HOURS);
        }
        double days = hours / (double)24;
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)days), (Object)TimeUnit.DAYS);
    }

    public double convertToTimeUnit(long milliseconds, TimeUnit unit) {
        double d;
        TimeUnit timeUnit = unit;
        if (((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)timeUnit)) {
            d = milliseconds * 1000L * 1000L;
        } else if (((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)timeUnit)) {
            d = milliseconds * 1000L;
        } else if (((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)timeUnit)) {
            d = milliseconds;
        } else if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit)) {
            d = (double)milliseconds / 1000.0;
        } else if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit)) {
            d = (double)milliseconds / 1000.0 / 60.0;
        } else if (((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit)) {
            d = (double)milliseconds / 1000.0 / 60.0 / 60.0;
        } else if (((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit)) {
            d = (double)milliseconds / 1000.0 / 60.0 / 60.0 / 24.0;
        } else {
            throw new MatchError((Object)timeUnit);
        }
        return d;
    }

    public String createOutputOperationFailureForUI(String failure) {
        String string;
        if (failure.startsWith("org.apache.spark.Spark")) {
            string = new StringBuilder(30).append("Failed due to Spark job error\n").append(failure).toString();
        } else {
            int nextLineIndex = failure.indexOf("\n");
            if (nextLineIndex < 0) {
                nextLineIndex = failure.length();
            }
            String firstLine = failure.substring(0, nextLineIndex);
            string = new StringBuilder(22).append("Failed due to error: ").append(firstLine).append("\n").append(failure).toString();
        }
        return string;
    }

    public scala.collection.immutable.Seq<Node> failureReasonCell(String failureReason, int rowspan, boolean includeFirstLineInExpandDetails) {
        Elem elem;
        boolean isMultiline = failureReason.indexOf(10) >= 0;
        String failureReasonSummary = StringEscapeUtils.escapeHtml4((String)(isMultiline ? failureReason.substring(0, failureReason.indexOf(10)) : failureReason));
        String failureDetails = isMultiline && !includeFirstLineInExpandDetails ? failureReason.substring(failureReason.indexOf(10) + 1) : failureReason;
        scala.collection.immutable.Seq details = org.apache.spark.ui.UIUtils$.MODULE$.detailsUINode(isMultiline, failureDetails);
        if (rowspan == 1) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("style", (Seq)new Text("max-width: 300px"), (MetaData)$md);
            $md = new UnprefixedAttribute("valign", (Seq)new Text("middle"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)failureReasonSummary);
            $buf.$amp$plus((Object)details);
            Elem elem2 = new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
            elem = elem2;
        } else {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("rowspan", Integer.toString(rowspan), (MetaData)$md);
            $md = new UnprefixedAttribute("style", (Seq)new Text("max-width: 300px"), (MetaData)$md);
            $md = new UnprefixedAttribute("valign", (Seq)new Text("middle"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)failureReasonSummary);
            $buf.$amp$plus((Object)details);
            $buf.$amp$plus((Object)new Text("\n      "));
            Elem elem3 = new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
            elem = elem3;
        }
        return elem;
    }

    public int failureReasonCell$default$2() {
        return 1;
    }

    public boolean failureReasonCell$default$3() {
        return true;
    }

    private UIUtils$() {
    }
}

