/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.util;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.classification.ClassifierParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class DatasetUtils$
implements Logging {
    public static final DatasetUtils$ MODULE$ = new DatasetUtils$();
    private static UserDefinedFunction validateVector;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Column checkNonNanValues(String colName, String displayed) {
        Column casted = functions$.MODULE$.col(colName).cast((DataType)DoubleType$.MODULE$);
        return functions$.MODULE$.when(casted.isNull().$bar$bar((Object)casted.isNaN()), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)new StringBuilder(24).append(displayed).append(" MUST NOT be Null or NaN").toString()))).when(casted.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY)).$bar$bar((Object)casted.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY))), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)new StringBuilder(31).append(displayed).append(" MUST NOT be Infinity, but got ").toString()), casted})))).otherwise((Object)casted);
    }

    public Column checkRegressionLabels(String labelCol) {
        return this.checkNonNanValues(labelCol, "Labels");
    }

    public Column checkClassificationLabels(String labelCol, Option<Object> numClasses) {
        Column column;
        Some some;
        int n;
        Column casted = functions$.MODULE$.col(labelCol).cast((DataType)DoubleType$.MODULE$);
        Option<Object> option = numClasses;
        if (option instanceof Some && 2 == (n = BoxesRunTime.unboxToInt((Object)(some = (Some)option).value()))) {
            column = functions$.MODULE$.when(casted.isNull().$bar$bar((Object)casted.isNaN()), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"Labels MUST NOT be Null or NaN"))).when(casted.$eq$bang$eq((Object)BoxesRunTime.boxToInteger((int)0)).$amp$amp((Object)casted.$eq$bang$eq((Object)BoxesRunTime.boxToInteger((int)1))), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"Labels MUST be in {0, 1}, but got "), casted})))).otherwise((Object)casted);
        } else {
            int n2 = BoxesRunTime.unboxToInt((Object)numClasses.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Integer.MAX_VALUE));
            Predef$.MODULE$.require(0 < n2 && n2 <= Integer.MAX_VALUE);
            column = functions$.MODULE$.when(casted.isNull().$bar$bar((Object)casted.isNaN()), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"Labels MUST NOT be Null or NaN"))).when(casted.$less((Object)BoxesRunTime.boxToInteger((int)0)).$bar$bar((Object)casted.$greater$eq((Object)BoxesRunTime.boxToInteger((int)n2))), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)new StringBuilder(33).append("Labels MUST be in [0, ").append(n2).append("), but got ").toString()), casted})))).when(casted.$eq$bang$eq((Object)casted.cast((DataType)IntegerType$.MODULE$)), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"Labels MUST be Integers, but got "), casted})))).otherwise((Object)casted);
        }
        return column;
    }

    public Column checkNonNegativeWeights(String weightCol) {
        Column casted = functions$.MODULE$.col(weightCol).cast((DataType)DoubleType$.MODULE$);
        return functions$.MODULE$.when(casted.isNull().$bar$bar((Object)casted.isNaN()), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"Weights MUST NOT be Null or NaN"))).when(casted.$less((Object)BoxesRunTime.boxToInteger((int)0)).$bar$bar((Object)casted.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY))), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"Weights MUST NOT be Negative or Infinity, but got "), casted})))).otherwise((Object)casted);
    }

    public Column checkNonNegativeWeights(Option<String> weightCol) {
        Some some;
        String w;
        Option<String> option = weightCol;
        Column column = option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(w = (String)(some = (Some)option).value())) ? this.checkNonNegativeWeights(w) : functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
        return column;
    }

    public Column checkNonNanVectors(Column vectorCol) {
        return functions$.MODULE$.when(vectorCol.isNull(), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"Vectors MUST NOT be Null"))).when(this.validateVector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{vectorCol})).unary_$bang(), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"Vector values MUST NOT be NaN or Infinity, but got "), vectorCol.cast((DataType)StringType$.MODULE$)})))).otherwise((Object)vectorCol);
    }

    public Column checkNonNanVectors(String vectorCol) {
        return this.checkNonNanVectors(functions$.MODULE$.col(vectorCol));
    }

    private UserDefinedFunction validateVector$lzycompute() {
        DatasetUtils$ datasetUtils$ = this;
        synchronized (datasetUtils$) {
            if (!bitmap$0) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Org_apache_spark_ml_util_DatasetUtils$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_util_DatasetUtils$$typecreator1$1() {
                    }
                }
                validateVector = functions$.MODULE$.udf((Function1 & Serializable)vector -> BoxesRunTime.boxToBoolean((boolean)DatasetUtils$.$anonfun$validateVector$1(vector)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Boolean(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_DatasetUtils$$typecreator1$1()));
                bitmap$0 = true;
            }
        }
        return validateVector;
    }

    private UserDefinedFunction validateVector() {
        return !bitmap$0 ? this.validateVector$lzycompute() : validateVector;
    }

    public RDD<Instance> extractInstances(PredictorParams p, Dataset<?> df, Option<Object> numClasses) {
        Column column;
        Column column2;
        PredictorParams predictorParams = p;
        if (predictorParams instanceof ClassifierParams) {
            ClassifierParams classifierParams = (ClassifierParams)predictorParams;
            column2 = this.checkClassificationLabels(classifierParams.getLabelCol(), numClasses);
        } else {
            column2 = this.checkRegressionLabels(p.getLabelCol());
        }
        Column labelCol = column2;
        PredictorParams predictorParams2 = p;
        if (predictorParams2 instanceof HasWeightCol) {
            PredictorParams predictorParams3 = predictorParams2;
            column = this.checkNonNegativeWeights(predictorParams3.get(((HasWeightCol)((Object)predictorParams3)).weightCol()));
        } else {
            column = functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
        }
        Column weightCol = column;
        return df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{labelCol, weightCol, this.checkNonNanVectors(p.getFeaturesCol())})).rdd().map((Function1 & Serializable)x0$1 -> {
            double d;
            double d2;
            Object v;
            block3: {
                Row row;
                block2: {
                    Some some;
                    row = x0$1;
                    if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(3) != 0) break block2;
                    Object l = ((SeqOps)some.get()).apply(0);
                    Object w = ((SeqOps)some.get()).apply(1);
                    v = ((SeqOps)some.get()).apply(2);
                    if (!(l instanceof Double)) break block2;
                    d2 = BoxesRunTime.unboxToDouble((Object)l);
                    if (!(w instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)w);
                    if (v instanceof org.apache.spark.ml.linalg.Vector) break block3;
                }
                throw new MatchError((Object)row);
            }
            org.apache.spark.ml.linalg.Vector vector = (org.apache.spark.ml.linalg.Vector)v;
            Instance instance = new Instance(d2, d, vector);
            return instance;
        }, ClassTag$.MODULE$.apply(Instance.class));
    }

    public Option<Object> extractInstances$default$3() {
        return None$.MODULE$;
    }

    public Column columnToVector(Dataset<?> dataset, String colName) {
        Column column;
        DataType columnDataType = dataset.schema().apply(colName).dataType();
        DataType dataType = columnDataType;
        if (dataType instanceof VectorUDT) {
            column = functions$.MODULE$.col(colName);
        } else if (dataType instanceof ArrayType) {
            UserDefinedFunction userDefinedFunction;
            ArrayType arrayType = (ArrayType)dataType;
            DataType dataType2 = arrayType.elementType();
            if (dataType2 instanceof FloatType) {
                public final class Org_apache_spark_ml_util_DatasetUtils$$typecreator2$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Org_apache_spark_ml_util_DatasetUtils$$typecreator2$1() {
                    }
                }
                public final class Org_apache_spark_ml_util_DatasetUtils$$typecreator1$2
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_util_DatasetUtils$$typecreator1$2() {
                    }
                }
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                userDefinedFunction = functions$.MODULE$.udf((Function1 & Serializable)vector -> {
                    double[] inputArray = (double[])Array$.MODULE$.ofDim(vector.size(), (ClassTag)ClassTag$.MODULE$.Double());
                    vector.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
                        inputArray$1[idx] = BoxesRunTime.unboxToFloat((Object)vector.apply(idx));
                    });
                    return org.apache.spark.ml.linalg.Vectors$.MODULE$.dense(inputArray);
                }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_DatasetUtils$$typecreator1$2()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_util_DatasetUtils$$typecreator2$1()));
            } else if (dataType2 instanceof DoubleType) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                JavaUniverse $u3 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Org_apache_spark_ml_util_DatasetUtils$$typecreator3$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_util_DatasetUtils$$typecreator3$1() {
                    }
                }
                public final class Org_apache_spark_ml_util_DatasetUtils$$typecreator4$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Org_apache_spark_ml_util_DatasetUtils$$typecreator4$1() {
                    }
                }
                userDefinedFunction = functions$.MODULE$.udf((Function1 & Serializable)vector -> org.apache.spark.ml.linalg.Vectors$.MODULE$.dense((double[])vector.toArray((ClassTag)ClassTag$.MODULE$.Double())), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_DatasetUtils$$typecreator3$1()), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_util_DatasetUtils$$typecreator4$1()));
            } else {
                throw new IllegalArgumentException(new StringBuilder(39).append("Array[").append(dataType2).append("] column cannot be cast to Vector").toString());
            }
            UserDefinedFunction transferUDF = userDefinedFunction;
            column = transferUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(colName)}));
        } else {
            throw new IllegalArgumentException(new StringBuilder(32).append(dataType).append(" column cannot be cast to Vector").toString());
        }
        return column;
    }

    public RDD<Vector> columnToOldVector(Dataset<?> dataset, String colName) {
        return dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.columnToVector(dataset, colName)})).rdd().map((Function1 & Serializable)x0$1 -> {
            Object point;
            Some some;
            Row row = x0$1;
            if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(1) != 0 || !((point = ((SeqOps)some.get()).apply(0)) instanceof org.apache.spark.ml.linalg.Vector)) {
                throw new MatchError((Object)row);
            }
            org.apache.spark.ml.linalg.Vector vector = (org.apache.spark.ml.linalg.Vector)point;
            Vector vector2 = Vectors$.MODULE$.fromML(vector);
            return vector2;
        }, ClassTag$.MODULE$.apply(Vector.class));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getNumClasses(Dataset<?> dataset, String labelCol, int maxNumClasses) {
        Option<Object> option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(labelCol));
        if (option instanceof Some) {
            Some some = (Some)option;
            int n = BoxesRunTime.unboxToInt((Object)some.value());
            if (true) {
                int n2 = n;
                return n2;
            }
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        Row[] maxLabelRow = (Row[])dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max(this.checkClassificationLabels(labelCol, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)maxNumClasses))))})).take(1);
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])maxLabelRow))) throw new SparkException("ML algorithm was given empty dataset.");
        if (maxLabelRow[0].get(0) == null) {
            throw new SparkException("ML algorithm was given empty dataset.");
        }
        double maxDoubleLabel = ((Row)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])maxLabelRow))).getDouble(0);
        Predef$.MODULE$.require(RichDouble$.MODULE$.isValidInt$extension(Predef$.MODULE$.doubleWrapper(maxDoubleLabel + 1.0)), (Function0 & Serializable)() -> new StringBuilder(0).append("Classifier found max label value =").append(new StringBuilder(62).append(" ").append(maxDoubleLabel).append(" but requires integers in range [0, ... ").append(Integer.MAX_VALUE).append(")").toString()).toString());
        int numClasses = (int)maxDoubleLabel + 1;
        Predef$.MODULE$.require(numClasses <= maxNumClasses, (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(38).append("Classifier inferred ").append(numClasses).append(" from label values").toString()).append(new StringBuilder(60).append(" in column ").append(labelCol).append(", but this exceeded the max numClasses (").append(maxNumClasses).append(") allowed").toString()).append(new StringBuilder(68).append(" to be inferred from values.  To avoid this error for labels with > ").append(maxNumClasses).toString()).append(" classes, specify numClasses explicitly in the metadata; this can be done by applying").append(" StringIndexer to the label column.").toString());
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(MODULE$.getClass().getCanonicalName()).append(new StringBuilder(22).append(" inferred ").append(numClasses).append(" classes for").toString()).append(new StringBuilder(69).append(" labelCol=").append(labelCol).append(" since numClasses was not specified in the column metadata.").toString()).toString());
        return numClasses;
    }

    public int getNumClasses$default$3() {
        return 100;
    }

    public int getNumFeatures(Dataset<?> dataset, String vectorCol) {
        return BoxesRunTime.unboxToInt((Object)MetadataUtils$.MODULE$.getNumFeatures(dataset.schema().apply(vectorCol)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> ((org.apache.spark.ml.linalg.Vector)((Row)dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.columnToVector(dataset, vectorCol)})).head()).getAs(0)).size()));
    }

    public static final /* synthetic */ boolean $anonfun$validateVector$1(org.apache.spark.ml.linalg.Vector vector) {
        boolean bl;
        org.apache.spark.ml.linalg.Vector vector2 = vector;
        if (vector2 instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector2;
            bl = ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.doubleArrayOps(denseVector.values()), (Function1)(JFunction1.mcZD.sp & Serializable)v -> !Double.isNaN(v) && !RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(v)));
        } else if (vector2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector2;
            bl = ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.doubleArrayOps(sparseVector.values()), (Function1)(JFunction1.mcZD.sp & Serializable)v -> !Double.isNaN(v) && !RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(v)));
        } else {
            throw new MatchError((Object)vector2);
        }
        return bl;
    }

    private DatasetUtils$() {
    }
}

