/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.IOException;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.OperatorExplainVectorization;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorAppMasterEventDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.io.DataOutputBuffer;

@Explain(displayName="Application Master Event Operator")
public class AppMasterEventDesc
extends AbstractOperatorDesc {
    private TableDesc table;
    private String vertexName;
    private String inputName;

    @Explain(displayName="Target Vertex")
    public String getVertexName() {
        return this.vertexName;
    }

    @Explain(displayName="Target Input")
    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    public void setVertexName(String vertexName) {
        this.vertexName = vertexName;
    }

    public TableDesc getTable() {
        return this.table;
    }

    public void setTable(TableDesc table) {
        this.table = table;
    }

    public void writeEventHeader(DataOutputBuffer buffer) throws IOException {
    }

    @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="App Master Event Vectorization", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public AppMasterEventOperatorExplainVectorization getAppMasterEventVectorization() {
        if (this.vectorDesc == null) {
            return null;
        }
        return new AppMasterEventOperatorExplainVectorization(this, this.vectorDesc);
    }

    public class AppMasterEventOperatorExplainVectorization
    extends OperatorExplainVectorization {
        private final AppMasterEventDesc appMasterEventDesc;
        private final VectorAppMasterEventDesc vectorAppMasterEventDesc;

        public AppMasterEventOperatorExplainVectorization(AppMasterEventDesc appMasterEventDesc, VectorDesc vectorDesc) {
            super(vectorDesc, true);
            this.appMasterEventDesc = appMasterEventDesc;
            this.vectorAppMasterEventDesc = (VectorAppMasterEventDesc)vectorDesc;
        }
    }
}

