/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.udf.ptf.SingleValueBoundaryScanner;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

class DoubleValueBoundaryScanner
extends SingleValueBoundaryScanner {
    public DoubleValueBoundaryScanner(BoundaryDef start, BoundaryDef end, OrderExpressionDef expressionDef) {
        super(start, end, expressionDef);
    }

    @Override
    public boolean isDistanceGreater(Object v1, Object v2, int amt) {
        if (v1 != null && v2 != null) {
            double d2;
            double d1 = PrimitiveObjectInspectorUtils.getDouble((Object)v1, (PrimitiveObjectInspector)((PrimitiveObjectInspector)this.expressionDef.getOI()));
            return d1 - (d2 = PrimitiveObjectInspectorUtils.getDouble((Object)v2, (PrimitiveObjectInspector)((PrimitiveObjectInspector)this.expressionDef.getOI()))) > (double)amt;
        }
        return v1 != null || v2 != null;
    }

    @Override
    public boolean isEqual(Object v1, Object v2) {
        if (v1 != null && v2 != null) {
            double d2;
            double d1 = PrimitiveObjectInspectorUtils.getDouble((Object)v1, (PrimitiveObjectInspector)((PrimitiveObjectInspector)this.expressionDef.getOI()));
            return d1 == (d2 = PrimitiveObjectInspectorUtils.getDouble((Object)v2, (PrimitiveObjectInspector)((PrimitiveObjectInspector)this.expressionDef.getOI())));
        }
        return v1 == null && v2 == null;
    }
}

