/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.DecisionTreeModel$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class DecisionTreeClassificationExample$ {
    public static final DecisionTreeClassificationExample$ MODULE$ = new DecisionTreeClassificationExample$();

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("DecisionTreeClassificationExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_libsvm_data.txt");
        RDD[] splits = data.randomSplit(new double[]{0.7, 0.3}, data.randomSplit$default$2());
        Tuple2 tuple2 = new Tuple2((Object)splits[0], (Object)splits[1]);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RDD trainingData = (RDD)tuple2._1();
        RDD testData = (RDD)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)trainingData, (Object)testData);
        Tuple2 tuple23 = tuple22;
        RDD trainingData2 = (RDD)tuple23._1();
        RDD testData2 = (RDD)tuple23._2();
        int numClasses = 2;
        Map categoricalFeaturesInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        String impurity = "gini";
        int maxDepth = 5;
        int maxBins = 32;
        DecisionTreeModel model = DecisionTree$.MODULE$.trainClassifier(trainingData2, numClasses, categoricalFeaturesInfo, impurity, maxDepth, maxBins);
        RDD labelAndPreds = testData2.map((Function1 & Serializable)point -> {
            double prediction = model.predict(point.features());
            return new Tuple2.mcDD.sp(point.label(), prediction);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        double testErr = (double)labelAndPreds.filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)DecisionTreeClassificationExample$.$anonfun$main$2(r))).count() / (double)testData2.count();
        Predef$.MODULE$.println((Object)new StringBuilder(13).append("Test Error = ").append(testErr).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(36).append("Learned classification tree model:\n ").append(model.toDebugString()).toString());
        model.save(sc, "target/tmp/myDecisionTreeClassificationModel");
        DecisionTreeModel sameModel = DecisionTreeModel$.MODULE$.load(sc, "target/tmp/myDecisionTreeClassificationModel");
        sc.stop();
    }

    public static final /* synthetic */ boolean $anonfun$main$2(Tuple2 r) {
        return r._1$mcD$sp() != r._2$mcD$sp();
    }

    private DecisionTreeClassificationExample$() {
    }
}

