/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptionsInRead$;
import org.apache.spark.sql.catalyst.json.JacksonGenerator;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\ra\u0001\u0002\b\u0010\u0001yA\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\tq\u0001\u0011\t\u0011)A\u0005W!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!A\u0005A!A!\u0002\u0013I\u0005\"B)\u0001\t\u0003\u0011\u0006bB-\u0001\u0005\u0004%IA\u0017\u0005\u0007K\u0002\u0001\u000b\u0011B.\t\u000f\u0019\u0004!\u0019!C\u0005O\"1a\u000e\u0001Q\u0001\n!Daa\u001c\u0001!\u0002\u0013\u0001\b\"B:\u0001\t\u0003\"\bBB@\u0001\t\u0003\n\tA\u0001\tKg>tw*\u001e;qkR<&/\u001b;fe*\u0011\u0001#E\u0001\u0005UN|gN\u0003\u0002\u0013'\u0005YA-\u0019;bg>,(oY3t\u0015\t!R#A\u0005fq\u0016\u001cW\u000f^5p]*\u0011acF\u0001\u0004gFd'B\u0001\r\u001a\u0003\u0015\u0019\b/\u0019:l\u0015\tQ2$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aH\u0012\u0011\u0005\u0001\nS\"A\t\n\u0005\t\n\"\u0001D(viB,Ho\u0016:ji\u0016\u0014\bC\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u0018\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0015&\u0005\u001daunZ4j]\u001e\fA\u0001]1uQV\t1\u0006\u0005\u0002-k9\u0011Qf\r\t\u0003]Ej\u0011a\f\u0006\u0003au\ta\u0001\u0010:p_Rt$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n\u0014A\u0002)sK\u0012,g-\u0003\u00027o\t11\u000b\u001e:j]\u001eT!\u0001N\u0019\u0002\u000bA\fG\u000f\u001b\u0011\u0002\u000f=\u0004H/[8ogB\u00111hP\u0007\u0002y)\u0011\u0001#\u0010\u0006\u0003}U\t\u0001bY1uC2L8\u000f^\u0005\u0003\u0001r\u00121BS*P\u001d>\u0003H/[8og\u0006QA-\u0019;b'\u000eDW-\\1\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015+\u0012!\u0002;za\u0016\u001c\u0018BA$E\u0005)\u0019FO];diRK\b/Z\u0001\bG>tG/\u001a=u!\tQu*D\u0001L\u0015\taU*A\u0005nCB\u0014X\rZ;dK*\u0011a*G\u0001\u0007Q\u0006$wn\u001c9\n\u0005A[%A\u0005+bg.\fE\u000f^3naR\u001cuN\u001c;fqR\fa\u0001P5oSRtD#B*V-^C\u0006C\u0001+\u0001\u001b\u0005y\u0001\"B\u0015\u0007\u0001\u0004Y\u0003\"B\u001d\u0007\u0001\u0004Q\u0004\"B!\u0007\u0001\u0004\u0011\u0005\"\u0002%\u0007\u0001\u0004I\u0015\u0001C3oG>$\u0017N\\4\u0016\u0003m\u0003\"\u0001X2\u000e\u0003uS!AX0\u0002\u000f\rD\u0017M]:fi*\u0011\u0001-Y\u0001\u0004]&|'\"\u00012\u0002\t)\fg/Y\u0005\u0003Iv\u0013qa\u00115beN,G/A\u0005f]\u000e|G-\u001b8hA\u00051qO]5uKJ,\u0012\u0001\u001b\t\u0003S2l\u0011A\u001b\u0006\u0003W\u0006\f!![8\n\u00055T'AE(viB,Ho\u0015;sK\u0006lwK]5uKJ\fqa\u001e:ji\u0016\u0014\b%A\u0002hK:\u0004\"aO9\n\u0005Id$\u0001\u0005&bG.\u001cxN\\$f]\u0016\u0014\u0018\r^8s\u0003\u00159(/\u001b;f)\t)\u0018\u0010\u0005\u0002wo6\t\u0011'\u0003\u0002yc\t!QK\\5u\u0011\u0015QH\u00021\u0001|\u0003\r\u0011xn\u001e\t\u0003yvl\u0011!P\u0005\u0003}v\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006)1\r\\8tKR\tQ\u000f")
public class JsonOutputWriter
extends OutputWriter
implements Logging {
    private final String path;
    private final Charset encoding;
    private final OutputStreamWriter writer;
    private final JacksonGenerator gen;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String path() {
        return this.path;
    }

    private Charset encoding() {
        return this.encoding;
    }

    private OutputStreamWriter writer() {
        return this.writer;
    }

    @Override
    public void write(InternalRow row) {
        this.gen.write(row);
        this.gen.writeLineEnding();
    }

    @Override
    public void close() {
        this.gen.close();
        this.writer().close();
    }

    public JsonOutputWriter(String path, JSONOptions options, StructType dataSchema, TaskAttemptContext context) {
        Charset charset;
        this.path = path;
        Logging.$init$((Logging)this);
        Option option = options.encoding();
        if (option instanceof Some) {
            Some some = (Some)option;
            String charsetName = (String)some.value();
            charset = Charset.forName(charsetName);
        } else if (None$.MODULE$.equals(option)) {
            charset = StandardCharsets.UTF_8;
        } else {
            throw new MatchError((Object)option);
        }
        this.encoding = charset;
        if (JSONOptionsInRead$.MODULE$.denyList().contains((Object)this.encoding())) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append(new StringBuilder(45).append("The JSON file (").append(this.path()).append(") was written in the encoding ").append(this.encoding().displayName()).toString()).append(" which can be read back by Spark only if multiLine is enabled.").toString());
        }
        this.writer = CodecStreams$.MODULE$.createOutputStreamWriter((JobContext)context, new Path(path), this.encoding());
        this.gen = new JacksonGenerator((DataType)dataSchema, (Writer)this.writer(), options);
    }
}

