/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DateFormatClass$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimestampFormatterHelper;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(timestamp, fmt) - Converts `timestamp` to a value of string in the format specified by the date format `fmt`.", arguments="\n    Arguments:\n      * timestamp - A date/timestamp or string to be converted to the given format.\n      * fmt - Date/time format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid date\n              and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-04-08', 'y');\n       2016\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\t\u0015c\u0001\u0002\u0014(\u0001RB\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0001\u0017\u0005\t9\u0002\u0011\t\u0012)A\u00053\"AQ\f\u0001BK\u0002\u0013\u0005\u0001\f\u0003\u0005_\u0001\tE\t\u0015!\u0003Z\u0011!y\u0006A!f\u0001\n\u0003\u0001\u0007\u0002\u00037\u0001\u0005#\u0005\u000b\u0011B1\t\u000b5\u0004A\u0011\u00018\t\u000b5\u0004A\u0011A:\t\u000bY\u0004A\u0011I<\t\u000by\u0004A\u0011I@\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010!9\u0011\u0011\u0004\u0001\u0005R\u0005m\u0001bBA\u0016\u0001\u0011\u0005\u0013Q\u0006\u0005\b\u0003\u0013\u0002A\u0011IA&\u0011\u0019\ti\u0005\u0001C)1\"9\u0011q\n\u0001\u0005R\u0005E\u0003bBA-\u0001\u0011E\u00131\f\u0005\n\u0003K\u0002\u0011\u0011!C\u0001\u0003OB\u0011\"a\u001c\u0001#\u0003%\t!!\u001d\t\u0013\u0005\u001d\u0005!%A\u0005\u0002\u0005E\u0004\"CAE\u0001E\u0005I\u0011AAF\u0011%\ty\tAA\u0001\n\u0003\n\t\nC\u0005\u0002\"\u0002\t\t\u0011\"\u0001\u0002$\"I\u00111\u0016\u0001\u0002\u0002\u0013\u0005\u0011Q\u0016\u0005\n\u0003g\u0003\u0011\u0011!C!\u0003kC\u0011\"a1\u0001\u0003\u0003%\t!!2\t\u0013\u0005%\u0007!!A\u0005B\u0005-\u0007\"CAh\u0001\u0005\u0005I\u0011IAi\u000f%\tYpJA\u0001\u0012\u0003\tiP\u0002\u0005'O\u0005\u0005\t\u0012AA\u0000\u0011\u0019ig\u0004\"\u0001\u0003\u0018!I!\u0011\u0004\u0010\u0002\u0002\u0013\u0015#1\u0004\u0005\n\u0005;q\u0012\u0011!CA\u0005?A\u0011Ba\n\u001f#\u0003%\t!a#\t\u0013\t%b$!A\u0005\u0002\n-\u0002\"\u0003B\u001d=E\u0005I\u0011AAF\u0011%\u0011YDHA\u0001\n\u0013\u0011iDA\bECR,gi\u001c:nCR\u001cE.Y:t\u0015\tA\u0013&A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0016,\u0003!\u0019\u0017\r^1msN$(B\u0001\u0017.\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003]=\nQa\u001d9be.T!\u0001M\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0014aA8sO\u000e\u00011c\u0002\u00016sqzd\t\u0014\t\u0003m]j\u0011aJ\u0005\u0003q\u001d\u0012\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005YR\u0014BA\u001e(\u0005a!\u0016.\\3ti\u0006l\u0007OR8s[\u0006$H/\u001a:IK2\u0004XM\u001d\t\u0003muJ!AP\u0014\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001Q\"\u000f\u0005Y\n\u0015B\u0001\"(\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001R#\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011!i\n\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0002\u0013\u0006)1oY1mC&\u00111\n\u0013\u0002\b!J|G-^2u!\tiEK\u0004\u0002O':\u0011qJU\u0007\u0002!*\u0011\u0011kM\u0001\u0007yI|w\u000e\u001e \n\u0003%K!A\u0011%\n\u0005U3&\u0001D*fe&\fG.\u001b>bE2,'B\u0001\"I\u0003\u0011aWM\u001a;\u0016\u0003e\u0003\"A\u000e.\n\u0005m;#AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\n!\u0002^5nKj{g.Z%e+\u0005\t\u0007cA$cI&\u00111\r\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0015LgB\u00014h!\ty\u0005*\u0003\u0002i\u0011\u00061\u0001K]3eK\u001aL!A[6\u0003\rM#(/\u001b8h\u0015\tA\u0007*A\u0006uS6,'l\u001c8f\u0013\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003paF\u0014\bC\u0001\u001c\u0001\u0011\u00159v\u00011\u0001Z\u0011\u0015iv\u00011\u0001Z\u0011\u001dyv\u0001%AA\u0002\u0005$2a\u001c;v\u0011\u00159\u0006\u00021\u0001Z\u0011\u0015i\u0006\u00021\u0001Z\u0003!!\u0017\r^1UsB,W#\u0001=\u0011\u0005edX\"\u0001>\u000b\u0005m\\\u0013!\u0002;za\u0016\u001c\u0018BA?{\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\u0011\u0011\u0011\u0001\t\u0006\u001b\u0006\r\u0011qA\u0005\u0004\u0003\u000b1&aA*fcB\u0019\u00110!\u0003\n\u0007\u0005-!P\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006aq/\u001b;i)&lWMW8oKR!\u0011\u0011CA\f!\r1\u00141C\u0005\u0004\u0003+9#a\u0006+j[\u0016TvN\\3Bo\u0006\u0014X-\u0012=qe\u0016\u001c8/[8o\u0011\u0015y6\u00021\u0001e\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0019\ti\"a\t\u0002(A\u0019q)a\b\n\u0007\u0005\u0005\u0002JA\u0002B]fDq!!\n\r\u0001\u0004\ti\"A\u0005uS6,7\u000f^1na\"9\u0011\u0011\u0006\u0007A\u0002\u0005u\u0011A\u00024pe6\fG/A\u0005e_\u001e+gnQ8eKR1\u0011qFA\u001e\u0003\u000b\u0002B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003k9\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003s\t\u0019D\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\ti$\u0004a\u0001\u0003\u007f\t1a\u0019;y!\u0011\t\t$!\u0011\n\t\u0005\r\u00131\u0007\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t9%\u0004a\u0001\u0003_\t!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001e\u000311wN]7biN#(/\u001b8h\u0003%I7\u000fU1sg&tw-\u0006\u0002\u0002TA\u0019q)!\u0016\n\u0007\u0005]\u0003JA\u0004C_>dW-\u00198\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#B8\u0002^\u0005\u0005\u0004BBA0#\u0001\u0007\u0011,A\u0004oK^dUM\u001a;\t\r\u0005\r\u0014\u00031\u0001Z\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$ra\\A5\u0003W\ni\u0007C\u0004X%A\u0005\t\u0019A-\t\u000fu\u0013\u0002\u0013!a\u00013\"9qL\u0005I\u0001\u0002\u0004\t\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003gR3!WA;W\t\t9\b\u0005\u0003\u0002z\u0005\rUBAA>\u0015\u0011\ti(a \u0002\u0013Ut7\r[3dW\u0016$'bAAA\u0011\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00151\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tiIK\u0002b\u0003k\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAJ!\u0011\t)*a(\u000e\u0005\u0005]%\u0002BAM\u00037\u000bA\u0001\\1oO*\u0011\u0011QT\u0001\u0005U\u00064\u0018-C\u0002k\u0003/\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!*\u0011\u0007\u001d\u000b9+C\u0002\u0002*\"\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\b\u00020\"I\u0011\u0011\u0017\r\u0002\u0002\u0003\u0007\u0011QU\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005]\u0006CBA]\u0003\u007f\u000bi\"\u0004\u0002\u0002<*\u0019\u0011Q\u0018%\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002B\u0006m&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u0015\u0002H\"I\u0011\u0011\u0017\u000e\u0002\u0002\u0003\u0007\u0011QD\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u0014\u00065\u0007\"CAY7\u0005\u0005\t\u0019AAS\u0003\u0019)\u0017/^1mgR!\u00111KAj\u0011%\t\t\fHA\u0001\u0002\u0004\ti\u0002K\f\u0001\u0003/\fi.a8\u0002d\u0006\u0015\u0018\u0011^Av\u0003_\f\t0!>\u0002xB\u0019a'!7\n\u0007\u0005mwEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u0005\u0018\u0001^0G+:\u001bu\f\u000b;j[\u0016\u001cH/Y7qY\u00012W\u000e^\u0015![\u0001\u001auN\u001c<feR\u001c\b\u0005\u0019;j[\u0016\u001cH/Y7qA\u0002\"x\u000eI1!m\u0006dW/\u001a\u0011pM\u0002\u001aHO]5oO\u0002Jg\u000e\t;iK\u00022wN]7bi\u0002\u001a\b/Z2jM&,G\r\t2zAQDW\r\t3bi\u0016\u0004cm\u001c:nCR\u0004\u0003MZ7uA:\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005\u001d\u0018A!\u001c\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"\u0018.\\3ti\u0006l\u0007\u000fI\u0017!\u0003\u0002\"\u0017\r^30i&lWm\u001d;b[B\u0004sN\u001d\u0011tiJLgn\u001a\u0011u_\u0002\u0012W\rI2p]Z,'\u000f^3eAQ|\u0007\u0005\u001e5fA\u001dLg/\u001a8!M>\u0014X.\u0019;/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u00012W\u000e\u001e\u0011.A\u0011\u000bG/Z\u0018uS6,\u0007EZ8s[\u0006$\b\u0005]1ui\u0016\u0014h\u000e\t;pA\u0019|G\u000e\\8x]\u0001\u001aV-\u001a\u0011=C\u0002B'/\u001a4>E!$H\u000f]:;_=\u001a\b/\u0019:l]\u0005\u0004\u0018m\u00195f]=\u0014xm\f3pGN|C.\u0019;fgR|3/\u001d7.e\u00164W\u0006Z1uKRLW.Z\u0017qCR$XM\u001d8/QRlGN\t ECR,G/[7fAA\u000bG\u000f^3s]Ndt&\u0019 !M>\u0014\bE^1mS\u0012\u0004C-\u0019;f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0005tG\r\t;j[\u0016\u0004cm\u001c:nCR\u0004\u0003/\u0019;uKJt7O\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002n\u00069%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aE2T\u0006\r\u001b.aa:C\u0006I\u0014zO%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192m)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002t\u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAA}\u0003\u0015\td&\u000e\u00181\u0003=!\u0015\r^3G_Jl\u0017\r^\"mCN\u001c\bC\u0001\u001c\u001f'\u0015q\"\u0011\u0001B\u0007!!\u0011\u0019A!\u0003Z3\u0006|WB\u0001B\u0003\u0015\r\u00119\u0001S\u0001\beVtG/[7f\u0013\u0011\u0011YA!\u0002\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0003\u0010\tUQB\u0001B\t\u0015\u0011\u0011\u0019\"a'\u0002\u0005%|\u0017bA+\u0003\u0012Q\u0011\u0011Q`\u0001\ti>\u001cFO]5oOR\u0011\u00111S\u0001\u0006CB\u0004H.\u001f\u000b\b_\n\u0005\"1\u0005B\u0013\u0011\u00159\u0016\u00051\u0001Z\u0011\u0015i\u0016\u00051\u0001Z\u0011\u001dy\u0016\u0005%AA\u0002\u0005\fq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011iC!\u000e\u0011\t\u001d\u0013'q\u0006\t\u0007\u000f\nE\u0012,W1\n\u0007\tM\u0002J\u0001\u0004UkBdWm\r\u0005\t\u0005o\u0019\u0013\u0011!a\u0001_\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011y\u0004\u0005\u0003\u0002\u0016\n\u0005\u0013\u0002\u0002B\"\u0003/\u0013aa\u00142kK\u000e$\b")
public class DateFormatClass
extends BinaryExpression
implements TimestampFormatterHelper,
ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;
    private final Option<String> timeZoneId;
    private transient Option<TimestampFormatter> formatterOption;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return DateFormatClass$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(DateFormatClass x$0) {
        return DateFormatClass$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$3() {
        return DateFormatClass$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, DateFormatClass> tupled() {
        return DateFormatClass$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, DateFormatClass>>> curried() {
        return DateFormatClass$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean forTimestampNTZ() {
        return TimestampFormatterHelper.forTimestampNTZ$(this);
    }

    @Override
    public final TimestampFormatter getFormatter(String fmt) {
        return TimestampFormatterHelper.getFormatter$(this, fmt);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private Option<TimestampFormatter> formatterOption$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.formatterOption = TimestampFormatterHelper.formatterOption$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.formatterOption;
    }

    @Override
    public final Option<TimestampFormatter> formatterOption() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.formatterOption$lzycompute() : this.formatterOption;
    }

    private boolean resolved$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object timestamp, Object format) {
        TimestampFormatter formatter = (TimestampFormatter)this.formatterOption().getOrElse((Function0 & Serializable)() -> this.getFormatter(format.toString()));
        return UTF8String.fromString((String)formatter.format(BoxesRunTime.unboxToLong((Object)timestamp)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return (ExprCode)this.formatterOption().map((Function1 & Serializable)tf -> {
            String timestampFormatter = ctx.addReferenceObj("timestampFormatter", tf, ctx.addReferenceObj$default$3());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(timestamp, x$1) -> new StringBuilder(32).append("UTF8String.fromString(").append(timestampFormatter).append(".format(").append((String)timestamp).append("))").toString());
        }).getOrElse((Function0 & Serializable)() -> {
            String tf = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(TimestampFormatter$.MODULE$.getClass().getName()), "$");
            String ldf = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(LegacyDateFormats$.MODULE$.getClass().getName()), "$");
            String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(timestamp, format) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(177).append("|UTF8String.fromString(").append(tf).append("$.MODULE$.apply(\n            |  ").append((String)format).append(".toString(),\n            |  ").append(zid).append(",\n            |  ").append(ldf).append("$.MODULE$.SIMPLE_DATE_FORMAT(),\n            |  false)\n            |.format(").append((String)timestamp).append("))").toString())));
        });
    }

    @Override
    public String prettyName() {
        return "date_format";
    }

    @Override
    public Expression formatString() {
        return this.right();
    }

    @Override
    public boolean isParsing() {
        return false;
    }

    @Override
    public DateFormatClass withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public DateFormatClass copy(Expression left, Expression right, Option<String> timeZoneId) {
        return new DateFormatClass(left, right, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "DateFormatClass";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DateFormatClass;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            case 2: {
                string = "timeZoneId";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DateFormatClass)) return false;
        boolean bl = true;
        if (!bl) return false;
        DateFormatClass dateFormatClass = (DateFormatClass)x$1;
        Expression expression = this.left();
        Expression expression2 = dateFormatClass.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = dateFormatClass.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = dateFormatClass.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!dateFormatClass.canEqual(this)) return false;
        return true;
    }

    public DateFormatClass(Expression left, Expression right, Option<String> timeZoneId) {
        this.left = left;
        this.right = right;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        TimestampFormatterHelper.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public DateFormatClass(Expression left, Expression right) {
        this(left, right, (Option<String>)None$.MODULE$);
    }
}

