/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.HashMap;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class VectorPartitionConversion {
    private static HashMap<PrimitiveObjectInspector.PrimitiveCategory, PrimitiveObjectInspector.PrimitiveCategory[]> implicitPrimitiveMap = new HashMap();

    public static boolean isImplicitVectorColumnConversion(TypeInfo fromTypeInfo, TypeInfo toTypeInfo) {
        if (fromTypeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && toTypeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveObjectInspector.PrimitiveCategory fromPrimitiveCategory = ((PrimitiveTypeInfo)fromTypeInfo).getPrimitiveCategory();
            PrimitiveObjectInspector.PrimitiveCategory toPrimitiveCategory = ((PrimitiveTypeInfo)toTypeInfo).getPrimitiveCategory();
            PrimitiveObjectInspector.PrimitiveCategory[] toPrimitiveCategories = implicitPrimitiveMap.get(fromPrimitiveCategory);
            if (toPrimitiveCategories != null) {
                for (PrimitiveObjectInspector.PrimitiveCategory candidatePrimitiveCategory : toPrimitiveCategories) {
                    if (candidatePrimitiveCategory != toPrimitiveCategory) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    static {
        implicitPrimitiveMap.put(PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN, new PrimitiveObjectInspector.PrimitiveCategory[]{PrimitiveObjectInspector.PrimitiveCategory.BYTE, PrimitiveObjectInspector.PrimitiveCategory.SHORT, PrimitiveObjectInspector.PrimitiveCategory.INT, PrimitiveObjectInspector.PrimitiveCategory.LONG});
        implicitPrimitiveMap.put(PrimitiveObjectInspector.PrimitiveCategory.BYTE, new PrimitiveObjectInspector.PrimitiveCategory[]{PrimitiveObjectInspector.PrimitiveCategory.SHORT, PrimitiveObjectInspector.PrimitiveCategory.INT, PrimitiveObjectInspector.PrimitiveCategory.LONG});
        implicitPrimitiveMap.put(PrimitiveObjectInspector.PrimitiveCategory.SHORT, new PrimitiveObjectInspector.PrimitiveCategory[]{PrimitiveObjectInspector.PrimitiveCategory.INT, PrimitiveObjectInspector.PrimitiveCategory.LONG});
        implicitPrimitiveMap.put(PrimitiveObjectInspector.PrimitiveCategory.INT, new PrimitiveObjectInspector.PrimitiveCategory[]{PrimitiveObjectInspector.PrimitiveCategory.LONG});
        implicitPrimitiveMap.put(PrimitiveObjectInspector.PrimitiveCategory.FLOAT, new PrimitiveObjectInspector.PrimitiveCategory[]{PrimitiveObjectInspector.PrimitiveCategory.DOUBLE});
        implicitPrimitiveMap.put(PrimitiveObjectInspector.PrimitiveCategory.CHAR, new PrimitiveObjectInspector.PrimitiveCategory[]{PrimitiveObjectInspector.PrimitiveCategory.STRING});
        implicitPrimitiveMap.put(PrimitiveObjectInspector.PrimitiveCategory.VARCHAR, new PrimitiveObjectInspector.PrimitiveCategory[]{PrimitiveObjectInspector.PrimitiveCategory.STRING});
    }
}

