/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Map;
import org.apache.spark.ml.feature.VectorIndexer;
import org.apache.spark.ml.feature.VectorIndexerModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;

public class JavaVectorIndexerExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaVectorIndexerExample").getOrCreate();
        Dataset data = spark.read().format("libsvm").load("data/mllib/sample_libsvm_data.txt");
        VectorIndexer indexer = new VectorIndexer().setInputCol("features").setOutputCol("indexed").setMaxCategories(10);
        VectorIndexerModel indexerModel = indexer.fit(data);
        Map categoryMaps = indexerModel.javaCategoryMaps();
        System.out.print("Chose " + categoryMaps.size() + " categorical features:");
        for (Integer feature : categoryMaps.keySet()) {
            System.out.print(" " + feature);
        }
        System.out.println();
        Dataset indexedData = indexerModel.transform(data);
        indexedData.show();
        spark.stop();
    }
}

