/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.ContainerPortFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.LifecycleFluent;
import io.fabric8.kubernetes.api.model.LifecycleHandlerFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.io.Serializable;
import java.util.Collection;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.deploy.k8s.submit.KubernetesClientUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ExecutorResourceRequest;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd!B\u0010!\u0001\u0019b\u0003\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011\r\u0003!\u0011!Q\u0001\n\u0011C\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\u0006\u001f\u0002!\t\u0001\u0015\u0005\b+\u0002\u0011\r\u0011\"\u0003W\u0011\u0019\u0011\u0007\u0001)A\u0005/\"91\r\u0001b\u0001\n\u0013!\u0007B\u00025\u0001A\u0003%Q\rC\u0004j\u0001\t\u0007I\u0011\u0002,\t\r)\u0004\u0001\u0015!\u0003X\u0011\u001dY\u0007A1A\u0005\nYCa\u0001\u001c\u0001!\u0002\u00139\u0006bB7\u0001\u0005\u0004%IA\u001c\u0005\u0007e\u0002\u0001\u000b\u0011B8\t\u000fM\u0004!\u0019!C\u0005]\"1A\u000f\u0001Q\u0001\n=Dq!\u001e\u0001C\u0002\u0013%a\u000e\u0003\u0004w\u0001\u0001\u0006Ia\u001c\u0005\bo\u0002\u0011\r\u0011\"\u0003y\u0011\u0019a\b\u0001)A\u0005s\"9Q\u0010\u0001b\u0001\n\u0003q\bbBA\u0007\u0001\u0001\u0006Ia \u0005\t\u0003\u001f\u0001!\u0019!C\u0005-\"9\u0011\u0011\u0003\u0001!\u0002\u00139\u0006\u0002CA\n\u0001\t\u0007I\u0011\u0002,\t\u000f\u0005U\u0001\u0001)A\u0005/\"I\u0011q\u0003\u0001C\u0002\u0013%\u0011\u0011\u0004\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\u001c!9\u00111\u0005\u0001\u0005\n\u0005\u0015\u0002bBA-\u0001\u0011\u0005\u00131\f\u0002\u0019\u0005\u0006\u001c\u0018nY#yK\u000e,Ho\u001c:GK\u0006$XO]3Ti\u0016\u0004(BA\u0011#\u0003!1W-\u0019;ve\u0016\u001c(BA\u0012%\u0003\rY\u0007h\u001d\u0006\u0003K\u0019\na\u0001Z3qY>L(BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0014\t\u0001i3g\u000e\t\u0003]Ej\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Q*T\"\u0001\u0011\n\u0005Y\u0002#aG&vE\u0016\u0014h.\u001a;fg\u001a+\u0017\r^;sK\u000e{gNZ5h'R,\u0007\u000f\u0005\u00029w5\t\u0011H\u0003\u0002;M\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002=s\t9Aj\\4hS:<\u0017AD6vE\u0016\u0014h.\u001a;fg\u000e{gNZ\u0002\u0001!\t\u0001\u0015)D\u0001#\u0013\t\u0011%E\u0001\fLk\n,'O\\3uKN,\u00050Z2vi>\u00148i\u001c8g\u0003\u0019\u0019XmY'heB\u0011QIR\u0007\u0002M%\u0011qI\n\u0002\u0010'\u0016\u001cWO]5us6\u000bg.Y4fe\u0006y!/Z:pkJ\u001cW\r\u0015:pM&dW\r\u0005\u0002K\u001b6\t1J\u0003\u0002MM\u0005A!/Z:pkJ\u001cW-\u0003\u0002O\u0017\ny!+Z:pkJ\u001cW\r\u0015:pM&dW-\u0001\u0004=S:LGO\u0010\u000b\u0005#J\u001bF\u000b\u0005\u00025\u0001!)Q\b\u0002a\u0001\u007f!)1\t\u0002a\u0001\t\")\u0001\n\u0002a\u0001\u0013\u00061R\r_3dkR|'oQ8oi\u0006Lg.\u001a:J[\u0006<W-F\u0001X!\tAvL\u0004\u0002Z;B\u0011!lL\u0007\u00027*\u0011ALP\u0001\u0007yI|w\u000e\u001e \n\u0005y{\u0013A\u0002)sK\u0012,g-\u0003\u0002aC\n11\u000b\u001e:j]\u001eT!AX\u0018\u0002/\u0015DXmY;u_J\u001cuN\u001c;bS:,'/S7bO\u0016\u0004\u0013\u0001\u00052m_\u000e\\W*\u00198bO\u0016\u0014\bk\u001c:u+\u0005)\u0007C\u0001\u0018g\u0013\t9wFA\u0002J]R\f\u0011C\u00197pG.l\u0015M\\1hKJ\u0004vN\u001d;!\u0003U)\u00070Z2vi>\u0014\bk\u001c3OC6,\u0007K]3gSb\fa#\u001a=fGV$xN\u001d)pI:\u000bW.\u001a)sK\u001aL\u0007\u0010I\u0001\nIJLg/\u001a:Ve2\f!\u0002\u001a:jm\u0016\u0014XK\u001d7!\u0003AI7\u000fR3gCVdG\u000f\u0015:pM&dW-F\u0001p!\tq\u0003/\u0003\u0002r_\t9!i\\8mK\u0006t\u0017!E5t\t\u00164\u0017-\u001e7u!J|g-\u001b7fA\u0005Y\u0011n\u001d)zi\"|g.\u00119q\u00031I7\u000fU=uQ>t\u0017\t\u001d9!\u0003A!\u0017n]1cY\u0016\u001cuN\u001c4jO6\u000b\u0007/A\teSN\f'\r\\3D_:4\u0017nZ'ba\u0002\nA#\\3n_JLxJ^3sQ\u0016\fGMR1di>\u0014X#A=\u0011\u00059R\u0018BA>0\u0005\u0019!u.\u001e2mK\u0006)R.Z7pef|e/\u001a:iK\u0006$g)Y2u_J\u0004\u0013!D3yK\u000e\u0014Vm]8ve\u000e,7/F\u0001\u0000!\u0011\t\t!a\u0002\u000f\u0007)\u000b\u0019!C\u0002\u0002\u0006-\u000bqBU3t_V\u00148-\u001a)s_\u001aLG.Z\u0005\u0005\u0003\u0013\tYAA\u000eFq\u0016\u001cW\u000f^8s%\u0016\u001cx.\u001e:dKN|%\u000fR3gCVdGo\u001d\u0006\u0004\u0003\u000bY\u0015AD3yK\u000e\u0014Vm]8ve\u000e,7\u000fI\u0001\u0015Kb,7-\u001e;pe6+Wn\u001c:z'R\u0014\u0018N\\4\u0002+\u0015DXmY;u_JlU-\\8ssN#(/\u001b8hA\u0005!R\r_3dkR|'oQ8sKN\u0014V-];fgR\fQ#\u001a=fGV$xN]\"pe\u0016\u001c(+Z9vKN$\b%\u0001\nfq\u0016\u001cW\u000f^8s\u0019&l\u0017\u000e^\"pe\u0016\u001cXCAA\u000e!\u0011q\u0013QD,\n\u0007\u0005}qF\u0001\u0004PaRLwN\\\u0001\u0014Kb,7-\u001e;pe2KW.\u001b;D_J,7\u000fI\u0001!EVLG\u000eZ#yK\u000e,Ho\u001c:SKN|WO]2fgF+\u0018M\u001c;ji&,7\u000f\u0006\u0003\u0002(\u0005%\u0003C\u0002-\u0002*]\u000bi#C\u0002\u0002,\u0005\u00141!T1q!\u0011\ty#!\u0012\u000e\u0005\u0005E\"\u0002BA\u001a\u0003k\tQ!\\8eK2TA!a\u000e\u0002:\u0005\u0019\u0011\r]5\u000b\t\u0005m\u0012QH\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(\u0002BA \u0003\u0003\nqAZ1ce&\u001c\u0007H\u0003\u0002\u0002D\u0005\u0011\u0011n\\\u0005\u0005\u0003\u000f\n\tD\u0001\u0005Rk\u0006tG/\u001b;z\u0011\u001d\tY%\ba\u0001\u0003\u001b\nqbY;ti>l'+Z:pkJ\u001cWm\u001d\t\u00061\u0006=\u00131K\u0005\u0004\u0003#\n'aA*fiB\u0019!*!\u0016\n\u0007\u0005]3JA\fFq\u0016\u001cW\u000f^8s%\u0016\u001cx.\u001e:dKJ+\u0017/^3ti\u0006a1m\u001c8gS\u001e,(/\u001a)pIR!\u0011QLA2!\r\u0001\u0015qL\u0005\u0004\u0003C\u0012#\u0001C*qCJ\\\u0007k\u001c3\t\u000f\u0005\u0015d\u00041\u0001\u0002^\u0005\u0019\u0001o\u001c3")
public class BasicExecutorFeatureStep
implements KubernetesFeatureConfigStep,
Logging {
    private final KubernetesExecutorConf kubernetesConf;
    private final SecurityManager secMgr;
    private final ResourceProfile resourceProfile;
    private final String executorContainerImage;
    private final int blockManagerPort;
    private final String executorPodNamePrefix;
    private final String driverUrl;
    private final boolean isDefaultProfile;
    private final boolean isPythonApp;
    private final boolean disableConfigMap;
    private final double memoryOverheadFactor;
    private final ResourceProfile.ExecutorResourcesOrDefaults execResources;
    private final String executorMemoryString;
    private final String executorCoresRequest;
    private final Option<String> executorLimitCores;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public scala.collection.immutable.Map<String, String> getAdditionalPodSystemProperties() {
        return KubernetesFeatureConfigStep.getAdditionalPodSystemProperties$(this);
    }

    @Override
    public Seq<HasMetadata> getAdditionalPreKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalPreKubernetesResources$(this);
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalKubernetesResources$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String executorContainerImage() {
        return this.executorContainerImage;
    }

    private int blockManagerPort() {
        return this.blockManagerPort;
    }

    private String executorPodNamePrefix() {
        return this.executorPodNamePrefix;
    }

    private String driverUrl() {
        return this.driverUrl;
    }

    private boolean isDefaultProfile() {
        return this.isDefaultProfile;
    }

    private boolean isPythonApp() {
        return this.isPythonApp;
    }

    private boolean disableConfigMap() {
        return this.disableConfigMap;
    }

    private double memoryOverheadFactor() {
        return this.memoryOverheadFactor;
    }

    public ResourceProfile.ExecutorResourcesOrDefaults execResources() {
        return this.execResources;
    }

    private String executorMemoryString() {
        return this.executorMemoryString;
    }

    private String executorCoresRequest() {
        return this.executorCoresRequest;
    }

    private Option<String> executorLimitCores() {
        return this.executorLimitCores;
    }

    private scala.collection.immutable.Map<String, Quantity> buildExecutorResourcesQuantities(Set<ExecutorResourceRequest> customResources) {
        return ((TraversableOnce)customResources.map((Function1 & Serializable & scala.Serializable)request -> {
            if (!new StringOps(Predef$.MODULE$.augmentString(request.vendor())).nonEmpty()) {
                throw new SparkException(new StringBuilder(55).append("Resource: ").append(request.resourceName()).append(" was requested, ").append("but vendor was not specified.").toString());
            }
            String vendorDomain = request.vendor();
            Quantity quantity = new Quantity(Long.toString(request.amount()));
            return new Tuple2((Object)KubernetesConf$.MODULE$.buildKubernetesResourceName(vendorDomain, request.resourceName()), (Object)quantity);
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public SparkPod configurePod(SparkPod pod2) {
        Container container;
        Container containerWithLimitCores;
        Nil$ requiredPorts;
        String name2 = new StringBuilder(6).append(this.executorPodNamePrefix()).append("-exec-").append(this.kubernetesConf.executorId()).toString();
        String configMapName = KubernetesClientUtils$.MODULE$.configMapNameExecutor();
        scala.collection.immutable.Map<String, String> confFilesMap = KubernetesClientUtils$.MODULE$.buildSparkConfDirFilesMap(configMapName, this.kubernetesConf.sparkConf(), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        Seq<KeyToPath> keyToPaths = KubernetesClientUtils$.MODULE$.buildKeyToPathObjects(confFilesMap);
        String hostname = name2.substring(Math.max(0, name2.length() - Config$.MODULE$.KUBERNETES_DNS_LABEL_NAME_MAX_LENGTH())).replaceAll("^[^\\w]+", "").replaceAll("[^\\w-]+", "_");
        Quantity executorMemoryQuantity = new Quantity(new StringBuilder(2).append(this.execResources().totalMemMiB()).append("Mi").toString());
        Quantity executorCpuQuantity = new Quantity(this.executorCoresRequest());
        scala.collection.immutable.Map<String, Quantity> executorResourceQuantities = this.buildExecutorResourcesQuantities((Set<ExecutorResourceRequest>)this.execResources().customResources().values().toSet());
        Seq sparkAuthSecret = (Seq)Option$.MODULE$.apply((Object)this.secMgr.getSecretKey()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string = x0$1;
            if (string != null) {
                String string2 = string;
                if (((Option)$this.kubernetesConf.get(package$.MODULE$.AUTH_SECRET_FILE_EXECUTOR())).isEmpty()) {
                    return (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityManager$.MODULE$.ENV_AUTH_SECRET()), (Object)string2), (List)Nil$.MODULE$);
                }
            }
            return Nil$.MODULE$;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Seq userOpts = (Seq)Option$.MODULE$.option2Iterable((Option)this.kubernetesConf.get(package$.MODULE$.EXECUTOR_JAVA_OPTIONS())).toSeq().flatMap((Function1 & Serializable & scala.Serializable)opts -> {
            String subsOpts = Utils$.MODULE$.substituteAppNExecIds(opts, $this.kubernetesConf.appId(), $this.kubernetesConf.executorId());
            return Utils$.MODULE$.splitCommandString(subsOpts);
        }, Seq$.MODULE$.canBuildFrom());
        Seq sparkOpts = Utils$.MODULE$.sparkJavaOpts(this.kubernetesConf.sparkConf(), (Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)SparkConf$.MODULE$.isExecutorStartupConf(name)));
        scala.collection.immutable.Map allOpts = ((TraversableOnce)((TraversableLike)((IterableLike)userOpts.$plus$plus((GenTraversableOnce)sparkOpts, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String opt = (String)tuple2._1();
                int index = tuple2._2$mcI$sp();
                return new Tuple2((Object)new StringBuilder(0).append(Constants$.MODULE$.ENV_JAVA_OPT_PREFIX()).append(index).toString(), (Object)opt);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq executorEnv = (Seq)KubernetesUtils$.MODULE$.buildEnvVars((Seq<Tuple2<String, String>>)((Seq)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_DRIVER_URL()), (Object)this.driverUrl()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_CORES()), (Object)this.execResources().cores().get().toString()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_MEMORY()), (Object)this.executorMemoryString()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_APPLICATION_ID()), (Object)this.kubernetesConf.appId()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_SPARK_CONF_DIR()), (Object)Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_ID()), (Object)this.kubernetesConf.executorId()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_RESOURCE_PROFILE_ID()), (Object)Integer.toString(this.resourceProfile.id())), (List)Nil$.MODULE$)))))))).$plus$plus(this.kubernetesConf.environment(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)sparkAuthSecret, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_CLASSPATH()), ((Option)this.kubernetesConf.get(package$.MODULE$.EXECUTOR_CLASS_PATH())).orNull(Predef$.MODULE$.$conforms())), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)allOpts, Seq$.MODULE$.canBuildFrom()))).$plus$plus(KubernetesUtils$.MODULE$.buildEnvVarsWithFieldRef((Seq<Tuple3<String, String, String>>)((Seq)new .colon.colon((Object)new Tuple3((Object)Constants$.MODULE$.ENV_EXECUTOR_POD_IP(), (Object)"v1", (Object)"status.podIP"), (List)new .colon.colon((Object)new Tuple3((Object)Constants$.MODULE$.ENV_EXECUTOR_POD_NAME(), (Object)"v1", (Object)"metadata.name"), (List)Nil$.MODULE$)))), Seq$.MODULE$.canBuildFrom());
        executorEnv.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BasicExecutorFeatureStep.$anonfun$configurePod$6(x$1))).foreach((Function1 & Serializable & scala.Serializable)e -> {
            e.setValue(e.getValue().replaceAll(Constants$.MODULE$.ENV_APPLICATION_ID(), this.kubernetesConf.appId()).replaceAll(Constants$.MODULE$.ENV_EXECUTOR_ID(), this.kubernetesConf.executorId()));
            return BoxedUnit.UNIT;
        });
        Object object = requiredPorts = this.blockManagerPort() != 0 ? (Seq)((TraversableLike)new .colon.colon((Object)new Tuple2((Object)Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME(), (Object)BoxesRunTime.boxToInteger((int)this.blockManagerPort())), (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                int port = tuple2._2$mcI$sp();
                return ((ContainerPortBuilder)((ContainerPortFluentImpl)new ContainerPortBuilder().withName(name)).withContainerPort(Predef$.MODULE$.int2Integer(port))).build();
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom()) : Nil$.MODULE$;
        if (!this.isDefaultProfile() && pod2.container() != null && pod2.container().getResources() != null) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "NOT using the default profile and removing template resources");
            pod2.container().setResources(new ResourceRequirements());
        }
        Container executorContainer = ((ContainerBuilder)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluent.EnvNested)((ContainerFluentImpl)((ContainerFluent.ResourcesNested)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)new ContainerBuilder(pod2.container()).withName((String)Option$.MODULE$.apply((Object)pod2.container().getName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Constants$.MODULE$.DEFAULT_EXECUTOR_CONTAINER_NAME()))).withImage(this.executorContainerImage())).withImagePullPolicy(this.kubernetesConf.imagePullPolicy())).editOrNewResources().addToRequests("memory", executorMemoryQuantity).addToLimits("memory", executorMemoryQuantity).addToRequests("cpu", executorCpuQuantity).addToLimits((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(executorResourceQuantities).asJava())).endResources()).addNewEnv().withName(Constants$.MODULE$.ENV_SPARK_USER()).withValue(Utils$.MODULE$.getCurrentUserName())).endEnv()).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(executorEnv).asJava())).addAllToPorts((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)requiredPorts).asJava())).addToArgs(new String[]{"executor"})).build();
        Container executorContainerWithConfVolume = this.disableConfigMap() ? executorContainer : ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)new ContainerBuilder(executorContainer).addNewVolumeMount().withName(Constants$.MODULE$.SPARK_CONF_VOLUME_EXEC()).withMountPath(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endVolumeMount()).build();
        Container container2 = containerWithLimitCores = this.isDefaultProfile() ? (Container)this.executorLimitCores().map((Function1 & Serializable & scala.Serializable)limitCores -> {
            Quantity executorCpuLimitQuantity = new Quantity(limitCores);
            return ((ContainerBuilder)((ContainerFluent.ResourcesNested)new ContainerBuilder(executorContainerWithConfVolume).editResources().addToLimits("cpu", executorCpuLimitQuantity)).endResources()).build();
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> executorContainerWithConfVolume) : executorContainerWithConfVolume;
        if (!this.kubernetesConf.workerDecommissioning()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Decommissioning not enabled, skipping shutdown script");
            container = containerWithLimitCores;
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Adding decommission script to lifecycle");
            container = ((ContainerBuilder)((ContainerFluent.LifecycleNested)((LifecycleFluent.PreStopNested)((LifecycleHandlerFluent.ExecNested)new ContainerBuilder(containerWithLimitCores).withNewLifecycle().withNewPreStop().withNewExec().addToCommand(new String[]{this.kubernetesConf.get(Config$.MODULE$.DECOMMISSION_SCRIPT())})).endExec()).endPreStop()).endLifecycle()).build();
        }
        Container containerWithLifecycle = container;
        Option ownerReference = this.kubernetesConf.driverPod().map((Function1 & Serializable & scala.Serializable)pod -> ((OwnerReferenceBuilder)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)new OwnerReferenceBuilder().withController(Predef$.MODULE$.boolean2Boolean(true))).withApiVersion(pod.getApiVersion())).withKind(pod.getKind())).withName(pod.getMetadata().getName())).withUid(pod.getMetadata().getUid())).build());
        String string = this.kubernetesConf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_PODS_ALLOCATOR());
        String policy = "statefulset".equals(string) ? "Always" : "Never";
        scala.collection.immutable.Map annotations = (scala.collection.immutable.Map)this.kubernetesConf.annotations().map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2((Object)k, (Object)Utils$.MODULE$.substituteAppNExecIds(v, $this.kubernetesConf.appId(), $this.kubernetesConf.executorId()));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
        PodFluent.SpecNested executorPodBuilder = (PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder(pod2.pod()).editOrNewMetadata().withName(name2).addToLabels((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.labels()).asJava()).addToAnnotations((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)annotations).asJava()).addToOwnerReferences((OwnerReference[])Option$.MODULE$.option2Iterable(ownerReference).toSeq().toArray(ClassTag$.MODULE$.apply(OwnerReference.class)))).endMetadata()).editOrNewSpec().withHostname(hostname).withRestartPolicy(policy).addToNodeSelector((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.nodeSelector()).asJava()).addToNodeSelector((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.executorNodeSelector()).asJava()).addToImagePullSecrets((LocalObjectReference[])this.kubernetesConf.imagePullSecrets().toArray(ClassTag$.MODULE$.apply(LocalObjectReference.class)));
        Pod executorPod = this.disableConfigMap() ? ((PodBuilder)executorPodBuilder.endSpec()).build() : ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.ConfigMapNested)executorPodBuilder.addNewVolume().withName(Constants$.MODULE$.SPARK_CONF_VOLUME_EXEC()).withNewConfigMap().withItems((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(keyToPaths).asJava()).withName(configMapName)).endConfigMap()).endVolume()).endSpec()).build();
        PodSpec podSpec = executorPod.getSpec();
        this.kubernetesConf.schedulerName().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            podSpec.setSchedulerName(x$1);
            return BoxedUnit.UNIT;
        });
        return new SparkPod(executorPod, containerWithLifecycle);
    }

    public static final /* synthetic */ boolean $anonfun$configurePod$6(EnvVar x$1) {
        String string = x$1.getName();
        String string2 = Constants$.MODULE$.ENV_EXECUTOR_DIRS();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public BasicExecutorFeatureStep(KubernetesExecutorConf kubernetesConf, SecurityManager secMgr, ResourceProfile resourceProfile) {
        this.kubernetesConf = kubernetesConf;
        this.secMgr = secMgr;
        this.resourceProfile = resourceProfile;
        KubernetesFeatureConfigStep.$init$(this);
        Logging.$init$((Logging)this);
        this.executorContainerImage = (String)kubernetesConf.get(Config$.MODULE$.EXECUTOR_CONTAINER_IMAGE()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException("Must specify the executor container image");
        });
        this.blockManagerPort = kubernetesConf.sparkConf().getInt(package$.MODULE$.BLOCK_MANAGER_PORT().key(), Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT());
        Predef$.MODULE$.require(this.blockManagerPort() == 0 || 1024 <= this.blockManagerPort() && this.blockManagerPort() < 65536, (Function0 & Serializable & scala.Serializable)() -> "port number must be 0 or in [1024, 65535]");
        this.executorPodNamePrefix = kubernetesConf.resourceNamePrefix();
        this.driverUrl = RpcEndpointAddress$.MODULE$.apply((String)kubernetesConf.get(package$.MODULE$.DRIVER_HOST_ADDRESS()), kubernetesConf.sparkConf().getInt(package$.MODULE$.DRIVER_PORT().key(), Constants$.MODULE$.DEFAULT_DRIVER_PORT()), CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME()).toString();
        this.isDefaultProfile = resourceProfile.id() == ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
        String string = kubernetesConf.get(Config$.MODULE$.APP_RESOURCE_TYPE());
        Some some = new Some((Object)Constants$.MODULE$.APP_RESOURCE_TYPE_PYTHON());
        this.isPythonApp = !(string != null ? !string.equals(some) : some != null);
        this.disableConfigMap = BoxesRunTime.unboxToBoolean((Object)kubernetesConf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_DISABLE_CONFIGMAP()));
        this.memoryOverheadFactor = kubernetesConf.contains(package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD_FACTOR()) ? BoxesRunTime.unboxToDouble(kubernetesConf.get(package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD_FACTOR())) : BoxesRunTime.unboxToDouble((Object)kubernetesConf.get(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR()));
        this.execResources = ResourceProfile$.MODULE$.getResourcesForClusterManager(resourceProfile.id(), resourceProfile.executorResources(), this.memoryOverheadFactor(), kubernetesConf.sparkConf(), this.isPythonApp(), Predef$.MODULE$.Map().empty());
        Predef$.MODULE$.assert(this.execResources().cores().nonEmpty());
        this.executorMemoryString = new StringBuilder(1).append(this.execResources().executorMemoryMiB()).append("m").toString();
        this.executorCoresRequest = this.isDefaultProfile() && kubernetesConf.sparkConf().contains(Config$.MODULE$.KUBERNETES_EXECUTOR_REQUEST_CORES()) ? (String)((Option)kubernetesConf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_REQUEST_CORES())).get() : this.execResources().cores().get().toString();
        this.executorLimitCores = (Option)kubernetesConf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_LIMIT_CORES());
    }
}

