/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TruncInstant;
import org.apache.spark.sql.catalyst.expressions.TruncTimestamp$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(fmt, ts) - Returns timestamp `ts` truncated to the unit specified by the format model `fmt`.\n  ", arguments="\n    Arguments:\n      * fmt - the format representing the unit to be truncated to\n          - \"YEAR\", \"YYYY\", \"YY\" - truncate to the first date of the year that the `ts` falls in, the time part will be zero out\n          - \"QUARTER\" - truncate to the first date of the quarter that the `ts` falls in, the time part will be zero out\n          - \"MONTH\", \"MM\", \"MON\" - truncate to the first date of the month that the `ts` falls in, the time part will be zero out\n          - \"WEEK\" - truncate to the Monday of the week that the `ts` falls in, the time part will be zero out\n          - \"DAY\", \"DD\" - zero out the time part\n          - \"HOUR\" - zero out the minute and second with fraction part\n          - \"MINUTE\"- zero out the second with fraction part\n          - \"SECOND\" -  zero out the second fraction part\n          - \"MILLISECOND\" - zero out the microseconds\n          - \"MICROSECOND\" - everything remains\n      * ts - datetime value or valid timestamp string\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('YEAR', '2015-03-05T09:32:05.359');\n       2015-01-01 00:00:00\n      > SELECT _FUNC_('MM', '2015-03-05T09:32:05.359');\n       2015-03-01 00:00:00\n      > SELECT _FUNC_('DD', '2015-03-05T09:32:05.359');\n       2015-03-05 00:00:00\n      > SELECT _FUNC_('HOUR', '2015-03-05T09:32:05.359');\n       2015-03-05 09:00:00\n      > SELECT _FUNC_('MILLISECOND', '2015-03-05T09:32:05.123456');\n       2015-03-05 09:32:05.123\n  ", group="datetime_funcs", since="2.3.0")
@ScalaSignature(bytes="\u0006\u0001\t-b\u0001B\u0014)\u0001VB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011!\t\u0006A!f\u0001\n\u0003\u0011\u0006\u0002C1\u0001\u0005#\u0005\u000b\u0011B*\t\u000b\t\u0004A\u0011A2\t\u000b!\u0004A\u0011\t&\t\u000b%\u0004A\u0011\t&\t\u000b)\u0004A\u0011I6\t\u000bm\u0004A\u0011\t?\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!A\u0011Q\u0001\u0001C\u0002\u0013\u0005#\nC\u0004\u0002\b\u0001\u0001\u000b\u0011B&\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f!1!\r\u0001C\u0001\u0003\u001fAq!!\u0006\u0001\t\u0003\n9\u0002C\u0004\u0002,\u0001!\t%!\f\t\u000f\u0005%\u0003\u0001\"\u0015\u0002L!I\u0011Q\u000b\u0001\u0002\u0002\u0013\u0005\u0011q\u000b\u0005\n\u0003?\u0002\u0011\u0013!C\u0001\u0003CB\u0011\"a\u001e\u0001#\u0003%\t!!\u0019\t\u0013\u0005e\u0004!%A\u0005\u0002\u0005m\u0004\"CA@\u0001\u0005\u0005I\u0011IAA\u0011%\t\t\nAA\u0001\n\u0003\t\u0019\nC\u0005\u0002\u001c\u0002\t\t\u0011\"\u0001\u0002\u001e\"I\u00111\u0015\u0001\u0002\u0002\u0013\u0005\u0013Q\u0015\u0005\n\u0003g\u0003\u0011\u0011!C\u0001\u0003kC\u0011\"a0\u0001\u0003\u0003%\t%!1\b\u0013\u0005-\b&!A\t\u0002\u00055h\u0001C\u0014)\u0003\u0003E\t!a<\t\r\t|B\u0011AA\u007f\u0011%\typHA\u0001\n\u000b\u0012\t\u0001C\u0005\u0003\u0004}\t\t\u0011\"!\u0003\u0006!I!QB\u0010\u0012\u0002\u0013\u0005\u00111\u0010\u0005\n\u0005\u001fy\u0012\u0011!CA\u0005#A\u0011Ba\b #\u0003%\t!a\u001f\t\u0013\t\u0005r$!A\u0005\n\t\r\"A\u0004+sk:\u001cG+[7fgR\fW\u000e\u001d\u0006\u0003S)\n1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0006L\u0001\tG\u0006$\u0018\r\\=ti*\u0011QFL\u0001\u0004gFd'BA\u00181\u0003\u0015\u0019\b/\u0019:l\u0015\t\t$'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002g\u0005\u0019qN]4\u0004\u0001M1\u0001A\u000e\u001e>\u0001\u001a\u0003\"a\u000e\u001d\u000e\u0003!J!!\u000f\u0015\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u001c<\u0013\ta\u0004F\u0001\u0007UeVt7-\u00138ti\u0006tG\u000f\u0005\u00028}%\u0011q\b\u000b\u0002\u0018)&lWMW8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:\u0004\"!\u0011#\u000e\u0003\tS\u0011aQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000b\n\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002B\u000f&\u0011\u0001J\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007M>\u0014X.\u0019;\u0016\u0003-\u0003\"a\u000e'\n\u00055C#AC#yaJ,7o]5p]\u00069am\u001c:nCR\u0004\u0013!\u0003;j[\u0016\u001cH/Y7q\u0003)!\u0018.\\3ti\u0006l\u0007\u000fI\u0001\u000bi&lWMW8oK&#W#A*\u0011\u0007\u0005#f+\u0003\u0002V\u0005\n1q\n\u001d;j_:\u0004\"a\u00160\u000f\u0005ac\u0006CA-C\u001b\u0005Q&BA.5\u0003\u0019a$o\\8u}%\u0011QLQ\u0001\u0007!J,G-\u001a4\n\u0005}\u0003'AB*ue&twM\u0003\u0002^\u0005\u0006YA/[7f5>tW-\u00133!\u0003\u0019a\u0014N\\5u}Q!A-\u001a4h!\t9\u0004\u0001C\u0003J\u000f\u0001\u00071\nC\u0003P\u000f\u0001\u00071\nC\u0004R\u000fA\u0005\t\u0019A*\u0002\t1,g\r^\u0001\u0006e&<\u0007\u000e^\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u00017\u0011\u00075\u0014XO\u0004\u0002oa:\u0011\u0011l\\\u0005\u0002\u0007&\u0011\u0011OQ\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019HOA\u0002TKFT!!\u001d\"\u0011\u0005YLX\"A<\u000b\u0005ad\u0013!\u0002;za\u0016\u001c\u0018B\u0001>x\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\u0005i\bC\u0001<\u007f\u0013\tyxOA\u0007US6,7\u000f^1naRK\b/Z\u0001\u000baJ,G\u000f^=OC6,W#\u0001,\u0002\u000f%t7\u000f^1oi\u0006A\u0011N\\:uC:$\b%\u0001\u0007xSRDG+[7f5>tW\rF\u0002>\u0003\u001bAQ!U\bA\u0002Y#R\u0001ZA\t\u0003'AQ!\u0013\tA\u0002-CQa\u0014\tA\u0002-\u000bA!\u001a<bYR!\u0011\u0011DA\u0010!\r\t\u00151D\u0005\u0004\u0003;\u0011%aA!os\"I\u0011\u0011E\t\u0011\u0002\u0003\u0007\u00111E\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003K\t9#D\u0001+\u0013\r\tIC\u000b\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR1\u0011qFA\u001e\u0003\u000b\u0002B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003kA\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003s\t\u0019D\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tiD\u0005a\u0001\u0003\u007f\t1a\u0019;y!\u0011\t\t$!\u0011\n\t\u0005\r\u00131\u0007\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t9E\u0005a\u0001\u0003_\t!!\u001a<\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#\u00023\u0002N\u0005E\u0003BBA('\u0001\u00071*A\u0004oK^dUM\u001a;\t\r\u0005M3\u00031\u0001L\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$r\u0001ZA-\u00037\ni\u0006C\u0004J)A\u0005\t\u0019A&\t\u000f=#\u0002\u0013!a\u0001\u0017\"9\u0011\u000b\u0006I\u0001\u0002\u0004\u0019\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003GR3aSA3W\t\t9\u0007\u0005\u0003\u0002j\u0005MTBAA6\u0015\u0011\ti'a\u001c\u0002\u0013Ut7\r[3dW\u0016$'bAA9\u0005\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00141\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tiHK\u0002T\u0003K\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAB!\u0011\t))a$\u000e\u0005\u0005\u001d%\u0002BAE\u0003\u0017\u000bA\u0001\\1oO*\u0011\u0011QR\u0001\u0005U\u00064\u0018-C\u0002`\u0003\u000f\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!&\u0011\u0007\u0005\u000b9*C\u0002\u0002\u001a\n\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0007\u0002 \"I\u0011\u0011\u0015\u000e\u0002\u0002\u0003\u0007\u0011QS\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u001d\u0006CBAU\u0003_\u000bI\"\u0004\u0002\u0002,*\u0019\u0011Q\u0016\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00022\u0006-&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a.\u0002>B\u0019\u0011)!/\n\u0007\u0005m&IA\u0004C_>dW-\u00198\t\u0013\u0005\u0005F$!AA\u0002\u0005e\u0011AB3rk\u0006d7\u000f\u0006\u0003\u00028\u0006\r\u0007\"CAQ;\u0005\u0005\t\u0019AA\rQ]\u0001\u0011qYAg\u0003\u001f\f\u0019.!6\u0002Z\u0006m\u0017q\\Aq\u0003K\f9\u000fE\u00028\u0003\u0013L1!a3)\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!5\u0002W*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015g[Rd\u0003\u0005^:*A5\u0002#+\u001a;ve:\u001c\b\u0005^5nKN$\u0018-\u001c9!AR\u001c\b\r\t;sk:\u001c\u0017\r^3eAQ|\u0007\u0005\u001e5fAUt\u0017\u000e\u001e\u0011ta\u0016\u001c\u0017NZ5fI\u0002\u0012\u0017\u0010\t;iK\u00022wN]7bi\u0002jw\u000eZ3mA\u00014W\u000e\u001e1/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\t9.ADJ\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002c-\u001c;![\u0001\"\b.\u001a\u0011g_Jl\u0017\r\u001e\u0011sKB\u0014Xm]3oi&tw\r\t;iK\u0002*h.\u001b;!i>\u0004#-\u001a\u0011ueVt7-\u0019;fI\u0002\"xN\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%W#B%\nb\u0003EI-Z3f\u0013C\u0006\t\u0012Z3\n\u0002S\u0006\t;sk:\u001c\u0017\r^3!i>\u0004C\u000f[3!M&\u00148\u000f\u001e\u0011eCR,\u0007e\u001c4!i\",\u0007%_3be\u0002\"\b.\u0019;!i\",\u0007\u0005\u0019;tA\u00022\u0017\r\u001c7tA%tG\u0006\t;iK\u0002\"\u0018.\\3!a\u0006\u0014H\u000fI<jY2\u0004#-\u001a\u0011{KJ|\u0007e\\;u\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011##V\u000b%\u000bV#SE\u0001j\u0003\u0005\u001e:v]\u000e\fG/\u001a\u0011u_\u0002\"\b.\u001a\u0011gSJ\u001cH\u000f\t3bi\u0016\u0004sN\u001a\u0011uQ\u0016\u0004\u0013/^1si\u0016\u0014\b\u0005\u001e5bi\u0002\"\b.\u001a\u0011aiN\u0004\u0007EZ1mYN\u0004\u0013N\u001c\u0017!i\",\u0007\u0005^5nK\u0002\u0002\u0018M\u001d;!o&dG\u000e\t2fAi,'o\u001c\u0011pkRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\tjuJ\u0014+IE1\u0002#%T'#Y\u0001\u0012Sj\u0014(#A5\u0002CO];oG\u0006$X\r\t;pAQDW\r\t4jeN$\b\u0005Z1uK\u0002zg\r\t;iK\u0002jwN\u001c;iAQD\u0017\r\u001e\u0011uQ\u0016\u0004\u0003\r^:aA\u0019\fG\u000e\\:!S:d\u0003\u0005\u001e5fAQLW.\u001a\u0011qCJ$\be^5mY\u0002\u0012W\r\t>fe>\u0004s.\u001e;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012X\u000b\u0016[%\u0005I\u0017!iJ,hnY1uK\u0002\"x\u000e\t;iK\u0002juN\u001c3bs\u0002zg\r\t;iK\u0002:X-Z6!i\"\fG\u000f\t;iK\u0002\u0002Go\u001d1!M\u0006dGn\u001d\u0011j]2\u0002C\u000f[3!i&lW\r\t9beR\u0004s/\u001b7mA\t,\u0007E_3s_\u0002zW\u000f\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003E\t#B3\nb\u0003E\t#EE\u0001j\u0003E_3s_\u0002zW\u000f\u001e\u0011uQ\u0016\u0004C/[7fAA\f'\u000f\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003E\t%P+J\u0013\u0003%\f\u0011{KJ|\u0007e\\;uAQDW\rI7j]V$X\rI1oI\u0002\u001aXmY8oI\u0002:\u0018\u000e\u001e5!MJ\f7\r^5p]\u0002\u0002\u0018M\u001d;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012N\u0013:+F+\u0012\u0012.Ai,'o\u001c\u0011pkR\u0004C\u000f[3!g\u0016\u001cwN\u001c3!o&$\b\u000e\t4sC\u000e$\u0018n\u001c8!a\u0006\u0014HO\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#eU#D\u001f:#%\u0005I\u0017!Ai,'o\u001c\u0011pkR\u0004C\u000f[3!g\u0016\u001cwN\u001c3!MJ\f7\r^5p]\u0002\u0002\u0018M\u001d;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012N\u00132c\u0015jU#D\u001f:#%\u0005I\u0017!u\u0016\u0014x\u000eI8vi\u0002\"\b.\u001a\u0011nS\u000e\u0014xn]3d_:$7O\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%T%D%>\u001bViQ(O\t\n\u0002S\u0006I3wKJLH\u000f[5oO\u0002\u0012X-\\1j]NT\u0001\u0005\t\u0011!A\u0001R\u0003\u0005^:![\u0001\"\u0017\r^3uS6,\u0007E^1mk\u0016\u0004sN\u001d\u0011wC2LG\r\t;j[\u0016\u001cH/Y7qAM$(/\u001b8h\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005u\u0017a!#\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dJV)\u0011*(Y\u0001:#\u0007M\u00196[A\u001aT\u0006M\u001bUaeR4G\r\u001e1k9\u001aT'O\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'M\u001b.aEj\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":S*T\u0014-A\u001d\u0012\u0004'M\u001b.aMj\u0003'\u000e+1si\u001a$G\u000f\u00196]M*\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014'N\u00171g5\u0002\u0014\u0007\t\u00191uA\u0002$\b\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\"Ei\n\u0017!OI\u0002\u0014'N\u00171g5\u0002T\u0007\u0016\u0019:uM\u0012$\bM\u001b/gUJt%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\nT'\f\u00194[A*\u0004\u0005\r\u0019;aAR\u0004\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O!{UKU\u0014-A\u001d\u0012\u0004'M\u001b.aMj\u0003'\u000e+1si\u001a$G\u000f\u00196]M*\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014'N\u00171g5\u0002T\u0007\t\u0019:uA\u0002$\b\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dj\u0015\n\u0014'J'\u0016\u001buJ\u0014#(Y\u0001:#\u0007M\u00196[A\u001aT\u0006M\u001bUaeR4G\r\u001e1k9\n$g\r\u001b6m\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cUj\u0003gM\u00171k\u0001\u0002\u0014HO\u001a3uA*d&\r\u001a4\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAr\u00039!\u0017\r^3uS6,wLZ;oGN\fQa]5oG\u0016\f#!!;\u0002\u000bIr3G\f\u0019\u0002\u001dQ\u0013XO\\2US6,7\u000f^1naB\u0011qgH\n\u0005?\u0005Eh\t\u0005\u0005\u0002t\u0006e8jS*e\u001b\t\t)PC\u0002\u0002x\n\u000bqA];oi&lW-\u0003\u0003\u0002|\u0006U(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011\u0011Q^\u0001\ti>\u001cFO]5oOR\u0011\u00111Q\u0001\u0006CB\u0004H.\u001f\u000b\bI\n\u001d!\u0011\u0002B\u0006\u0011\u0015I%\u00051\u0001L\u0011\u0015y%\u00051\u0001L\u0011\u001d\t&\u0005%AA\u0002M\u000bq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\u0019Ba\u0007\u0011\t\u0005#&Q\u0003\t\u0007\u0003\n]1jS*\n\u0007\te!I\u0001\u0004UkBdWm\r\u0005\t\u0005;!\u0013\u0011!a\u0001I\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u0015\u0002\u0003BAC\u0005OIAA!\u000b\u0002\b\n1qJ\u00196fGR\u0004")
public class TruncTimestamp
extends BinaryExpression
implements TruncInstant,
TimeZoneAwareExpression,
scala.Serializable {
    private final Expression format;
    private final Expression timestamp;
    private final Option<String> timeZoneId;
    private final Expression instant;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$3() {
        return TruncTimestamp$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(TruncTimestamp truncTimestamp) {
        return TruncTimestamp$.MODULE$.unapply(truncTimestamp);
    }

    public static Option<String> apply$default$3() {
        return TruncTimestamp$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, TruncTimestamp> tupled() {
        return TruncTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, TruncTimestamp>>> curried() {
        return TruncTimestamp$.MODULE$.curried();
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public boolean nullable() {
        return TruncInstant.nullable$(this);
    }

    @Override
    public Object evalHelper(InternalRow input, int minLevel, Function2<Object, Object, Object> truncFunc) {
        return TruncInstant.evalHelper$(this, input, minLevel, truncFunc);
    }

    @Override
    public ExprCode codeGenHelper(CodegenContext ctx, ExprCode ev, int minLevel, boolean orderReversed, Function2<String, String, String> truncFunc) {
        return TruncInstant.codeGenHelper$(this, ctx, ev, minLevel, orderReversed, truncFunc);
    }

    @Override
    public boolean codeGenHelper$default$4() {
        return TruncInstant.codeGenHelper$default$4$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        TruncTimestamp truncTimestamp = this;
        synchronized (truncTimestamp) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        TruncTimestamp truncTimestamp = this;
        synchronized (truncTimestamp) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if (!this.bitmap$trans$0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() {
        TruncTimestamp truncTimestamp = this;
        synchronized (truncTimestamp) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel = TruncInstant.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    }

    @Override
    public int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    }

    @Override
    public Expression format() {
        return this.format;
    }

    public Expression timestamp() {
        return this.timestamp;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.format();
    }

    @Override
    public Expression right() {
        return this.timestamp();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)TimestampType$.MODULE$, (List)Nil$.MODULE$));
    }

    public TimestampType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "date_trunc";
    }

    @Override
    public Expression instant() {
        return this.instant;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object eval(InternalRow input) {
        return this.evalHelper(input, DateTimeUtils$.MODULE$.MIN_LEVEL_OF_TIMESTAMP_TRUNC(), (Function2<Object, Object, Object>)(Function2 & Serializable & scala.Serializable)(t, level) -> BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.truncTimestamp(BoxesRunTime.unboxToLong((Object)t), BoxesRunTime.unboxToInt((Object)level), this.zoneId())));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
        return this.codeGenHelper(ctx, ev, DateTimeUtils$.MODULE$.MIN_LEVEL_OF_TIMESTAMP_TRUNC(), true, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(date, fmt) -> new StringBuilder(21).append("truncTimestamp(").append((String)date).append(", ").append((String)fmt).append(", ").append(zid).append(");").toString());
    }

    @Override
    public TruncTimestamp withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public TruncTimestamp copy(Expression format, Expression timestamp, Option<String> timeZoneId) {
        return new TruncTimestamp(format, timestamp, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.format();
    }

    public Expression copy$default$2() {
        return this.timestamp();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "TruncTimestamp";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.format();
            }
            case 1: {
                return this.timestamp();
            }
            case 2: {
                return this.timeZoneId();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncTimestamp truncTimestamp = (TruncTimestamp)x$1;
        Expression expression = this.format();
        Expression expression2 = truncTimestamp.format();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.timestamp();
        Expression expression4 = truncTimestamp.timestamp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = truncTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!truncTimestamp.canEqual(this)) return false;
        return true;
    }

    public TruncTimestamp(Expression format, Expression timestamp, Option<String> timeZoneId) {
        this.format = format;
        this.timestamp = timestamp;
        this.timeZoneId = timeZoneId;
        ExpectsInputTypes.$init$(this);
        TruncInstant.$init$(this);
        TimeZoneAwareExpression.$init$(this);
        this.instant = timestamp;
    }

    public TruncTimestamp(Expression format, Expression timestamp) {
        this(format, timestamp, (Option<String>)None$.MODULE$);
    }
}

