/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.optimizer.InlineCTE;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeWatermark;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.WithCTE;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.ReportsSinkMetrics;
import org.apache.spark.sql.connector.read.streaming.ReportsSourceMetrics;
import org.apache.spark.sql.connector.read.streaming.SparkDataStream;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.MicroBatchScanExec;
import org.apache.spark.sql.execution.datasources.v2.StreamWriterCommitProgress;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.streaming.EventTimeStats;
import org.apache.spark.sql.execution.streaming.EventTimeWatermarkExec;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.ProgressReporter$;
import org.apache.spark.sql.execution.streaming.ProgressReporter$ExecutionStats$;
import org.apache.spark.sql.execution.streaming.StateStoreWriter;
import org.apache.spark.sql.execution.streaming.StreamProgress;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation;
import org.apache.spark.sql.streaming.SinkProgress;
import org.apache.spark.sql.streaming.SinkProgress$;
import org.apache.spark.sql.streaming.SourceProgress;
import org.apache.spark.sql.streaming.StateOperatorProgress;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.sql.streaming.StreamingQueryStatus;
import org.apache.spark.util.Clock;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Queue;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0005aa\u0002*T!\u0003\r\t\u0001\u0019\u0005\u0006[\u0002!\tA\u001c\u0004\u0005e\u0002\u00015\u000f\u0003\u0005{\u0005\tU\r\u0011\"\u0001|\u0011%\t9C\u0001B\tB\u0003%A\u0010\u0003\u0006\u0002*\t\u0011)\u001a!C\u0001\u0003WA!\"!\u0013\u0003\u0005#\u0005\u000b\u0011BA\u0017\u0011)\tYE\u0001BK\u0002\u0013\u0005\u0011Q\n\u0005\u000b\u0003/\u0012!\u0011#Q\u0001\n\u0005=\u0003bBA-\u0005\u0011\u0005\u00111\f\u0005\n\u0003O\u0012\u0011\u0011!C\u0001\u0003SB\u0011\"!\u001d\u0003#\u0003%\t!a\u001d\t\u0013\u0005%%!%A\u0005\u0002\u0005-\u0005\"CAH\u0005E\u0005I\u0011AAI\u0011%\t)JAA\u0001\n\u0003\n9\nC\u0005\u0002(\n\t\t\u0011\"\u0001\u0002*\"I\u0011\u0011\u0017\u0002\u0002\u0002\u0013\u0005\u00111\u0017\u0005\n\u0003\u007f\u0013\u0011\u0011!C!\u0003\u0003D\u0011\"a4\u0003\u0003\u0003%\t!!5\t\u0013\u0005m'!!A\u0005B\u0005u\u0007\"CAp\u0005\u0005\u0005I\u0011IAq\u0011%\t\u0019OAA\u0001\n\u0003\n)oB\u0005\u0002j\u0002\t\t\u0011#\u0001\u0002l\u001aA!\u000fAA\u0001\u0012\u0003\ti\u000fC\u0004\u0002Z]!\t!a?\t\u0013\u0005}w#!A\u0005F\u0005\u0005\b\"CA\u007f/\u0005\u0005I\u0011QA\u0000\u0011%\u00119aFA\u0001\n\u0003\u0013I\u0001C\u0004\u0003\u001c\u00011\tB!\b\t\u000f\t-\u0002A\"\u0005\u0003\u001e!9!Q\u0006\u0001\u0007\u0012\t=\u0002b\u0002B\u0019\u0001\u0019E!1\u0007\u0005\b\u0005\u007f\u0001a\u0011\u0003B!\u0011\u001d\u00119\u0006\u0001D\t\u00053BqAa\u0019\u0001\r#\u0011)\u0007C\u0004\u0003j\u00011\tBa\u001b\t\u000f\t}\u0004A\"\u0005\u0003\u0002\"9!Q\u0011\u0001\u0007\u0012\t\u001d\u0005b\u0002BK\u0001\u0019E!q\u0013\u0005\b\u0005C\u0003a\u0011\u0003BR\u0011\u001d\u0011)\u000b\u0001D\t\u0005OCqA!-\u0001\r#\u0011\u0019\fC\u0005\u0003H\u0002\u0001\r\u0011\"\u0003\u0003$\"I!\u0011\u001a\u0001A\u0002\u0013%!1\u001a\u0005\n\u0005\u001f\u0004\u0001\u0019!C\u0005\u0005GC\u0011B!5\u0001\u0001\u0004%IAa5\t\u0017\t]\u0007\u00011AA\u0002\u0013%!\u0011\u001c\u0005\f\u0005;\u0004\u0001\u0019!a\u0001\n\u0013\u0011y\u000eC\u0006\u0003d\u0002\u0001\r\u00111A\u0005\n\te\u0007b\u0003Bs\u0001\u0001\u0007\t\u0019!C\u0005\u0005OD1Ba;\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003Z\"Y!Q\u001e\u0001A\u0002\u0003\u0007I\u0011\u0002Bx\u0011%\u0011\u0019\u0010\u0001a\u0001\n\u0013\u0011\u0019\u000bC\u0005\u0003v\u0002\u0001\r\u0011\"\u0003\u0003x\"I!1 \u0001C\u0002\u0013%!Q \u0005\n\u0007\u0017\u0001\u0001\u0019!C\u0005\u0007\u001bA\u0011ba\u0004\u0001\u0001\u0004%Ia!\u0005\t\u0013\rU\u0001A1A\u0005\n\r]\u0001\"CB\u0013\u0001\t\u0007I\u0011\u0002BR\u0011%\u00199\u0003\u0001a\u0001\n\u0013\u0011\u0019\u000bC\u0005\u0004*\u0001\u0001\r\u0011\"\u0003\u0004,!I1q\u0006\u0001C\u0002\u0013%1\u0011\u0007\u0005\n\u0007\u007f\u0001\u0001\u0019!C\t\u0007\u0003B\u0011b!\u0015\u0001\u0001\u0004%\tba\u0015\t\u0017\r]\u0003\u00011AA\u0002\u0013%1\u0011\f\u0005\f\u0007C\u0002\u0001\u0019!a\u0001\n\u0013\u0019\u0019\u0007C\u0004\u0004h\u0001!\ta!\u0011\t\u000f\r%\u0004\u0001\"\u0001\u0004l!911\u000f\u0001\u0005\u0002\rU\u0004BBB<\u0001\u0011Ea\u000eC\u0004\u0004z\u0001!\tba\u001f\t\u000f\r%\u0005\u0001\"\u0003\u0004\f\"91\u0011\u0013\u0001\u0005\n\rM\u0005bBBL\u0001\u0011%1\u0011\u0014\u0005\b\u0007;\u0003A\u0011CBP\u0011\u001d\u0019I\u000b\u0001C\u0005\u0007WCqaa,\u0001\t\u0013\u0019\t\fC\u0004\u00048\u0002!Ia!/\t\u000f\rm\u0006\u0001\"\u0003\u0004>\"911\u001a\u0001\u0005\u0012\r5\u0007bBBy\u0001\u0011E11\u001f\u0005\b\u0007s\u0004A\u0011CB~\u0005A\u0001&o\\4sKN\u001c(+\u001a9peR,'O\u0003\u0002U+\u0006I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003-^\u000b\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005aK\u0016aA:rY*\u0011!lW\u0001\u0006gB\f'o\u001b\u0006\u00039v\u000ba!\u00199bG\",'\"\u00010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\tw\r\u0005\u0002cK6\t1MC\u0001e\u0003\u0015\u00198-\u00197b\u0013\t17M\u0001\u0004B]f\u0014VM\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003Uf\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003Y&\u0014q\u0001T8hO&tw-\u0001\u0004%S:LG\u000f\n\u000b\u0002_B\u0011!\r]\u0005\u0003c\u000e\u0014A!\u00168ji\nqQ\t_3dkRLwN\\*uCR\u001c8\u0003\u0002\u0002bi^\u0004\"AY;\n\u0005Y\u001c'a\u0002)s_\u0012,8\r\u001e\t\u0003EbL!!_2\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0013%t\u0007/\u001e;S_^\u001cX#\u0001?\u0011\u000fu\fI!a\u0004\u0002\"9\u0019a0!\u0002\u0011\u0005}\u001cWBAA\u0001\u0015\r\t\u0019aX\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u001d1-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0017\tiAA\u0002NCBT1!a\u0002d!\u0011\t\t\"!\b\u000e\u0005\u0005M!b\u0001+\u0002\u0016)!\u0011qCA\r\u0003\u0011\u0011X-\u00193\u000b\u0007\u0005mq+A\u0005d_:tWm\u0019;pe&!\u0011qDA\n\u0005=\u0019\u0006/\u0019:l\t\u0006$\u0018m\u0015;sK\u0006l\u0007c\u00012\u0002$%\u0019\u0011QE2\u0003\t1{gnZ\u0001\u000bS:\u0004X\u000f\u001e*poN\u0004\u0013AD:uCR,w\n]3sCR|'o]\u000b\u0003\u0003[\u0001b!a\f\u0002:\u0005}b\u0002BA\u0019\u0003kq1a`A\u001a\u0013\u0005!\u0017bAA\u001cG\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u001e\u0003{\u00111aU3r\u0015\r\t9d\u0019\t\u0005\u0003\u0003\n)%\u0004\u0002\u0002D)\u0011AkV\u0005\u0005\u0003\u000f\n\u0019EA\u000bTi\u0006$Xm\u00149fe\u0006$xN\u001d)s_\u001e\u0014Xm]:\u0002\u001fM$\u0018\r^3Pa\u0016\u0014\u0018\r^8sg\u0002\na\"\u001a<f]R$\u0016.\\3Ti\u0006$8/\u0006\u0002\u0002PA9Q0!\u0003\u0002R\u0005E\u0003cA?\u0002T%!\u0011QKA\u0007\u0005\u0019\u0019FO]5oO\u0006yQM^3oiRKW.Z*uCR\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\t\u0003;\n\t'a\u0019\u0002fA\u0019\u0011q\f\u0002\u000e\u0003\u0001AQA_\u0005A\u0002qDq!!\u000b\n\u0001\u0004\ti\u0003C\u0004\u0002L%\u0001\r!a\u0014\u0002\t\r|\u0007/\u001f\u000b\t\u0003;\nY'!\u001c\u0002p!9!P\u0003I\u0001\u0002\u0004a\b\"CA\u0015\u0015A\u0005\t\u0019AA\u0017\u0011%\tYE\u0003I\u0001\u0002\u0004\ty%\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005U$f\u0001?\u0002x-\u0012\u0011\u0011\u0010\t\u0005\u0003w\n))\u0004\u0002\u0002~)!\u0011qPAA\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0004\u000e\f!\"\u00198o_R\fG/[8o\u0013\u0011\t9)! \u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u00055%\u0006BA\u0017\u0003o\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0014*\"\u0011qJA<\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u0014\t\u0005\u00037\u000b)+\u0004\u0002\u0002\u001e*!\u0011qTAQ\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\r\u0016\u0001\u00026bm\u0006LA!!\u0016\u0002\u001e\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u0016\t\u0004E\u00065\u0016bAAXG\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QWA^!\r\u0011\u0017qW\u0005\u0004\u0003s\u001b'aA!os\"I\u0011Q\u0018\t\u0002\u0002\u0003\u0007\u00111V\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\r\u0007CBAc\u0003\u0017\f),\u0004\u0002\u0002H*\u0019\u0011\u0011Z2\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002N\u0006\u001d'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a5\u0002ZB\u0019!-!6\n\u0007\u0005]7MA\u0004C_>dW-\u00198\t\u0013\u0005u&#!AA\u0002\u0005U\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005-\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005e\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002T\u0006\u001d\b\"CA_+\u0005\u0005\t\u0019AA[\u00039)\u00050Z2vi&|gn\u0015;biN\u00042!a\u0018\u0018'\u00119\u0012q^<\u0011\u0017\u0005E\u0018q\u001f?\u0002.\u0005=\u0013QL\u0007\u0003\u0003gT1!!>d\u0003\u001d\u0011XO\u001c;j[\u0016LA!!?\u0002t\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\u0005-\u0018!B1qa2LH\u0003CA/\u0005\u0003\u0011\u0019A!\u0002\t\u000biT\u0002\u0019\u0001?\t\u000f\u0005%\"\u00041\u0001\u0002.!9\u00111\n\u000eA\u0002\u0005=\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0017\u00119\u0002E\u0003c\u0005\u001b\u0011\t\"C\u0002\u0003\u0010\r\u0014aa\u00149uS>t\u0007\u0003\u00032\u0003\u0014q\fi#a\u0014\n\u0007\tU1M\u0001\u0004UkBdWm\r\u0005\n\u00053Y\u0012\u0011!a\u0001\u0003;\n1\u0001\u001f\u00131\u0003\tIG-\u0006\u0002\u0003 A!!\u0011\u0005B\u0014\u001b\t\u0011\u0019C\u0003\u0003\u0003&\u0005\u0005\u0016\u0001B;uS2LAA!\u000b\u0003$\t!Q+V%E\u0003\u0015\u0011XO\\%e\u0003\u0011q\u0017-\\3\u0016\u0005\u0005E\u0013\u0001\u0004;sS\u001e<WM]\"m_\u000e\\WC\u0001B\u001b!\u0011\u00119Da\u000f\u000e\u0005\te\"b\u0001B\u00133&!!Q\bB\u001d\u0005\u0015\u0019En\\2l\u0003-awnZ5dC2\u0004F.\u00198\u0016\u0005\t\r\u0003\u0003\u0002B#\u0005'j!Aa\u0012\u000b\t\t%#1J\u0001\bY><\u0017nY1m\u0015\u0011\u0011iEa\u0014\u0002\u000bAd\u0017M\\:\u000b\u0007\tEs+\u0001\u0005dCR\fG._:u\u0013\u0011\u0011)Fa\u0012\u0003\u00171{w-[2bYBc\u0017M\\\u0001\u000eY\u0006\u001cH/\u0012=fGV$\u0018n\u001c8\u0016\u0005\tm\u0003\u0003\u0002B/\u0005?j\u0011!V\u0005\u0004\u0005C*&AD)vKJLX\t_3dkRLwN\\\u0001\b]\u0016<H)\u0019;b+\t\u00119\u0007E\u0004~\u0003\u0013\tyAa\u0011\u0002%MLgn[\"p[6LG\u000f\u0015:pOJ,7o]\u000b\u0003\u0005[\u0002RA\u0019B\u0007\u0005_\u0002BA!\u001d\u0003|5\u0011!1\u000f\u0006\u0005\u0005k\u00129(\u0001\u0002we)\u0019!\u0011P+\u0002\u0017\u0011\fG/Y:pkJ\u001cWm]\u0005\u0005\u0005{\u0012\u0019H\u0001\u000eTiJ,\u0017-\\,sSR,'oQ8n[&$\bK]8he\u0016\u001c8/A\u0004t_V\u00148-Z:\u0016\u0005\t\r\u0005CBA\u0018\u0003s\ty!\u0001\u0003tS:\\WC\u0001BE!\u0011\u0011YI!%\u000e\u0005\t5%\u0002\u0002BH\u00033\tqaY1uC2|w-\u0003\u0003\u0003\u0014\n5%!\u0002+bE2,\u0017!E8gMN,GoU3r\u001b\u0016$\u0018\rZ1uCV\u0011!\u0011\u0014\t\u0005\u00057\u0013i*D\u0001T\u0013\r\u0011yj\u0015\u0002\u0012\u001f\u001a47/\u001a;TKFlU\r^1eCR\f\u0017AD2veJ,g\u000e\u001e\"bi\u000eD\u0017\nZ\u000b\u0003\u0003C\tAb\u001d9be.\u001cVm]:j_:,\"A!+\u0011\t\t-&QV\u0007\u0002/&\u0019!qV,\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u0013A|7\u000f^#wK:$HcA8\u00036\"9!qW\u0015A\u0002\te\u0016!B3wK:$\b\u0003\u0002B^\u0005\u0003tA!!\u0011\u0003>&!!qXA\"\u0003Y\u0019FO]3b[&tw-U;fefd\u0015n\u001d;f]\u0016\u0014\u0018\u0002\u0002Bb\u0005\u000b\u0014Q!\u0012<f]RTAAa0\u0002D\u0005a2-\u001e:sK:$HK]5hO\u0016\u00148\u000b^1siRKW.Z:uC6\u0004\u0018\u0001I2veJ,g\u000e\u001e+sS\u001e<WM]*uCJ$H+[7fgR\fW\u000e]0%KF$2a\u001cBg\u0011%\tilKA\u0001\u0002\u0004\t\t#\u0001\u000edkJ\u0014XM\u001c;Ue&<w-\u001a:F]\u0012$\u0016.\\3ti\u0006l\u0007/\u0001\u0010dkJ\u0014XM\u001c;Ue&<w-\u001a:F]\u0012$\u0016.\\3ti\u0006l\u0007o\u0018\u0013fcR\u0019qN!6\t\u0013\u0005uV&!AA\u0002\u0005\u0005\u0012AG2veJ,g\u000e\u001e+sS\u001e<WM]*uCJ$xJ\u001a4tKR\u001cXC\u0001Bn!\u001di\u0018\u0011BA\b\u0003#\nadY;se\u0016tG\u000f\u0016:jO\u001e,'o\u0015;beR|eMZ:fiN|F%Z9\u0015\u0007=\u0014\t\u000fC\u0005\u0002>>\n\t\u00111\u0001\u0003\\\u0006A2-\u001e:sK:$HK]5hO\u0016\u0014XI\u001c3PM\u001a\u001cX\r^:\u00029\r,(O]3oiR\u0013\u0018nZ4fe\u0016sGm\u00144gg\u0016$8o\u0018\u0013fcR\u0019qN!;\t\u0013\u0005u\u0016'!AA\u0002\tm\u0017aG2veJ,g\u000e\u001e+sS\u001e<WM\u001d'bi\u0016\u001cHo\u00144gg\u0016$8/A\u0010dkJ\u0014XM\u001c;Ue&<w-\u001a:MCR,7\u000f^(gMN,Go]0%KF$2a\u001cBy\u0011%\tilMA\u0001\u0002\u0004\u0011Y.A\rmCN$HK]5hO\u0016\u00148\u000b^1siRKW.Z:uC6\u0004\u0018!\b7bgR$&/[4hKJ\u001cF/\u0019:u)&lWm\u001d;b[B|F%Z9\u0015\u0007=\u0014I\u0010C\u0005\u0002>V\n\t\u00111\u0001\u0002\"\u0005\u00112-\u001e:sK:$H)\u001e:bi&|gn]'t+\t\u0011y\u0010\u0005\u0005\u0004\u0002\r\u001d\u0011\u0011KA\u0011\u001b\t\u0019\u0019A\u0003\u0003\u0004\u0006\u0005\u001d\u0017aB7vi\u0006\u0014G.Z\u0005\u0005\u0007\u0013\u0019\u0019AA\u0004ICNDW*\u00199\u0002'5,GO]5d/\u0006\u0014h.\u001b8h\u0019><w-\u001a3\u0016\u0005\u0005M\u0017aF7fiJL7mV1s]&tw\rT8hO\u0016$w\fJ3r)\ry71\u0003\u0005\n\u0003{C\u0014\u0011!a\u0001\u0003'\fa\u0002\u001d:pOJ,7o\u001d\"vM\u001a,'/\u0006\u0002\u0004\u001aA11\u0011AB\u000e\u0007?IAa!\b\u0004\u0004\t)\u0011+^3vKB!\u0011\u0011IB\u0011\u0013\u0011\u0019\u0019#a\u0011\u0003-M#(/Z1nS:<\u0017+^3ssB\u0013xn\u001a:fgN\f1D\\8ECR\f\u0007K]8he\u0016\u001c8/\u0012<f]RLe\u000e^3sm\u0006d\u0017\u0001\t7bgRtu.\u0012=fGV$\u0018n\u001c8Qe><'/Z:t\u000bZ,g\u000e\u001e+j[\u0016\fA\u0005\\1ti:{W\t_3dkRLwN\u001c)s_\u001e\u0014Xm]:Fm\u0016tG\u000fV5nK~#S-\u001d\u000b\u0004_\u000e5\u0002\"CA_y\u0005\u0005\t\u0019AA\u0011\u0003=!\u0018.\\3ti\u0006l\u0007OR8s[\u0006$XCAB\u001a!\u0011\u0019)da\u000f\u000e\u0005\r]\"\u0002BB\u001d\u0003C\u000bA\u0001^3yi&!1QHB\u001c\u0005A\u0019\u0016.\u001c9mK\u0012\u000bG/\u001a$pe6\fG/A\u0007dkJ\u0014XM\u001c;Ti\u0006$Xo]\u000b\u0003\u0007\u0007\u0002B!!\u0011\u0004F%!1qIA\"\u0005Q\u0019FO]3b[&tw-U;fef\u001cF/\u0019;vg\"\u001aaha\u0013\u0011\u0007\t\u001ci%C\u0002\u0004P\r\u0014\u0001B^8mCRLG.Z\u0001\u0012GV\u0014(/\u001a8u'R\fG/^:`I\u0015\fHcA8\u0004V!I\u0011QX \u0002\u0002\u0003\u000711I\u0001\u0015Y\u0006$Xm\u001d;TiJ,\u0017-\u001c)s_\u001e\u0014Xm]:\u0016\u0005\rm\u0003\u0003\u0002BN\u0007;J1aa\u0018T\u00059\u0019FO]3b[B\u0013xn\u001a:fgN\f\u0001\u0004\\1uKN$8\u000b\u001e:fC6\u0004&o\\4sKN\u001cx\fJ3r)\ry7Q\r\u0005\n\u0003{\u000b\u0015\u0011!a\u0001\u00077\naa\u001d;biV\u001c\u0018A\u0004:fG\u0016tG\u000f\u0015:pOJ,7o]\u000b\u0003\u0007[\u0002RAYB8\u0007?I1a!\u001dd\u0005\u0015\t%O]1z\u00031a\u0017m\u001d;Qe><'/Z:t+\t\u0019y\"\u0001\u0007ti\u0006\u0014H\u000f\u0016:jO\u001e,'/\u0001\u000bsK\u000e|'\u000f\u001a+sS\u001e<WM](gMN,Go\u001d\u000b\b_\u000eu4\u0011QBC\u0011\u001d\u0019yH\u0012a\u0001\u00077\nAA\u001a:p[\"911\u0011$A\u0002\rm\u0013A\u0001;p\u0011\u001d\u00199I\u0012a\u0001\u00077\na\u0001\\1uKN$\u0018AD1eI:+w\u000f\u0015:pOJ,7o\u001d\u000b\u0004_\u000e5\u0005bBBH\u000f\u0002\u00071qD\u0001\f]\u0016<\bK]8he\u0016\u001c8/\u0001\bva\u0012\fG/\u001a)s_\u001e\u0014Xm]:\u0015\u0007=\u001c)\nC\u0004\u0004\u0010\"\u0003\raa\b\u0002\u001dU\u0004H-\u0019;f\u0013\u0012dWM\\3tgR\u0019qna'\t\u000f\r=\u0015\n1\u0001\u0004 \u0005ia-\u001b8jg\"$&/[4hKJ$Ra\\BQ\u0007KCqaa)K\u0001\u0004\t\u0019.\u0001\u0006iCNtUm\u001e#bi\u0006Dqaa*K\u0001\u0004\t\u0019.A\u0006iCN,\u00050Z2vi\u0016$\u0017aG3yiJ\f7\r^*uCR,w\n]3sCR|'/T3ue&\u001c7\u000f\u0006\u0003\u0002.\r5\u0006bBBT\u0017\u0002\u0007\u00111[\u0001\u0016Kb$(/Y2u\u000bb,7-\u001e;j_:\u001cF/\u0019;t)\u0019\tifa-\u00046\"911\u0015'A\u0002\u0005M\u0007bBBT\u0019\u0002\u0007\u00111[\u0001\u001cKb$(/Y2u'>,(oY3U_:+X.\u00138qkR\u0014vn^:\u0015\u0003q\fa#\u001a=ue\u0006\u001cGo\u00142tKJ4X\rZ'fiJL7m\u001d\u000b\u0007\u0007\u007f\u001b9m!3\u0011\u000fu\fI!!\u0015\u0004BB!!1VBb\u0013\r\u0019)m\u0016\u0002\u0004%><\bbBBR\u001d\u0002\u0007\u00111\u001b\u0005\b\u0005/r\u0005\u0019\u0001B.\u0003=\u0011X\r]8siRKW.\u001a+bW\u0016tW\u0003BBh\u0007/$Ba!5\u0004nR!11[Br!\u0011\u0019)na6\r\u0001\u001191\u0011\\(C\u0002\rm'!\u0001+\u0012\t\ru\u0017Q\u0017\t\u0004E\u000e}\u0017bABqG\n9aj\u001c;iS:<\u0007\u0002CBs\u001f\u0012\u0005\raa:\u0002\t\t|G-\u001f\t\u0006E\u000e%81[\u0005\u0004\u0007W\u001c'\u0001\u0003\u001fcs:\fW.\u001a \t\u000f\r=x\n1\u0001\u0002R\u0005\u0001BO]5hO\u0016\u0014H)\u001a;bS2\\U-_\u0001\u0010M>\u0014X.\u0019;US6,7\u000f^1naR!\u0011\u0011KB{\u0011\u001d\u00199\u0010\u0015a\u0001\u0003C\ta!\\5mY&\u001c\u0018aE;qI\u0006$Xm\u0015;biV\u001cX*Z:tC\u001e,GcA8\u0004~\"91q`)A\u0002\u0005E\u0013aB7fgN\fw-\u001a")
public interface ProgressReporter
extends Logging {
    public ProgressReporter$ExecutionStats$ ExecutionStats();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs_$eq(scala.collection.mutable.HashMap<String, Object> var1);

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer_$eq(Queue<StreamingQueryProgress> var1);

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval_$eq(long var1);

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat_$eq(SimpleDateFormat var1);

    public UUID id();

    public UUID runId();

    public String name();

    public Clock triggerClock();

    public LogicalPlan logicalPlan();

    public QueryExecution lastExecution();

    public scala.collection.immutable.Map<SparkDataStream, LogicalPlan> newData();

    public Option<StreamWriterCommitProgress> sinkCommitProgress();

    public Seq<SparkDataStream> sources();

    public Table sink();

    public OffsetSeqMetadata offsetSeqMetadata();

    public long currentBatchId();

    public SparkSession sparkSession();

    public void postEvent(StreamingQueryListener.Event var1);

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq(long var1);

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq(long var1);

    public scala.collection.immutable.Map<SparkDataStream, String> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets_$eq(scala.collection.immutable.Map<SparkDataStream, String> var1);

    public scala.collection.immutable.Map<SparkDataStream, String> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets_$eq(scala.collection.immutable.Map<SparkDataStream, String> var1);

    public scala.collection.immutable.Map<SparkDataStream, String> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerLatestOffsets();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerLatestOffsets_$eq(scala.collection.immutable.Map<SparkDataStream, String> var1);

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq(long var1);

    public scala.collection.mutable.HashMap<String, Object> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs();

    public boolean org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(boolean var1);

    public Queue<StreamingQueryProgress> org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval();

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime_$eq(long var1);

    public SimpleDateFormat org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat();

    public StreamingQueryStatus currentStatus();

    public void currentStatus_$eq(StreamingQueryStatus var1);

    public StreamProgress org$apache$spark$sql$execution$streaming$ProgressReporter$$latestStreamProgress();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$latestStreamProgress_$eq(StreamProgress var1);

    public static /* synthetic */ StreamingQueryStatus status$(ProgressReporter $this) {
        return $this.status();
    }

    default public StreamingQueryStatus status() {
        return this.currentStatus();
    }

    public static /* synthetic */ StreamingQueryProgress[] recentProgress$(ProgressReporter $this) {
        return $this.recentProgress();
    }

    default public StreamingQueryProgress[] recentProgress() {
        StreamingQueryProgress[] streamingQueryProgressArray;
        Queue<StreamingQueryProgress> queue = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            streamingQueryProgressArray = (StreamingQueryProgress[])this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().toArray(ClassTag$.MODULE$.apply(StreamingQueryProgress.class));
        }
        return streamingQueryProgressArray;
    }

    public static /* synthetic */ StreamingQueryProgress lastProgress$(ProgressReporter $this) {
        return $this.lastProgress();
    }

    default public StreamingQueryProgress lastProgress() {
        StreamingQueryProgress streamingQueryProgress;
        Queue<StreamingQueryProgress> queue = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            streamingQueryProgress = (StreamingQueryProgress)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().lastOption().orNull(Predef$.MODULE$.$conforms());
        }
        return streamingQueryProgress;
    }

    public static /* synthetic */ void startTrigger$(ProgressReporter $this) {
        $this.startTrigger();
    }

    default public void startTrigger() {
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> "Starting Trigger Calculation");
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp());
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq(this.triggerClock().getTimeMillis());
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets_$eq(null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets_$eq(null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerLatestOffsets_$eq(null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().clear();
    }

    public static /* synthetic */ void recordTriggerOffsets$(ProgressReporter $this, StreamProgress from, StreamProgress to, StreamProgress latest) {
        $this.recordTriggerOffsets(from, to, latest);
    }

    default public void recordTriggerOffsets(StreamProgress from, StreamProgress to, StreamProgress latest) {
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets_$eq((scala.collection.immutable.Map<SparkDataStream, String>)from.mapValues((Function1 & Serializable & scala.Serializable)x$1 -> x$1.json()).toMap(Predef$.MODULE$.$conforms()));
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets_$eq((scala.collection.immutable.Map<SparkDataStream, String>)to.mapValues((Function1 & Serializable & scala.Serializable)x$2 -> x$2.json()).toMap(Predef$.MODULE$.$conforms()));
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerLatestOffsets_$eq((scala.collection.immutable.Map<SparkDataStream, String>)latest.mapValues((Function1 & Serializable & scala.Serializable)x$3 -> x$3.json()).toMap(Predef$.MODULE$.$conforms()));
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$latestStreamProgress_$eq(to);
    }

    private void addNewProgress(StreamingQueryProgress newProgress) {
        Queue<StreamingQueryProgress> queue = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().$plus$eq((Object)newProgress);
            while (this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().length() >= this.sparkSession().sqlContext().conf().streamingProgressRetention()) {
                this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().dequeue();
            }
        }
    }

    private void updateProgress(StreamingQueryProgress newProgress) {
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime_$eq(this.triggerClock().getTimeMillis());
        this.addNewProgress(newProgress);
        this.postEvent(new StreamingQueryListener.QueryProgressEvent(newProgress));
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Streaming query made progress: ").append(newProgress).toString());
    }

    private void updateIdleness(StreamingQueryProgress newProgress) {
        long now = this.triggerClock().getTimeMillis();
        if (now - this.org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval() >= this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime()) {
            this.addNewProgress(newProgress);
            if (this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime() > Long.MIN_VALUE) {
                this.postEvent(new StreamingQueryListener.QueryIdleEvent(newProgress.id(), newProgress.runId(), this.formatTimestamp(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp())));
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Streaming query has been idle and waiting for new data more than ").append(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval()).append(" ms.").toString());
            }
            this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime_$eq(now);
            return;
        }
    }

    public static /* synthetic */ void finishTrigger$(ProgressReporter $this, boolean hasNewData, boolean hasExecuted) {
        $this.finishTrigger(hasNewData, hasExecuted);
    }

    default public void finishTrigger(boolean hasNewData, boolean hasExecuted) {
        java.util.Map map;
        Predef$.MODULE$.assert(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets() != null && this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets() != null && this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerLatestOffsets() != null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq(this.triggerClock().getTimeMillis());
        ExecutionStats executionStats = this.extractExecutionStats(hasNewData, hasExecuted);
        long processingTimeMills = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp() - this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp();
        double processingTimeSec = (double)Math.max(1L, processingTimeMills) / (double)1000L;
        double inputTimeSec = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp() >= 0L ? (double)(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp() - this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp()) / (double)1000L : Double.POSITIVE_INFINITY;
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Execution stats: ").append(executionStats).toString());
        Seq sourceProgress = (Seq)((TraversableLike)this.sources().distinct()).map((Function1 & Serializable & scala.Serializable)source -> {
            java.util.Map map;
            long numRecords = BoxesRunTime.unboxToLong((Object)executionStats.inputRows().getOrElse(source, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            SparkDataStream sparkDataStream = source;
            if (sparkDataStream instanceof ReportsSourceMetrics) {
                ReportsSourceMetrics reportsSourceMetrics = (ReportsSourceMetrics)sparkDataStream;
                map = reportsSourceMetrics.metrics(Optional.ofNullable(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$latestStreamProgress().get((SparkDataStream)source).orNull(Predef$.MODULE$.$conforms())));
            } else {
                map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).asJava();
            }
            java.util.Map sourceMetrics = map;
            return new SourceProgress(source.toString(), (String)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets().get(source).orNull(Predef$.MODULE$.$conforms()), (String)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets().get(source).orNull(Predef$.MODULE$.$conforms()), (String)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerLatestOffsets().get(source).orNull(Predef$.MODULE$.$conforms()), numRecords, (double)numRecords / inputTimeSec, (double)numRecords / processingTimeSec, sourceMetrics);
        }, Seq$.MODULE$.canBuildFrom());
        Option sinkOutput = hasExecuted ? this.sinkCommitProgress().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.numOutputRows())) : this.sinkCommitProgress().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)ProgressReporter.$anonfun$finishTrigger$5(x$5)));
        Table table = this.sink();
        if (table instanceof ReportsSinkMetrics) {
            Table table2 = table;
            map = ((ReportsSinkMetrics)table2).metrics();
        } else {
            map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).asJava();
        }
        java.util.Map sinkMetrics = map;
        SinkProgress sinkProgress = SinkProgress$.MODULE$.apply(this.sink().toString(), (Option<Object>)sinkOutput, sinkMetrics);
        scala.collection.immutable.Map<String, Row> observedMetrics = this.extractObservedMetrics(hasNewData, this.lastExecution());
        StreamingQueryProgress newProgress = new StreamingQueryProgress(this.id(), this.runId(), this.name(), this.formatTimestamp(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp()), this.currentBatchId(), processingTimeMills, new HashMap<String, Long>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().toMap(Predef$.MODULE$.$conforms()).mapValues((Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)x))).toMap(Predef$.MODULE$.$conforms())).asJava()), new HashMap<String, String>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(executionStats.eventTimeStats()).asJava()), (StateOperatorProgress[])executionStats.stateOperators().toArray(ClassTag$.MODULE$.apply(StateOperatorProgress.class)), (SourceProgress[])sourceProgress.toArray(ClassTag$.MODULE$.apply(SourceProgress.class)), sinkProgress, new HashMap<String, Row>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(observedMetrics).asJava()));
        if (hasExecuted) {
            this.updateProgress(newProgress);
        } else {
            this.updateIdleness(newProgress);
        }
        StreamingQueryStatus qual$1 = this.currentStatus();
        boolean x$1 = false;
        String x$2 = qual$1.copy$default$1();
        boolean x$3 = qual$1.copy$default$2();
        this.currentStatus_$eq(qual$1.copy(x$2, x$3, x$1));
    }

    private Seq<StateOperatorProgress> extractStateOperatorMetrics(boolean hasExecuted) {
        if (this.lastExecution() == null) {
            return Nil$.MODULE$;
        }
        return this.lastExecution().executedPlan().collect((PartialFunction)new scala.Serializable(null, hasExecuted){
            public static final long serialVersionUID = 0L;
            private final boolean hasExecuted$1;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof StateStoreWriter) {
                    StateOperatorProgress progress = ((StateStoreWriter)((Object)A1)).getProgress();
                    if (this.hasExecuted$1) {
                        return (B1)progress;
                    }
                    return (B1)progress.copy(0L, 0L);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                return sparkPlan instanceof StateStoreWriter;
            }
            {
                this.hasExecuted$1 = hasExecuted$1;
            }
        });
    }

    private ExecutionStats extractExecutionStats(boolean hasNewData, boolean hasExecuted) {
        boolean hasEventTime = this.logicalPlan().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof EventTimeWatermark) {
                    EventTimeWatermark eventTimeWatermark = (EventTimeWatermark)A1;
                    return (B1)eventTimeWatermark;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                return logicalPlan2 instanceof EventTimeWatermark;
            }
        }).nonEmpty();
        scala.collection.immutable.Map watermarkTimestamp = hasEventTime ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"watermark"), (Object)this.formatTimestamp(this.offsetSeqMetadata().batchWatermarkMs()))})) : Predef$.MODULE$.Map().empty();
        Seq<StateOperatorProgress> stateOperators = this.extractStateOperatorMetrics(hasExecuted);
        if (!hasNewData) {
            return new ExecutionStats(this, (scala.collection.immutable.Map<SparkDataStream, Object>)Predef$.MODULE$.Map().empty(), stateOperators, (scala.collection.immutable.Map<String, String>)watermarkTimestamp);
        }
        scala.collection.immutable.Map<SparkDataStream, Object> numInputRows = this.extractSourceToNumInputRows();
        scala.collection.immutable.Map eventTimeStats = ((MapLike)this.lastExecution().executedPlan().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProgressReporter $outer;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                EventTimeWatermarkExec eventTimeWatermarkExec;
                A1 A1 = x2;
                if (A1 instanceof EventTimeWatermarkExec && (eventTimeWatermarkExec = (EventTimeWatermarkExec)A1).eventTimeStats().value().count() > 0L) {
                    EventTimeStats stats = eventTimeWatermarkExec.eventTimeStats().value();
                    return (B1)((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max"), (Object)BoxesRunTime.boxToLong((long)stats.max())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min"), (Object)BoxesRunTime.boxToLong((long)stats.min())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"avg"), (Object)BoxesRunTime.boxToLong((long)((long)stats.avg())))}))).mapValues((Function1 & Serializable & scala.Serializable)millis -> $anonfun$2.$anonfun$applyOrElse$1(this, BoxesRunTime.unboxToLong((Object)millis)));
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(SparkPlan x2) {
                EventTimeWatermarkExec eventTimeWatermarkExec;
                SparkPlan sparkPlan = x2;
                return sparkPlan instanceof EventTimeWatermarkExec && (eventTimeWatermarkExec = (EventTimeWatermarkExec)sparkPlan).eventTimeStats().value().count() > 0L;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$1($anonfun$2 $this, long millis) {
                return $this.$outer.formatTimestamp(millis);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.execution.streaming.ProgressReporter$$anonfun$2 java.lang.Object )}, serializedLambda);
            }
        }).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)watermarkTimestamp);
        return new ExecutionStats(this, numInputRows, stateOperators, (scala.collection.immutable.Map<String, String>)eventTimeStats.toMap(Predef$.MODULE$.$conforms()));
    }

    private scala.collection.immutable.Map<SparkDataStream, Object> extractSourceToNumInputRows() {
        block2: {
            Seq allStreamingLeaves = this.logicalPlan().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof StreamingDataSourceV2Relation) {
                        StreamingDataSourceV2Relation streamingDataSourceV2Relation = (StreamingDataSourceV2Relation)A1;
                        return (B1)BoxesRunTime.boxToBoolean((boolean)(streamingDataSourceV2Relation.stream() instanceof MicroBatchStream));
                    }
                    if (A1 instanceof StreamingExecutionRelation) {
                        return (B1)BoxesRunTime.boxToBoolean((boolean)false);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan2 = x1;
                    if (logicalPlan2 instanceof StreamingDataSourceV2Relation) {
                        return true;
                    }
                    return logicalPlan2 instanceof StreamingExecutionRelation;
                }
            });
            boolean onlyDataSourceV2Sources = allStreamingLeaves.forall((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ProgressReporter.$anonfun$extractSourceToNumInputRows$5(BoxesRunTime.unboxToBoolean((Object)x$9))));
            if (onlyDataSourceV2Sources) {
                Seq sourceToInputRowsTuples = this.lastExecution().executedPlan().collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        A1 A1 = x2;
                        if (A1 instanceof MicroBatchScanExec) {
                            MicroBatchScanExec microBatchScanExec = (MicroBatchScanExec)A1;
                            long numRows = BoxesRunTime.unboxToLong((Object)microBatchScanExec.metrics().get((Object)"numOutputRows").map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)$anonfun$4.$anonfun$applyOrElse$2(x$10))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                            MicroBatchStream source = microBatchScanExec.stream();
                            return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source), (Object)BoxesRunTime.boxToLong((long)numRows));
                        }
                        return (B1)function1.apply(x2);
                    }

                    public final boolean isDefinedAt(SparkPlan x2) {
                        SparkPlan sparkPlan = x2;
                        return sparkPlan instanceof MicroBatchScanExec;
                    }

                    public static final /* synthetic */ long $anonfun$applyOrElse$2(SQLMetric x$10) {
                        return x$10.value();
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2$adapted(org.apache.spark.sql.execution.metric.SQLMetric ), $anonfun$applyOrElse$3()}, serializedLambda);
                    }
                });
                this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Source -> # input rows\n\t").append(sourceToInputRowsTuples.mkString("\n\t")).toString());
                return ProgressReporter.sumRows$1(sourceToInputRowsTuples);
            }
            scala.collection.immutable.Map logicalPlanLeafToSource = (scala.collection.immutable.Map)this.newData().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    SparkDataStream source = (SparkDataStream)tuple2._1();
                    LogicalPlan logicalPlan2 = (LogicalPlan)tuple2._2();
                    return (Seq)logicalPlan2.collectLeaves().map((Function1 & Serializable & scala.Serializable)leaf -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(leaf), (Object)source), Seq$.MODULE$.canBuildFrom());
                }
                throw new MatchError((Object)tuple2);
            }, Map$.MODULE$.canBuildFrom());
            LogicalPlan finalLogicalPlan = ProgressReporter.unrollCTE$1(this.lastExecution().logical());
            Seq allLogicalPlanLeaves = finalLogicalPlan.collectLeaves();
            Seq allExecPlanLeaves = this.lastExecution().executedPlan().collectLeaves();
            if (allLogicalPlanLeaves.size() == allExecPlanLeaves.size()) {
                Seq execLeafToSource = (Seq)((TraversableLike)allLogicalPlanLeaves.zip((GenIterable)allExecPlanLeaves, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    SparkPlan ep;
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null && (ep = (SparkPlan)((Object)((Object)tuple2._2()))) instanceof MicroBatchScanExec) {
                        MicroBatchScanExec microBatchScanExec = (MicroBatchScanExec)ep;
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)microBatchScanExec), (Object)microBatchScanExec.stream())));
                    }
                    if (tuple2 != null) {
                        LogicalPlan lp = (LogicalPlan)tuple2._1();
                        SparkPlan ep2 = (SparkPlan)((Object)((Object)tuple2._2()));
                        return Option$.MODULE$.option2Iterable(logicalPlanLeafToSource.get((Object)lp).map((Function1 & Serializable & scala.Serializable)source -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ep2), source)));
                    }
                    throw new MatchError((Object)tuple2);
                }, Seq$.MODULE$.canBuildFrom());
                Seq sourceToInputRowsTuples = (Seq)execLeafToSource.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 != null) {
                        SparkPlan execLeaf = (SparkPlan)((Object)((Object)tuple2._1()));
                        SparkDataStream source = (SparkDataStream)tuple2._2();
                        long numRows = BoxesRunTime.unboxToLong((Object)execLeaf.metrics().get((Object)"numOutputRows").map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.value())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source), (Object)BoxesRunTime.boxToLong((long)numRows));
                    }
                    throw new MatchError((Object)tuple2);
                }, Seq$.MODULE$.canBuildFrom());
                return ProgressReporter.sumRows$1(sourceToInputRowsTuples);
            }
            if (this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged()) break block2;
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(154).append("Could not report metrics as number leaves in trigger logical plan did not match that").append(" of the execution plan:\n").append("logical plan leaves: ").append(ProgressReporter.toString$1(allLogicalPlanLeaves)).append("\n").append("execution plan leaves: ").append(ProgressReporter.toString$1(allExecPlanLeaves)).append("\n").toString());
            this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(true);
        }
        return Predef$.MODULE$.Map().empty();
    }

    private scala.collection.immutable.Map<String, Row> extractObservedMetrics(boolean hasNewData, QueryExecution lastExecution) {
        if (!hasNewData || lastExecution == null) {
            return Predef$.MODULE$.Map().empty();
        }
        return lastExecution.observedMetrics();
    }

    public static /* synthetic */ Object reportTimeTaken$(ProgressReporter $this, String triggerDetailKey, Function0 body) {
        return $this.reportTimeTaken(triggerDetailKey, body);
    }

    default public <T> T reportTimeTaken(String triggerDetailKey, Function0<T> body) {
        long startTime = this.triggerClock().getTimeMillis();
        Object result = body.apply();
        long endTime = this.triggerClock().getTimeMillis();
        long timeTaken = package$.MODULE$.max(endTime - startTime, 0L);
        long previousTime = BoxesRunTime.unboxToLong((Object)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().getOrElse((Object)triggerDetailKey, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().put((Object)triggerDetailKey, (Object)BoxesRunTime.boxToLong((long)(previousTime + timeTaken)));
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append(triggerDetailKey).append(" took ").append(timeTaken).append(" ms").toString());
        return (T)result;
    }

    public static /* synthetic */ String formatTimestamp$(ProgressReporter $this, long millis) {
        return $this.formatTimestamp(millis);
    }

    default public String formatTimestamp(long millis) {
        return this.org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat().format(new Date(millis));
    }

    public static /* synthetic */ void updateStatusMessage$(ProgressReporter $this, String message) {
        $this.updateStatusMessage(message);
    }

    default public void updateStatusMessage(String message) {
        StreamingQueryStatus qual$1 = this.currentStatus();
        String x$1 = message;
        boolean x$2 = qual$1.copy$default$2();
        boolean x$3 = qual$1.copy$default$3();
        this.currentStatus_$eq(qual$1.copy(x$1, x$2, x$3));
    }

    public static /* synthetic */ long $anonfun$finishTrigger$5(StreamWriterCommitProgress x$5) {
        return 0L;
    }

    public static /* synthetic */ long $anonfun$extractSourceToNumInputRows$2(Seq x$7) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)x$7.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8._2$mcJ$sp()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    private static scala.collection.immutable.Map sumRows$1(Seq tuples) {
        return tuples.groupBy((Function1 & Serializable & scala.Serializable)x$6 -> (SparkDataStream)x$6._1()).mapValues((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)ProgressReporter.$anonfun$extractSourceToNumInputRows$2(x$7))).toMap(Predef$.MODULE$.$conforms());
    }

    public static /* synthetic */ boolean $anonfun$extractSourceToNumInputRows$4(LogicalPlan x0$1) {
        LogicalPlan logicalPlan2 = x0$1;
        return logicalPlan2 instanceof WithCTE;
    }

    private static LogicalPlan unrollCTE$1(LogicalPlan plan) {
        boolean containsCTE = plan.exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ProgressReporter.$anonfun$extractSourceToNumInputRows$4(x0$1)));
        if (containsCTE) {
            return new InlineCTE(true).apply(plan);
        }
        return plan;
    }

    public static /* synthetic */ boolean $anonfun$extractSourceToNumInputRows$5(boolean x$9) {
        return x$9;
    }

    private static String toString$1(Seq seq) {
        return new StringBuilder(11).append("(size = ").append(seq.size()).append("), ").append(seq.mkString(", ")).toString();
    }

    public static void $init$(ProgressReporter $this) {
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs_$eq((scala.collection.mutable.HashMap<String, Object>)new scala.collection.mutable.HashMap());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(false);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer_$eq((Queue<StreamingQueryProgress>)new Queue());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval_$eq($this.sparkSession().sessionState().conf().streamingNoDataProgressEventInterval());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime_$eq(Long.MIN_VALUE);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat_$eq(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat().setTimeZone(DateTimeUtils$.MODULE$.getTimeZone("UTC"));
        $this.currentStatus_$eq(new StreamingQueryStatus("Initializing StreamExecution", false, false));
    }

    public class ExecutionStats
    implements Product,
    scala.Serializable {
        private final scala.collection.immutable.Map<SparkDataStream, Object> inputRows;
        private final Seq<StateOperatorProgress> stateOperators;
        private final scala.collection.immutable.Map<String, String> eventTimeStats;
        public final /* synthetic */ ProgressReporter $outer;

        public scala.collection.immutable.Map<SparkDataStream, Object> inputRows() {
            return this.inputRows;
        }

        public Seq<StateOperatorProgress> stateOperators() {
            return this.stateOperators;
        }

        public scala.collection.immutable.Map<String, String> eventTimeStats() {
            return this.eventTimeStats;
        }

        public ExecutionStats copy(scala.collection.immutable.Map<SparkDataStream, Object> inputRows, Seq<StateOperatorProgress> stateOperators, scala.collection.immutable.Map<String, String> eventTimeStats) {
            return new ExecutionStats(this.org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer(), inputRows, stateOperators, eventTimeStats);
        }

        public scala.collection.immutable.Map<SparkDataStream, Object> copy$default$1() {
            return this.inputRows();
        }

        public Seq<StateOperatorProgress> copy$default$2() {
            return this.stateOperators();
        }

        public scala.collection.immutable.Map<String, String> copy$default$3() {
            return this.eventTimeStats();
        }

        public String productPrefix() {
            return "ExecutionStats";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.inputRows();
                }
                case 1: {
                    return this.stateOperators();
                }
                case 2: {
                    return this.eventTimeStats();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExecutionStats;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ExecutionStats)) return false;
            if (((ExecutionStats)object).org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer() != this.org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ExecutionStats executionStats = (ExecutionStats)x$1;
            scala.collection.immutable.Map<SparkDataStream, Object> map = this.inputRows();
            scala.collection.immutable.Map<SparkDataStream, Object> map2 = executionStats.inputRows();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Seq<StateOperatorProgress> seq = this.stateOperators();
            Seq<StateOperatorProgress> seq2 = executionStats.stateOperators();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            scala.collection.immutable.Map<String, String> map3 = this.eventTimeStats();
            scala.collection.immutable.Map<String, String> map4 = executionStats.eventTimeStats();
            if (map3 == null) {
                if (map4 != null) {
                    return false;
                }
            } else if (!map3.equals(map4)) return false;
            if (!executionStats.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ProgressReporter org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer() {
            return this.$outer;
        }

        public ExecutionStats(ProgressReporter $outer, scala.collection.immutable.Map<SparkDataStream, Object> inputRows, Seq<StateOperatorProgress> stateOperators, scala.collection.immutable.Map<String, String> eventTimeStats) {
            this.inputRows = inputRows;
            this.stateOperators = stateOperators;
            this.eventTimeStats = eventTimeStats;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

