/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.DistanceMeasure$;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.clustering.LocalKMeans$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.DoubleAccumulator;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tmg\u0001B\u001f?\u0001%C\u0001\"\u0017\u0001\u0003\u0002\u0004%IA\u0017\u0005\t=\u0002\u0011\t\u0019!C\u0005?\"AQ\r\u0001B\u0001B\u0003&1\f\u0003\u0005g\u0001\t\u0005\r\u0011\"\u0003[\u0011!9\u0007A!a\u0001\n\u0013A\u0007\u0002\u00036\u0001\u0005\u0003\u0005\u000b\u0015B.\t\u0011-\u0004!\u00111A\u0005\n1D\u0001\u0002\u001f\u0001\u0003\u0002\u0004%I!\u001f\u0005\tw\u0002\u0011\t\u0011)Q\u0005[\"AA\u0010\u0001BA\u0002\u0013%!\f\u0003\u0005~\u0001\t\u0005\r\u0011\"\u0003\u007f\u0011%\t\t\u0001\u0001B\u0001B\u0003&1\f\u0003\u0006\u0002\u0004\u0001\u0011\t\u0019!C\u0005\u0003\u000bA!\"!\u0004\u0001\u0005\u0003\u0007I\u0011BA\b\u0011)\t\u0019\u0002\u0001B\u0001B\u0003&\u0011q\u0001\u0005\u000b\u0003+\u0001!\u00111A\u0005\n\u0005]\u0001BCA\u0010\u0001\t\u0005\r\u0011\"\u0003\u0002\"!Q\u0011Q\u0005\u0001\u0003\u0002\u0003\u0006K!!\u0007\t\u0013\u0005\u001d\u0002A!a\u0001\n\u0013a\u0007BCA\u0015\u0001\t\u0005\r\u0011\"\u0003\u0002,!I\u0011q\u0006\u0001\u0003\u0002\u0003\u0006K!\u001c\u0005\b\u0003c\u0001A\u0011BA\u001a\u0011\u001d\t\t\u0004\u0001C\u0005\u0003\u000fBq!!\r\u0001\t\u0003\t9\u0007\u0003\u0004\u0002l\u0001!\tA\u0017\u0005\b\u0003g\u0002A\u0011AA;\u0011\u0019\ti\b\u0001C\u00015\"9\u0011\u0011\u0011\u0001\u0005\u0002\u0005\r\u0005BBAE\u0001\u0011\u0005A\u000eC\u0004\u0002\u000e\u0002!\t!a$\t\r\u0005U\u0005\u0001\"\u0001[\u0011\u001d\tI\n\u0001C\u0001\u00037Cq!!)\u0001\t\u0003\t)\u0001C\u0004\u0002&\u0002!\t!a*\t\u000f\u00055\u0006\u0001\"\u0001\u0002\u0018!9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0006BBA]\u0001\u0011\u0005A\u000eC\u0004\u0002B\u0002!\t!a1\t\u0013\u0005%\u0007\u00011A\u0005\n\u0005-\u0007\"CAm\u0001\u0001\u0007I\u0011BAn\u0011!\ty\u000e\u0001Q!\n\u00055\u0007bBAq\u0001\u0011\u0005\u00111\u001d\u0005\b\u0003W\u0004A\u0011AAw\u0011!\u0011i\u0001\u0001C\u0001\u0005\n=\u0001\u0002\u0003B\u001f\u0001\u0011\u0005!Ia\u0010\t\u000f\t%\u0003\u0001\"\u0003\u0003L!9!\u0011\f\u0001\u0005\n\tm\u0003\u0002\u0003B1\u0001\u0011\u0005aHa\u0019\b\u000f\tMd\b#\u0001\u0003v\u00191QH\u0010E\u0001\u0005oBq!!\r3\t\u0003\u0011I\bC\u0005\u0003|I\u0012\r\u0011\"\u0001\u0003~!A!q\u0012\u001a!\u0002\u0013\u0011y\bC\u0005\u0003\u0014J\u0012\r\u0011\"\u0001\u0003~!A!q\u0013\u001a!\u0002\u0013\u0011y\bC\u0004\u0003\u001cJ\"\tA!(\t\u000f\tm%\u0007\"\u0001\u00030\"9!1\u0014\u001a\u0005\u0002\tm\u0006\u0002\u0003Bce\u0011\u0005!Ia2\t\u0013\t5''!A\u0005\n\t='AB&NK\u0006t7O\u0003\u0002@\u0001\u0006Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005\u0005\u0013\u0015!B7mY&\u0014'BA\"E\u0003\u0015\u0019\b/\u0019:l\u0015\t)e)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u000f\u0006\u0019qN]4\u0004\u0001M!\u0001A\u0013)T!\tYe*D\u0001M\u0015\u0005i\u0015!B:dC2\f\u0017BA(M\u0005\u0019\te.\u001f*fMB\u00111*U\u0005\u0003%2\u0013AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"\u0001V,\u000e\u0003US!A\u0016\"\u0002\u0011%tG/\u001a:oC2L!\u0001W+\u0003\u000f1{wmZ5oO\u0006\t1.F\u0001\\!\tYE,\u0003\u0002^\u0019\n\u0019\u0011J\u001c;\u0002\u000b-|F%Z9\u0015\u0005\u0001\u001c\u0007CA&b\u0013\t\u0011GJ\u0001\u0003V]&$\bb\u00023\u0003\u0003\u0003\u0005\raW\u0001\u0004q\u0012\n\u0014AA6!\u00035i\u0017\r_%uKJ\fG/[8og\u0006\tR.\u0019=Ji\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0005\u0001L\u0007b\u00023\u0006\u0003\u0003\u0005\raW\u0001\u000f[\u0006D\u0018\n^3sCRLwN\\:!\u0003IIg.\u001b;jC2L'0\u0019;j_:lu\u000eZ3\u0016\u00035\u0004\"A\\;\u000f\u0005=\u001c\bC\u00019M\u001b\u0005\t(B\u0001:I\u0003\u0019a$o\\8u}%\u0011A\u000fT\u0001\u0007!J,G-\u001a4\n\u0005Y<(AB*ue&twM\u0003\u0002u\u0019\u00061\u0012N\\5uS\u0006d\u0017N_1uS>tWj\u001c3f?\u0012*\u0017\u000f\u0006\u0002au\"9A\rCA\u0001\u0002\u0004i\u0017aE5oSRL\u0017\r\\5{CRLwN\\'pI\u0016\u0004\u0013aE5oSRL\u0017\r\\5{CRLwN\\*uKB\u001c\u0018aF5oSRL\u0017\r\\5{CRLwN\\*uKB\u001cx\fJ3r)\t\u0001w\u0010C\u0004e\u0017\u0005\u0005\t\u0019A.\u0002)%t\u0017\u000e^5bY&T\u0018\r^5p]N#X\r]:!\u0003\u001d)\u0007o]5m_:,\"!a\u0002\u0011\u0007-\u000bI!C\u0002\u0002\f1\u0013a\u0001R8vE2,\u0017aC3qg&dwN\\0%KF$2\u0001YA\t\u0011!!g\"!AA\u0002\u0005\u001d\u0011\u0001C3qg&dwN\u001c\u0011\u0002\tM,W\rZ\u000b\u0003\u00033\u00012aSA\u000e\u0013\r\ti\u0002\u0014\u0002\u0005\u0019>tw-\u0001\u0005tK\u0016$w\fJ3r)\r\u0001\u00171\u0005\u0005\tIF\t\t\u00111\u0001\u0002\u001a\u0005)1/Z3eA\u0005yA-[:uC:\u001cW-T3bgV\u0014X-A\neSN$\u0018M\\2f\u001b\u0016\f7/\u001e:f?\u0012*\u0017\u000fF\u0002a\u0003[Aq\u0001\u001a\u000b\u0002\u0002\u0003\u0007Q.\u0001\teSN$\u0018M\\2f\u001b\u0016\f7/\u001e:fA\u00051A(\u001b8jiz\"\u0002#!\u000e\u0002:\u0005m\u0012QHA \u0003\u0003\n\u0019%!\u0012\u0011\u0007\u0005]\u0002!D\u0001?\u0011\u0015If\u00031\u0001\\\u0011\u00151g\u00031\u0001\\\u0011\u0015Yg\u00031\u0001n\u0011\u0015ah\u00031\u0001\\\u0011\u001d\t\u0019A\u0006a\u0001\u0003\u000fAq!!\u0006\u0017\u0001\u0004\tI\u0002\u0003\u0004\u0002(Y\u0001\r!\u001c\u000b\u000f\u0003k\tI%a\u0013\u0002N\u0005=\u0013\u0011KA*\u0011\u0015Iv\u00031\u0001\\\u0011\u00151w\u00031\u0001\\\u0011\u0015Yw\u00031\u0001n\u0011\u0015ax\u00031\u0001\\\u0011\u001d\t\u0019a\u0006a\u0001\u0003\u000fAq!!\u0006\u0018\u0001\u0004\tI\u0002K\u0003\u0018\u0003/\n\u0019\u0007\u0005\u0003\u0002Z\u0005}SBAA.\u0015\r\tiFQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA1\u00037\u0012QaU5oG\u0016\f#!!\u001a\u0002\u000bAr\u0003H\f\u0019\u0015\u0005\u0005U\u0002&\u0002\r\u0002X\u0005\r\u0014\u0001B4fi.CS!GA,\u0003_\n#!!\u001d\u0002\u000bErCG\f\u0019\u0002\tM,Go\u0013\u000b\u0005\u0003o\nI(D\u0001\u0001\u0011\u0015I&\u00041\u0001\\Q\u0015Q\u0012qKA2\u0003A9W\r^'bq&#XM]1uS>t7\u000fK\u0003\u001c\u0003/\ny'\u0001\ttKRl\u0015\r_%uKJ\fG/[8ogR!\u0011qOAC\u0011\u00151G\u00041\u0001\\Q\u0015a\u0012qKA2\u0003U9W\r^%oSRL\u0017\r\\5{CRLwN\\'pI\u0016DS!HA,\u0003_\nQc]3u\u0013:LG/[1mSj\fG/[8o\u001b>$W\r\u0006\u0003\u0002x\u0005E\u0005\"B6\u001f\u0001\u0004i\u0007&\u0002\u0010\u0002X\u0005\r\u0014AF4fi&s\u0017\u000e^5bY&T\u0018\r^5p]N#X\r]:)\u000b}\t9&a\u001c\u0002-M,G/\u00138ji&\fG.\u001b>bi&|gn\u0015;faN$B!a\u001e\u0002\u001e\")A\u0010\ta\u00017\"*\u0001%a\u0016\u0002d\u0005Qq-\u001a;FaNLGn\u001c8)\u000b\u0005\n9&a\u001c\u0002\u0015M,G/\u00129tS2|g\u000e\u0006\u0003\u0002x\u0005%\u0006bBA\u0002E\u0001\u0007\u0011q\u0001\u0015\u0006E\u0005]\u00131M\u0001\bO\u0016$8+Z3eQ\u0015\u0019\u0013qKA8\u0003\u001d\u0019X\r^*fK\u0012$B!a\u001e\u00026\"9\u0011Q\u0003\u0013A\u0002\u0005e\u0001&\u0002\u0013\u0002X\u0005=\u0014AE4fi\u0012K7\u000f^1oG\u0016lU-Y:ve\u0016DS!JA,\u0003{\u000b#!a0\u0002\u000bIrCG\f\u0019\u0002%M,G\u000fR5ti\u0006t7-Z'fCN,(/\u001a\u000b\u0005\u0003o\n)\r\u0003\u0004\u0002(\u0019\u0002\r!\u001c\u0015\u0006M\u0005]\u0013QX\u0001\rS:LG/[1m\u001b>$W\r\\\u000b\u0003\u0003\u001b\u0004RaSAh\u0003'L1!!5M\u0005\u0019y\u0005\u000f^5p]B!\u0011qGAk\u0013\r\t9N\u0010\u0002\f\u00176+\u0017M\\:N_\u0012,G.\u0001\tj]&$\u0018.\u00197N_\u0012,Gn\u0018\u0013fcR\u0019\u0001-!8\t\u0011\u0011D\u0013\u0011!a\u0001\u0003\u001b\fQ\"\u001b8ji&\fG.T8eK2\u0004\u0013aD:fi&s\u0017\u000e^5bY6{G-\u001a7\u0015\t\u0005]\u0014Q\u001d\u0005\b\u0003OT\u0003\u0019AAj\u0003\u0015iw\u000eZ3mQ\u0015Q\u0013qKA8\u0003\r\u0011XO\u001c\u000b\u0005\u0003'\fy\u000fC\u0004\u0002r.\u0002\r!a=\u0002\t\u0011\fG/\u0019\t\u0007\u0003k\fY0a@\u000e\u0005\u0005](bAA}\u0005\u0006\u0019!\u000f\u001a3\n\t\u0005u\u0018q\u001f\u0002\u0004%\u0012#\u0005\u0003\u0002B\u0001\u0005\u000fi!Aa\u0001\u000b\u0007\t\u0015\u0001)\u0001\u0004mS:\fGnZ\u0005\u0005\u0005\u0013\u0011\u0019A\u0001\u0004WK\u000e$xN\u001d\u0015\u0006W\u0005]\u00131M\u0001\u000eeVtw+\u001b;i/\u0016Lw\r\u001b;\u0015\u0011\u0005M'\u0011\u0003B\u000f\u0005OAqAa\u0005-\u0001\u0004\u0011)\"A\u0005j]N$\u0018M\\2fgB1\u0011Q_A~\u0005/\u0001ra\u0013B\r\u0003\u007f\f9!C\u0002\u0003\u001c1\u0013a\u0001V;qY\u0016\u0014\u0004b\u0002B\u0010Y\u0001\u0007!\u0011E\u0001\u0012Q\u0006tG\r\\3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007cA&\u0003$%\u0019!Q\u0005'\u0003\u000f\t{w\u000e\\3b]\"9!\u0011\u0006\u0017A\u0002\t-\u0012!B5ogR\u0014\b#B&\u0002P\n5\u0002\u0003\u0002B\u0018\u0005si!A!\r\u000b\t\tM\"QG\u0001\u0005kRLGNC\u0002\u00038\t\u000b!!\u001c7\n\t\tm\"\u0011\u0007\u0002\u0010\u0013:\u001cHO];nK:$\u0018\r^5p]\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\t\t\u0005#q\t\t\u0006\u0017\n\r\u0013q`\u0005\u0004\u0005\u000bb%!B!se\u0006L\bbBAy[\u0001\u0007\u00111_\u0001\u0017eVt\u0017\t\\4pe&$\b.\\,ji\"<V-[4iiR1\u00111\u001bB'\u0005/Bq!!=/\u0001\u0004\u0011y\u0005\u0005\u0004\u0002v\u0006m(\u0011\u000b\t\u0005\u0003o\u0011\u0019&C\u0002\u0003Vy\u0012aBV3di>\u0014x+\u001b;i\u001d>\u0014X\u000eC\u0004\u0003*9\u0002\rAa\u000b\u0002\u0015%t\u0017\u000e\u001e*b]\u0012|W\u000e\u0006\u0003\u0003^\t}\u0003#B&\u0003D\tE\u0003bBAy_\u0001\u0007!qJ\u0001\u0013S:LGoS'fC:\u001c\b+\u0019:bY2,G\u000e\u0006\u0004\u0003^\t\u0015$q\r\u0005\b\u0003c\u0004\u0004\u0019\u0001B(\u0011\u001d\u0011I\u0007\ra\u0001\u0005W\nq\u0003Z5ti\u0006t7-Z'fCN,(/Z%ogR\fgnY3\u0011\t\u0005]\"QN\u0005\u0004\u0005_r$a\u0004#jgR\fgnY3NK\u0006\u001cXO]3)\u000b\u0001\t9&a\u0019\u0002\r-kU-\u00198t!\r\t9DM\n\u0004e)\u0003FC\u0001B;\u0003\u0019\u0011\u0016I\u0014#P\u001bV\u0011!q\u0010\t\u0005\u0005\u0003\u0013Y)\u0004\u0002\u0003\u0004*!!Q\u0011BD\u0003\u0011a\u0017M\\4\u000b\u0005\t%\u0015\u0001\u00026bm\u0006L1A\u001eBBQ\u0015!\u0014qKA2\u0003\u001d\u0011\u0016I\u0014#P\u001b\u0002BS!NA,\u0003G\n\u0001cS0N\u000b\u0006s5k\u0018)B%\u0006cE*\u0012')\u000bY\n9&a\u0019\u0002#-{V*R!O'~\u0003\u0016IU!M\u0019\u0016c\u0005\u0005K\u00038\u0003/\n\u0019'A\u0003ue\u0006Lg\u000e\u0006\u0007\u0002T\n}%\u0011\u0015BR\u0005K\u00139\u000bC\u0004\u0002rb\u0002\r!a=\t\u000beC\u0004\u0019A.\t\u000b\u0019D\u0004\u0019A.\t\u000b-D\u0004\u0019A7\t\u000f\u0005U\u0001\b1\u0001\u0002\u001a!*\u0001(a\u0016\u0003,\u0006\u0012!QV\u0001\u0006e9\nd\u0006\r\u000b\u000b\u0003'\u0014\tLa-\u00036\n]\u0006bBAys\u0001\u0007\u00111\u001f\u0005\u00063f\u0002\ra\u0017\u0005\u0006Mf\u0002\ra\u0017\u0005\u0006Wf\u0002\r!\u001c\u0015\u0006s\u0005]#1\u0016\u000b\t\u0003'\u0014iLa0\u0003B\"9\u0011\u0011\u001f\u001eA\u0002\u0005M\b\"B-;\u0001\u0004Y\u0006\"\u00024;\u0001\u0004Y\u0006&\u0002\u001e\u0002X\u0005\r\u0014\u0001\u0005<bY&$\u0017\r^3J]&$Xj\u001c3f)\u0011\u0011\tC!3\t\r\t-7\b1\u0001n\u0003!Ig.\u001b;N_\u0012,\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!5\u0011\t\t\u0005%1[\u0005\u0005\u0005+\u0014\u0019I\u0001\u0004PE*,7\r\u001e\u0015\u0006e\u0005]\u00131\r\u0015\u0006c\u0005]\u00131\r")
public class KMeans
implements scala.Serializable,
Logging {
    private int k;
    private int maxIterations;
    private String initializationMode;
    private int initializationSteps;
    private double epsilon;
    private long seed;
    private String distanceMeasure;
    private Option<KMeansModel> initialModel;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2) {
        return KMeans$.MODULE$.train(rDD, n, n2);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, String string) {
        return KMeans$.MODULE$.train(rDD, n, n2, string);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, String string, long l) {
        return KMeans$.MODULE$.train(rDD, n, n2, string, l);
    }

    public static String K_MEANS_PARALLEL() {
        return KMeans$.MODULE$.K_MEANS_PARALLEL();
    }

    public static String RANDOM() {
        return KMeans$.MODULE$.RANDOM();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private String initializationMode() {
        return this.initializationMode;
    }

    private void initializationMode_$eq(String x$1) {
        this.initializationMode = x$1;
    }

    private int initializationSteps() {
        return this.initializationSteps;
    }

    private void initializationSteps_$eq(int x$1) {
        this.initializationSteps = x$1;
    }

    private double epsilon() {
        return this.epsilon;
    }

    private void epsilon_$eq(double x$1) {
        this.epsilon = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private String distanceMeasure() {
        return this.distanceMeasure;
    }

    private void distanceMeasure_$eq(String x$1) {
        this.distanceMeasure = x$1;
    }

    public int getK() {
        return this.k();
    }

    public KMeans setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Number of clusters must be positive but got ").append(k).toString());
        this.k_$eq(k);
        return this;
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public KMeans setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Maximum of iterations must be nonnegative but got ").append(maxIterations).toString());
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public String getInitializationMode() {
        return this.initializationMode();
    }

    public KMeans setInitializationMode(String initializationMode) {
        KMeans$.MODULE$.validateInitMode(initializationMode);
        this.initializationMode_$eq(initializationMode);
        return this;
    }

    public int getInitializationSteps() {
        return this.initializationSteps();
    }

    public KMeans setInitializationSteps(int initializationSteps) {
        Predef$.MODULE$.require(initializationSteps > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Number of initialization steps must be positive but got ").append(initializationSteps).toString());
        this.initializationSteps_$eq(initializationSteps);
        return this;
    }

    public double getEpsilon() {
        return this.epsilon();
    }

    public KMeans setEpsilon(double epsilon) {
        Predef$.MODULE$.require(epsilon >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Distance threshold must be nonnegative but got ").append(epsilon).toString());
        this.epsilon_$eq(epsilon);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public KMeans setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public String getDistanceMeasure() {
        return this.distanceMeasure();
    }

    public KMeans setDistanceMeasure(String distanceMeasure) {
        DistanceMeasure$.MODULE$.validateDistanceMeasure(distanceMeasure);
        this.distanceMeasure_$eq(distanceMeasure);
        return this;
    }

    private Option<KMeansModel> initialModel() {
        return this.initialModel;
    }

    private void initialModel_$eq(Option<KMeansModel> x$1) {
        this.initialModel = x$1;
    }

    public KMeans setInitialModel(KMeansModel model) {
        Predef$.MODULE$.require(model.k() == this.k(), (Function0 & Serializable & scala.Serializable)() -> "mismatched cluster count");
        this.initialModel_$eq((Option<KMeansModel>)new Some((Object)model));
        return this;
    }

    public KMeansModel run(RDD<Vector> data) {
        RDD instances = data.map((Function1 & Serializable & scala.Serializable)point -> new Tuple2(point, (Object)BoxesRunTime.boxToDouble((double)1.0)), ClassTag$.MODULE$.apply(Tuple2.class));
        StorageLevel storageLevel = data.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        return this.runWithWeight((RDD<Tuple2<Vector, Object>>)instances, handlePersistence, (Option<Instrumentation>)None$.MODULE$);
    }

    public KMeansModel runWithWeight(RDD<Tuple2<Vector, Object>> instances, boolean handlePersistence, Option<Instrumentation> instr) {
        RDD norms = instances.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)KMeans.$anonfun$runWithWeight$1(x0$1)), ClassTag$.MODULE$.Double());
        RDD vectors = instances.zip(norms, ClassTag$.MODULE$.Double()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                double norm = tuple2._2$mcD$sp();
                if (tuple22 != null) {
                    Vector v = (Vector)tuple22._1();
                    double w = tuple22._2$mcD$sp();
                    return new VectorWithNorm(v, norm, w);
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(VectorWithNorm.class));
        RDD rDD = handlePersistence ? vectors.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : norms.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        KMeansModel model = this.runAlgorithmWithWeight((RDD<VectorWithNorm>)vectors, instr);
        RDD rDD2 = handlePersistence ? vectors.unpersist(vectors.unpersist$default$1()) : norms.unpersist(norms.unpersist$default$1());
        return model;
    }

    public Vector[] initialize(RDD<Vector> data) {
        VectorWithNorm[] vectorWithNormArray;
        RDD dataWithNorms = data.map((Function1 & Serializable & scala.Serializable)x$1 -> new VectorWithNorm((Vector)x$1), ClassTag$.MODULE$.apply(VectorWithNorm.class));
        String string = this.initializationMode();
        String string2 = KMeans$.MODULE$.RANDOM();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            vectorWithNormArray = this.initRandom((RDD<VectorWithNorm>)dataWithNorms);
        } else {
            String string4 = KMeans$.MODULE$.K_MEANS_PARALLEL();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                DistanceMeasure distanceMeasureInstance = DistanceMeasure$.MODULE$.decodeFromString(this.distanceMeasure());
                dataWithNorms.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
                VectorWithNorm[] centers = this.initKMeansParallel((RDD<VectorWithNorm>)dataWithNorms, distanceMeasureInstance);
                dataWithNorms.unpersist(dataWithNorms.unpersist$default$1());
                vectorWithNormArray = centers;
            } else {
                throw new MatchError((Object)string);
            }
        }
        VectorWithNorm[] centers = vectorWithNormArray;
        return (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])centers)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.vector(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
    }

    private KMeansModel runAlgorithmWithWeight(RDD<VectorWithNorm> data, Option<Instrumentation> instr) {
        VectorWithNorm[] vectorWithNormArray;
        SparkContext sc = data.sparkContext();
        long initStartTime = System.nanoTime();
        DistanceMeasure distanceMeasureInstance = DistanceMeasure$.MODULE$.decodeFromString(this.distanceMeasure());
        Option<KMeansModel> option = this.initialModel();
        if (option instanceof Some) {
            Some some = (Some)option;
            KMeansModel kMeansCenters = (KMeansModel)some.value();
            vectorWithNormArray = (VectorWithNorm[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kMeansCenters.clusterCenters())).map((Function1 & Serializable & scala.Serializable)x$3 -> new VectorWithNorm((Vector)x$3), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(VectorWithNorm.class)));
        } else if (None$.MODULE$.equals(option)) {
            String string = this.initializationMode();
            String string2 = KMeans$.MODULE$.RANDOM();
            vectorWithNormArray = !(string != null ? !string.equals(string2) : string2 != null) ? this.initRandom(data) : this.initKMeansParallel(data, distanceMeasureInstance);
        } else {
            throw new MatchError(option);
        }
        VectorWithNorm[] centers = vectorWithNormArray;
        int numFeatures = ((VectorWithNorm)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])centers)).head()).vector().size();
        double initTimeInSeconds = (double)(System.nanoTime() - initStartTime) / 1.0E9;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            String arg$macro$1 = this.initializationMode();
            double arg$macro$2 = initTimeInSeconds;
            return new StringOps("Initialization with %s took %.3f seconds.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToDouble((double)arg$macro$2)}));
        });
        BooleanRef converged = BooleanRef.create((boolean)false);
        DoubleRef cost = DoubleRef.create((double)0.0);
        IntRef iteration = IntRef.create((int)0);
        long iterationStartTime = System.nanoTime();
        instr.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.logNumFeatures(numFeatures);
            return BoxedUnit.UNIT;
        });
        boolean shouldComputeStats = DistanceMeasure$.MODULE$.shouldComputeStatistics(centers.length);
        boolean shouldComputeStatsLocally = DistanceMeasure$.MODULE$.shouldComputeStatisticsLocally(centers.length, numFeatures);
        while (iteration.elem < this.maxIterations() && !converged.elem) {
            Broadcast bcCenters = sc.broadcast((Object)centers, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
            None$ stats = shouldComputeStats ? (shouldComputeStatsLocally ? new Some((Object)distanceMeasureInstance.computeStatistics(centers)) : new Some((Object)distanceMeasureInstance.computeStatisticsDistributedly(sc, (Broadcast<VectorWithNorm[]>)bcCenters))) : None$.MODULE$;
            Broadcast bcStats = sc.broadcast((Object)stats, ClassTag$.MODULE$.apply(Option.class));
            DoubleAccumulator costAccum = sc.doubleAccumulator();
            Map collected = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(data.mapPartitions((Function1 & Serializable & scala.Serializable)points -> {
                VectorWithNorm[] centers = (VectorWithNorm[])bcCenters.value();
                Option stats = (Option)bcStats.value();
                int dims = ((VectorWithNorm)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])centers)).head()).vector().size();
                Vector[] sums = (Vector[])Array$.MODULE$.fill(centers.length, (Function0 & Serializable & scala.Serializable)() -> Vectors$.MODULE$.zeros(dims), ClassTag$.MODULE$.apply(Vector.class));
                double[] clusterWeightSum = (double[])Array$.MODULE$.ofDim(centers.length, ClassTag$.MODULE$.Double());
                points.foreach((Function1 & Serializable & scala.Serializable)point -> {
                    KMeans.$anonfun$runAlgorithmWithWeight$6(distanceMeasureInstance, centers, stats, costAccum, sums, clusterWeightSum, point);
                    return BoxedUnit.UNIT;
                });
                return package$.MODULE$.Iterator().tabulate(centers.length, (Function1 & Serializable & scala.Serializable)j -> KMeans.$anonfun$runAlgorithmWithWeight$7(sums, clusterWeightSum, BoxesRunTime.unboxToInt((Object)j))).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KMeans.$anonfun$runAlgorithmWithWeight$8(x$6)));
            }, data.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2 & Serializable & scala.Serializable)(sumweight1, sumweight2) -> {
                BLAS$.MODULE$.axpy(1.0, (Vector)sumweight2._1(), (Vector)sumweight1._1());
                return new Tuple2(sumweight1._1(), (Object)BoxesRunTime.boxToDouble((double)(sumweight1._2$mcD$sp() + sumweight2._2$mcD$sp())));
            }), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
            if (iteration.elem == 0) {
                instr.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                    x$7.logNumExamples(costAccum.count());
                    return BoxedUnit.UNIT;
                });
                instr.foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                    x$8.logSumOfWeights(BoxesRunTime.unboxToDouble((Object)((TraversableOnce)collected.values().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToDouble((double)x$9._2$mcD$sp()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
                    return BoxedUnit.UNIT;
                });
            }
            bcCenters.destroy();
            bcStats.destroy();
            converged.elem = true;
            collected.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KMeans.$anonfun$runAlgorithmWithWeight$13(this, distanceMeasureInstance, converged, centers, x0$1);
                return BoxedUnit.UNIT;
            });
            cost.elem = Predef$.MODULE$.Double2double(costAccum.value());
            instr.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                x$10.logNamedValue(new StringBuilder(10).append("Cost@iter=").append(iteration.elem).toString(), String.valueOf(BoxesRunTime.boxToDouble((double)cost.elem)));
                return BoxedUnit.UNIT;
            });
            ++iteration.elem;
        }
        double iterationTimeInSeconds = (double)(System.nanoTime() - iterationStartTime) / 1.0E9;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            double arg$macro$3 = iterationTimeInSeconds;
            return new StringOps("Iterations took %.3f seconds.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$3)}));
        });
        if (iteration.elem == this.maxIterations()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("KMeans reached the max number of iterations: ").append(this.maxIterations()).append(".").toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("KMeans converged in ").append(iteration$1.elem).append(" iterations.").toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("The cost is ").append(cost$1.elem).append(".").toString());
        return new KMeansModel((Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])centers)).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.vector(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class))), this.distanceMeasure(), cost.elem, iteration.elem);
    }

    private VectorWithNorm[] initRandom(RDD<VectorWithNorm> data) {
        return (VectorWithNorm[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.takeSample(false, this.k(), (long)new XORShiftRandom(this.seed()).nextInt()))).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.vector(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class))))).distinct())).map((Function1 & Serializable & scala.Serializable)x$13 -> new VectorWithNorm((Vector)x$13), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(VectorWithNorm.class)));
    }

    public VectorWithNorm[] initKMeansParallel(RDD<VectorWithNorm> data, DistanceMeasure distanceMeasureInstance) {
        RDD costs = data.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToDouble((double)KMeans.$anonfun$initKMeansParallel$1(x$14)), ClassTag$.MODULE$.Double());
        int seed = new XORShiftRandom(this.seed()).nextInt();
        VectorWithNorm[] sample = (VectorWithNorm[])data.takeSample(false, 1, (long)seed);
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sample)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("No samples available from ").append(data).toString());
        ArrayBuffer centers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        VectorWithNorm[] newCenters = (VectorWithNorm[])((Object[])new VectorWithNorm[]{((VectorWithNorm)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sample)).head()).toDense()});
        centers.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newCenters)));
        IntRef step = IntRef.create((int)0);
        ArrayBuffer bcNewCentersList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (step.elem < this.initializationSteps()) {
            Broadcast bcNewCenters = data.context().broadcast((Object)newCenters, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
            bcNewCentersList.$plus$eq((Object)bcNewCenters);
            RDD preCosts = costs;
            costs = data.zip(preCosts, ClassTag$.MODULE$.Double()).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)KMeans.$anonfun$initKMeansParallel$3(distanceMeasureInstance, bcNewCenters, x0$1)), ClassTag$.MODULE$.Double()).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
            double sumCosts = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(costs).sum();
            bcNewCenters.unpersist();
            preCosts.unpersist(preCosts.unpersist$default$1());
            RDD qual$1 = data.zip(costs, ClassTag$.MODULE$.Double());
            Function2 & Serializable & scala.Serializable x$1 = (Function2 & Serializable & scala.Serializable)(index, pointCosts) -> KMeans.$anonfun$initKMeansParallel$4(this, seed, step, sumCosts, BoxesRunTime.unboxToInt((Object)index), pointCosts);
            boolean x$2 = qual$1.mapPartitionsWithIndex$default$2();
            VectorWithNorm[] chosen = (VectorWithNorm[])qual$1.mapPartitionsWithIndex((Function2)x$1, x$2, ClassTag$.MODULE$.apply(VectorWithNorm.class)).collect();
            newCenters = (VectorWithNorm[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chosen)).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.toDense(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(VectorWithNorm.class)));
            centers.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newCenters)));
            ++step.elem;
        }
        RDD qual$2 = costs;
        boolean x$3 = qual$2.unpersist$default$1();
        qual$2.unpersist(x$3);
        bcNewCentersList.foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            x$17.destroy();
            return BoxedUnit.UNIT;
        });
        VectorWithNorm[] distinctCenters = (VectorWithNorm[])((TraversableOnce)((TraversableLike)((SeqLike)centers.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.vector(), ArrayBuffer$.MODULE$.canBuildFrom())).distinct()).map((Function1 & Serializable & scala.Serializable)x$19 -> new VectorWithNorm((Vector)x$19), ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(VectorWithNorm.class));
        if (distinctCenters.length <= this.k()) {
            return distinctCenters;
        }
        Broadcast bcCenters = data.context().broadcast((Object)distinctCenters, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
        Map countMap = data.map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)KMeans.$anonfun$initKMeansParallel$11(distanceMeasureInstance, bcCenters, x$20)), ClassTag$.MODULE$.Int()).countByValue((Ordering)Ordering.Int$.MODULE$);
        bcCenters.destroy();
        double[] myWeights = (double[])((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])distinctCenters)).indices().map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$21 -> BoxesRunTime.unboxToLong((Object)countMap.getOrElse((Object)BoxesRunTime.boxToInteger((int)x$21), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
        return LocalKMeans$.MODULE$.kMeansPlusPlus(0, distinctCenters, myWeights, this.k(), 30);
    }

    public static final /* synthetic */ double $anonfun$runWithWeight$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Vector v = (Vector)tuple2._1();
            return Vectors$.MODULE$.norm(v, 2.0);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$runAlgorithmWithWeight$6(DistanceMeasure distanceMeasureInstance$1, VectorWithNorm[] centers$1, Option stats$1, DoubleAccumulator costAccum$1, Vector[] sums$1, double[] clusterWeightSum$1, VectorWithNorm point) {
        Tuple2<Object, Object> tuple2 = distanceMeasureInstance$1.findClosest(centers$1, (Option<double[]>)stats$1, point);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int bestCenter = tuple2._1$mcI$sp();
        double cost = tuple2._2$mcD$sp();
        Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(bestCenter, cost);
        int bestCenter2 = sp2._1$mcI$sp();
        double cost2 = sp2._2$mcD$sp();
        costAccum$1.add(cost2 * point.weight());
        distanceMeasureInstance$1.updateClusterSum(point, sums$1[bestCenter2]);
        clusterWeightSum$1[bestCenter2] = clusterWeightSum$1[bestCenter2] + point.weight();
    }

    public static final /* synthetic */ Tuple2 $anonfun$runAlgorithmWithWeight$7(Vector[] sums$1, double[] clusterWeightSum$1, int j) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)j), (Object)new Tuple2((Object)sums$1[j], (Object)BoxesRunTime.boxToDouble((double)clusterWeightSum$1[j])));
    }

    public static final /* synthetic */ boolean $anonfun$runAlgorithmWithWeight$8(Tuple2 x$6) {
        return ((Tuple2)x$6._2())._2$mcD$sp() > 0.0;
    }

    public static final /* synthetic */ void $anonfun$runAlgorithmWithWeight$13(KMeans $this, DistanceMeasure distanceMeasureInstance$1, BooleanRef converged$1, VectorWithNorm[] centers$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int j = tuple2._1$mcI$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                Vector sum = (Vector)tuple22._1();
                double weightSum = tuple22._2$mcD$sp();
                VectorWithNorm newCenter = distanceMeasureInstance$1.centroid(sum, weightSum);
                if (converged$1.elem && !distanceMeasureInstance$1.isCenterConverged(centers$2[j], newCenter, $this.epsilon())) {
                    converged$1.elem = false;
                }
                centers$2[j] = newCenter;
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ double $anonfun$initKMeansParallel$1(VectorWithNorm x$14) {
        return Double.POSITIVE_INFINITY;
    }

    public static final /* synthetic */ double $anonfun$initKMeansParallel$3(DistanceMeasure distanceMeasureInstance$2, Broadcast bcNewCenters$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            VectorWithNorm point = (VectorWithNorm)tuple2._1();
            double cost = tuple2._2$mcD$sp();
            return scala.math.package$.MODULE$.min(distanceMeasureInstance$2.pointCost((VectorWithNorm[])bcNewCenters$1.value(), point), cost);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$initKMeansParallel$5(KMeans $this, XORShiftRandom rand$1, double sumCosts$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            double c = tuple2._2$mcD$sp();
            return rand$1.nextDouble() < 2.0 * c * (double)$this.k() / sumCosts$1;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Iterator $anonfun$initKMeansParallel$4(KMeans $this, int seed$1, IntRef step$1, double sumCosts$1, int index, Iterator pointCosts) {
        XORShiftRandom rand = new XORShiftRandom((long)(seed$1 ^ step$1.elem << 16 ^ index));
        return pointCosts.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)KMeans.$anonfun$initKMeansParallel$5($this, rand, sumCosts$1, x0$2))).map((Function1 & Serializable & scala.Serializable)x$15 -> (VectorWithNorm)x$15._1());
    }

    public static final /* synthetic */ int $anonfun$initKMeansParallel$11(DistanceMeasure distanceMeasureInstance$2, Broadcast bcCenters$2, VectorWithNorm x$20) {
        return distanceMeasureInstance$2.findClosest((VectorWithNorm[])bcCenters$2.value(), x$20)._1$mcI$sp();
    }

    private KMeans(int k, int maxIterations, String initializationMode, int initializationSteps, double epsilon, long seed, String distanceMeasure) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.initializationMode = initializationMode;
        this.initializationSteps = initializationSteps;
        this.epsilon = epsilon;
        this.seed = seed;
        this.distanceMeasure = distanceMeasure;
        Logging.$init$((Logging)this);
        this.initialModel = None$.MODULE$;
    }

    private KMeans(int k, int maxIterations, String initializationMode, int initializationSteps, double epsilon, long seed) {
        this(k, maxIterations, initializationMode, initializationSteps, epsilon, seed, DistanceMeasure$.MODULE$.EUCLIDEAN());
    }

    public KMeans() {
        this(2, 20, KMeans$.MODULE$.K_MEANS_PARALLEL(), 2, 1.0E-4, Utils$.MODULE$.random().nextLong(), DistanceMeasure$.MODULE$.EUCLIDEAN());
    }
}

