/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.Serializable;
import org.apache.spark.mllib.feature.ChiSqSelector$;
import org.apache.spark.mllib.feature.ChiSqSelectorModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.mllib.stat.test.ChiSqTestResult;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001\u0002\u0017.\u0001aBQA\u0011\u0001\u0005\u0002\rCqa\u0014\u0001A\u0002\u0013\u0005\u0001\u000bC\u0004U\u0001\u0001\u0007I\u0011A+\t\rm\u0003\u0001\u0015)\u0003R\u0011\u001da\u0006\u00011A\u0005\u0002uCq!\u0019\u0001A\u0002\u0013\u0005!\r\u0003\u0004e\u0001\u0001\u0006KA\u0018\u0005\bK\u0002\u0001\r\u0011\"\u0001^\u0011\u001d1\u0007\u00011A\u0005\u0002\u001dDa!\u001b\u0001!B\u0013q\u0006b\u00026\u0001\u0001\u0004%\t!\u0018\u0005\bW\u0002\u0001\r\u0011\"\u0001m\u0011\u0019q\u0007\u0001)Q\u0005=\"9q\u000e\u0001a\u0001\n\u0003i\u0006b\u00029\u0001\u0001\u0004%\t!\u001d\u0005\u0007g\u0002\u0001\u000b\u0015\u00020\t\u000fQ\u0004\u0001\u0019!C\u0001k\"I\u00111\u0001\u0001A\u0002\u0013\u0005\u0011Q\u0001\u0005\b\u0003\u0013\u0001\u0001\u0015)\u0003w\u0011\u0019\u0011\u0005\u0001\"\u0001\u0002\f!9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0001bBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u0011\u0001\t\u0003\t\u0019\u0005C\u0004\u0002J\u0001!\t!a\u0013\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T\u001dA\u00111P\u0017\t\u0002E\niHB\u0004-[!\u0005\u0011'a \t\r\tkB\u0011AAA\u0011%\t\u0019)\bb\u0001\n\u0003\tT\u000fC\u0004\u0002\u0006v\u0001\u000b\u0011\u0002<\t\u0013\u0005\u001dUD1A\u0005\u0002E*\bbBAE;\u0001\u0006IA\u001e\u0005\n\u0003\u0017k\"\u0019!C\u0001cUDq!!$\u001eA\u0003%a\u000fC\u0005\u0002\u0010v\u0011\r\u0011\"\u00012k\"9\u0011\u0011S\u000f!\u0002\u00131\b\"CAJ;\t\u0007I\u0011A\u0019v\u0011\u001d\t)*\bQ\u0001\nYD\u0011\"a&\u001e\u0005\u0004%\t!!'\t\u0011\u0005\u0005V\u0004)A\u0005\u00037C\u0011\"a)\u001e\u0003\u0003%I!!*\u0003\u001b\rC\u0017nU9TK2,7\r^8s\u0015\tqs&A\u0004gK\u0006$XO]3\u000b\u0005A\n\u0014!B7mY&\u0014'B\u0001\u001a4\u0003\u0015\u0019\b/\u0019:l\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!O \u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\r\u0005s\u0017PU3g!\tQ\u0004)\u0003\u0002Bw\ta1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012\u0001\u0012\t\u0003\u000b\u0002i\u0011!\f\u0015\u0004\u0003\u001dk\u0005C\u0001%L\u001b\u0005I%B\u0001&2\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u0019&\u0013QaU5oG\u0016\f\u0013AT\u0001\u0006e9\nd\u0006M\u0001\u000f]VlGk\u001c9GK\u0006$XO]3t+\u0005\t\u0006C\u0001\u001eS\u0013\t\u00196HA\u0002J]R\f!C\\;n)>\u0004h)Z1ukJ,7o\u0018\u0013fcR\u0011a+\u0017\t\u0003u]K!\u0001W\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b5\u000e\t\t\u00111\u0001R\u0003\rAH%M\u0001\u0010]VlGk\u001c9GK\u0006$XO]3tA\u0005Q\u0001/\u001a:dK:$\u0018\u000e\\3\u0016\u0003y\u0003\"AO0\n\u0005\u0001\\$A\u0002#pk\ndW-\u0001\bqKJ\u001cWM\u001c;jY\u0016|F%Z9\u0015\u0005Y\u001b\u0007b\u0002.\u0007\u0003\u0003\u0005\rAX\u0001\fa\u0016\u00148-\u001a8uS2,\u0007%A\u0002gaJ\fqA\u001a9s?\u0012*\u0017\u000f\u0006\u0002WQ\"9!,CA\u0001\u0002\u0004q\u0016\u0001\u00024qe\u0002\n1A\u001a3s\u0003\u001d1GM]0%KF$\"AV7\t\u000fic\u0011\u0011!a\u0001=\u0006!a\r\u001a:!\u0003\r1w/Z\u0001\bM^,w\fJ3r)\t1&\u000fC\u0004[\u001f\u0005\u0005\t\u0019\u00010\u0002\t\u0019<X\rI\u0001\rg\u0016dWm\u0019;peRK\b/Z\u000b\u0002mB\u0011qO \b\u0003qr\u0004\"!_\u001e\u000e\u0003iT!a_\u001c\u0002\rq\u0012xn\u001c;?\u0013\ti8(\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u007f\u0006\u0005!AB*ue&twM\u0003\u0002~w\u0005\u00012/\u001a7fGR|'\u000fV=qK~#S-\u001d\u000b\u0004-\u0006\u001d\u0001b\u0002.\u0013\u0003\u0003\u0005\rA^\u0001\u000eg\u0016dWm\u0019;peRK\b/\u001a\u0011\u0015\u0007\u0011\u000bi\u0001C\u0003P)\u0001\u0007\u0011\u000b\u000b\u0003\u0015\u000f\u0006E\u0011EAA\n\u0003\u0015\tdf\r\u00181\u0003E\u0019X\r\u001e(v[R{\u0007OR3biV\u0014Xm\u001d\u000b\u0005\u00033\tY\"D\u0001\u0001\u0011\u0019\ti\"\u0006a\u0001#\u0006)a/\u00197vK\"\"QcRA\u0011C\t\t\u0019#A\u00032]Yr\u0003'A\u0007tKR\u0004VM]2f]RLG.\u001a\u000b\u0005\u00033\tI\u0003\u0003\u0004\u0002\u001eY\u0001\rA\u0018\u0015\u0004-\u001dk\u0015AB:fi\u001a\u0003(\u000f\u0006\u0003\u0002\u001a\u0005E\u0002BBA\u000f/\u0001\u0007a\fK\u0002\u0018\u000f6\u000baa]3u\r\u0012\u0014H\u0003BA\r\u0003sAa!!\b\u0019\u0001\u0004q\u0006\u0006\u0002\rH\u0003{\t#!a\u0010\u0002\u000bIr#G\f\u0019\u0002\rM,GOR<f)\u0011\tI\"!\u0012\t\r\u0005u\u0011\u00041\u0001_Q\u0011Ir)!\u0010\u0002\u001fM,GoU3mK\u000e$xN\u001d+za\u0016$B!!\u0007\u0002N!1\u0011Q\u0004\u000eA\u0002YD3AG$N\u0003\r1\u0017\u000e\u001e\u000b\u0005\u0003+\nY\u0006E\u0002F\u0003/J1!!\u0017.\u0005I\u0019\u0005.[*r'\u0016dWm\u0019;pe6{G-\u001a7\t\u000f\u0005u3\u00041\u0001\u0002`\u0005!A-\u0019;b!\u0019\t\t'a\u001a\u0002l5\u0011\u00111\r\u0006\u0004\u0003K\n\u0014a\u0001:eI&!\u0011\u0011NA2\u0005\r\u0011F\t\u0012\t\u0005\u0003[\n\u0019(\u0004\u0002\u0002p)\u0019\u0011\u0011O\u0018\u0002\u0015I,wM]3tg&|g.\u0003\u0003\u0002v\u0005=$\u0001\u0004'bE\u0016dW\r\u001a)pS:$\b\u0006B\u000eH\u0003#AC\u0001A$\u0002\u0012\u0005i1\t[5TcN+G.Z2u_J\u0004\"!R\u000f\u0014\u0007uIt\b\u0006\u0002\u0002~\u0005qa*^7U_B4U-\u0019;ve\u0016\u001c\u0018a\u0004(v[R{\u0007OR3biV\u0014Xm\u001d\u0011\u0002\u0015A+'oY3oi&dW-A\u0006QKJ\u001cWM\u001c;jY\u0016\u0004\u0013a\u0001$Q%\u0006!a\t\u0015*!\u0003\r1EIU\u0001\u0005\r\u0012\u0013\u0006%A\u0002G/\u0016\u000bAAR,FA\u000512/\u001e9q_J$X\rZ*fY\u0016\u001cGo\u001c:UsB,7/\u0006\u0002\u0002\u001cB!!(!(w\u0013\r\tyj\u000f\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0018gV\u0004\bo\u001c:uK\u0012\u001cV\r\\3di>\u0014H+\u001f9fg\u0002\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0015\t\u0005\u0003S\u000b\u0019,\u0004\u0002\u0002,*!\u0011QVAX\u0003\u0011a\u0017M\\4\u000b\u0005\u0005E\u0016\u0001\u00026bm\u0006LA!!.\u0002,\n1qJ\u00196fGR\u0004")
public class ChiSqSelector
implements scala.Serializable {
    private int numTopFeatures = 50;
    private double percentile = 0.1;
    private double fpr = 0.05;
    private double fdr = 0.05;
    private double fwe = 0.05;
    private String selectorType = ChiSqSelector$.MODULE$.NumTopFeatures();

    public static String[] supportedSelectorTypes() {
        return ChiSqSelector$.MODULE$.supportedSelectorTypes();
    }

    public int numTopFeatures() {
        return this.numTopFeatures;
    }

    public void numTopFeatures_$eq(int x$1) {
        this.numTopFeatures = x$1;
    }

    public double percentile() {
        return this.percentile;
    }

    public void percentile_$eq(double x$1) {
        this.percentile = x$1;
    }

    public double fpr() {
        return this.fpr;
    }

    public void fpr_$eq(double x$1) {
        this.fpr = x$1;
    }

    public double fdr() {
        return this.fdr;
    }

    public void fdr_$eq(double x$1) {
        this.fdr = x$1;
    }

    public double fwe() {
        return this.fwe;
    }

    public void fwe_$eq(double x$1) {
        this.fwe = x$1;
    }

    public String selectorType() {
        return this.selectorType;
    }

    public void selectorType_$eq(String x$1) {
        this.selectorType = x$1;
    }

    public ChiSqSelector setNumTopFeatures(int value) {
        this.numTopFeatures_$eq(value);
        return this;
    }

    public ChiSqSelector setPercentile(double value) {
        Predef$.MODULE$.require(0.0 <= value && value <= 1.0, (Function0 & Serializable & scala.Serializable)() -> "Percentile must be in [0,1]");
        this.percentile_$eq(value);
        return this;
    }

    public ChiSqSelector setFpr(double value) {
        Predef$.MODULE$.require(0.0 <= value && value <= 1.0, (Function0 & Serializable & scala.Serializable)() -> "FPR must be in [0,1]");
        this.fpr_$eq(value);
        return this;
    }

    public ChiSqSelector setFdr(double value) {
        Predef$.MODULE$.require(0.0 <= value && value <= 1.0, (Function0 & Serializable & scala.Serializable)() -> "FDR must be in [0,1]");
        this.fdr_$eq(value);
        return this;
    }

    public ChiSqSelector setFwe(double value) {
        Predef$.MODULE$.require(0.0 <= value && value <= 1.0, (Function0 & Serializable & scala.Serializable)() -> "FWE must be in [0,1]");
        this.fwe_$eq(value);
        return this;
    }

    public ChiSqSelector setSelectorType(String value) {
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ChiSqSelector$.MODULE$.supportedSelectorTypes())).contains((Object)value), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("ChiSqSelector Type: ").append(value).append(" was not supported.").toString());
        this.selectorType_$eq(value);
        return this;
    }

    public ChiSqSelectorModel fit(RDD<LabeledPoint> data) {
        Tuple2[] tuple2Array;
        Tuple2[] chiSqTestResult = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Statistics$.MODULE$.chiSqTest(data))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        String string = this.selectorType();
        String string2 = ChiSqSelector$.MODULE$.NumTopFeatures();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            tuple2Array = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chiSqTestResult)).sortBy((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)ChiSqSelector.$anonfun$fit$1(x0$1)), (Ordering)Ordering.Double$.MODULE$))).take(this.numTopFeatures());
        } else {
            String string4 = ChiSqSelector$.MODULE$.Percentile();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                tuple2Array = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chiSqTestResult)).sortBy((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)ChiSqSelector.$anonfun$fit$2(x0$2)), (Ordering)Ordering.Double$.MODULE$))).take((int)((double)chiSqTestResult.length * this.percentile()));
            } else {
                String string6 = ChiSqSelector$.MODULE$.FPR();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    tuple2Array = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chiSqTestResult)).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ChiSqSelector.$anonfun$fit$3(this, x0$3)));
                } else {
                    String string8 = ChiSqSelector$.MODULE$.FDR();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        Tuple2[] tempRes = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chiSqTestResult)).sortBy((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToDouble((double)ChiSqSelector.$anonfun$fit$4(x0$4)), (Ordering)Ordering.Double$.MODULE$);
                        Tuple2[] selected = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tempRes)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)ChiSqSelector.$anonfun$fit$5(this, chiSqTestResult, x0$5)));
                        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])selected)).isEmpty()) {
                            tuple2Array = (Tuple2[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class));
                        } else {
                            int maxIndex = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])selected)).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3._2$mcI$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).max((Ordering)Ordering.Int$.MODULE$));
                            tuple2Array = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tempRes)).take(maxIndex + 1);
                        }
                    } else {
                        String string10 = ChiSqSelector$.MODULE$.FWE();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            tuple2Array = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chiSqTestResult)).filter((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)ChiSqSelector.$anonfun$fit$7(this, chiSqTestResult, x0$6)));
                        } else {
                            throw new IllegalArgumentException(new StringBuilder(28).append("Unknown ChiSqSelector Type: ").append(string).toString());
                        }
                    }
                }
            }
        }
        Tuple2[] features = tuple2Array;
        int[] indices = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])features)).map((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToInteger((int)ChiSqSelector.$anonfun$fit$8(x0$7)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        return new ChiSqSelectorModel(indices);
    }

    public static final /* synthetic */ double $anonfun$fit$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ChiSqTestResult res = (ChiSqTestResult)tuple2._1();
            return res.pValue();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ double $anonfun$fit$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            ChiSqTestResult res = (ChiSqTestResult)tuple2._1();
            return res.pValue();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$fit$3(ChiSqSelector $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            ChiSqTestResult res = (ChiSqTestResult)tuple2._1();
            return res.pValue() < $this.fpr();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ double $anonfun$fit$4(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            ChiSqTestResult res = (ChiSqTestResult)tuple2._1();
            return res.pValue();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$fit$5(ChiSqSelector $this, Tuple2[] chiSqTestResult$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (tuple22 != null) {
                ChiSqTestResult res = (ChiSqTestResult)tuple22._1();
                return res.pValue() <= $this.fdr() * (double)(index + 1) / (double)chiSqTestResult$1.length;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$fit$7(ChiSqSelector $this, Tuple2[] chiSqTestResult$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            ChiSqTestResult res = (ChiSqTestResult)tuple2._1();
            return res.pValue() < $this.fwe() / (double)chiSqTestResult$1.length;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$fit$8(Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 != null) {
            int index = tuple2._2$mcI$sp();
            return index;
        }
        throw new MatchError((Object)tuple2);
    }

    public ChiSqSelector() {
    }

    public ChiSqSelector(int numTopFeatures) {
        this();
        this.numTopFeatures_$eq(numTopFeatures);
    }
}

