/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.feature.IDFModel$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001\u0002\n\u0014\u0001yA\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\ts\u0001\u0011\t\u0011)A\u0005U!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003>\u0011!A\u0005A!b\u0001\n\u0003I\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\r5\u0003A\u0011A\fO\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u00159\u0006\u0001\"\u0001c\u0011\u00159\u0006\u0001\"\u0001i\u000f\u0019!8\u0003#\u0001\u0018k\u001a1!c\u0005E\u0001/YDQ!\u0014\u0007\u0005\u0002]DQa\u0016\u0007\u0005\u0002aDaa\u001f\u0007\u0005\u0002]a\b\u0002CA\u0005\u0019\u0011\u0005q#a\u0003\t\u0013\u0005\rB\"!A\u0005\n\u0005\u0015\"\u0001C%E\r6{G-\u001a7\u000b\u0005Q)\u0012a\u00024fCR,(/\u001a\u0006\u0003-]\tQ!\u001c7mS\nT!\u0001G\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\r\u0001q$\n\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u00012\u0013BA\u0014\"\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\rIGMZ\u000b\u0002UA\u00111FL\u0007\u0002Y)\u0011Q&F\u0001\u0007Y&t\u0017\r\\4\n\u0005=b#A\u0002,fGR|'\u000fK\u0002\u0002c]\u0002\"AM\u001b\u000e\u0003MR!\u0001N\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00027g\t)1+\u001b8dK\u0006\n\u0001(A\u00032]Er\u0003'\u0001\u0003jI\u001a\u0004\u0003f\u0001\u00022o\u00059Am\\2Ge\u0016\fX#A\u001f\u0011\u0007\u0001r\u0004)\u0003\u0002@C\t)\u0011I\u001d:bsB\u0011\u0001%Q\u0005\u0003\u0005\u0006\u0012A\u0001T8oO\"\u001a1!\r#\"\u0003\u0015\u000bQa\r\u00181]A\n\u0001\u0002Z8d\rJ,\u0017\u000f\t\u0015\u0004\tE\"\u0015a\u00028v[\u0012{7m]\u000b\u0002\u0001\"\u001aQ!\r#\u0002\u00119,X\u000eR8dg\u0002B3AB\u0019E\u0003\u0019a\u0014N\\5u}Q!q*U*V!\t\u0001\u0006!D\u0001\u0014\u0011\u0015As\u00011\u0001+Q\r\t\u0016g\u000e\u0005\u0006w\u001d\u0001\r!\u0010\u0015\u0004'F\"\u0005\"\u0002%\b\u0001\u0004\u0001\u0005fA+2\t\u0006IAO]1og\u001a|'/\u001c\u000b\u00033~\u00032AW/+\u001b\u0005Y&B\u0001/\u0018\u0003\r\u0011H\rZ\u0005\u0003=n\u00131A\u0015#E\u0011\u0015\u0001\u0007\u00021\u0001Z\u0003\u001d!\u0017\r^1tKRD3\u0001C\u00198)\tQ3\rC\u0003e\u0013\u0001\u0007!&A\u0001wQ\rI\u0011GZ\u0011\u0002O\u0006)\u0011GL\u001a/aQ\u0011\u0011.\u001d\t\u0004U>TS\"A6\u000b\u00051l\u0017\u0001\u00026bm\u0006T!A\\\f\u0002\u0007\u0005\u0004\u0018.\u0003\u0002qW\n9!*\u0019<b%\u0012#\u0005\"\u00021\u000b\u0001\u0004I\u0007f\u0001\u00062o!\u001a\u0001!M\u001c\u0002\u0011%#e)T8eK2\u0004\"\u0001\u0015\u0007\u0014\u00071yR\u0005F\u0001v)\rQ\u0013P\u001f\u0005\u0006Q9\u0001\rA\u000b\u0005\u0006I:\u0001\rAK\u0001\u000fiJ\fgn\u001d4pe6$UM\\:f)\u0015i\u00181AA\u0003!\r\u0001cH \t\u0003A}L1!!\u0001\"\u0005\u0019!u.\u001e2mK\")\u0001f\u0004a\u0001U!1\u0011qA\bA\u0002u\faA^1mk\u0016\u001c\u0018a\u0004;sC:\u001chm\u001c:n'B\f'o]3\u0015\u0011\u00055\u00111DA\u000f\u0003C\u0001b\u0001IA\b\u0003'i\u0018bAA\tC\t1A+\u001e9mKJ\u0002B\u0001\t \u0002\u0016A\u0019\u0001%a\u0006\n\u0007\u0005e\u0011EA\u0002J]RDQ\u0001\u000b\tA\u0002)Bq!a\b\u0011\u0001\u0004\t\u0019\"A\u0004j]\u0012L7-Z:\t\r\u0005\u001d\u0001\u00031\u0001~\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u001d\u0002\u0003BA\u0015\u0003ci!!a\u000b\u000b\t\u00055\u0012qF\u0001\u0005Y\u0006twMC\u0001m\u0013\u0011\t\u0019$a\u000b\u0003\r=\u0013'.Z2u\u0001")
public class IDFModel
implements Serializable {
    private final Vector idf;
    private final long[] docFreq;
    private final long numDocs;

    public Vector idf() {
        return this.idf;
    }

    public long[] docFreq() {
        return this.docFreq;
    }

    public long numDocs() {
        return this.numDocs;
    }

    public RDD<Vector> transform(RDD<Vector> dataset) {
        Broadcast bcIdf = dataset.context().broadcast((Object)this.idf(), ClassTag$.MODULE$.apply(Vector.class));
        return dataset.mapPartitions((Function1 & java.io.Serializable & Serializable)iter -> iter.map((Function1 & java.io.Serializable & Serializable)v -> IDFModel$.MODULE$.transform((Vector)bcIdf.value(), (Vector)v)), dataset.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Vector.class));
    }

    public Vector transform(Vector v) {
        return IDFModel$.MODULE$.transform(this.idf(), v);
    }

    public JavaRDD<Vector> transform(JavaRDD<Vector> dataset) {
        return this.transform((RDD<Vector>)dataset.rdd()).toJavaRDD();
    }

    public IDFModel(Vector idf, long[] docFreq, long numDocs) {
        this.idf = idf;
        this.docFreq = docFreq;
        this.numDocs = numDocs;
    }
}

