/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat;

import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001\u0002\u001a4\u0001yBQ\u0001\u0014\u0001\u0005\u00025Cqa\u0014\u0001A\u0002\u0013%\u0001\u000bC\u0004U\u0001\u0001\u0007I\u0011B+\t\rm\u0003\u0001\u0015)\u0003R\u0011%a\u0006\u00011AA\u0002\u0013%Q\fC\u0005e\u0001\u0001\u0007\t\u0019!C\u0005K\"Iq\r\u0001a\u0001\u0002\u0003\u0006KA\u0018\u0005\nQ\u0002\u0001\r\u00111A\u0005\nuC\u0011\"\u001b\u0001A\u0002\u0003\u0007I\u0011\u00026\t\u00131\u0004\u0001\u0019!A!B\u0013q\u0006\"C7\u0001\u0001\u0004\u0005\r\u0011\"\u0003^\u0011%q\u0007\u00011AA\u0002\u0013%q\u000eC\u0005r\u0001\u0001\u0007\t\u0011)Q\u0005=\"I!\u000f\u0001a\u0001\u0002\u0004%I!\u0018\u0005\ng\u0002\u0001\r\u00111A\u0005\nQD\u0011B\u001e\u0001A\u0002\u0003\u0005\u000b\u0015\u00020\t\u000f]\u0004\u0001\u0019!C\u0005q\"9A\u0010\u0001a\u0001\n\u0013i\bBB@\u0001A\u0003&\u0011\u0010C\u0005\u0002\u0002\u0001\u0001\r\u0011\"\u0003\u0002\u0004!I\u0011Q\u0001\u0001A\u0002\u0013%\u0011q\u0001\u0005\b\u0003\u0017\u0001\u0001\u0015)\u0003b\u0011%\ti\u0001\u0001a\u0001\n\u0013\t\u0019\u0001C\u0005\u0002\u0010\u0001\u0001\r\u0011\"\u0003\u0002\u0012!9\u0011Q\u0003\u0001!B\u0013\t\u0007BCA\f\u0001\u0001\u0007\t\u0019!C\u0005;\"Y\u0011\u0011\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u000e\u0011)\ty\u0002\u0001a\u0001\u0002\u0003\u0006KA\u0018\u0005\f\u0003C\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\u0003C\u0006\u0002(\u0001\u0001\r\u00111A\u0005\n\u0005%\u0002bCA\u0017\u0001\u0001\u0007\t\u0011)Q\u0005\u0003KA!\"a\f\u0001\u0001\u0004\u0005\r\u0011\"\u0003^\u0011-\t\t\u0004\u0001a\u0001\u0002\u0004%I!a\r\t\u0015\u0005]\u0002\u00011A\u0001B\u0003&a\f\u0003\u0006\u0002:\u0001\u0001\r\u00111A\u0005\nuC1\"a\u000f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002>!Q\u0011\u0011\t\u0001A\u0002\u0003\u0005\u000b\u0015\u00020\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002F!A\u00111\t\u0001\u0005\u0002]\nY\u0007C\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005}\u0004\u0001\"\u0011\u0002\u0002\"9\u0011Q\u0011\u0001\u0005B\u0005\u0005\u0005BBAE\u0001\u0011\u0005\u0003\u0010C\u0004\u0002\u000e\u0002!\t%a\u0001\t\u000f\u0005=\u0005\u0001\"\u0011\u0002\u0002\"9\u00111\u0013\u0001\u0005B\u0005\u0005\u0005bBAL\u0001\u0011\u0005\u0013\u0011\u0011\u0005\b\u00037\u0003A\u0011IAA\u0011\u001d\t\u0019\u000b\u0001C!\u0003\u0003\u0013A$T;mi&4\u0018M]5bi\u0016|e\u000e\\5oKN+X.\\1sSj,'O\u0003\u00025k\u0005!1\u000f^1u\u0015\t1t'A\u0003nY2L'M\u0003\u00029s\u0005)1\u000f]1sW*\u0011!hO\u0001\u0007CB\f7\r[3\u000b\u0003q\n1a\u001c:h\u0007\u0001\u0019B\u0001A F\u0013B\u0011\u0001iQ\u0007\u0002\u0003*\t!)A\u0003tG\u0006d\u0017-\u0003\u0002E\u0003\n1\u0011I\\=SK\u001a\u0004\"AR$\u000e\u0003MJ!\u0001S\u001a\u0003=5+H\u000e^5wCJL\u0017\r^3Ti\u0006$\u0018n\u001d;jG\u0006d7+^7nCJL\bC\u0001!K\u0013\tY\u0015I\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGO\u0010\u000b\u0002\u001dB\u0011a\tA\u0001\u0002]V\t\u0011\u000b\u0005\u0002A%&\u00111+\u0011\u0002\u0004\u0013:$\u0018!\u00028`I\u0015\fHC\u0001,Z!\t\u0001u+\u0003\u0002Y\u0003\n!QK\\5u\u0011\u001dQ6!!AA\u0002E\u000b1\u0001\u001f\u00132\u0003\tq\u0007%\u0001\u0005dkJ\u0014X*Z1o+\u0005q\u0006c\u0001!`C&\u0011\u0001-\u0011\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0001\nL!aY!\u0003\r\u0011{WO\u00197f\u00031\u0019WO\u001d:NK\u0006tw\fJ3r)\t1f\rC\u0004[\r\u0005\u0005\t\u0019\u00010\u0002\u0013\r,(O]'fC:\u0004\u0013aB2veJl%G\\\u0001\fGV\u0014(/\u0014\u001ao?\u0012*\u0017\u000f\u0006\u0002WW\"9!,CA\u0001\u0002\u0004q\u0016\u0001C2veJl%G\u001c\u0011\u0002\r\r,(O]'3\u0003)\u0019WO\u001d:Ne}#S-\u001d\u000b\u0003-BDqA\u0017\u0007\u0002\u0002\u0003\u0007a,A\u0004dkJ\u0014XJ\r\u0011\u0002\r\r,(O\u001d'2\u0003)\u0019WO\u001d:Mc}#S-\u001d\u000b\u0003-VDqAW\b\u0002\u0002\u0003\u0007a,A\u0004dkJ\u0014H*\r\u0011\u0002\u0011Q|G/\u00197D]R,\u0012!\u001f\t\u0003\u0001jL!a_!\u0003\t1{gnZ\u0001\ri>$\u0018\r\\\"oi~#S-\u001d\u000b\u0003-zDqA\u0017\n\u0002\u0002\u0003\u0007\u00110A\u0005u_R\fGn\u00118uA\u0005qAo\u001c;bY^+\u0017n\u001a5u'VlW#A1\u0002%Q|G/\u00197XK&<\u0007\u000e^*v[~#S-\u001d\u000b\u0004-\u0006%\u0001b\u0002.\u0016\u0003\u0003\u0005\r!Y\u0001\u0010i>$\u0018\r\\,fS\u001eDGoU;nA\u0005yq/Z5hQR\u001c\u0016/^1sKN+X.A\nxK&<\u0007\u000e^*rk\u0006\u0014XmU;n?\u0012*\u0017\u000fF\u0002W\u0003'AqA\u0017\r\u0002\u0002\u0003\u0007\u0011-\u0001\txK&<\u0007\u000e^*rk\u0006\u0014XmU;nA\u0005i1-\u001e:s/\u0016Lw\r\u001b;Tk6\f\u0011cY;se^+\u0017n\u001a5u'Vlw\fJ3r)\r1\u0016Q\u0004\u0005\b5n\t\t\u00111\u0001_\u00039\u0019WO\u001d:XK&<\u0007\u000e^*v[\u0002\n1A\u001c8{+\t\t)\u0003E\u0002A?f\fqA\u001c8{?\u0012*\u0017\u000fF\u0002W\u0003WA\u0001B\u0017\u0010\u0002\u0002\u0003\u0007\u0011QE\u0001\u0005]:T\b%A\u0004dkJ\u0014X*\u0019=\u0002\u0017\r,(O]'bq~#S-\u001d\u000b\u0004-\u0006U\u0002b\u0002.\"\u0003\u0003\u0005\rAX\u0001\tGV\u0014(/T1yA\u000591-\u001e:s\u001b&t\u0017aC2veJl\u0015N\\0%KF$2AVA \u0011\u001dQF%!AA\u0002y\u000b\u0001bY;se6Kg\u000eI\u0001\u0004C\u0012$G\u0003BA$\u0003\u0013j\u0011\u0001\u0001\u0005\b\u0003\u00172\u0003\u0019AA'\u0003\u0019\u0019\u0018-\u001c9mKB!\u0011qJA+\u001b\t\t\tFC\u0002\u0002TU\na\u0001\\5oC2<\u0017\u0002BA,\u0003#\u0012aAV3di>\u0014\b&\u0002\u0014\u0002\\\u0005\u001d\u0004\u0003BA/\u0003Gj!!a\u0018\u000b\u0007\u0005\u0005t'\u0001\u0006b]:|G/\u0019;j_:LA!!\u001a\u0002`\t)1+\u001b8dK\u0006\u0012\u0011\u0011N\u0001\u0006c9\nd\u0006\r\u000b\u0007\u0003\u000f\ni'!\u001d\t\u000f\u0005=t\u00051\u0001\u0002N\u0005A\u0011N\\:uC:\u001cW\r\u0003\u0004\u0002t\u001d\u0002\r!Y\u0001\u0007o\u0016Lw\r\u001b;\u0002\u000b5,'oZ3\u0015\t\u0005\u001d\u0013\u0011\u0010\u0005\u0007\u0003wB\u0003\u0019\u0001(\u0002\u000b=$\b.\u001a:)\u000b!\nY&a\u001a\u0002\t5,\u0017M\\\u000b\u0003\u0003\u001bBS!KA.\u0003O\n\u0001B^1sS\u0006t7-\u001a\u0015\u0006U\u0005m\u0013qM\u0001\u0006G>,h\u000e\u001e\u0015\u0006W\u0005m\u0013qM\u0001\no\u0016Lw\r\u001b;Tk6\f1B\\;n\u001d>t'0\u001a:pg\"*Q&a\u0017\u0002h\u0005\u0019Q.\u0019=)\u000b9\nY&a\u001a\u0002\u00075Lg\u000eK\u00030\u00037\n9'\u0001\u0004o_JlGJ\r\u0015\u0006a\u0005m\u0013qT\u0011\u0003\u0003C\u000bQ!\r\u00183]A\naA\\8s[2\u000b\u0004&B\u0019\u0002\\\u0005}\u0005&\u0002\u0001\u0002\\\u0005\u001d\u0004")
public class MultivariateOnlineSummarizer
implements MultivariateStatisticalSummary,
Serializable {
    private int n = 0;
    private double[] currMean;
    private double[] currM2n;
    private double[] currM2;
    private double[] currL1;
    private long totalCnt = 0L;
    private double totalWeightSum = 0.0;
    private double weightSquareSum = 0.0;
    private double[] currWeightSum;
    private long[] nnz;
    private double[] currMax;
    private double[] currMin;

    private int n() {
        return this.n;
    }

    private void n_$eq(int x$1) {
        this.n = x$1;
    }

    private double[] currMean() {
        return this.currMean;
    }

    private void currMean_$eq(double[] x$1) {
        this.currMean = x$1;
    }

    private double[] currM2n() {
        return this.currM2n;
    }

    private void currM2n_$eq(double[] x$1) {
        this.currM2n = x$1;
    }

    private double[] currM2() {
        return this.currM2;
    }

    private void currM2_$eq(double[] x$1) {
        this.currM2 = x$1;
    }

    private double[] currL1() {
        return this.currL1;
    }

    private void currL1_$eq(double[] x$1) {
        this.currL1 = x$1;
    }

    private long totalCnt() {
        return this.totalCnt;
    }

    private void totalCnt_$eq(long x$1) {
        this.totalCnt = x$1;
    }

    private double totalWeightSum() {
        return this.totalWeightSum;
    }

    private void totalWeightSum_$eq(double x$1) {
        this.totalWeightSum = x$1;
    }

    private double weightSquareSum() {
        return this.weightSquareSum;
    }

    private void weightSquareSum_$eq(double x$1) {
        this.weightSquareSum = x$1;
    }

    private double[] currWeightSum() {
        return this.currWeightSum;
    }

    private void currWeightSum_$eq(double[] x$1) {
        this.currWeightSum = x$1;
    }

    private long[] nnz() {
        return this.nnz;
    }

    private void nnz_$eq(long[] x$1) {
        this.nnz = x$1;
    }

    private double[] currMax() {
        return this.currMax;
    }

    private void currMax_$eq(double[] x$1) {
        this.currMax = x$1;
    }

    private double[] currMin() {
        return this.currMin;
    }

    private void currMin_$eq(double[] x$1) {
        this.currMin = x$1;
    }

    public MultivariateOnlineSummarizer add(Vector sample) {
        return this.add(sample, 1.0);
    }

    public MultivariateOnlineSummarizer add(Vector instance, double weight) {
        Predef$.MODULE$.require(weight >= 0.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(32).append("sample weight, ").append(weight).append(" has to be >= 0.0").toString());
        if (weight == 0.0) {
            return this;
        }
        if (this.n() == 0) {
            Predef$.MODULE$.require(instance.size() > 0, (Function0 & java.io.Serializable & Serializable)() -> "Vector should have dimension larger than zero.");
            this.n_$eq(instance.size());
            this.currMean_$eq((double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double()));
            this.currM2n_$eq((double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double()));
            this.currM2_$eq((double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double()));
            this.currL1_$eq((double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double()));
            this.currWeightSum_$eq((double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double()));
            this.nnz_$eq((long[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Long()));
            this.currMax_$eq((double[])Array$.MODULE$.fill(this.n(), (Function0)(JFunction0.mcD.sp & java.io.Serializable & Serializable)() -> Double$.MODULE$.MinValue(), ClassTag$.MODULE$.Double()));
            this.currMin_$eq((double[])Array$.MODULE$.fill(this.n(), (Function0)(JFunction0.mcD.sp & java.io.Serializable & Serializable)() -> Double.MAX_VALUE, ClassTag$.MODULE$.Double()));
        }
        Predef$.MODULE$.require(this.n() == instance.size(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(64).append("Dimensions mismatch when adding new sample.").append(" Expecting ").append(this.n()).append(" but got ").append(instance.size()).append(".").toString());
        double[] localCurrMean = this.currMean();
        double[] localCurrM2n = this.currM2n();
        double[] localCurrM2 = this.currM2();
        double[] localCurrL1 = this.currL1();
        double[] localWeightSum = this.currWeightSum();
        long[] localNumNonzeros = this.nnz();
        double[] localCurrMax = this.currMax();
        double[] localCurrMin = this.currMin();
        instance.foreachNonZero((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & java.io.Serializable & Serializable)(index, value) -> {
            if (localCurrMax[index] < value) {
                localCurrMax$1[index] = value;
            }
            if (localCurrMin[index] > value) {
                localCurrMin$1[index] = value;
            }
            double prevMean = localCurrMean[index];
            double diff = value - prevMean;
            localCurrMean$1[index] = prevMean + weight * diff / (localWeightSum[index] + weight);
            localCurrM2n$1[index] = localCurrM2n[index] + weight * (value - localCurrMean[index]) * diff;
            localCurrM2$1[index] = localCurrM2[index] + weight * value * value;
            localCurrL1$1[index] = localCurrL1[index] + weight * package$.MODULE$.abs(value);
            localWeightSum$1[index] = localWeightSum[index] + weight;
            localNumNonzeros$1[index] = localNumNonzeros[index] + 1L;
        });
        this.totalWeightSum_$eq(this.totalWeightSum() + weight);
        this.weightSquareSum_$eq(this.weightSquareSum() + weight * weight);
        this.totalCnt_$eq(this.totalCnt() + 1L);
        return this;
    }

    public MultivariateOnlineSummarizer merge(MultivariateOnlineSummarizer other) {
        block3: {
            block2: {
                if (this.totalWeightSum() == 0.0 || other.totalWeightSum() == 0.0) break block2;
                Predef$.MODULE$.require(this.n() == other.n(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(78).append("Dimensions mismatch when merging with another summarizer. ").append("Expecting ").append(this.n()).append(" but got ").append(other.n()).append(".").toString());
                this.totalCnt_$eq(this.totalCnt() + other.totalCnt());
                this.totalWeightSum_$eq(this.totalWeightSum() + other.totalWeightSum());
                this.weightSquareSum_$eq(this.weightSquareSum() + other.weightSquareSum());
                for (int i = 0; i < this.n(); ++i) {
                    double thisNnz = this.currWeightSum()[i];
                    double otherNnz = other.currWeightSum()[i];
                    double totalNnz = thisNnz + otherNnz;
                    long totalCnnz = this.nnz()[i] + other.nnz()[i];
                    if (totalNnz != 0.0) {
                        double deltaMean = other.currMean()[i] - this.currMean()[i];
                        double[] dArray = this.currMean();
                        int n = i;
                        dArray[n] = dArray[n] + deltaMean * otherNnz / totalNnz;
                        double[] dArray2 = this.currM2n();
                        int n2 = i;
                        dArray2[n2] = dArray2[n2] + (other.currM2n()[i] + deltaMean * deltaMean * thisNnz * otherNnz / totalNnz);
                        double[] dArray3 = this.currM2();
                        int n3 = i;
                        dArray3[n3] = dArray3[n3] + other.currM2()[i];
                        double[] dArray4 = this.currL1();
                        int n4 = i;
                        dArray4[n4] = dArray4[n4] + other.currL1()[i];
                        this.currMax()[i] = package$.MODULE$.max(this.currMax()[i], other.currMax()[i]);
                        this.currMin()[i] = package$.MODULE$.min(this.currMin()[i], other.currMin()[i]);
                    }
                    this.currWeightSum()[i] = totalNnz;
                    this.nnz()[i] = totalCnnz;
                }
                break block3;
            }
            if (this.totalWeightSum() != 0.0 || other.totalWeightSum() == 0.0) break block3;
            this.n_$eq(other.n());
            this.currMean_$eq((double[])other.currMean().clone());
            this.currM2n_$eq((double[])other.currM2n().clone());
            this.currM2_$eq((double[])other.currM2().clone());
            this.currL1_$eq((double[])other.currL1().clone());
            this.totalCnt_$eq(other.totalCnt());
            this.totalWeightSum_$eq(other.totalWeightSum());
            this.weightSquareSum_$eq(other.weightSquareSum());
            this.currWeightSum_$eq((double[])other.currWeightSum().clone());
            this.nnz_$eq((long[])other.nnz().clone());
            this.currMax_$eq((double[])other.currMax().clone());
            this.currMin_$eq((double[])other.currMin().clone());
        }
        return this;
    }

    @Override
    public Vector mean() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0 & java.io.Serializable & Serializable)() -> "Nothing has been added to this summarizer.");
        double[] realMean = (double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double());
        for (int i = 0; i < this.n(); ++i) {
            realMean[i] = this.currMean()[i] * (this.currWeightSum()[i] / this.totalWeightSum());
        }
        return Vectors$.MODULE$.dense(realMean);
    }

    @Override
    public Vector variance() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0 & java.io.Serializable & Serializable)() -> "Nothing has been added to this summarizer.");
        double[] realVariance = (double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double());
        double denominator = this.totalWeightSum() - this.weightSquareSum() / this.totalWeightSum();
        if (denominator > 0.0) {
            double[] deltaMean = this.currMean();
            int len = this.currM2n().length;
            for (int i = 0; i < len; ++i) {
                realVariance[i] = package$.MODULE$.max((this.currM2n()[i] + deltaMean[i] * deltaMean[i] * this.currWeightSum()[i] * (this.totalWeightSum() - this.currWeightSum()[i]) / this.totalWeightSum()) / denominator, 0.0);
            }
        }
        return Vectors$.MODULE$.dense(realVariance);
    }

    @Override
    public long count() {
        return this.totalCnt();
    }

    @Override
    public double weightSum() {
        return this.totalWeightSum();
    }

    @Override
    public Vector numNonzeros() {
        Predef$.MODULE$.require(this.totalCnt() > 0L, (Function0 & java.io.Serializable & Serializable)() -> "Nothing has been added to this summarizer.");
        return Vectors$.MODULE$.dense((double[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(this.nnz())).map((Function1)(JFunction1.mcDJ.sp & java.io.Serializable & Serializable)x$1 -> x$1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    @Override
    public Vector max() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0 & java.io.Serializable & Serializable)() -> "Nothing has been added to this summarizer.");
        for (int i = 0; i < this.n(); ++i) {
            if (this.nnz()[i] >= this.totalCnt() || !(this.currMax()[i] < 0.0)) continue;
            this.currMax()[i] = 0.0;
        }
        return Vectors$.MODULE$.dense(this.currMax());
    }

    @Override
    public Vector min() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0 & java.io.Serializable & Serializable)() -> "Nothing has been added to this summarizer.");
        for (int i = 0; i < this.n(); ++i) {
            if (this.nnz()[i] >= this.totalCnt() || !(this.currMin()[i] > 0.0)) continue;
            this.currMin()[i] = 0.0;
        }
        return Vectors$.MODULE$.dense(this.currMin());
    }

    @Override
    public Vector normL2() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0 & java.io.Serializable & Serializable)() -> "Nothing has been added to this summarizer.");
        double[] realMagnitude = (double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double());
        int len = this.currM2().length;
        for (int i = 0; i < len; ++i) {
            realMagnitude[i] = package$.MODULE$.sqrt(this.currM2()[i]);
        }
        return Vectors$.MODULE$.dense(realMagnitude);
    }

    @Override
    public Vector normL1() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0 & java.io.Serializable & Serializable)() -> "Nothing has been added to this summarizer.");
        return Vectors$.MODULE$.dense(this.currL1());
    }
}

