% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mllib_fpm.R
\name{spark.findFrequentSequentialPatterns}
\alias{spark.findFrequentSequentialPatterns}
\alias{spark.findFrequentSequentialPatterns,SparkDataFrame-method}
\alias{findFrequentSequentialPatterns,PrefixSpan,SparkDataFrame-method}
\title{PrefixSpan}
\usage{
spark.findFrequentSequentialPatterns(data, ...)

\S4method{spark.findFrequentSequentialPatterns}{SparkDataFrame}(
  data,
  minSupport = 0.1,
  maxPatternLength = 10L,
  maxLocalProjDBSize = 32000000L,
  sequenceCol = "sequence"
)
}
\arguments{
\item{data}{A SparkDataFrame.}

\item{...}{additional argument(s) passed to the method.}

\item{minSupport}{Minimal support level.}

\item{maxPatternLength}{Maximal pattern length.}

\item{maxLocalProjDBSize}{Maximum number of items (including delimiters used in the internal
storage format) allowed in a projected database before local
processing.}

\item{sequenceCol}{name of the sequence column in dataset.}
}
\value{
A complete set of frequent sequential patterns in the input sequences of itemsets.
        The returned \code{SparkDataFrame} contains columns of sequence and corresponding
        frequency. The schema of it will be:
        \code{sequence: ArrayType(ArrayType(T))}, \code{freq: integer}
        where T is the item type
}
\description{
A parallel PrefixSpan algorithm to mine frequent sequential patterns.
\code{spark.findFrequentSequentialPatterns} returns a complete set of frequent sequential
patterns.
For more details, see
\href{https://spark.apache.org/docs/latest/mllib-frequent-pattern-mining.html#prefixspan}{
PrefixSpan}.
}
\note{
spark.findFrequentSequentialPatterns(SparkDataFrame) since 3.0.0
}
\examples{
\dontrun{
df <- createDataFrame(list(list(list(list(1L, 2L), list(3L))),
                           list(list(list(1L), list(3L, 2L), list(1L, 2L))),
                           list(list(list(1L, 2L), list(5L))),
                           list(list(list(6L)))),
                      schema = c("sequence"))
frequency <- spark.findFrequentSequentialPatterns(df, minSupport = 0.5, maxPatternLength = 5L,
                                                  maxLocalProjDBSize = 32000000L)
showDF(frequency)
}
}
