/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.MessageDigestAlgorithms;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Sha2$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr, bitLength) - Returns a checksum of SHA-2 family as a hex string of `expr`.\n      SHA-224, SHA-256, SHA-384, and SHA-512 are supported. Bit length of 0 is equivalent to 256.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', 256);\n       529bc3b07127ecb7e53a4dcf1991d9152c24537d919178022b2c42657f79a26b\n  ", since="1.5.0", group="hash_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005}g\u0001\u0002\u0010 \u00012B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u00151\u0006\u0001\"\u0011X\u0011\u0015Y\u0006\u0001\"\u0011X\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u00159\u0007\u0001\"\u0011X\u0011\u0015A\u0007\u0001\"\u0015j\u0011\u0015\t\b\u0001\"\u0011s\u0011\u001d\t\t\u0001\u0001C)\u0003\u0007A\u0011\"!\u0004\u0001\u0003\u0003%\t!a\u0004\t\u0013\u0005U\u0001!%A\u0005\u0002\u0005]\u0001\"CA\u0017\u0001E\u0005I\u0011AA\f\u0011%\ty\u0003AA\u0001\n\u0003\n\t\u0004C\u0005\u0002D\u0001\t\t\u0011\"\u0001\u0002F!I\u0011Q\n\u0001\u0002\u0002\u0013\u0005\u0011q\n\u0005\n\u0003+\u0002\u0011\u0011!C!\u0003/B\u0011\"!\u001a\u0001\u0003\u0003%\t!a\u001a\t\u0013\u0005-\u0004!!A\u0005B\u00055\u0004\"CA9\u0001\u0005\u0005I\u0011IA:\u000f%\t9jHA\u0001\u0012\u0003\tIJ\u0002\u0005\u001f?\u0005\u0005\t\u0012AAN\u0011\u0019\t\u0006\u0004\"\u0001\u00024\"I\u0011Q\u0017\r\u0002\u0002\u0013\u0015\u0013q\u0017\u0005\n\u0003sC\u0012\u0011!CA\u0003wC\u0011\"!1\u0019\u0003\u0003%\t)a1\t\u0013\u0005U\u0007$!A\u0005\n\u0005]'\u0001B*iCJR!\u0001I\u0011\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003E\r\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003I\u0015\n1a]9m\u0015\t1s%A\u0003ta\u0006\u00148N\u0003\u0002)S\u00051\u0011\r]1dQ\u0016T\u0011AK\u0001\u0004_J<7\u0001A\n\u0007\u00015\nDGQ#\u0011\u00059zS\"A\u0010\n\u0005Az\"\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tq#'\u0003\u00024?\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u00026\u007f9\u0011a\u0007\u0010\b\u0003oij\u0011\u0001\u000f\u0006\u0003s-\na\u0001\u0010:p_Rt\u0014\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005ur\u0014a\u00029bG.\fw-\u001a\u0006\u0002w%\u0011\u0001)\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003{y\u0002\"AL\"\n\u0005\u0011{\"\u0001\t#fM\u0006,H\u000e^*ue&tw\r\u0015:pIV\u001c\u0017N\\4FqB\u0014Xm]:j_:\u0004\"AR$\u000e\u0003yJ!\u0001\u0013 \u0003\u000fA\u0013x\u000eZ;di\u0006!A.\u001a4u+\u0005Y\u0005C\u0001\u0018M\u0013\tiuD\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002T)V\u0003\"A\f\u0001\t\u000b%+\u0001\u0019A&\t\u000b=+\u0001\u0019A&\u0002\u001d9,H\u000e\\%oi>dWM]1oiV\t\u0001\f\u0005\u0002G3&\u0011!L\u0010\u0002\b\u0005>|G.Z1o\u0003!qW\u000f\u001c7bE2,\u0017AC5oaV$H+\u001f9fgV\ta\fE\u00026?\u0006L!\u0001Y!\u0003\u0007M+\u0017\u000f\u0005\u0002cK6\t1M\u0003\u0002eG\u0005)A/\u001f9fg&\u0011am\u0019\u0002\t\t\u0006$\u0018\rV=qK\u0006Q2m\u001c8uKb$\u0018J\u001c3fa\u0016tG-\u001a8u\r>dG-\u00192mK\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0019!.\\8\u0011\u0005\u0019[\u0017B\u00017?\u0005\r\te.\u001f\u0005\u0006]*\u0001\rA[\u0001\u0007S:\u0004X\u000f^\u0019\t\u000bAT\u0001\u0019\u00016\u0002\r%t\u0007/\u001e;3\u0003%!wnR3o\u0007>$W\rF\u0002tsz\u0004\"\u0001^<\u000e\u0003UT!A^\u0010\u0002\u000f\r|G-Z4f]&\u0011\u00010\u001e\u0002\t\u000bb\u0004(oQ8eK\")!p\u0003a\u0001w\u0006\u00191\r\u001e=\u0011\u0005Qd\u0018BA?v\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQa`\u0006A\u0002M\f!!\u001a<\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#B*\u0002\u0006\u0005%\u0001BBA\u0004\u0019\u0001\u00071*A\u0004oK^dUM\u001a;\t\r\u0005-A\u00021\u0001L\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$RaUA\t\u0003'Aq!S\u0007\u0011\u0002\u0003\u00071\nC\u0004P\u001bA\u0005\t\u0019A&\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0004\u0016\u0004\u0017\u0006m1FAA\u000f!\u0011\ty\"!\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001db(\u0001\u0006b]:|G/\u0019;j_:LA!a\u000b\u0002\"\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\r\u0011\t\u0005U\u0012qH\u0007\u0003\u0003oQA!!\u000f\u0002<\u0005!A.\u00198h\u0015\t\ti$\u0001\u0003kCZ\f\u0017\u0002BA!\u0003o\u0011aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA$!\r1\u0015\u0011J\u0005\u0004\u0003\u0017r$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00016\u0002R!I\u00111\u000b\n\u0002\u0002\u0003\u0007\u0011qI\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005e\u0003#BA.\u0003CRWBAA/\u0015\r\tyFP\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA2\u0003;\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019\u0001,!\u001b\t\u0011\u0005MC#!AA\u0002)\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111GA8\u0011%\t\u0019&FA\u0001\u0002\u0004\t9%\u0001\u0004fcV\fGn\u001d\u000b\u00041\u0006U\u0004\u0002CA*-\u0005\u0005\t\u0019\u00016)'\u0001\tI(a \u0002\u0002\u0006\u0015\u0015qQAF\u0003\u001b\u000b\t*a%\u0011\u00079\nY(C\u0002\u0002~}\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0004\u0006\t\u0019I\u0003\u0011!A\u0001zf)\u0016(D?\"*\u0007\u0010\u001d:-A\tLG\u000fT3oORD\u0017\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u00043\r[3dWN,X\u000eI8gAMC\u0015)\f\u001a!M\u0006l\u0017\u000e\\=!CN\u0004\u0013\r\t5fq\u0002\u001aHO]5oO\u0002zg\r\t1fqB\u0014\bM\f\u0006!A\u0001\u0002\u0003\u0005I*I\u00036\u0012$\u0007\u000e\u0017!'\"\u000bUFM\u001b7Y\u0001\u001a\u0006*Q\u00174qQb\u0003%\u00198eAMC\u0015)L\u001b2e\u0001\n'/\u001a\u0011tkB\u0004xN\u001d;fI:\u0002#)\u001b;!Y\u0016tw\r\u001e5!_\u001a\u0004\u0003\u0007I5tA\u0015\fX/\u001b<bY\u0016tG\u000f\t;pAI*dG\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002\n\u0006q(\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148n\n\u0017!eU2\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00116ee\u00127m\r21oE\u0012t'Z2co\u0015,4'\u0019\u001beG\u001a\f\u0014(O\u0019esE*$g\u0019\u001a5kM:D-O\u0019:c]B\u0004G\r\u001ace\r$$GN\u001b8M^J\u0014M\r\u001cc\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAH\u0003\u0015\td&\u000e\u00181\u0003\u00159'o\\;qC\t\t)*\u0001\u0006iCNDwLZ;oGN\fAa\u00155beA\u0011a\u0006G\n\u00061\u0005u\u0015\u0011\u0016\t\b\u0003?\u000b)kS&T\u001b\t\t\tKC\u0002\u0002$z\nqA];oi&lW-\u0003\u0003\u0002(\u0006\u0005&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u00111VAY\u001b\t\tiK\u0003\u0003\u00020\u0006m\u0012AA5p\u0013\r\u0001\u0015Q\u0016\u000b\u0003\u00033\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003g\tQ!\u00199qYf$RaUA_\u0003\u007fCQ!S\u000eA\u0002-CQaT\u000eA\u0002-\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002F\u0006E\u0007#\u0002$\u0002H\u0006-\u0017bAAe}\t1q\n\u001d;j_:\u0004RARAg\u0017.K1!a4?\u0005\u0019!V\u000f\u001d7fe!A\u00111\u001b\u000f\u0002\u0002\u0003\u00071+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!7\u0011\t\u0005U\u00121\\\u0005\u0005\u0003;\f9D\u0001\u0004PE*,7\r\u001e")
public class Sha2
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable,
DefaultStringProducingExpression {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Sha2 x$0) {
        return Sha2$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, Sha2> tupled() {
        return Sha2$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Sha2>> curried() {
        return Sha2$.MODULE$.curried();
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.children().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contextIndependentFoldable()));
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        int bitLength = BoxesRunTime.unboxToInt((Object)input2);
        byte[] input = (byte[])input1;
        int n = bitLength;
        switch (n) {
            case 224: {
                return UTF8String.fromString((String)new DigestUtils("SHA-224").digestAsHex(input));
            }
            case 0: 
            case 256: {
                return UTF8String.fromString((String)DigestUtils.sha256Hex((byte[])input));
            }
            case 384: {
                return UTF8String.fromString((String)DigestUtils.sha384Hex((byte[])input));
            }
            case 512: {
                return UTF8String.fromString((String)DigestUtils.sha512Hex((byte[])input));
            }
        }
        return null;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String digestUtils = DigestUtils.class.getName();
        String messageDigestAlgorithms = MessageDigestAlgorithms.class.getName();
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(eval1, eval2) -> "\n        if (" + eval2 + " == 224) {\n          " + ev.value() + " = UTF8String.fromString(\n                          new " + digestUtils + "(" + messageDigestAlgorithms + ".SHA_224).digestAsHex(" + eval1 + "));\n        } else if (" + eval2 + " == 256 || " + eval2 + " == 0) {\n          " + ev.value() + " =\n            UTF8String.fromString(" + digestUtils + ".sha256Hex(" + eval1 + "));\n        } else if (" + eval2 + " == 384) {\n          " + ev.value() + " =\n            UTF8String.fromString(" + digestUtils + ".sha384Hex(" + eval1 + "));\n        } else if (" + eval2 + " == 512) {\n          " + ev.value() + " =\n            UTF8String.fromString(" + digestUtils + ".sha512Hex(" + eval1 + "));\n        } else {\n          " + ev.isNull() + " = true;\n        }\n      ");
    }

    @Override
    public Sha2 withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public Sha2 copy(Expression left, Expression right) {
        return new Sha2(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Sha2";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sha2;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sha2)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sha2 sha2 = (Sha2)x$1;
        Expression expression = this.left();
        Expression expression2 = sha2.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = sha2.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sha2.canEqual(this)) return false;
        return true;
    }

    public Sha2(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        DefaultStringProducingExpression.$init$(this);
    }
}

