/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseNumeric;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hive.common.HiveCompat;

public abstract class GenericUDFBaseArithmetic
extends GenericUDFBaseBinary {
    GenericUDF arithmeticOperation;
    protected boolean confLookupNeeded = true;
    protected boolean ansiSqlArithmetic = false;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentException(this.getClass().getSimpleName() + " requires two arguments.");
        }
        if (this.confLookupNeeded) {
            HiveCompat.CompatLevel compatLevel = HiveCompat.getCompatLevel((HiveConf)SessionState.get().getConf());
            this.ansiSqlArithmetic = compatLevel.ordinal() > HiveCompat.CompatLevel.HIVE_0_12.ordinal();
            this.confLookupNeeded = false;
        }
        boolean isDateTimeOp = false;
        block3: for (int idx = 0; idx < 2; ++idx) {
            switch (((PrimitiveObjectInspector)arguments[idx]).getPrimitiveCategory()) {
                case DATE: 
                case TIMESTAMP: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_DAY_TIME: {
                    isDateTimeOp = true;
                    continue block3;
                }
            }
        }
        if (isDateTimeOp) {
            this.arithmeticOperation = this.instantiateDTIUDF();
        } else {
            GenericUDFBaseNumeric numericUDF = this.instantiateNumericUDF();
            numericUDF.setAnsiSqlArithmetic(this.ansiSqlArithmetic);
            numericUDF.setConfLookupNeeded(this.confLookupNeeded);
            this.arithmeticOperation = numericUDF;
        }
        return this.arithmeticOperation.initialize(arguments);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        return this.arithmeticOperation.evaluate(arguments);
    }

    @Override
    public void copyToNewInstance(Object newInstance) throws UDFArgumentException {
        super.copyToNewInstance(newInstance);
        GenericUDFBaseArithmetic other = (GenericUDFBaseArithmetic)newInstance;
        other.confLookupNeeded = this.confLookupNeeded;
        other.ansiSqlArithmetic = this.ansiSqlArithmetic;
    }

    protected abstract GenericUDFBaseNumeric instantiateNumericUDF();

    protected abstract GenericUDF instantiateDTIUDF();
}

