/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCDatabaseMetadata$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRDD;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Using;
import scala.util.Using$;

public final class JDBCRDD$
implements Logging,
Serializable {
    public static final JDBCRDD$ MODULE$ = new JDBCRDD$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StructType resolveTable(JDBCOptions options, Connection conn) {
        StructType structType;
        String url = options.url();
        String prepareQuery2 = options.prepareQuery();
        String table = options.tableOrQuery();
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        String fullQuery = prepareQuery2 + dialect.getSchemaQuery(table);
        try {
            structType = this.getQueryOutputSchema(fullQuery, options, dialect, conn);
        }
        catch (Throwable throwable) {
            SQLException sQLException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SQLException && dialect.isSyntaxErrorBestEffort(sQLException = (SQLException)throwable2)) {
                throw new SparkException("JDBC_EXTERNAL_ENGINE_SYNTAX_ERROR.DURING_OUTPUT_SCHEMA_RESOLUTION", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbcQuery"), (Object)fullQuery)})), (Throwable)sQLException);
            }
            throw throwable;
        }
        return structType;
    }

    public StructType resolveTable(JDBCOptions options) {
        return (StructType)JdbcUtils$.MODULE$.withConnection(options, (Function1 & Serializable)x$1 -> MODULE$.resolveTable(options, (Connection)x$1));
    }

    public StructType getQueryOutputSchema(String query, JDBCOptions options, JdbcDialect dialect, Connection conn) {
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Generated JDBC query to get scan output schema: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.SQL_TEXT, query)}))));
        return (StructType)Using$.MODULE$.resource((Object)conn.prepareStatement(query), (Function1 & Serializable)statement -> {
            statement.setQueryTimeout(options.queryTimeout());
            return (StructType)Using$.MODULE$.resource((Object)statement.executeQuery(), (Function1 & Serializable)rs -> JdbcUtils$.MODULE$.getSchema(conn, (ResultSet)rs, dialect, true, options.preferTimestampNTZ()), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public StructType getQueryOutputSchema(String query, JDBCOptions options, JdbcDialect dialect) {
        return (StructType)JdbcUtils$.MODULE$.withConnection(options, (Function1 & Serializable)x$2 -> MODULE$.getQueryOutputSchema(query, options, dialect, (Connection)x$2));
    }

    private StructType pruneSchema(StructType schema, String[] columns) {
        scala.collection.immutable.Map fieldMap = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x.name()), x), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return new StructType((StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)name -> (StructField)fieldMap.apply(name), ClassTag$.MODULE$.apply(StructField.class)));
    }

    public RDD<InternalRow> scanTable(SparkContext sc, StructType schema, String[] requiredColumns, Predicate[] predicates, Partition[] parts, JDBCOptions options, Option<StructType> outputSchema, Option<String[]> groupByColumns, Option<TableSampleInfo> sample, int limit, String[] sortOrders, int offset, scala.collection.immutable.Map<String, SQLMetric> additionalMetrics) {
        String url = options.url();
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        String[] quotedColumns = groupByColumns.isEmpty() ? (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])requiredColumns), (Function1 & Serializable)colName -> dialect.quoteIdentifier((String)colName), ClassTag$.MODULE$.apply(String.class)) : requiredColumns;
        Function1<Object, Connection> connectionFactory = dialect.createConnectionFactory(options);
        return new JDBCRDD(sc, connectionFactory, (StructType)outputSchema.getOrElse((Function0 & Serializable)() -> MODULE$.pruneSchema(schema, requiredColumns)), quotedColumns, predicates, parts, url, options, JDBCDatabaseMetadata$.MODULE$.fromJDBCConnectionFactory(connectionFactory), groupByColumns, sample, limit, sortOrders, offset, additionalMetrics);
    }

    public Option<StructType> scanTable$default$7() {
        return None$.MODULE$;
    }

    public Option<String[]> scanTable$default$8() {
        return None$.MODULE$;
    }

    public Option<TableSampleInfo> scanTable$default$9() {
        return None$.MODULE$;
    }

    public int scanTable$default$10() {
        return 0;
    }

    public String[] scanTable$default$11() {
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    public int scanTable$default$12() {
        return 0;
    }

    public scala.collection.immutable.Map<String, SQLMetric> scanTable$default$13() {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JDBCRDD$.class);
    }

    private JDBCRDD$() {
    }
}

