/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.spark.network.protocol.AbstractMessage;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.RequestMessage;

public class MergedBlockMetaRequest
extends AbstractMessage
implements RequestMessage {
    public final long requestId;
    public final String appId;
    public final int shuffleId;
    public final int shuffleMergeId;
    public final int reduceId;

    public MergedBlockMetaRequest(long requestId, String appId, int shuffleId, int shuffleMergeId, int reduceId) {
        super(null, false);
        this.requestId = requestId;
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.shuffleMergeId = shuffleMergeId;
        this.reduceId = reduceId;
    }

    @Override
    public Message.Type type() {
        return Message.Type.MergedBlockMetaRequest;
    }

    @Override
    public int encodedLength() {
        return 8 + Encoders.Strings.encodedLength(this.appId) + 4 + 4 + 4;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.requestId);
        Encoders.Strings.encode(buf, this.appId);
        buf.writeInt(this.shuffleId);
        buf.writeInt(this.shuffleMergeId);
        buf.writeInt(this.reduceId);
    }

    public static MergedBlockMetaRequest decode(ByteBuf buf) {
        long requestId = buf.readLong();
        String appId = Encoders.Strings.decode(buf);
        int shuffleId = buf.readInt();
        int shuffleMergeId = buf.readInt();
        int reduceId = buf.readInt();
        return new MergedBlockMetaRequest(requestId, appId, shuffleId, shuffleMergeId, reduceId);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.appId, this.shuffleId, this.shuffleMergeId, this.reduceId);
    }

    public boolean equals(Object other) {
        if (other instanceof MergedBlockMetaRequest) {
            MergedBlockMetaRequest o = (MergedBlockMetaRequest)other;
            return this.requestId == o.requestId && this.shuffleId == o.shuffleId && this.shuffleMergeId == o.shuffleMergeId && this.reduceId == o.reduceId && Objects.equals(this.appId, o.appId);
        }
        return false;
    }

    public String toString() {
        return "MergedBlockMetaRequest[requestId=" + this.requestId + ",appId=" + this.appId + ",shuffleId=" + this.shuffleId + ",shuffleMergeId=" + this.shuffleMergeId + ",reduceId=" + this.reduceId + "]";
    }
}

