/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import java.io.Serializable;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.DenseVector$;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.SparseVector$;
import org.apache.spark.ml.linalg.Vector;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Vectors$ {
    public static final Vectors$ MODULE$ = new Vectors$();
    private static final DenseVector empty = new DenseVector(Array$.MODULE$.emptyDoubleArray());
    private static final int MAX_HASH_NNZ = 128;

    public Vector dense(double firstValue, double ... otherValues) {
        return this.dense(firstValue, (Seq<Object>)ScalaRunTime$.MODULE$.wrapDoubleArray(otherValues));
    }

    public DenseVector empty() {
        return empty;
    }

    public Vector dense(double firstValue, Seq<Object> otherValues) {
        double d = firstValue;
        return new DenseVector((double[])((IterableOnceOps)otherValues.$plus$colon((Object)BoxesRunTime.boxToDouble((double)d))).toArray((ClassTag)ClassTag$.MODULE$.Double()));
    }

    public Vector dense(double[] values) {
        return new DenseVector(values);
    }

    public Vector sparse(int size, int[] indices, double[] values) {
        return new SparseVector(size, indices, values);
    }

    public Vector sparse(int size, Seq<Tuple2<Object, Object>> elements) {
        Tuple2 tuple2 = ((IterableOps)elements.sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq indices = (Seq)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indices, (Object)values);
        Seq indices2 = (Seq)tuple22._1();
        Seq values2 = (Seq)tuple22._2();
        return new SparseVector(size, (int[])indices2.toArray((ClassTag)ClassTag$.MODULE$.Int()), (double[])values2.toArray((ClassTag)ClassTag$.MODULE$.Double()));
    }

    public Vector sparse(int size, Iterable<Tuple2<Integer, Double>> elements) {
        return this.sparse(size, (Seq<Tuple2<Object, Object>>)((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(elements).asScala().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Integer i = (Integer)tuple2._1();
                Double x = (Double)tuple2._2();
                return new Tuple2.mcID.sp(i.intValue(), x.doubleValue());
            }
            throw new MatchError((Object)tuple2);
        })).toSeq());
    }

    public Vector zeros(int size) {
        return new DenseVector(new double[size]);
    }

    public Vector fromBreeze(breeze.linalg.Vector<Object> breezeVector) {
        breeze.linalg.Vector<Object> vector = breezeVector;
        if (vector instanceof breeze.linalg.DenseVector) {
            breeze.linalg.DenseVector denseVector = (breeze.linalg.DenseVector)vector;
            if (denseVector.offset() == 0 && denseVector.stride() == 1 && denseVector.length() == denseVector.data$mcD$sp().length) {
                return new DenseVector(denseVector.data$mcD$sp());
            }
            return new DenseVector(denseVector.toArray$mcD$sp((ClassTag)ClassTag$.MODULE$.Double()));
        }
        if (vector instanceof breeze.linalg.SparseVector) {
            breeze.linalg.SparseVector sparseVector = (breeze.linalg.SparseVector)vector;
            if (sparseVector.index().length == sparseVector.used()) {
                return new SparseVector(sparseVector.length(), sparseVector.index(), sparseVector.data$mcD$sp());
            }
            return new SparseVector(sparseVector.length(), (int[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.intArrayOps(sparseVector.index()), 0, sparseVector.used()), (double[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.doubleArrayOps(sparseVector.data$mcD$sp()), 0, sparseVector.used()));
        }
        if (vector != null) {
            breeze.linalg.Vector<Object> vector2 = vector;
            throw scala.sys.package$.MODULE$.error("Unsupported Breeze vector type: " + vector2.getClass().getName());
        }
        throw new MatchError(vector);
    }

    public double norm(Vector vector, double p) {
        SparseVector sparseVector;
        Option<Tuple3<Object, int[], double[]>> option;
        double[] dArray;
        DenseVector denseVector;
        Option<double[]> option2;
        Predef$.MODULE$.require(p >= 1.0, (Function0 & Serializable)() -> "To compute the p-norm of the vector, we require that you specify a p>=1. You specified p=" + p + ".");
        Vector vector2 = vector;
        if (vector2 instanceof DenseVector && !(option2 = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector2)).isEmpty()) {
            double[] vs;
            dArray = vs = (double[])option2.get();
        } else if (vector2 instanceof SparseVector && !(option = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector2)).isEmpty()) {
            double[] vs;
            dArray = vs = (double[])((Tuple3)option.get())._3();
        } else {
            throw new IllegalArgumentException("Do not support vector type " + vector2.getClass());
        }
        double[] values = dArray;
        int size = values.length;
        if (p == 1.0) {
            double sum = 0.0;
            for (int i = 0; i < size; ++i) {
                sum += package$.MODULE$.abs(values[i]);
            }
            return sum;
        }
        if (p == (double)2) {
            double sum = 0.0;
            for (int i = 0; i < size; ++i) {
                sum += values[i] * values[i];
            }
            return package$.MODULE$.sqrt(sum);
        }
        if (p == Double.POSITIVE_INFINITY) {
            double max = 0.0;
            for (int i = 0; i < size; ++i) {
                double value = package$.MODULE$.abs(values[i]);
                if (!(value > max)) continue;
                max = value;
            }
            return max;
        }
        double sum = 0.0;
        for (int i = 0; i < size; ++i) {
            sum += package$.MODULE$.pow(package$.MODULE$.abs(values[i]), p);
        }
        return package$.MODULE$.pow(sum, 1.0 / p);
    }

    public Vector normalize(Vector vector, double p) {
        double n = this.norm(vector, p);
        Predef$.MODULE$.require(n > 0.0, (Function0 & Serializable)() -> "Can not normalize zero-length vectors.");
        BLAS$.MODULE$.scal(1.0 / n, vector);
        return vector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double sqdist(Vector v1, Vector v2) {
        Predef$.MODULE$.require(v1.size() == v2.size(), (Function0 & Serializable)() -> "Vector dimensions do not match: Dim(v1)=" + v1.size() + " and Dim(v2)=" + v2.size() + ".");
        double squaredDistance = 0.0;
        Tuple2 tuple2 = new Tuple2((Object)v1, (Object)v2);
        if (tuple2 != null) {
            Vector v12 = (Vector)tuple2._1();
            Vector v22 = (Vector)tuple2._2();
            if (v12 instanceof SparseVector) {
                SparseVector sparseVector = (SparseVector)v12;
                if (v22 instanceof SparseVector) {
                    SparseVector sparseVector2 = (SparseVector)v22;
                    double[] v1Values = sparseVector.values();
                    int[] v1Indices = sparseVector.indices();
                    double[] v2Values = sparseVector2.values();
                    int[] v2Indices = sparseVector2.indices();
                    int nnzv1 = v1Indices.length;
                    int nnzv2 = v2Indices.length;
                    int kv1 = 0;
                    int kv2 = 0;
                    while (true) {
                        if (kv1 >= nnzv1) {
                            if (kv2 >= nnzv2) return squaredDistance;
                        }
                        double score = 0.0;
                        if (kv2 >= nnzv2 || kv1 < nnzv1 && v1Indices[kv1] < v2Indices[kv2]) {
                            score = v1Values[kv1];
                            ++kv1;
                        } else if (kv1 >= nnzv1 || kv2 < nnzv2 && v2Indices[kv2] < v1Indices[kv1]) {
                            score = v2Values[kv2];
                            ++kv2;
                        } else {
                            score = v1Values[kv1] - v2Values[kv2];
                            ++kv1;
                            ++kv2;
                        }
                        squaredDistance += score * score;
                    }
                }
            }
        }
        if (tuple2 != null) {
            Vector v13 = (Vector)tuple2._1();
            Vector v23 = (Vector)tuple2._2();
            if (v13 instanceof SparseVector) {
                SparseVector sparseVector = (SparseVector)v13;
                if (v23 instanceof DenseVector) {
                    DenseVector denseVector = (DenseVector)v23;
                    return this.sqdist(sparseVector, denseVector);
                }
            }
        }
        if (tuple2 != null) {
            Vector v14 = (Vector)tuple2._1();
            Vector v24 = (Vector)tuple2._2();
            if (v14 instanceof DenseVector) {
                DenseVector denseVector = (DenseVector)v14;
                if (v24 instanceof SparseVector) {
                    SparseVector sparseVector = (SparseVector)v24;
                    return this.sqdist(sparseVector, denseVector);
                }
            }
        }
        if (tuple2 == null) throw new IllegalArgumentException("Do not support vector type " + v1.getClass() + " and " + v2.getClass());
        Vector vector = (Vector)tuple2._1();
        Vector vector2 = (Vector)tuple2._2();
        if (!(vector instanceof DenseVector)) throw new IllegalArgumentException("Do not support vector type " + v1.getClass() + " and " + v2.getClass());
        DenseVector denseVector = (DenseVector)vector;
        Option<double[]> option = DenseVector$.MODULE$.unapply(denseVector);
        if (option.isEmpty()) throw new IllegalArgumentException("Do not support vector type " + v1.getClass() + " and " + v2.getClass());
        double[] vv1 = (double[])option.get();
        if (!(vector2 instanceof DenseVector)) throw new IllegalArgumentException("Do not support vector type " + v1.getClass() + " and " + v2.getClass());
        DenseVector denseVector2 = (DenseVector)vector2;
        Option<double[]> option2 = DenseVector$.MODULE$.unapply(denseVector2);
        if (option2.isEmpty()) throw new IllegalArgumentException("Do not support vector type " + v1.getClass() + " and " + v2.getClass());
        double[] vv2 = (double[])option2.get();
        int kv = 0;
        int sz = vv1.length;
        while (kv < sz) {
            double score = vv1[kv] - vv2[kv];
            squaredDistance += score * score;
            ++kv;
        }
        return squaredDistance;
    }

    public double sqdist(SparseVector v1, DenseVector v2) {
        int iv1;
        int kv1 = 0;
        int[] indices = v1.indices();
        double squaredDistance = 0.0;
        int nnzv1 = indices.length;
        int nnzv2 = v2.size();
        int n = iv1 = nnzv1 > 0 ? indices[kv1] : -1;
        for (int kv2 = 0; kv2 < nnzv2; ++kv2) {
            double score = 0.0;
            if (kv2 != iv1) {
                score = v2.apply(kv2);
            } else {
                score = v1.values()[kv1] - v2.apply(kv2);
                if (kv1 < nnzv1 - 1) {
                    iv1 = indices[++kv1];
                }
            }
            squaredDistance += score * score;
        }
        return squaredDistance;
    }

    public boolean equals(IndexedSeq<Object> v1Indices, double[] v1Values, IndexedSeq<Object> v2Indices, double[] v2Values) {
        int v1Size = v1Values.length;
        int v2Size = v2Values.length;
        int k1 = 0;
        int k2 = 0;
        boolean allEqual = true;
        while (allEqual) {
            while (k1 < v1Size && v1Values[k1] == 0.0) {
                ++k1;
            }
            while (k2 < v2Size && v2Values[k2] == 0.0) {
                ++k2;
            }
            if (k1 >= v1Size || k2 >= v2Size) {
                return k1 >= v1Size && k2 >= v2Size;
            }
            allEqual = BoxesRunTime.unboxToInt((Object)v1Indices.apply(k1)) == BoxesRunTime.unboxToInt((Object)v2Indices.apply(k2)) && v1Values[k1] == v2Values[k2];
            ++k1;
            ++k2;
        }
        return allEqual;
    }

    public int MAX_HASH_NNZ() {
        return MAX_HASH_NNZ;
    }

    public long getSparseSize(long nnz) {
        int doubleBytes = 8;
        int intBytes = 4;
        long arrayHeader = 12L;
        return (long)(doubleBytes + intBytes) * nnz + arrayHeader * 2L + 4L;
    }

    public long getDenseSize(long size) {
        int doubleBytes = 8;
        long arrayHeader = 12L;
        return (long)doubleBytes * size + arrayHeader;
    }

    private Vectors$() {
    }
}

