/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.vertx;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.StandardHttpClientBuilder;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.vertx.VertxHttpClient;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.spi.tls.SslContextFactory;
import io.vertx.ext.web.client.WebClientOptions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

public class VertxHttpClientBuilder<F extends HttpClient.Factory>
extends StandardHttpClientBuilder<VertxHttpClient<F>, F, VertxHttpClientBuilder<F>> {
    private static final int MAX_CONNECTIONS = 8192;
    private static final int MAX_WS_MESSAGE_SIZE = Integer.MAX_VALUE;
    final Vertx vertx;
    private final boolean closeVertx;

    public VertxHttpClientBuilder(F clientFactory, Vertx sharedVertx) {
        this(clientFactory, sharedVertx != null ? sharedVertx : VertxHttpClientBuilder.createVertxInstance(), sharedVertx == null);
    }

    VertxHttpClientBuilder(F clientFactory, Vertx vertx, boolean closeVertx) {
        super(clientFactory);
        this.vertx = vertx;
        this.closeVertx = closeVertx;
    }

    public VertxHttpClient<F> build() {
        String[] protocols;
        if (this.client != null) {
            return new VertxHttpClient(this, ((VertxHttpClient)this.client).getClosed(), ((VertxHttpClient)this.client).getClient(), this.closeVertx);
        }
        WebClientOptions options = new WebClientOptions();
        options.setMaxPoolSize(8192);
        options.setMaxWebSockets(8192);
        options.setIdleTimeoutUnit(TimeUnit.SECONDS);
        options.setMaxWebSocketFrameSize(Integer.MAX_VALUE);
        options.setMaxWebSocketMessageSize(Integer.MAX_VALUE);
        if (this.connectTimeout != null) {
            options.setConnectTimeout((int)this.connectTimeout.toMillis());
        }
        if (this.followRedirects) {
            options.setFollowRedirects(this.followRedirects);
        }
        if (this.proxyType != HttpClient.ProxyType.DIRECT && this.proxyAddress != null) {
            ProxyOptions proxyOptions = new ProxyOptions().setHost(this.proxyAddress.getHostName()).setPort(this.proxyAddress.getPort()).setType(this.convertProxyType());
            String[] userPassword = HttpClientUtils.decodeBasicCredentials((String)this.proxyAuthorization);
            if (userPassword != null) {
                proxyOptions.setUsername(userPassword[0]);
                proxyOptions.setPassword(userPassword[1]);
            } else {
                this.addProxyAuthInterceptor();
            }
            options.setProxyOptions(proxyOptions);
        }
        if (this.tlsVersions != null && this.tlsVersions.length > 0) {
            protocols = (String[])Stream.of(this.tlsVersions).map(TlsVersion::javaName).toArray(String[]::new);
            options.setEnabledSecureTransportProtocols(new HashSet<String>(Arrays.asList(protocols)));
        } else {
            protocols = null;
        }
        if (this.preferHttp11) {
            options.setProtocolVersion(HttpVersion.HTTP_1_1);
        }
        if (this.sslContext != null) {
            options.setSsl(true);
            options.setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions(){

                public JdkSSLEngineOptions copy() {
                    return this;
                }

                public SslContextFactory sslContextFactory() {
                    return () -> new JdkSslContext(VertxHttpClientBuilder.this.sslContext, true, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, ApplicationProtocolConfig.DISABLED, ClientAuth.NONE, protocols, false);
                }
            });
        }
        return new VertxHttpClient(this, new AtomicBoolean(), this.vertx.createHttpClient((HttpClientOptions)options), this.closeVertx);
    }

    protected VertxHttpClientBuilder<F> newInstance(F clientFactory) {
        return new VertxHttpClientBuilder<F>(clientFactory, this.vertx, this.closeVertx);
    }

    private ProxyType convertProxyType() {
        switch (this.proxyType) {
            case HTTP: {
                return ProxyType.HTTP;
            }
            case SOCKS4: {
                return ProxyType.SOCKS4;
            }
            case SOCKS5: {
                return ProxyType.SOCKS5;
            }
        }
        throw new KubernetesClientException("Unsupported proxy type");
    }

    private static Vertx createVertxInstance() {
        Vertx vertx;
        String originalValue = System.getProperty("vertx.disableDnsResolver");
        try {
            System.setProperty("vertx.disableDnsResolver", "true");
            vertx = Vertx.vertx((VertxOptions)new VertxOptions().setFileSystemOptions(new FileSystemOptions().setFileCachingEnabled(false).setClassPathResolvingEnabled(false)).setUseDaemonThread(Boolean.valueOf(true)));
        }
        finally {
            if (originalValue == null) {
                System.clearProperty("vertx.disableDnsResolver");
            } else {
                System.setProperty("vertx.disableDnsResolver", originalValue);
            }
        }
        return vertx;
    }
}

