/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.exchange;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.plans.physical.ClusteredDistribution;
import org.apache.spark.sql.catalyst.plans.physical.Distribution;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.catalyst.plans.physical.ShuffleSpec;
import org.apache.spark.sql.execution.SparkPlan;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ValidateRequirements$
implements Logging {
    public static final ValidateRequirements$ MODULE$ = new ValidateRequirements$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean validate(SparkPlan plan, Distribution requiredDistribution) {
        return this.validate(plan) && plan.outputPartitioning().satisfies(requiredDistribution);
    }

    public boolean validate(SparkPlan plan2) {
        return plan2.children().forall((Function1 & Serializable)plan -> BoxesRunTime.boxToBoolean((boolean)ValidateRequirements$.MODULE$.validate(plan))) && this.validateInternal(plan2);
    }

    private boolean validateInternal(SparkPlan plan) {
        Seq children = plan.children();
        Seq<Distribution> requiredChildDistributions = plan.requiredChildDistribution();
        Seq<Seq<SortOrder>> requiredChildOrderings = plan.requiredChildOrdering();
        Predef$.MODULE$.assert(requiredChildDistributions.length() == children.length());
        Predef$.MODULE$.assert(requiredChildOrderings.length() == children.length());
        boolean satisfied = ((IterableOnceOps)children.zip((IterableOnce)requiredChildDistributions.zip(requiredChildOrderings))).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ValidateRequirements$.$anonfun$validateInternal$1(plan, x0$1)));
        if (satisfied && children.length() > 1 && requiredChildDistributions.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ValidateRequirements$.$anonfun$validateInternal$3(x$1)))) {
            Seq specs = (Seq)((IterableOps)((IterableOps)children.map((Function1 & Serializable)x$2 -> x$2.outputPartitioning())).zip(requiredChildDistributions)).map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    Partitioning p = (Partitioning)tuple2._1();
                    Distribution d = (Distribution)tuple2._2();
                    return p.createShuffleSpec((ClusteredDistribution)d);
                }
                throw new MatchError((Object)tuple2);
            });
            if (((IterableOnceOps)specs.tail()).forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isCompatibleWith((ShuffleSpec)specs.head())))) {
                return true;
            }
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "ValidateRequirements failed: children not co-partitioned in\n" + plan);
            return false;
        }
        return satisfied;
    }

    public static final /* synthetic */ boolean $anonfun$validateInternal$1(SparkPlan plan$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            SparkPlan child = (SparkPlan)tuple2._1();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                Distribution distribution = (Distribution)tuple22._1();
                Seq ordering2 = (Seq)tuple22._2();
                if (!child.outputPartitioning().satisfies(distribution) || !SortOrder$.MODULE$.orderingSatisfies(child.outputOrdering(), ordering2)) {
                    MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "ValidateRequirements failed: " + distribution + ", " + ordering2 + "\n" + plan$1);
                    return false;
                }
            }
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$validateInternal$3(Distribution x$1) {
        return x$1 instanceof ClusteredDistribution;
    }

    private ValidateRequirements$() {
    }
}

