/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import java.util.HashSet;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.analysis.resolver.AggregateResolutionResult;
import org.apache.spark.sql.catalyst.analysis.resolver.AggregateWithLcaResolutionResult;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.LateralColumnAliasResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.NameScope;
import org.apache.spark.sql.catalyst.analysis.resolver.NameScopeStack;
import org.apache.spark.sql.catalyst.analysis.resolver.OrdinalReplacementGroupingExpressions;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolvedAggregateExpressions;
import org.apache.spark.sql.catalyst.analysis.resolver.Resolver;
import org.apache.spark.sql.catalyst.analysis.resolver.TreeNodeResolver;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\ra\u0001\u0002\u0007\u000e\u0001qA\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005{!)\u0001\t\u0001C\u0001\u0003\"9Q\t\u0001b\u0001\n\u00131\u0005B\u0002&\u0001A\u0003%q\tC\u0004L\u0001\t\u0007I\u0011\u0002'\t\rA\u0003\u0001\u0015!\u0003N\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u0015)\u0006\u0001\"\u0003W\u0011\u0015i\u0007\u0001\"\u0003o\u0011\u0015\u0019\b\u0001\"\u0003u\u0005E\tum\u001a:fO\u0006$XMU3t_24XM\u001d\u0006\u0003\u001d=\t\u0001B]3t_24XM\u001d\u0006\u0003!E\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003%M\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003)U\t1a]9m\u0015\t1r#A\u0003ta\u0006\u00148N\u0003\u0002\u00193\u00051\u0011\r]1dQ\u0016T\u0011AG\u0001\u0004_J<7\u0001A\n\u0005\u0001u\u0019#\u0007\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VM\u001a\t\u0005I\u0015:s&D\u0001\u000e\u0013\t1SB\u0001\tUe\u0016,gj\u001c3f%\u0016\u001cx\u000e\u001c<feB\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\bY><\u0017nY1m\u0015\ta\u0013#A\u0003qY\u0006t7/\u0003\u0002/S\tI\u0011iZ4sK\u001e\fG/\u001a\t\u0003QAJ!!M\u0015\u0003\u00171{w-[2bYBc\u0017M\u001c\t\u0003gYj\u0011\u0001\u000e\u0006\u0003kE\t1\"\u001a=qe\u0016\u001c8/[8og&\u0011q\u0007\u000e\u0002\f\u00032L\u0017m\u001d%fYB,'/\u0001\tpa\u0016\u0014\u0018\r^8s%\u0016\u001cx\u000e\u001c<feB\u0011AEO\u0005\u0003w5\u0011\u0001BU3t_24XM]\u0001\u0013Kb\u0004(/Z:tS>t'+Z:pYZ,'\u000f\u0005\u0002%}%\u0011q(\u0004\u0002\u0013\u000bb\u0004(/Z:tS>t'+Z:pYZ,'/\u0001\u0004=S:LGO\u0010\u000b\u0004\u0005\u000e#\u0005C\u0001\u0013\u0001\u0011\u0015A4\u00011\u0001:\u0011\u0015a4\u00011\u0001>\u0003\u0019\u00198m\u001c9fgV\tq\t\u0005\u0002%\u0011&\u0011\u0011*\u0004\u0002\u000f\u001d\u0006lWmU2pa\u0016\u001cF/Y2l\u0003\u001d\u00198m\u001c9fg\u0002\n1\u0002\\2b%\u0016\u001cx\u000e\u001c<feV\tQ\n\u0005\u0002%\u001d&\u0011q*\u0004\u0002\u001b\u0019\u0006$XM]1m\u0007>dW/\u001c8BY&\f7OU3t_24XM]\u0001\rY\u000e\f'+Z:pYZ,'\u000fI\u0001\be\u0016\u001cx\u000e\u001c<f)\ty3\u000bC\u0003U\u0011\u0001\u0007q%A\nv]J,7o\u001c7wK\u0012\fum\u001a:fO\u0006$X-\u0001\u000buef\u0014Vm]8mm\u0016<%o\\;q\u0005f\fE\u000e\u001c\u000b\u0004/\u001a\\\u0007c\u0001-aG:\u0011\u0011L\u0018\b\u00035vk\u0011a\u0017\u0006\u00039n\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0011\n\u0005}{\u0012a\u00029bG.\fw-Z\u0005\u0003C\n\u00141aU3r\u0015\tyv\u0004\u0005\u00024I&\u0011Q\r\u000e\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\"B4\n\u0001\u0004A\u0017\u0001F1hOJ,w-\u0019;f\u000bb\u0004(/Z:tS>t7\u000f\u0005\u0002%S&\u0011!.\u0004\u0002\u001d%\u0016\u001cx\u000e\u001c<fI\u0006;wM]3hCR,W\t\u001f9sKN\u001c\u0018n\u001c8t\u0011\u0015a\u0017\u00021\u0001(\u0003%\twm\u001a:fO\u0006$X-A\u0007dC:<%o\\;q\u0005f\fE\u000e\u001c\u000b\u0003_J\u0004\"A\b9\n\u0005E|\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006k)\u0001\raV\u0001\u0018O\u0016$xI]8va&tw-\u0011;ue&\u0014W\u000f^3JIN$2!^A\u0001!\r180`\u0007\u0002o*\u0011\u00010_\u0001\u0005kRLGNC\u0001{\u0003\u0011Q\u0017M^1\n\u0005q<(a\u0002%bg\"\u001cV\r\u001e\t\u0003gyL!a \u001b\u0003\r\u0015C\bO]%e\u0011\u0015a7\u00021\u0001(\u0001")
public class AggregateResolver
implements TreeNodeResolver<Aggregate, LogicalPlan>,
AliasHelper {
    private final Resolver operatorResolver;
    private final ExpressionResolver expressionResolver;
    private final NameScopeStack scopes;
    private final LateralColumnAliasResolver lcaResolver;

    @Override
    public AttributeMap<Alias> getAliasMap(Project plan2) {
        return AliasHelper.getAliasMap$((AliasHelper)this, plan2);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Aggregate plan2) {
        return AliasHelper.getAliasMap$((AliasHelper)this, plan2);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Iterable<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    @Override
    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$(this, expr, aliasMap);
    }

    @Override
    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$(this, expr, aliasMap);
    }

    @Override
    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$(this, e);
    }

    @Override
    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$(this, e);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    private NameScopeStack scopes() {
        return this.scopes;
    }

    private LateralColumnAliasResolver lcaResolver() {
        return this.lcaResolver;
    }

    @Override
    public LogicalPlan resolve(Aggregate unresolvedAggregate) {
        AggregateResolutionResult aggregateResolutionResult;
        this.scopes().pushScope(this.scopes().pushScope$default$1());
        try {
            LogicalPlan resolvedChild = this.operatorResolver.resolve(unresolvedAggregate.child());
            this.scopes().current().availableAliases().clear();
            ResolvedAggregateExpressions resolvedAggregateExpressions = this.expressionResolver.resolveAggregateExpressions(unresolvedAggregate.aggregateExpressions(), unresolvedAggregate);
            this.scopes().current().setOrdinalReplacementExpressions(new OrdinalReplacementGroupingExpressions((IndexedSeq<NamedExpression>)resolvedAggregateExpressions.expressions().toIndexedSeq(), resolvedAggregateExpressions.hasStar(), resolvedAggregateExpressions.expressionIndexesWithAggregateFunctions()));
            Seq<Expression> resolvedGroupingExpressions = this.canGroupByAll(unresolvedAggregate.groupingExpressions()) ? this.tryResolveGroupByAll(resolvedAggregateExpressions, unresolvedAggregate) : this.expressionResolver.resolveGroupingExpressions(unresolvedAggregate.groupingExpressions(), unresolvedAggregate);
            Seq resolvedGroupingExpressionsWithoutAliases = (Seq)resolvedGroupingExpressions.map((Function1 & Serializable)e -> this.trimAliases((Expression)e));
            Seq resolvedAggregateExpressionsWithoutAliases = (Seq)resolvedAggregateExpressions.expressions().map((Function1 & Serializable)e -> (NamedExpression)((Object)this.trimNonTopLevelAliases((Expression)((Object)e))));
            Aggregate resolvedAggregate = unresolvedAggregate.copy((Seq<Expression>)resolvedGroupingExpressionsWithoutAliases, (Seq<NamedExpression>)resolvedAggregateExpressionsWithoutAliases, resolvedChild, unresolvedAggregate.copy$default$4());
            if (resolvedAggregateExpressions.hasLateralColumnAlias()) {
                AggregateWithLcaResolutionResult aggregateWithLcaResolutionResult = this.lcaResolver().handleLcaInAggregate(resolvedAggregate);
                aggregateResolutionResult = new AggregateResolutionResult(aggregateWithLcaResolutionResult.resolvedOperator(), aggregateWithLcaResolutionResult.outputList(), this.getGroupingAttributeIds(aggregateWithLcaResolutionResult.baseAggregate()), aggregateWithLcaResolutionResult.aggregateListAliases(), aggregateWithLcaResolutionResult.baseAggregate());
            } else {
                ExprUtils$.MODULE$.assertValidAggregation(resolvedAggregate);
                aggregateResolutionResult = new AggregateResolutionResult(resolvedAggregate, resolvedAggregate.aggregateExpressions(), this.getGroupingAttributeIds(resolvedAggregate), this.scopes().current().getTopAggregateExpressionAliases(), resolvedAggregate);
            }
        }
        finally {
            this.scopes().popScope();
        }
        AggregateResolutionResult resolvedAggregate = aggregateResolutionResult;
        this.scopes().overwriteOutputAndExtendHiddenOutput((Seq<Attribute>)((Seq)resolvedAggregate.outputList().map((Function1 & Serializable)x$1 -> x$1.toAttribute())), (Option<HashSet<ExprId>>)new Some(resolvedAggregate.groupingAttributeIds()), resolvedAggregate.aggregateListAliases(), (Option<Aggregate>)new Some((Object)resolvedAggregate.baseAggregate()));
        return resolvedAggregate.operator();
    }

    private Seq<Expression> tryResolveGroupByAll(ResolvedAggregateExpressions aggregateExpressions, Aggregate aggregate) {
        if (aggregateExpressions.resolvedExpressionsWithoutAggregates().isEmpty() && aggregateExpressions.hasAttributeOutsideOfAggregateExpressions()) {
            throw package$.MODULE$.AnalysisErrorAt(aggregate).failAnalysis("UNRESOLVED_ALL_IN_GROUP_BY", (Map<String, String>)Predef$.MODULE$.Map().empty());
        }
        return (Seq)aggregateExpressions.resolvedExpressionsWithoutAggregates().map((Function1 & Serializable)x0$1 -> {
            NamedExpression namedExpression = x0$1;
            if (namedExpression instanceof Alias) {
                Alias alias = (Alias)namedExpression;
                return alias.child();
            }
            return (Expression)((Object)namedExpression);
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canGroupByAll(Seq<Expression> expressions) {
        boolean x$6;
        boolean x$5;
        boolean x$4;
        Seq<Expression> seq = expressions;
        if (seq == null) return false;
        SeqOps seqOps = scala.package$.MODULE$.Seq().unapplySeq(seq);
        if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return false;
        if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return false;
        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) != 0) return false;
        Expression unresolvedAttribute = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        if (!(unresolvedAttribute instanceof UnresolvedAttribute)) return false;
        UnresolvedAttribute unresolvedAttribute2 = (UnresolvedAttribute)unresolvedAttribute;
        boolean bl = unresolvedAttribute2.equalsIgnoreCase("ALL");
        boolean isOrderByAll = bl;
        if (!isOrderByAll) return false;
        NameScope qual$1 = this.scopes().current();
        .colon.colon x$1 = new .colon.colon((Object)"ALL", (List)Nil$.MODULE$);
        boolean x$2 = true;
        boolean x$3 = qual$1.resolveMultipartName$default$2();
        if (!qual$1.resolveMultipartName((Seq<String>)x$1, x$3, true, x$4 = qual$1.resolveMultipartName$default$4(), x$5 = qual$1.resolveMultipartName$default$5(), x$6 = qual$1.resolveMultipartName$default$6()).candidates().isEmpty()) return false;
        return true;
    }

    private HashSet<ExprId> getGroupingAttributeIds(Aggregate aggregate) {
        HashSet<ExprId> groupingAttributeIds = new HashSet<ExprId>(aggregate.groupingExpressions().size());
        aggregate.groupingExpressions().foreach((Function1 & Serializable)rootExpression -> {
            rootExpression.foreach((Function1 & Serializable)x0$1 -> {
                AggregateResolver.$anonfun$getGroupingAttributeIds$2(groupingAttributeIds$1, x0$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        return groupingAttributeIds;
    }

    public static final /* synthetic */ void $anonfun$getGroupingAttributeIds$2(HashSet groupingAttributeIds$1, Expression x0$1) {
        Expression expression = x0$1;
        if (expression instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression;
            groupingAttributeIds$1.add(attributeReference.exprId());
            return;
        }
    }

    public AggregateResolver(Resolver operatorResolver, ExpressionResolver expressionResolver) {
        this.operatorResolver = operatorResolver;
        this.expressionResolver = expressionResolver;
        SQLConfHelper.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        AliasHelper.$init$(this);
        this.scopes = operatorResolver.getNameScopes();
        this.lcaResolver = expressionResolver.getLcaResolver();
    }
}

