/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayJoin$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.internal.types.AbstractArrayType;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.UTF8StringBuilder;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(array, delimiter[, nullReplacement]) - Concatenates the elements of the given array\n      using the delimiter and an optional string to replace nulls. If no value is set for\n      nullReplacement, any null value is filtered.", examples="\n    Examples:\n      > SELECT _FUNC_(array('hello', 'world'), ' ');\n       hello world\n      > SELECT _FUNC_(array('hello', null ,'world'), ' ');\n       hello world\n      > SELECT _FUNC_(array('hello', null ,'world'), ' ', ',');\n       hello , world\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\t\u0005c\u0001B\u0014)\u0001VB\u0001b\u0014\u0001\u0003\u0016\u0004%\t\u0001\u0015\u0005\t#\u0002\u0011\t\u0012)A\u0005m!A!\u000b\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005T\u0001\tE\t\u0015!\u00037\u0011!!\u0006A!f\u0001\n\u0003)\u0006\u0002C-\u0001\u0005#\u0005\u000b\u0011\u0002,\t\u000bi\u0003A\u0011A.\t\u000bi\u0003A\u0011\u00011\t\u000bi\u0003A\u0011A2\t\u000b\u001d\u0004A\u0011\t5\t\u000bI\u0004A\u0011I:\t\u000bU\u0004A\u0011\u000b<\t\u000bq\u0004A\u0011I?\t\r\u0005\r\u0001\u0001\"\u0011~\u0011\u0019\t)\u0001\u0001C!{\"9\u0011q\u0001\u0001\u0005B\u0005%\u0001bBA\u000f\u0001\u0011E\u0013q\u0004\u0005\b\u0003w\u0001A\u0011BA\u001f\u0011\u001d\ti\u0006\u0001C!\u0003?Bq!a\u001a\u0001\t\u0003\nI\u0007C\u0005\u0002l\u0001\t\t\u0011\"\u0001\u0002n!I\u0011Q\u000f\u0001\u0012\u0002\u0013\u0005\u0011q\u000f\u0005\n\u0003\u001b\u0003\u0011\u0013!C\u0001\u0003oB\u0011\"a$\u0001#\u0003%\t!!%\t\u0013\u0005U\u0005!!A\u0005B\u0005]\u0005\"CAT\u0001\u0005\u0005I\u0011AAU\u0011%\t\t\fAA\u0001\n\u0003\t\u0019\fC\u0005\u0002:\u0002\t\t\u0011\"\u0011\u0002<\"I\u0011\u0011\u001a\u0001\u0002\u0002\u0013\u0005\u00111\u001a\u0005\n\u0003\u001f\u0004\u0011\u0011!C!\u0003#D\u0011\"!6\u0001\u0003\u0003%\t%a6\b\u0013\u0005m\b&!A\t\u0002\u0005uh\u0001C\u0014)\u0003\u0003E\t!a@\t\ri\u000bC\u0011\u0001B\f\u0011%\u0011I\"IA\u0001\n\u000b\u0012Y\u0002C\u0005\u0003\u001e\u0005\n\t\u0011\"!\u0003 !I!qE\u0011\u0002\u0002\u0013\u0005%\u0011\u0006\u0005\n\u0005o\t\u0013\u0011!C\u0005\u0005s\u0011\u0011\"\u0011:sCfTu.\u001b8\u000b\u0005%R\u0013aC3yaJ,7o]5p]NT!a\u000b\u0017\u0002\u0011\r\fG/\u00197zgRT!!\f\u0018\u0002\u0007M\fHN\u0003\u00020a\u0005)1\u000f]1sW*\u0011\u0011GM\u0001\u0007CB\f7\r[3\u000b\u0003M\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u001c;{\r\u0003\"a\u000e\u001d\u000e\u0003!J!!\u000f\u0015\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u00028w%\u0011A\b\u000b\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001 B\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$a\u0002)s_\u0012,8\r\u001e\t\u0003\t2s!!\u0012&\u000f\u0005\u0019KU\"A$\u000b\u0005!#\u0014A\u0002\u001fs_>$h(C\u0001A\u0013\tYu(A\u0004qC\u000e\\\u0017mZ3\n\u00055s%\u0001D*fe&\fG.\u001b>bE2,'BA&@\u0003\u0015\t'O]1z+\u00051\u0014AB1se\u0006L\b%A\u0005eK2LW.\u001b;fe\u0006QA-\u001a7j[&$XM\u001d\u0011\u0002\u001f9,H\u000e\u001c*fa2\f7-Z7f]R,\u0012A\u0016\t\u0004}]3\u0014B\u0001-@\u0005\u0019y\u0005\u000f^5p]\u0006\u0001b.\u001e7m%\u0016\u0004H.Y2f[\u0016tG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tqkfl\u0018\t\u0003o\u0001AQaT\u0004A\u0002YBQAU\u0004A\u0002YBQ\u0001V\u0004A\u0002Y#2\u0001X1c\u0011\u0015y\u0005\u00021\u00017\u0011\u0015\u0011\u0006\u00021\u00017)\u0011aF-\u001a4\t\u000b=K\u0001\u0019\u0001\u001c\t\u000bIK\u0001\u0019\u0001\u001c\t\u000bQK\u0001\u0019\u0001\u001c\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001j!\r!%\u000e\\\u0005\u0003W:\u00131aU3r!\ti\u0007/D\u0001o\u0015\tyG&A\u0003usB,7/\u0003\u0002r]\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tG\"LG\u000e\u001a:f]V\tA\u000fE\u0002EUZ\nqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0005Y:\b\"\u0002=\r\u0001\u0004I\u0018a\u00038fo\u000eC\u0017\u000e\u001c3sK:\u00042\u0001\u0012>7\u0013\tYhJ\u0001\u0006J]\u0012,\u00070\u001a3TKF\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u0002}B\u0011ah`\u0005\u0004\u0003\u0003y$a\u0002\"p_2,\u0017M\\\u0001\tM>dG-\u00192mK\u0006Q2m\u001c8uKb$\u0018J\u001c3fa\u0016tG-\u001a8u\r>dG-\u00192mK\u0006!QM^1m)\u0011\tY!!\u0005\u0011\u0007y\ni!C\u0002\u0002\u0010}\u00121!\u00118z\u0011%\t\u0019\u0002\u0005I\u0001\u0002\u0004\t)\"A\u0003j]B,H\u000f\u0005\u0003\u0002\u0018\u0005eQ\"\u0001\u0016\n\u0007\u0005m!FA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t\t#!\f\u00028A!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(!\nqaY8eK\u001e,g.\u0003\u0003\u0002,\u0005\u0015\"\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005=\u0012\u00031\u0001\u00022\u0005\u00191\r\u001e=\u0011\t\u0005\r\u00121G\u0005\u0005\u0003k\t)C\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005e\u0012\u00031\u0001\u0002\"\u0005\u0011QM^\u0001\u001cO\u0016t7i\u001c3f\r>\u0014\u0018I\u001d:bs\u0006sG\rR3mS6LG/\u001a:\u0015\u0011\u0005}\u0012qJA)\u0003'\u0002B!!\u0011\u0002J9!\u00111IA#!\t1u(C\u0002\u0002H}\na\u0001\u0015:fI\u00164\u0017\u0002BA&\u0003\u001b\u0012aa\u0015;sS:<'bAA$\u007f!9\u0011q\u0006\nA\u0002\u0005E\u0002bBA\u001d%\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003+\u0012\u0002\u0019AA,\u0003!qW\u000f\u001c7Fm\u0006d\u0007c\u0003 \u0002Z\u0005}\u0012qHA \u0003\u007fI1!a\u0017@\u0005%1UO\\2uS>t7'\u0001\u0005eCR\fG+\u001f9f+\t\t\t\u0007E\u0002n\u0003GJ1!!\u001ao\u0005!!\u0015\r^1UsB,\u0017A\u00039sKR$\u0018PT1nKV\u0011\u0011qH\u0001\u0005G>\u0004\u0018\u0010F\u0004]\u0003_\n\t(a\u001d\t\u000f=+\u0002\u0013!a\u0001m!9!+\u0006I\u0001\u0002\u00041\u0004b\u0002+\u0016!\u0003\u0005\rAV\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIHK\u00027\u0003wZ#!! \u0011\t\u0005}\u0014\u0011R\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000f{\u0014AC1o]>$\u0018\r^5p]&!\u00111RAA\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a%+\u0007Y\u000bY(A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00033\u0003B!a'\u0002&6\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000b\t+\u0001\u0003mC:<'BAAR\u0003\u0011Q\u0017M^1\n\t\u0005-\u0013QT\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003W\u00032APAW\u0013\r\tyk\u0010\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0017\t)\fC\u0005\u00028n\t\t\u00111\u0001\u0002,\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!0\u0011\r\u0005}\u0016QYA\u0006\u001b\t\t\tMC\u0002\u0002D~\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9-!1\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004}\u00065\u0007\"CA\\;\u0005\u0005\t\u0019AA\u0006\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005e\u00151\u001b\u0005\n\u0003os\u0012\u0011!a\u0001\u0003W\u000ba!Z9vC2\u001cHc\u0001@\u0002Z\"I\u0011qW\u0010\u0002\u0002\u0003\u0007\u00111\u0002\u0015\u0014\u0001\u0005u\u00171]As\u0003S\fY/a<\u0002r\u0006U\u0018q\u001f\t\u0004o\u0005}\u0017bAAqQ\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAt\u0003\u0005e'\u0002\t\u0011!A}3UKT\"`Q\u0005\u0014(/Y=-A\u0011,G.[7ji\u0016\u00148\f\f\u0011ok2d'+\u001a9mC\u000e,W.\u001a8u;&\u0002S\u0006I\"p]\u000e\fG/\u001a8bi\u0016\u001c\b\u0005\u001e5fA\u0015dW-\\3oiN\u0004sN\u001a\u0011uQ\u0016\u0004s-\u001b<f]\u0002\n'O]1z\u0015\u0001\u0002\u0003\u0005\t\u0011!kNLgn\u001a\u0011uQ\u0016\u0004C-\u001a7j[&$XM\u001d\u0011b]\u0012\u0004\u0013M\u001c\u0011paRLwN\\1mAM$(/\u001b8hAQ|\u0007E]3qY\u0006\u001cW\r\t8vY2\u001ch\u0006I%gA9|\u0007E^1mk\u0016\u0004\u0013n\u001d\u0011tKR\u0004cm\u001c:\u000bA\u0001\u0002\u0003\u0005\t\u0011ok2d'+\u001a9mC\u000e,W.\u001a8uY\u0001\ng.\u001f\u0011ok2d\u0007E^1mk\u0016\u0004\u0013n\u001d\u0011gS2$XM]3e]\u0005AQ\r_1na2,7/\t\u0002\u0002n\u0006\tIP\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0014iK2dwn\n\u0017!O]|'\u000f\u001c3(S1\u0002s\u0005I\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001BW\r\u001c7pA]|'\u000f\u001c3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)O!,G\u000e\\8(Y\u0001rW\u000f\u001c7!Y\u001d:xN\u001d7eO%b\u0003e\n\u0011(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003.\u001a7m_\u0002:xN\u001d7e\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQ\u001dBW\r\u001c7pO1\u0002c.\u001e7mA1:so\u001c:mI\u001eJC\u0006I\u0014!O1\u0002s\u0005L\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001BW\r\u001c7pA1\u0002so\u001c:mI*\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002t\u0006Y\u0011M\u001d:bs~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\tI0A\u00033]Qr\u0003'A\u0005BeJ\f\u0017PS8j]B\u0011q'I\n\u0006C\t\u0005!Q\u0002\t\t\u0005\u0007\u0011IA\u000e\u001cW96\u0011!Q\u0001\u0006\u0004\u0005\u000fy\u0014a\u0002:v]RLW.Z\u0005\u0005\u0005\u0017\u0011)AA\tBEN$(/Y2u\rVt7\r^5p]N\u0002BAa\u0004\u0003\u00165\u0011!\u0011\u0003\u0006\u0005\u0005'\t\t+\u0001\u0002j_&\u0019QJ!\u0005\u0015\u0005\u0005u\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005e\u0015!B1qa2LHc\u0002/\u0003\"\t\r\"Q\u0005\u0005\u0006\u001f\u0012\u0002\rA\u000e\u0005\u0006%\u0012\u0002\rA\u000e\u0005\u0006)\u0012\u0002\rAV\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011YCa\r\u0011\ty:&Q\u0006\t\u0007}\t=bG\u000e,\n\u0007\tErH\u0001\u0004UkBdWm\r\u0005\t\u0005k)\u0013\u0011!a\u00019\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tm\u0002\u0003BAN\u0005{IAAa\u0010\u0002\u001e\n1qJ\u00196fGR\u0004")
public class ArrayJoin
extends Expression
implements ExpectsInputTypes,
Serializable {
    private final Expression array;
    private final Expression delimiter;
    private final Option<Expression> nullReplacement;

    public static Option<Tuple3<Expression, Expression, Option<Expression>>> unapply(ArrayJoin x$0) {
        return ArrayJoin$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Option<Expression>>, ArrayJoin> tupled() {
        return ArrayJoin$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<Expression>, ArrayJoin>>> curried() {
        return ArrayJoin$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression array() {
        return this.array;
    }

    public Expression delimiter() {
        return this.delimiter;
    }

    public Option<Expression> nullReplacement() {
        return this.nullReplacement;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        if (this.nullReplacement().isDefined()) {
            return new .colon.colon((Object)new AbstractArrayType((AbstractDataType)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3())), (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)));
        }
        return new .colon.colon((Object)new AbstractArrayType((AbstractDataType)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3())), (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$));
    }

    @Override
    public Seq<Expression> children() {
        if (this.nullReplacement().isDefined()) {
            return new .colon.colon((Object)this.array(), (List)new .colon.colon((Object)this.delimiter(), (List)new .colon.colon((Object)((Expression)this.nullReplacement().get()), (List)Nil$.MODULE$)));
        }
        return new .colon.colon((Object)this.array(), (List)new .colon.colon((Object)this.delimiter(), (List)Nil$.MODULE$));
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        if (this.nullReplacement().isDefined()) {
            return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Option<Expression>)new Some(newChildren.apply(2)));
        }
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), this.copy$default$3());
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1 & Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)x$31.nullable()));
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)x$32.foldable()));
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.children().forall((Function1 & Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)x$33.contextIndependentFoldable()));
    }

    @Override
    public Object eval(InternalRow input) {
        Function1 & Serializable intersect;
        Object arrayEval = this.array().eval(input);
        if (arrayEval == null) {
            return null;
        }
        Object delimiterEval = this.delimiter().eval(input);
        if (delimiterEval == null) {
            return null;
        }
        Option nullReplacementEval = this.nullReplacement().map((Function1 & Serializable)x$34 -> x$34.eval(input));
        if (nullReplacementEval.contains(null)) {
            return null;
        }
        UTF8StringBuilder buffer = new UTF8StringBuilder();
        BooleanRef firstItem = BooleanRef.create((boolean)true);
        Option option = nullReplacementEval;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object rep = some.value();
            intersect = (Function1 & Serializable)prependDelimiter -> BoxesRunTime.boxToBoolean((boolean)ArrayJoin.$anonfun$eval$8(buffer, delimiterEval, rep, BoxesRunTime.unboxToBoolean((Object)prependDelimiter)));
        } else if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)ArrayJoin.$anonfun$eval$9(BoxesRunTime.unboxToBoolean((Object)x$35)));
        } else {
            throw new MatchError((Object)option);
        }
        Function1 & Serializable nullHandling = intersect;
        ((ArrayData)arrayEval).foreach((DataType)StringType$.MODULE$, (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(x$36, item) -> {
            ArrayJoin.$anonfun$eval$10(nullHandling, firstItem, buffer, delimiterEval, BoxesRunTime.unboxToInt((Object)x$36), item);
            return BoxedUnit.UNIT;
        });
        return buffer.build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String string;
        Option<Expression> option = this.nullReplacement();
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression replacement = (Expression)some.value();
            ExprCode replacementGen = replacement.genCode(ctx);
            Function3 & Serializable nullHandling = (Function3 & Serializable)(buffer, delimiter, firstItem) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |if (!" + firstItem + ") {\n             |  " + buffer + ".append(" + delimiter + ");\n             |}\n             |" + buffer + ".append(" + replacementGen.value() + ");\n             |" + firstItem + " = false;\n           "));
            String execCode = replacement.nullable() ? ctx.nullSafeExec(replacement.nullable(), ExprValue$.MODULE$.exprValueToString(replacementGen.isNull()), this.genCodeForArrayAndDelimiter(ctx, ev, (Function3<String, String, String, String>)nullHandling)) : this.genCodeForArrayAndDelimiter(ctx, ev, (Function3<String, String, String, String>)nullHandling);
            string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |" + replacementGen.code() + "\n           |" + execCode + "\n         "));
        } else if (None$.MODULE$.equals(option)) {
            string = this.genCodeForArrayAndDelimiter(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(x$37, x$38, x$39) -> "// nulls are ignored");
        } else {
            throw new MatchError(option);
        }
        String code = string;
        if (this.nullable()) {
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |boolean ", " = true;\n           |UTF8String ", " = null;\n           |", "\n         "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), code})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
        }
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |UTF8String ", " = null;\n           |", "\n         "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), code})).stripMargin(), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    private String genCodeForArrayAndDelimiter(CodegenContext ctx, ExprCode ev, Function3<String, String, String, String> nullEval) {
        ExprCode arrayGen = this.array().genCode(ctx);
        ExprCode delimiterGen = this.delimiter().genCode(ctx);
        String buffer = ctx.freshName("buffer");
        String bufferClass = UTF8StringBuilder.class.getName();
        String i = ctx.freshName("i");
        String firstItem = ctx.freshName("firstItem");
        String resultCode = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |" + bufferClass + " " + buffer + " = new " + bufferClass + "();\n         |boolean " + firstItem + " = true;\n         |for (int " + i + " = 0; " + i + " < " + arrayGen.value() + ".numElements(); " + i + " ++) {\n         |  if (" + arrayGen.value() + ".isNullAt(" + i + ")) {\n         |    " + nullEval.apply((Object)buffer, (Object)ExprValue$.MODULE$.exprValueToString(delimiterGen.value()), (Object)firstItem) + "\n         |  } else {\n         |    if (!" + firstItem + ") {\n         |      " + buffer + ".append(" + delimiterGen.value() + ");\n         |    }\n         |    " + buffer + ".append(" + CodeGenerator$.MODULE$.getValue(ExprValue$.MODULE$.exprValueToString(arrayGen.value()), (DataType)StringType$.MODULE$, i) + ");\n         |    " + firstItem + " = false;\n         |  }\n         |}\n         |" + ev.value() + " = " + buffer + ".build();"));
        if (this.array().nullable() || this.delimiter().nullable()) {
            return arrayGen.code().toString() + ctx.nullSafeExec(this.array().nullable(), ExprValue$.MODULE$.exprValueToString(arrayGen.isNull()), delimiterGen.code().toString() + ctx.nullSafeExec(this.delimiter().nullable(), ExprValue$.MODULE$.exprValueToString(delimiterGen.isNull()), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |" + ev.isNull() + " = false;\n             |" + resultCode))));
        }
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |" + arrayGen.code() + "\n         |" + delimiterGen.code() + "\n         |" + resultCode));
    }

    @Override
    public DataType dataType() {
        return ((ArrayType)this.array().dataType()).elementType();
    }

    @Override
    public String prettyName() {
        return "array_join";
    }

    public ArrayJoin copy(Expression array, Expression delimiter, Option<Expression> nullReplacement) {
        return new ArrayJoin(array, delimiter, nullReplacement);
    }

    public Expression copy$default$1() {
        return this.array();
    }

    public Expression copy$default$2() {
        return this.delimiter();
    }

    public Option<Expression> copy$default$3() {
        return this.nullReplacement();
    }

    @Override
    public String productPrefix() {
        return "ArrayJoin";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.array();
            }
            case 1: {
                return this.delimiter();
            }
            case 2: {
                return this.nullReplacement();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayJoin;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "array";
            }
            case 1: {
                return "delimiter";
            }
            case 2: {
                return "nullReplacement";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayJoin)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayJoin arrayJoin = (ArrayJoin)x$1;
        Expression expression = this.array();
        Expression expression2 = arrayJoin.array();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimiter();
        Expression expression4 = arrayJoin.delimiter();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Expression> option = this.nullReplacement();
        Option<Expression> option2 = arrayJoin.nullReplacement();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!arrayJoin.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$eval$8(UTF8StringBuilder buffer$1, Object delimiterEval$1, Object rep$1, boolean prependDelimiter) {
        if (!prependDelimiter) {
            buffer$1.append((UTF8String)delimiterEval$1);
        }
        buffer$1.append((UTF8String)rep$1);
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$eval$9(boolean x$35) {
        return false;
    }

    public static final /* synthetic */ void $anonfun$eval$10(Function1 nullHandling$1, BooleanRef firstItem$1, UTF8StringBuilder buffer$1, Object delimiterEval$1, int x$36, Object item) {
        if (item == null) {
            if (BoxesRunTime.unboxToBoolean((Object)nullHandling$1.apply((Object)BoxesRunTime.boxToBoolean((boolean)firstItem$1.elem)))) {
                firstItem$1.elem = false;
                return;
            }
            return;
        }
        if (!firstItem$1.elem) {
            buffer$1.append((UTF8String)delimiterEval$1);
        }
        buffer$1.append((UTF8String)item);
        firstItem$1.elem = false;
    }

    public ArrayJoin(Expression array, Expression delimiter, Option<Expression> nullReplacement) {
        this.array = array;
        this.delimiter = delimiter;
        this.nullReplacement = nullReplacement;
        ExpectsInputTypes.$init$(this);
    }

    public ArrayJoin(Expression array, Expression delimiter) {
        this(array, delimiter, (Option<Expression>)None$.MODULE$);
    }

    public ArrayJoin(Expression array, Expression delimiter, Expression nullReplacement) {
        this(array, delimiter, (Option<Expression>)new Some((Object)nullReplacement));
    }
}

