/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ConditionalExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="CASE WHEN expr1 THEN expr2 [WHEN expr3 THEN expr4]* [ELSE expr5] END - When `expr1` = true, returns `expr2`; else when `expr3` = true, returns `expr4`; else returns `expr5`.", arguments="\n    Arguments:\n      * expr1, expr3 - the branch condition expressions should all be boolean type.\n      * expr2, expr4, expr5 - the branch value expressions and else value expression should all be\n          same type or coercible to a common type.\n  ", examples="\n    Examples:\n      > SELECT CASE WHEN 1 > 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       1.0\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       2.0\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 < 0 THEN 2.0 END;\n       NULL\n  ", since="1.0.1", group="conditional_funcs")
@ScalaSignature(bytes="\u0006\u0005\t5f\u0001\u0002\u0017.\u0001jB\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0001\u0017\u0005\t?\u0002\u0011\t\u0012)A\u00053\"A\u0001\r\u0001BK\u0002\u0013\u0005\u0011\r\u0003\u0005f\u0001\tE\t\u0015!\u0003c\u0011\u00151\u0007\u0001\"\u0001h\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u001dq\u0007A1A\u0005F=Dq!!\u0004\u0001A\u00035\u0001\u000fC\u0004\u0002\u0010\u0001!\t&!\u0005\t\u0015\u0005u\u0001\u0001#b\u0001\n\u0003\ny\u0002C\u0004\u00028\u0001!\t%!\u000f\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002:!9\u00111\t\u0001\u0005B\u0005\u0015\u0003BBA*\u0001\u0011\u0005C\u000eC\u0004\u0002V\u0001!\t%a\u0016\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004bBA<\u0001\u0011\u0005\u0013\u0011\u0010\u0005\u0007e\u0001!\t%a#\t\u000f\u00055\u0005\u0001\"\u0003\u0002\u0010\"9\u00111\u0016\u0001\u0005B\u00055\u0006\"CAZ\u0001\u0005\u0005I\u0011AA[\u0011%\tY\fAI\u0001\n\u0003\ti\fC\u0005\u0002T\u0002\t\n\u0011\"\u0001\u0002V\"I\u0011\u0011\u001c\u0001\u0002\u0002\u0013\u0005\u00131\u001c\u0005\n\u0003W\u0004\u0011\u0011!C\u0001\u0003[D\u0011\"!>\u0001\u0003\u0003%\t!a>\t\u0013\u0005u\b!!A\u0005B\u0005}\b\"\u0003B\u0007\u0001\u0005\u0005I\u0011\u0001B\b\u0011%\u0011\u0019\u0002AA\u0001\n\u0003\u0012)\u0002C\u0005\u0003\u001a\u0001\t\t\u0011\"\u0011\u0003\u001c\u001d9!QI\u0017\t\u0002\t\u001dcA\u0002\u0017.\u0011\u0003\u0011I\u0005\u0003\u0004gC\u0011\u0005!1\f\u0005\b\u0005;\nC\u0011\u0001B0\u0011\u001d\u0011)'\tC\u0001\u0005OB\u0011Ba\u001b\"\u0005\u0004%\tA!\u001c\t\u0011\t-\u0015\u0005)A\u0005\u0005_B\u0011B!\u0018\"\u0003\u0003%\tI!$\t\u0013\tM\u0015%%A\u0005\u0002\u0005U\u0007\"\u0003BKC\u0005\u0005I\u0011\u0011BL\u0011%\u0011\t+II\u0001\n\u0003\t)\u000eC\u0005\u0003$\u0006\n\t\u0011\"\u0003\u0003&\nA1)Y:f/\",gN\u0003\u0002/_\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0001\u0014'\u0001\u0005dCR\fG._:u\u0015\t\u00114'A\u0002tc2T!\u0001N\u001b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y:\u0014AB1qC\u000eDWMC\u00019\u0003\ry'oZ\u0002\u0001'\u0019\u00011h\u0010\"F\u0017B\u0011A(P\u0007\u0002[%\u0011a(\f\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001fA\u0013\t\tUF\u0001\u000fD_6\u0004H.\u001a=UsB,W*\u001a:hS:<W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005q\u001a\u0015B\u0001#.\u0005U\u0019uN\u001c3ji&|g.\u00197FqB\u0014Xm]:j_:\u0004\"AR%\u000e\u0003\u001dS\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u001e\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002M):\u0011QJ\u0015\b\u0003\u001dFk\u0011a\u0014\u0006\u0003!f\na\u0001\u0010:p_Rt\u0014\"\u0001%\n\u0005M;\u0015a\u00029bG.\fw-Z\u0005\u0003+Z\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!aU$\u0002\u0011\t\u0014\u0018M\\2iKN,\u0012!\u0017\t\u0004\u0019jc\u0016BA.W\u0005\r\u0019V-\u001d\t\u0005\rv[4(\u0003\u0002_\u000f\n1A+\u001e9mKJ\n\u0011B\u0019:b]\u000eDWm\u001d\u0011\u0002\u0013\u0015d7/\u001a,bYV,W#\u00012\u0011\u0007\u0019\u001b7(\u0003\u0002e\u000f\n1q\n\u001d;j_:\f!\"\u001a7tKZ\u000bG.^3!\u0003\u0019a\u0014N\\5u}Q\u0019\u0001.\u001b6\u0011\u0005q\u0002\u0001\"B,\u0006\u0001\u0004I\u0006b\u00021\u0006!\u0003\u0005\rAY\u0001\tG\"LG\u000e\u001a:f]V\tQ\u000eE\u0002M5n\nAB\\8eKB\u000bG\u000f^3s]N,\u0012\u0001\u001d\t\u0004\u0019j\u000b\bc\u0001:\u0002\b9\u00191/!\u0001\u000f\u0005QthBA;~\u001d\t1HP\u0004\u0002xw:\u0011\u0001P\u001f\b\u0003\u001dfL\u0011\u0001O\u0005\u0003m]J!\u0001N\u001b\n\u0005I\u001a\u0014B\u0001\u00192\u0013\tyx&A\u0003ue\u0016,7/\u0003\u0003\u0002\u0004\u0005\u0015\u0011a\u0003+sK\u0016\u0004\u0016\r\u001e;fe:T!a`\u0018\n\t\u0005%\u00111\u0002\u0002\f)J,W\rU1ui\u0016\u0014hN\u0003\u0003\u0002\u0004\u0005\u0015\u0011!\u00048pI\u0016\u0004\u0016\r\u001e;fe:\u001c\b%A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR\u0019\u0001.a\u0005\t\u000f\u0005U\u0011\u00021\u0001\u0002\u0018\u0005Ya.Z<DQ&dGM]3o!\u0011a\u0015\u0011D\u001e\n\u0007\u0005maK\u0001\u0006J]\u0012,\u00070\u001a3TKF\fA#\u001b8qkR$\u0016\u0010]3t\r>\u0014X*\u001a:hS:<WCAA\u0011!\u0011a%,a\t\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000b2\u0003\u0015!\u0018\u0010]3t\u0013\u0011\ti#a\n\u0003\u0011\u0011\u000bG/\u0019+za\u0016D3ACA\u0019!\r1\u00151G\u0005\u0004\u0003k9%!\u0003;sC:\u001c\u0018.\u001a8u\u0003!qW\u000f\u001c7bE2,WCAA\u001e!\r1\u0015QH\u0005\u0004\u0003\u007f9%a\u0002\"p_2,\u0017M\\\u0001\u001bG>tG/\u001a=u\u0013:$W\r]3oI\u0016tGOR8mI\u0006\u0014G.Z\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003\u000f\u0002B!!\u0013\u0002P5\u0011\u00111\n\u0006\u0004\u0003\u001bz\u0013\u0001C1oC2L8/[:\n\t\u0005E\u00131\n\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006)\u0012\r\\<bsN,e/\u00197vCR,G-\u00138qkR\u001c\u0018\u0001H<ji\"tUm^!mo\u0006L8/\u0012<bYV\fG/\u001a3J]B,Ho\u001d\u000b\u0004Q\u0006e\u0003BBA*\u001f\u0001\u0007Q.\u0001\u0007ce\u0006t7\r[$s_V\u00048/\u0006\u0002\u0002`A\u0019AJW7\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003K\nY\u0007E\u0002G\u0003OJ1!!\u001bH\u0005\r\te.\u001f\u0005\n\u0003[\n\u0002\u0013!a\u0001\u0003_\nQ!\u001b8qkR\u0004B!!\u001d\u0002t5\tq&C\u0002\u0002v=\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006AAo\\*ue&tw\r\u0006\u0002\u0002|A!\u0011QPAC\u001d\u0011\ty(!!\u0011\u00059;\u0015bAAB\u000f\u00061\u0001K]3eK\u001aLA!a\"\u0002\n\n11\u000b\u001e:j]\u001eT1!a!H+\t\tY(\u0001\u000bnk2$\u0018N\u0011:b]\u000eDWm]\"pI\u0016<WM\u001c\u000b\u0007\u0003#\u000bi*a*\u0011\t\u0005M\u0015\u0011T\u0007\u0003\u0003+S1!a&.\u0003\u001d\u0019w\u000eZ3hK:LA!a'\u0002\u0016\nAQ\t\u001f9s\u0007>$W\rC\u0004\u0002 R\u0001\r!!)\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\u0014\u0006\r\u0016\u0002BAS\u0003+\u0013abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002*R\u0001\r!!%\u0002\u0005\u00154\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t\t*a,\u00022\"9\u0011qT\u000bA\u0002\u0005\u0005\u0006bBAU+\u0001\u0007\u0011\u0011S\u0001\u0005G>\u0004\u0018\u0010F\u0003i\u0003o\u000bI\fC\u0004X-A\u0005\t\u0019A-\t\u000f\u00014\u0002\u0013!a\u0001E\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA`U\rI\u0016\u0011Y\u0016\u0003\u0003\u0007\u0004B!!2\u0002P6\u0011\u0011q\u0019\u0006\u0005\u0003\u0013\fY-A\u0005v]\u000eDWmY6fI*\u0019\u0011QZ$\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002R\u0006\u001d'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAlU\r\u0011\u0017\u0011Y\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005u\u0007\u0003BAp\u0003Sl!!!9\u000b\t\u0005\r\u0018Q]\u0001\u0005Y\u0006twM\u0003\u0002\u0002h\u0006!!.\u0019<b\u0013\u0011\t9)!9\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005=\bc\u0001$\u0002r&\u0019\u00111_$\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015\u0014\u0011 \u0005\n\u0003w\\\u0012\u0011!a\u0001\u0003_\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0001!\u0019\u0011\u0019A!\u0003\u0002f5\u0011!Q\u0001\u0006\u0004\u0005\u000f9\u0015AC2pY2,7\r^5p]&!!1\u0002B\u0003\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005m\"\u0011\u0003\u0005\n\u0003wl\u0012\u0011!a\u0001\u0003K\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011Q\u001cB\f\u0011%\tYPHA\u0001\u0002\u0004\ty/\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003w\u0011i\u0002C\u0005\u0002|~\t\t\u00111\u0001\u0002f!:\u0002A!\t\u0003(\t%\"Q\u0006B\u0018\u0005g\u0011)D!\u000f\u0003<\t}\"\u0011\t\t\u0004y\t\r\u0012b\u0001B\u0013[\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B\u0016\u0003\u0005m3)Q*FA]CUI\u0014\u0011fqB\u0014\u0018\u0007\t+I\u000b:\u0003S\r\u001f9se\u0001Zv\u000bS#OA\u0015D\bO]\u001a!)\"+e\nI3yaJ$TL\u000b\u0011\\\u000b2\u001bV\tI3yaJ,T\fI#O\t\u0002j\u0003e\u00165f]\u0002\u0002W\r\u001f9sc\u0001\u0004S\b\t;sk\u0016d\u0003E]3ukJt7\u000f\t1fqB\u0014(\u0007Y\u001e!K2\u001cX\rI<iK:\u0004\u0003-\u001a=qeN\u0002\u0007%\u0010\u0011ueV,G\u0006\t:fiV\u0014hn\u001d\u0011aKb\u0004(\u000f\u000e1<A\u0015d7/\u001a\u0011sKR,(O\\:!A\u0016D\bO]\u001ba]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0005c\t\u0011\u0011 \u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0015D\bO]\u0019-A\u0015D\bO]\u001a![\u0001\"\b.\u001a\u0011ce\u0006t7\r\u001b\u0011d_:$\u0017\u000e^5p]\u0002*\u0007\u0010\u001d:fgNLwN\\:!g\"|W\u000f\u001c3!C2d\u0007EY3!E>|G.Z1oAQL\b/\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0015D\bO\u001d\u001a-A\u0015D\bO\u001d\u001b-A\u0015D\bO]\u001b![\u0001\"\b.\u001a\u0011ce\u0006t7\r\u001b\u0011wC2,X\rI3yaJ,7o]5p]N\u0004\u0013M\u001c3!K2\u001cX\r\t<bYV,\u0007%\u001a=qe\u0016\u001c8/[8oAMDw.\u001e7eA\u0005dG\u000e\t2f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003e]1nK\u0002\"\u0018\u0010]3!_J\u00043m\\3sG&\u0014G.\u001a\u0011u_\u0002\n\u0007eY8n[>t\u0007\u0005^=qK:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!qG\u0001\u0003\u0006)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u00033)Q*FA]CUI\u0014\u00112Ay\u0002\u0003\u0007\t+I\u000b:\u0003\u0013\u0007I,I\u000b:\u0003#\u0007\t !a\u0001\"\u0006*\u0012(!e9\u0002\u0004%\u0012'T\u000b\u0002\ndF\r\u0011F\u001d\u0012[$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u00181\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u001a\u0015iU#!/\"+e\nI\u0019!y\u0001\u0002\u0004\u0005\u0016%F\u001d\u0002\n\u0004e\u0016%F\u001d\u0002\u0012\u0004E\u0010\u00111AQCUI\u0014\u00113]A\u0002S\tT*FAEr#\u0007I#O\tnR\u0001\u0005\t\u0011!A\u0001\u0002#G\f\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA\r\u000b5+\u0012\u0011X\u0011\u0016s\u0005%\r\u0011=AA\u0002C\u000bS#OAE\u0002s\u000bS#OAI\u0002C\b\t\u0019!)\"+e\n\t\u001a/a\u0001*e\nR\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u001dVcEJ\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\u0011i$A\u00032]Ar\u0013'A\u0003he>,\b/\t\u0002\u0003D\u0005\t2m\u001c8eSRLwN\\1m?\u001a,hnY:\u0002\u0011\r\u000b7/Z,iK:\u0004\"\u0001P\u0011\u0014\u000b\u0005\u0012YE!\u0015\u0011\u0007\u0019\u0013i%C\u0002\u0003P\u001d\u0013a!\u00118z%\u00164\u0007\u0003\u0002B*\u00053j!A!\u0016\u000b\t\t]\u0013Q]\u0001\u0003S>L1!\u0016B+)\t\u00119%A\u0003baBd\u0017\u0010F\u0003i\u0005C\u0012\u0019\u0007C\u0003XG\u0001\u0007\u0011\fC\u0003aG\u0001\u00071(\u0001\tde\u0016\fG/\u001a$s_6\u0004\u0016M]:feR\u0019\u0001N!\u001b\t\u000b]#\u0003\u0019A7\u0002\u001bI,w-[:uef,e\u000e\u001e:z+\t\u0011y\u0007\u0005\u0004G;\u0006m$\u0011\u000f\t\u0007\rv\u0013\u0019H!\u001f\u0011\u0007q\u0012)(C\u0002\u0003x5\u0012a\"\u0012=qe\u0016\u001c8/[8o\u0013:4w\u000e\u0005\u0003\u0003|\t\u0015e\u0002\u0002B?\u0005\u0003s1\u0001\u001eB@\u0013\r\tieL\u0005\u0005\u0005\u0007\u000bY%\u0001\tGk:\u001cG/[8o%\u0016<\u0017n\u001d;ss&!!q\u0011BE\u0005=1UO\\2uS>t')^5mI\u0016\u0014(\u0002\u0002BB\u0003\u0017\naB]3hSN$(/_#oiJL\b\u0005F\u0003i\u0005\u001f\u0013\t\nC\u0003XO\u0001\u0007\u0011\fC\u0004aOA\u0005\t\u0019\u00012\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u001a\nu\u0005\u0003\u0002$d\u00057\u0003BAR/ZE\"A!qT\u0015\u0002\u0002\u0003\u0007\u0001.A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001BT!\u0011\tyN!+\n\t\t-\u0016\u0011\u001d\u0002\u0007\u001f\nTWm\u0019;")
public class CaseWhen
extends Expression
implements ComplexTypeMergingExpression,
ConditionalExpression,
Serializable {
    private transient Seq<DataType> inputTypesForMerging;
    private final Seq<Tuple2<Expression, Expression>> branches;
    private final Option<Expression> elseValue;
    private final Seq<Enumeration.Value> nodePatterns;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> $lessinit$greater$default$2() {
        return CaseWhen$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Tuple2<Expression, Expression>>, Option<Expression>>> unapply(CaseWhen x$0) {
        return CaseWhen$.MODULE$.unapply(x$0);
    }

    public static Option<Expression> apply$default$2() {
        return CaseWhen$.MODULE$.apply$default$2();
    }

    public static Tuple2<String, Tuple2<ExpressionInfo, Function1<Seq<Expression>, Expression>>> registryEntry() {
        return CaseWhen$.MODULE$.registryEntry();
    }

    public static CaseWhen createFromParser(Seq<Expression> branches) {
        return CaseWhen$.MODULE$.createFromParser(branches);
    }

    @Override
    public final boolean foldable() {
        return ConditionalExpression.foldable$(this);
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public DataType dataType() {
        return ComplexTypeMergingExpression.dataType$(this);
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        CaseWhen caseWhen = this;
        synchronized (caseWhen) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        if (!this.bitmap$0) {
            return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    public Seq<Tuple2<Expression, Expression>> branches() {
        return this.branches;
    }

    public Option<Expression> elseValue() {
        return this.elseValue;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((IterableOps)this.branches().flatMap((Function1 & Serializable)b -> {
            Expression expression = (Expression)b._1();
            Expression expression2 = (Expression)b._2();
            return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
        })).$plus$plus(this.elseValue());
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public CaseWhen withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        if (newChildren.length() % 2 == 0) {
            return this.copy((Seq<Tuple2<Expression, Expression>>)newChildren.grouped(2).map((Function1 & Serializable)x0$1 -> {
                SeqOps seqOps;
                IndexedSeq indexedSeq = x0$1;
                if (indexedSeq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)indexedSeq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                    Expression a = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    Expression b = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                    return new Tuple2((Object)a, (Object)b);
                }
                throw new MatchError((Object)indexedSeq);
            }).toSeq(), this.copy$default$2());
        }
        return this.copy((Seq<Tuple2<Expression, Expression>>)((IterableOps)newChildren.dropRight(1)).grouped(2).map((Function1 & Serializable)x0$2 -> {
            SeqOps seqOps;
            IndexedSeq indexedSeq = x0$2;
            if (indexedSeq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)indexedSeq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                Expression a = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Expression b = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                return new Tuple2((Object)a, (Object)b);
            }
            throw new MatchError((Object)indexedSeq);
        }).toSeq(), (Option<Expression>)newChildren.lastOption());
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        CaseWhen caseWhen = this;
        synchronized (caseWhen) {
            if (!this.bitmap$trans$0) {
                this.inputTypesForMerging = (Seq)((IterableOps)this.branches().map((Function1 & Serializable)x$1 -> ((Expression)x$1._2()).dataType())).$plus$plus((IterableOnce)this.elseValue().map((Function1 & Serializable)x$2 -> x$2.dataType()));
                this.bitmap$trans$0 = true;
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        if (!this.bitmap$trans$0) {
            return this.inputTypesForMerging$lzycompute();
        }
        return this.inputTypesForMerging;
    }

    @Override
    public boolean nullable() {
        if (this.branches().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$nullable$1(x$3)))) {
            Tuple2 tuple2 = this.branches().span((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$nullable$2(x$4)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq h = (Seq)tuple2._1();
            Seq t = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)h, (Object)t);
            Seq h2 = (Seq)tuple22._1();
            Seq t2 = (Seq)tuple22._2();
            return h2.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$nullable$3(x$6))) || ((Expression)((Tuple2)t2.head())._2()).nullable();
        }
        return this.branches().exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$nullable$4(x$7))) || BoxesRunTime.unboxToBoolean((Object)this.elseValue().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.nullable())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.children().forall((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.contextIndependentFoldable()));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (TypeCoercion$.MODULE$.haveSameType(this.inputTypesForMerging())) {
            if (this.branches().forall((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$checkInputDataTypes$2(x$10)))) {
                return TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            int index = this.branches().indexWhere((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$checkInputDataTypes$3(x$11)));
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)TypeUtils$.MODULE$.ordinalNumber(index)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)TypeUtils$.MODULE$.toSQLType((AbstractDataType)BooleanType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)TypeUtils$.MODULE$.toSQLExpr((Expression)((Tuple2)this.branches().apply(index))._1())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)TypeUtils$.MODULE$.toSQLType((AbstractDataType)((Expression)((Tuple2)this.branches().apply(index))._1()).dataType()))}))));
        }
        return new TypeCheckResult.DataTypeMismatch("DATA_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)TypeUtils$.MODULE$.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)((IterableOnceOps)this.inputTypesForMerging().map((Function1 & Serializable)t -> TypeUtils$.MODULE$.toSQLType((AbstractDataType)t))).mkString("[", ", ", "]"))}))));
    }

    @Override
    public Seq<Expression> alwaysEvaluatedInputs() {
        Expression expression = (Expression)this.children().head();
        return Nil$.MODULE$.$colon$colon((Object)expression);
    }

    @Override
    public CaseWhen withNewAlwaysEvaluatedInputs(Seq<Expression> alwaysEvaluatedInputs) {
        return this.withNewChildrenInternal((IndexedSeq)alwaysEvaluatedInputs.toIndexedSeq().$plus$plus((IterableOnce)this.children().drop(1)));
    }

    @Override
    public Seq<Seq<Expression>> branchGroups() {
        Nil$ conditions = this.branches().length() > 1 ? (Seq)this.branches().map((Function1 & Serializable)x$12 -> (Expression)x$12._1()) : Nil$.MODULE$;
        Nil$ values = this.elseValue().nonEmpty() ? (Seq)((IterableOps)this.branches().map((Function1 & Serializable)x$13 -> (Expression)x$13._2())).$plus$plus(this.elseValue()) : Nil$.MODULE$;
        return new .colon.colon((Object)conditions, (List)new .colon.colon((Object)values, (List)Nil$.MODULE$));
    }

    @Override
    public Object eval(InternalRow input) {
        int size = this.branches().size();
        for (int i = 0; i < size; ++i) {
            if (!Boolean.TRUE.equals(((Expression)((Tuple2)this.branches().apply(i))._1()).eval(input))) continue;
            return ((Expression)((Tuple2)this.branches().apply(i))._2()).eval(input);
        }
        if (this.elseValue().isDefined()) {
            return ((Expression)this.elseValue().get()).eval(input);
        }
        return null;
    }

    @Override
    public String toString() {
        String cases = ((IterableOnceOps)this.branches().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Expression c = (Expression)tuple2._1();
                Expression v = (Expression)tuple2._2();
                return " WHEN " + c + " THEN " + v;
            }
            throw new MatchError((Object)tuple2);
        })).mkString();
        String elseCase = (String)this.elseValue().map((Function1 & Serializable)x$14 -> " ELSE " + x$14).getOrElse((Function0 & Serializable)() -> "");
        return "CASE" + cases + elseCase + " END";
    }

    @Override
    public String sql() {
        String cases = ((IterableOnceOps)this.branches().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Expression c = (Expression)tuple2._1();
                Expression v = (Expression)tuple2._2();
                return " WHEN " + c.sql() + " THEN " + v.sql();
            }
            throw new MatchError((Object)tuple2);
        })).mkString();
        String elseCase = (String)this.elseValue().map((Function1 & Serializable)x$15 -> " ELSE " + x$15.sql()).getOrElse((Function0 & Serializable)() -> "");
        return "CASE" + cases + elseCase + " END";
    }

    private ExprCode multiBranchesCodegen(CodegenContext ctx, ExprCode ev) {
        Seq allConditions;
        int NOT_MATCHED = -1;
        int HAS_NONNULL = 0;
        int HAS_NULL = 1;
        String resultState = ctx.freshName("caseWhenResultState");
        ev.value_$eq(JavaCode$.MODULE$.global(ctx.addMutableState(CodeGenerator$.MODULE$.javaType(this.dataType()), ExprValue$.MODULE$.exprValueToString(ev.value()), ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5()), this.dataType()));
        Seq cases = (Seq)this.branches().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Expression condExpr = (Expression)tuple2._1();
                Expression valueExpr = (Expression)tuple2._2();
                ExprCode cond = condExpr.genCode(ctx);
                ExprCode res = valueExpr.genCode(ctx);
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |" + cond.code() + "\n         |if (!" + cond.isNull() + " && " + cond.value() + ") {\n         |  " + res.code() + "\n         |  " + resultState + " = (byte)(" + res.isNull() + " ? " + HAS_NULL + " : " + HAS_NONNULL + ");\n         |  " + ev.value() + " = " + res.value() + ";\n         |  continue;\n         |}\n       "));
            }
            throw new MatchError((Object)tuple2);
        });
        Option elseCode = this.elseValue().map((Function1 & Serializable)elseExpr -> {
            ExprCode res = elseExpr.genCode(ctx);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |" + res.code() + "\n         |" + resultState + " = (byte)(" + res.isNull() + " ? " + HAS_NULL + " : " + HAS_NONNULL + ");\n         |" + ev.value() + " = " + res.value() + ";\n       "));
        });
        Seq x$1 = allConditions = (Seq)cases.$plus$plus((IterableOnce)elseCode);
        String x$2 = "caseWhen";
        String x$3 = "byte";
        Function1 & Serializable x$4 = (Function1 & Serializable)func -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |byte " + resultState + " = " + NOT_MATCHED + ";\n           |do {\n           |  " + func + "\n           |} while (false);\n           |return " + resultState + ";\n         "));
        Function1 & Serializable x$5 = (Function1 & Serializable)x$16 -> ((IterableOnceOps)x$16.map((Function1 & Serializable)funcCall -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |" + resultState + " = " + funcCall + ";\n           |if (" + resultState + " != " + NOT_MATCHED + ") {\n           |  continue;\n           |}\n         ")))).mkString();
        Seq<Tuple2<String, String>> x$6 = ctx.splitExpressionsWithCurrentInputs$default$3();
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)x$1, "caseWhen", x$6, "byte", (Function1<String, String>)x$4, (Function1<Seq<String>, String>)x$5);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " ", " = ", ";\n         |do {\n         |  ", "\n         |} while (false);\n         |// TRUE if any condition is met and the result is null, or no any condition is met.\n         |final boolean ", " = (", " != ", ");\n       "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"byte", resultState, BoxesRunTime.boxToInteger((int)NOT_MATCHED), codes, ev.isNull(), resultState, BoxesRunTime.boxToInteger((int)HAS_NONNULL)})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        if (this.branches().length() == 1) {
            return new If((Expression)((Tuple2)this.branches().apply(0))._1(), (Expression)((Tuple2)this.branches().apply(0))._2(), (Expression)this.elseValue().getOrElse((Function0 & Serializable)() -> Literal$.MODULE$.create(null, ((Expression)((Tuple2)this.branches().apply(0))._2()).dataType()))).doGenCode(ctx, ev);
        }
        return this.multiBranchesCodegen(ctx, ev);
    }

    public CaseWhen copy(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        return new CaseWhen(branches, elseValue);
    }

    public Seq<Tuple2<Expression, Expression>> copy$default$1() {
        return this.branches();
    }

    public Option<Expression> copy$default$2() {
        return this.elseValue();
    }

    @Override
    public String productPrefix() {
        return "CaseWhen";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.branches();
            }
            case 1: {
                return this.elseValue();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CaseWhen;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "branches";
            }
            case 1: {
                return "elseValue";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CaseWhen)) return false;
        boolean bl = true;
        if (!bl) return false;
        CaseWhen caseWhen = (CaseWhen)x$1;
        Seq<Tuple2<Expression, Expression>> seq = this.branches();
        Seq<Tuple2<Expression, Expression>> seq2 = caseWhen.branches();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<Expression> option = this.elseValue();
        Option<Expression> option2 = caseWhen.elseValue();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!caseWhen.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$nullable$1(Tuple2 x$3) {
        Object object = x$3._1();
        Literal literal = Literal$.MODULE$.TrueLiteral();
        return !(object != null ? !object.equals(literal) : literal != null);
    }

    public static final /* synthetic */ boolean $anonfun$nullable$2(Tuple2 x$4) {
        Object object = x$4._1();
        Literal literal = Literal$.MODULE$.TrueLiteral();
        return object == null ? literal != null : !object.equals(literal);
    }

    public static final /* synthetic */ boolean $anonfun$nullable$3(Tuple2 x$6) {
        return ((Expression)x$6._2()).nullable();
    }

    public static final /* synthetic */ boolean $anonfun$nullable$4(Tuple2 x$7) {
        return ((Expression)x$7._2()).nullable();
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$2(Tuple2 x$10) {
        DataType dataType = ((Expression)x$10._1()).dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return !(dataType != null ? !dataType.equals(booleanType$) : booleanType$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$3(Tuple2 x$11) {
        DataType dataType = ((Expression)x$11._1()).dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return dataType == null ? booleanType$ != null : !dataType.equals(booleanType$);
    }

    public CaseWhen(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        this.branches = branches;
        this.elseValue = elseValue;
        ComplexTypeMergingExpression.$init$(this);
        ConditionalExpression.$init$(this);
        this.nodePatterns = new .colon.colon((Object)TreePattern$.MODULE$.CASE_WHEN(), (List)Nil$.MODULE$);
    }
}

