/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.Concat$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.ByteArray;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(col1, col2, ..., colN) - Returns the concatenation of col1, col2, ..., colN.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', 'SQL');\n       SparkSQL\n      > SELECT _FUNC_(array(1, 2, 3), array(4, 5), array(6));\n       [1,2,3,4,5,6]\n  ", note="\n    Concat logic for arrays is available since 2.4.0.\n  ", group="collection_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\tmd\u0001\u0002\u0014(\u0001RB\u0001\u0002\u0016\u0001\u0003\u0016\u0004%\t!\u0016\u0005\t3\u0002\u0011\t\u0012)A\u0005-\")!\f\u0001C\u00017\")a\f\u0001C\u0005?\"9q\r\u0001b\u0001\n\u000bB\u0007BB@\u0001A\u00035\u0011\u000eC\u0004\u0002\u0002\u0001!\t%a\u0001\t\u0015\u0005E\u0001\u0001#b\u0001\n\u0003\n\u0019\u0002C\u0004\u0002$\u0001!I!!\n\t\u000f\u00055\u0002\u0001\"\u0003\u00020!9\u0011\u0011\t\u0001\u0005B\u0005\u0015\u0002bBA\"\u0001\u0011\u0005\u0013Q\u0005\u0005\b\u0003\u000b\u0002A\u0011IA\u0013\u0011\u001d\t9\u0005\u0001C!\u0003\u0013B!\"!\u0018\u0001\u0011\u000b\u0007I\u0011BA0\u0011\u001d\tI\u0007\u0001C)\u0003WBq!a\"\u0001\t\u0013\tI\tC\u0004\u0002\u0014\u0002!I!!&\t\u000f\u0005\u0005\u0006\u0001\"\u0011\u0002$\"1A\u0006\u0001C!\u0003_Aq!!*\u0001\t#\n9\u000bC\u0005\u00024\u0002\t\t\u0011\"\u0001\u00026\"I\u0011\u0011\u0018\u0001\u0012\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003#\u0004\u0011\u0011!C!\u0003'D\u0011\"a9\u0001\u0003\u0003%\t!!:\t\u0013\u00055\b!!A\u0005\u0002\u0005=\b\"CA{\u0001\u0005\u0005I\u0011IA|\u0011%\u0011)\u0001AA\u0001\n\u0003\u00119\u0001C\u0005\u0003\f\u0001\t\t\u0011\"\u0011\u0003\u000e!I!\u0011\u0003\u0001\u0002\u0002\u0013\u0005#1C\u0004\n\u0005{9\u0013\u0011!E\u0001\u0005\u007f1\u0001BJ\u0014\u0002\u0002#\u0005!\u0011\t\u0005\u00075\u0002\"\tA!\u0017\t\u0013\u0005\u0005\u0006%!A\u0005F\tm\u0003\"\u0003B/A\u0005\u0005I\u0011\u0011B0\u0011%\u0011\u0019\u0007IA\u0001\n\u0003\u0013)\u0007C\u0005\u0003r\u0001\n\t\u0011\"\u0003\u0003t\t11i\u001c8dCRT!\u0001K\u0015\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003U-\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003Y5\n1a]9m\u0015\tqs&A\u0003ta\u0006\u00148N\u0003\u00021c\u00051\u0011\r]1dQ\u0016T\u0011AM\u0001\u0004_J<7\u0001A\n\u0007\u0001UJDH\u0011%\u0011\u0005Y:T\"A\u0014\n\u0005a:#AC#yaJ,7o]5p]B\u0011aGO\u0005\u0003w\u001d\u0012AdQ8na2,\u0007\u0010V=qK6+'oZ5oO\u0016C\bO]3tg&|g\u000e\u0005\u0002>\u00016\taH\u0003\u0002@W\u00051QM\u001d:peNL!!\u0011 \u0003\u001fE+XM]=FeJ|'o\u001d\"bg\u0016\u0004\"a\u0011$\u000e\u0003\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0012\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002J#:\u0011!j\u0014\b\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001bN\na\u0001\u0010:p_Rt\u0014\"A#\n\u0005A#\u0015a\u00029bG.\fw-Z\u0005\u0003%N\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0015#\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012A\u0016\t\u0004\u0013^+\u0014B\u0001-T\u0005\r\u0019V-]\u0001\nG\"LG\u000e\u001a:f]\u0002\na\u0001P5oSRtDC\u0001/^!\t1\u0004\u0001C\u0003U\u0007\u0001\u0007a+\u0001\u0007bY2|w/\u001a3UsB,7/F\u0001a!\rIu+\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003I.\nQ\u0001^=qKNL!AZ2\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00048pI\u0016\u0004\u0016\r\u001e;fe:\u001cX#A5\u0011\u0007%;&\u000e\u0005\u0002ly:\u0011A.\u001f\b\u0003[^t!A\u001c<\u000f\u0005=,hB\u00019u\u001d\t\t8O\u0004\u0002Le&\t!'\u0003\u00021c%\u0011afL\u0005\u0003Y5J!AK\u0016\n\u0005aL\u0013!\u0002;sK\u0016\u001c\u0018B\u0001>|\u0003-!&/Z3QCR$XM\u001d8\u000b\u0005aL\u0013BA?\u007f\u0005-!&/Z3QCR$XM\u001d8\u000b\u0005i\\\u0018!\u00048pI\u0016\u0004\u0016\r\u001e;fe:\u001c\b%A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u0002\u0006A!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f%\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0003\u001f\tIAA\bUsB,7\t[3dWJ+7/\u001e7u\u0003!!\u0017\r^1UsB,WCAA\u000b!\r\u0011\u0017qC\u0005\u0004\u00033\u0019'\u0001\u0003#bi\u0006$\u0016\u0010]3)\u0007!\ti\u0002E\u0002D\u0003?I1!!\tE\u0005%!(/\u00198tS\u0016tG/\u0001\u000esKN,H\u000e^!se\u0006LX\t\\3nK:$h*\u001e7mC\ndW-\u0006\u0002\u0002(A\u00191)!\u000b\n\u0007\u0005-BIA\u0004C_>dW-\u00198\u0002\u0011)\fg/\u0019+za\u0016,\"!!\r\u0011\t\u0005M\u00121\b\b\u0005\u0003k\t9\u0004\u0005\u0002L\t&\u0019\u0011\u0011\b#\u0002\rA\u0013X\rZ3g\u0013\u0011\ti$a\u0010\u0003\rM#(/\u001b8h\u0015\r\tI\u0004R\u0001\t]VdG.\u00192mK\u0006Aam\u001c7eC\ndW-\u0001\u000ed_:$X\r\u001f;J]\u0012,\u0007/\u001a8eK:$hi\u001c7eC\ndW-\u0001\u0003fm\u0006dG\u0003BA&\u0003#\u00022aQA'\u0013\r\ty\u0005\u0012\u0002\u0004\u0003:L\b\"CA*\u001dA\u0005\t\u0019AA+\u0003\u0015Ig\u000e];u!\u0011\t9&!\u0017\u000e\u0003%J1!a\u0017*\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0011\u0011|7i\u001c8dCR,\"!!\u0019\u0011\u000f\r\u000b\u0019'!\u0016\u0002L%\u0019\u0011Q\r#\u0003\u0013\u0019+hn\u0019;j_:\f\u0004fA\b\u0002\u001e\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003[\nI(a!\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cR1!a\u001d(\u0003\u001d\u0019w\u000eZ3hK:LA!a\u001e\u0002r\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002|A\u0001\r!! \u0002\u0007\r$\b\u0010\u0005\u0003\u0002p\u0005}\u0014\u0002BAA\u0003c\u0012abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002\u0006B\u0001\r!!\u001c\u0002\u0005\u00154\u0018AG4f]\u000e{G-\u001a$pe:+XNY3s\u001f\u001a,E.Z7f]R\u001cH\u0003BAF\u0003#\u0003raQAG\u0003c\t\t$C\u0002\u0002\u0010\u0012\u0013a\u0001V;qY\u0016\u0014\u0004bBA>#\u0001\u0007\u0011QP\u0001\u0011O\u0016t7i\u001c3f\r>\u0014\u0018I\u001d:bsN$\u0002\"!\r\u0002\u0018\u0006e\u0015Q\u0014\u0005\b\u0003w\u0012\u0002\u0019AA?\u0011\u001d\tYJ\u0005a\u0001\u0003+\t1\"\u001a7f[\u0016tG\u000fV=qK\"9\u0011q\u0014\nA\u0002\u0005\u001d\u0012\u0001D2iK\u000e\\gi\u001c:Ok2d\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005E\u0012aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\ra\u0016\u0011\u0016\u0005\b\u0003W+\u0002\u0019AAW\u0003-qWm^\"iS2$'/\u001a8\u0011\t%\u000by+N\u0005\u0004\u0003c\u001b&AC%oI\u0016DX\rZ*fc\u0006!1m\u001c9z)\ra\u0016q\u0017\u0005\b)Z\u0001\n\u00111\u0001W\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!0+\u0007Y\u000byl\u000b\u0002\u0002BB!\u00111YAg\u001b\t\t)M\u0003\u0003\u0002H\u0006%\u0017!C;oG\",7m[3e\u0015\r\tY\rR\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAh\u0003\u000b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u001b\t\u0005\u0003/\f\t/\u0004\u0002\u0002Z*!\u00111\\Ao\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0017\u0001\u00026bm\u0006LA!!\u0010\u0002Z\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u001d\t\u0004\u0007\u0006%\u0018bAAv\t\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111JAy\u0011%\t\u0019PGA\u0001\u0002\u0004\t9/A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003s\u0004b!a?\u0003\u0002\u0005-SBAA\u007f\u0015\r\ty\u0010R\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0002\u0003{\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011q\u0005B\u0005\u0011%\t\u0019\u0010HA\u0001\u0002\u0004\tY%\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAk\u0005\u001fA\u0011\"a=\u001e\u0003\u0003\u0005\r!a:\u0002\r\u0015\fX/\u00197t)\u0011\t9C!\u0006\t\u0013\u0005Mh$!AA\u0002\u0005-\u0003f\u0006\u0001\u0003\u001a\t}!\u0011\u0005B\u0013\u0005O\u0011YC!\f\u00032\tM\"q\u0007B\u001d!\r1$1D\u0005\u0004\u0005;9#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005G\t1k\u0018$V\u001d\u000e{\u0006fY8mc1\u00023m\u001c73Y\u0001rcF\f\u0017!G>dg*\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011d_:\u001c\u0017\r^3oCRLwN\u001c\u0011pM\u0002\u001aw\u000e\\\u0019-A\r|GN\r\u0017!]9rC\u0006I2pY:s\u0013\u0001C3yC6\u0004H.Z:\"\u0005\t%\u0012!a\u000e\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u001a\u0006/\u0019:lO1\u0002seU)MO%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u00159be.\u001c\u0016\u000b\u0014\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00152Y\u0001\u0012D\u0006I\u001a*Y\u0001\n'O]1zQQb\u0003%N\u0015-A\u0005\u0014(/Y=)m%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.2YIb3\u0007\f\u001b-k12TL\u0003\u0011!\u0003\u0011qw\u000e^3\"\u0005\t=\u0012!\u000f\u0006!A\u0001\u00023i\u001c8dCR\u0004Cn\\4jG\u00022wN\u001d\u0011beJ\f\u0017p\u001d\u0011jg\u0002\ng/Y5mC\ndW\rI:j]\u000e,\u0007E\r\u00185]Ar#\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\tU\u0012\u0001E2pY2,7\r^5p]~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011Y$A\u00032]Ur\u0003'\u0001\u0004D_:\u001c\u0017\r\u001e\t\u0003m\u0001\u001aR\u0001\tB\"\u0005\u001f\u0002bA!\u0012\u0003LYcVB\u0001B$\u0015\r\u0011I\u0005R\u0001\beVtG/[7f\u0013\u0011\u0011iEa\u0012\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0005\u0003\u0003R\t]SB\u0001B*\u0015\u0011\u0011)&!8\u0002\u0005%|\u0017b\u0001*\u0003TQ\u0011!q\b\u000b\u0003\u0003+\fQ!\u00199qYf$2\u0001\u0018B1\u0011\u0015!6\u00051\u0001W\u0003\u001d)h.\u00199qYf$BAa\u001a\u0003nA!1I!\u001bW\u0013\r\u0011Y\u0007\u0012\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\t=D%!AA\u0002q\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011)\b\u0005\u0003\u0002X\n]\u0014\u0002\u0002B=\u00033\u0014aa\u00142kK\u000e$\b")
public class Concat
extends Expression
implements ComplexTypeMergingExpression,
QueryErrorsBase,
Serializable {
    private transient DataType dataType;
    private transient Function1<InternalRow, Object> doConcat;
    private final Seq<Expression> children;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient Seq<DataType> inputTypesForMerging;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<Seq<Expression>> unapply(Concat x$0) {
        return Concat$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<Concat, A> g) {
        return Concat$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Concat> compose(Function1<A$, Seq<Expression>> g) {
        return Concat$.MODULE$.compose(g);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        Concat concat = this;
        synchronized (concat) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression.inputTypesForMerging$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.inputTypesForMerging$lzycompute();
        }
        return this.inputTypesForMerging;
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        Concat concat = this;
        synchronized (concat) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        if (!this.bitmap$0) {
            return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public Seq<AbstractDataType> org$apache$spark$sql$catalyst$expressions$Concat$$allowedTypes() {
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)ArrayType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (this.children().isEmpty()) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        Option dataTypeMismatch = ((IterableOnceOps)this.children().zipWithIndex()).collectFirst((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ Concat $outer;

            public final <A1 extends Tuple2<Expression, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int idx = A1._2$mcI$sp();
                    if (!this.$outer.org$apache$spark$sql$catalyst$expressions$Concat$$allowedTypes().exists((Function1 & Serializable)x$42 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$1.$anonfun$applyOrElse$1(e, x$42)))) {
                        return (B1)new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.$outer.ordinalNumber(idx)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.$outer.toSQLType((AbstractDataType)TypeCollection$.MODULE$.apply(this.$outer.org$apache$spark$sql$catalyst$expressions$Concat$$allowedTypes()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.$outer.toSQLExpr(e)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.$outer.toSQLType((AbstractDataType)e.dataType()))}))));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Expression, Object> x1) {
                Tuple2<Expression, Object> tuple2 = x1;
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    if (!this.$outer.org$apache$spark$sql$catalyst$expressions$Concat$$allowedTypes().exists((Function1 & Serializable)x$42 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$1.$anonfun$isDefinedAt$1(e, x$42)))) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(Expression e$1, AbstractDataType x$42) {
                return x$42.acceptsType(e$1.dataType());
            }

            public static final /* synthetic */ boolean $anonfun$isDefinedAt$1(Expression e$2, AbstractDataType x$42) {
                return x$42.acceptsType(e$2.dataType());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.catalyst.expressions.Expression org.apache.spark.sql.types.AbstractDataType ), $anonfun$isDefinedAt$1$adapted(org.apache.spark.sql.catalyst.expressions.Expression org.apache.spark.sql.types.AbstractDataType )}, serializedLambda);
            }
        });
        Option option = dataTypeMismatch;
        if (option instanceof Some) {
            Some some = (Some)option;
            TypeCheckResult.DataTypeMismatch mismatch = (TypeCheckResult.DataTypeMismatch)some.value();
            return mismatch;
        }
        return TypeUtils$.MODULE$.checkForSameTypeInputExpr((Seq<DataType>)((Seq)this.children().map((Function1 & Serializable)x$43 -> x$43.dataType())), this.prettyName());
    }

    private DataType dataType$lzycompute() {
        Concat concat = this;
        synchronized (concat) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.dataType = this.children().isEmpty() ? StringType$.MODULE$ : ComplexTypeMergingExpression.dataType$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.dataType$lzycompute();
        }
        return this.dataType;
    }

    private boolean resultArrayElementNullable() {
        return ((ArrayType)this.dataType()).containsNull();
    }

    private String javaType() {
        return CodeGenerator$.MODULE$.javaType(this.dataType());
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1 & Serializable)x$44 -> BoxesRunTime.boxToBoolean((boolean)x$44.nullable()));
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable)x$45 -> BoxesRunTime.boxToBoolean((boolean)x$45.foldable()));
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.children().forall((Function1 & Serializable)x$46 -> BoxesRunTime.boxToBoolean((boolean)x$46.contextIndependentFoldable()));
    }

    @Override
    public Object eval(InternalRow input) {
        return this.doConcat().apply((Object)input);
    }

    private Function1<InternalRow, Object> doConcat$lzycompute() {
        Concat concat = this;
        synchronized (concat) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Function1 & Serializable intersect;
                DataType dataType = this.dataType();
                if (BinaryType$.MODULE$.equals(dataType)) {
                    intersect = (Function1 & Serializable)input -> {
                        Seq inputs = (Seq)this.children().map((Function1 & Serializable)x$47 -> (byte[])x$47.eval((InternalRow)input));
                        return ByteArray.concat((byte[][])((byte[][])inputs.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)))));
                    };
                } else if (dataType instanceof StringType) {
                    intersect = (Function1 & Serializable)input -> {
                        Seq inputs = (Seq)this.children().map((Function1 & Serializable)x$48 -> (UTF8String)x$48.eval((InternalRow)input));
                        return UTF8String.concat((UTF8String[])((UTF8String[])inputs.toArray(ClassTag$.MODULE$.apply(UTF8String.class))));
                    };
                } else if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType elementType = arrayType.elementType();
                    intersect = (Function1 & Serializable)input -> {
                        LazyList inputs = ((LazyList)this.children().to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.LazyList()))).map((Function1 & Serializable)x$49 -> x$49.eval((InternalRow)input));
                        if (inputs.contains(null)) {
                            return null;
                        }
                        LazyList arrayData = inputs.map((Function1 & Serializable)x$50 -> (ArrayData)x$50);
                        long numberOfElements = BoxesRunTime.unboxToLong((Object)arrayData.foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable)(sum, ad) -> BoxesRunTime.boxToLong((long)Concat.$anonfun$doConcat$8(BoxesRunTime.unboxToLong((Object)sum), ad))));
                        if (numberOfElements > 0x7FFFFFF0L) {
                            throw QueryExecutionErrors$.MODULE$.arrayFunctionWithElementsExceedLimitError(this.prettyName(), numberOfElements);
                        }
                        Object[] finalData = new Object[(int)numberOfElements];
                        IntRef position = IntRef.create((int)0);
                        arrayData.foreach((Function1 & Serializable)ad -> {
                            Concat.$anonfun$doConcat$9(elementType, finalData, position, ad);
                            return BoxedUnit.UNIT;
                        });
                        return new GenericArrayData((Object)finalData);
                    };
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doConcat = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.doConcat;
    }

    private Function1<InternalRow, Object> doConcat() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.doConcat$lzycompute();
        }
        return this.doConcat;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        Tuple2 tuple2;
        Seq evals = (Seq)this.children().map((Function1 & Serializable)x$51 -> x$51.genCode(ctx));
        String args = ctx.freshName("args");
        String hasNull = ctx.freshName("hasNull");
        Seq inputs = (Seq)((IterableOps)((IterableOps)evals.zip((IterableOnce)this.children().map((Function1 & Serializable)x$52 -> BoxesRunTime.boxToBoolean((boolean)x$52.nullable())))).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (tuple22 != null) {
                    ExprCode eval = (ExprCode)tuple22._1();
                    boolean bl = tuple22._2$mcZ$sp();
                    if (bl) {
                        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |if (!" + hasNull + ") {\n           |  " + eval.code() + "\n           |  if (!" + eval.isNull() + ") {\n           |    " + args + "[" + index + "] = " + eval.value() + ";\n           |  } else {\n           |    " + hasNull + " = true;\n           |  }\n           |}\n         "));
                    }
                }
            }
            if (tuple2 != null) {
                Tuple2 tuple23 = (Tuple2)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (tuple23 != null) {
                    ExprCode eval = (ExprCode)tuple23._1();
                    boolean bl = tuple23._2$mcZ$sp();
                    if (!bl) {
                        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |if (!" + hasNull + ") {\n           |  " + eval.code() + "\n           |  " + args + "[" + index + "] = " + eval.value() + ";\n           |}\n         "));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        Tuple2 tuple22 = new Tuple2((Object)(this.javaType() + "[]"), (Object)args);
        Tuple2 tuple23 = new Tuple2((Object)"boolean", (Object)hasNull);
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)inputs, "valueConcat", (Seq<Tuple2<String, String>>)Nil$.MODULE$.$colon$colon((Object)tuple23).$colon$colon((Object)tuple22), "boolean", (Function1<String, String>)(Function1 & Serializable)body -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |" + body + "\n           |return " + hasNull + ";\n         ")), (Function1<Seq<String>, String>)(Function1 & Serializable)x$53 -> ((IterableOnceOps)x$53.map((Function1 & Serializable)funcCall -> hasNull + " = " + funcCall + ";")).mkString("\n"));
        DataType dataType = this.dataType();
        if (BinaryType$.MODULE$.equals(dataType)) {
            tuple2 = new Tuple2((Object)(ByteArray.class.getName() + ".concat"), (Object)("byte[][] " + args + " = new byte[" + evals.length() + "][];"));
        } else if (dataType instanceof StringType) {
            tuple2 = new Tuple2((Object)"UTF8String.concat", (Object)("UTF8String[] " + args + " = new UTF8String[" + evals.length() + "];"));
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            String concat = this.genCodeForArrays(ctx, elementType, containsNull);
            tuple2 = new Tuple2((Object)concat, (Object)("ArrayData[] " + args + " = new ArrayData[" + evals.length() + "];"));
        } else {
            throw new MatchError((Object)dataType);
        }
        Tuple2 tuple24 = tuple2;
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        String concat = (String)tuple24._1();
        String initCode = (String)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)concat, (Object)initCode);
        String concat2 = (String)tuple25._1();
        String initCode2 = (String)tuple25._2();
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |boolean ", " = false;\n         |", "\n         |", "\n         |", " ", " = null;\n         |if (!", ") {\n         |  ", " = ", "(", ");\n         |}\n         |boolean ", " = ", " == null;\n       "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{hasNull, initCode2, codes, this.javaType(), ev.value(), hasNull, ev.value(), concat2, args, ev.isNull(), ev.value()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    private Tuple2<String, String> genCodeForNumberOfElements(CodegenContext ctx) {
        String numElements = ctx.freshName("numElements");
        String z = ctx.freshName("z");
        String code = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |long " + numElements + " = 0L;\n        |for (int " + z + " = 0; " + z + " < " + this.children().length() + "; " + z + "++) {\n        |  " + numElements + " += args[" + z + "].numElements();\n        |}\n      "));
        return new Tuple2((Object)code, (Object)numElements);
    }

    private String genCodeForArrays(CodegenContext ctx, DataType elementType, boolean checkForNull) {
        String counter = ctx.freshName("counter");
        String arrayData = ctx.freshName("arrayData");
        String y = ctx.freshName("y");
        String z = ctx.freshName("z");
        Tuple2<String, String> tuple2 = this.genCodeForNumberOfElements(ctx);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String numElemCode = (String)tuple2._1();
        String numElemName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)numElemCode, (Object)numElemName);
        String numElemCode2 = (String)tuple22._1();
        String numElemName2 = (String)tuple22._2();
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, elementType, numElemName2, " " + this.prettyName() + " failed.");
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, elementType, "args[" + y + "]", counter, z, this.resultArrayElementNullable());
        String concat = ctx.freshName("concat");
        String concatDef = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |private ArrayData " + concat + "(ArrayData[] args) {\n         |  " + numElemCode2 + "\n         |  " + initialization + "\n         |  int " + counter + " = 0;\n         |  for (int " + y + " = 0; " + y + " < " + this.children().length() + "; " + y + "++) {\n         |    for (int " + z + " = 0; " + z + " < args[" + y + "].numElements(); " + z + "++) {\n         |      " + assignment + "\n         |      " + counter + "++;\n         |    }\n         |  }\n         |  return " + arrayData + ";\n         |}\n       "));
        return ctx.addNewFunction(concat, concatDef, ctx.addNewFunction$default$3());
    }

    @Override
    public String toString() {
        return "concat(" + this.children().mkString(", ") + ")";
    }

    @Override
    public String sql() {
        return "concat(" + ((IterableOnceOps)this.children().map((Function1 & Serializable)x$56 -> x$56.sql())).mkString(", ") + ")";
    }

    @Override
    public Concat withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren);
    }

    public Concat copy(Seq<Expression> children2) {
        return new Concat(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "Concat";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.children();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Concat;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "children";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Concat)) return false;
        boolean bl = true;
        if (!bl) return false;
        Concat concat = (Concat)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = concat.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!concat.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$doConcat$8(long sum, ArrayData ad) {
        return sum + (long)ad.numElements();
    }

    public static final /* synthetic */ void $anonfun$doConcat$9(DataType elementType$2, Object[] finalData$1, IntRef position$1, ArrayData ad) {
        Object[] arr = ad.toObjectArray(elementType$2);
        Array$.MODULE$.copy((Object)arr, 0, (Object)finalData$1, position$1.elem, arr.length);
        position$1.elem += arr.length;
    }

    public Concat(Seq<Expression> children2) {
        this.children = children2;
        ComplexTypeMergingExpression.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.nodePatterns = new .colon.colon((Object)TreePattern$.MODULE$.CONCAT(), (List)Nil$.MODULE$);
    }
}

