/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed$;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Shuffle$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.RandomIndicesGenerator;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="_FUNC_(array) - Returns a random permutation of the given array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 20, 3, 5));\n       [3,1,5,20]\n      > SELECT _FUNC_(array(1, 20, null, 3));\n       [20,null,3,1]\n  ", note="\n    The function is non-deterministic.\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\tud\u0001\u0002\u0016,\u0001bB\u0001\u0002\u0017\u0001\u0003\u0016\u0004%\t!\u0017\u0005\t;\u0002\u0011\t\u0012)A\u00055\"Aa\f\u0001BK\u0002\u0013\u0005q\f\u0003\u0005g\u0001\tE\t\u0015!\u0003a\u0011\u00159\u0007\u0001\"\u0001i\u0011\u00159\u0007\u0001\"\u0001m\u0011\u00159\u0007\u0001\"\u0001o\u0011\u0015\u0011\b\u0001\"\u0011t\u0011\u00159\b\u0001\"\u0011Z\u0011\u0015A\b\u0001\"\u0011z\u0011\u0015Y\b\u0001\"\u0011}\u0011!y\b\u0001#b\u0001\n\u0003\u001a\bbBA\u0001\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003/\u0001A\u0011IA\r\u0011\u0019\t\t\u0003\u0001C\u0005g\"Q\u00111\u0005\u0001\t\u0006\u0004%\t!!\u0007\t\u0017\u00055\u0002\u00011A\u0001B\u0003&\u0011q\u0006\u0005\b\u0003{\u0001A\u0011KA \u0011\u001d\t\t\u0006\u0001C)\u0003'Bq!a\u001a\u0001\t#\nI\u0007C\u0004\u0002\u0006\u0002!I!a\"\t\u000f\u0005\u0005\u0006\u0001\"\u0011\u0002$\"I\u0011\u0011\u0016\u0001\u0002\u0002\u0013\u0005\u00111\u0016\u0005\n\u0003c\u0003\u0011\u0013!C\u0001\u0003gC\u0011\"!3\u0001#\u0003%\t!a3\t\u0013\u0005=\u0007!!A\u0005B\u0005E\u0007\"CAq\u0001\u0005\u0005I\u0011AAr\u0011%\t)\u000fAA\u0001\n\u0003\t9\u000fC\u0005\u0002n\u0002\t\t\u0011\"\u0011\u0002p\"I\u0011Q \u0001\u0002\u0002\u0013\u0005\u0011q \u0005\n\u0005\u0007\u0001\u0011\u0011!C!\u0005\u000bA\u0011B!\u0003\u0001\u0003\u0003%\tEa\u0003\b\u0013\tU2&!A\t\u0002\t]b\u0001\u0003\u0016,\u0003\u0003E\tA!\u000f\t\r\u001d\u0014C\u0011\u0001B)\u0011%\u0011\u0019FIA\u0001\n\u000b\u0012)\u0006C\u0005\u0003X\t\n\t\u0011\"!\u0003Z!I!q\f\u0012\u0012\u0002\u0013\u0005\u00111\u001a\u0005\n\u0005C\u0012\u0013\u0011!CA\u0005GB\u0011B!\u001d##\u0003%\t!a3\t\u0013\tM$%!A\u0005\n\tU$aB*ik\u001a4G.\u001a\u0006\u0003Y5\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011afL\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0001'M\u0001\u0004gFd'B\u0001\u001a4\u0003\u0015\u0019\b/\u0019:l\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\u0004\u0001M9\u0001!O\u001fA\u0007\u001ac\u0005C\u0001\u001e<\u001b\u0005Y\u0013B\u0001\u001f,\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001e?\u0013\ty4FA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004\"AO!\n\u0005\t[#\u0001\u0005(p]\u0012,G/\u001a:nS:L7\u000f^5d!\tQD)\u0003\u0002FW\tAR\t\u001f9sKN\u001c\u0018n\u001c8XSRD'+\u00198e_6\u001cV-\u001a3\u0011\u0005\u001dSU\"\u0001%\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013%\u0003\u000fA\u0013x\u000eZ;diB\u0011Q*\u0016\b\u0003\u001dNs!a\u0014*\u000e\u0003AS!!U\u001c\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0015B\u0001+I\u0003\u001d\u0001\u0018mY6bO\u0016L!AV,\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005QC\u0015!B2iS2$W#\u0001.\u0011\u0005iZ\u0016B\u0001/,\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\u0015I\fg\u000eZ8n'\u0016,G-F\u0001a!\r9\u0015mY\u0005\u0003E\"\u0013aa\u00149uS>t\u0007CA$e\u0013\t)\u0007J\u0001\u0003M_:<\u0017a\u0003:b]\u0012|WnU3fI\u0002\na\u0001P5oSRtDcA5kWB\u0011!\b\u0001\u0005\u00061\u0016\u0001\rA\u0017\u0005\b=\u0016\u0001\n\u00111\u0001a)\tIW\u000eC\u0003Y\r\u0001\u0007!\fF\u0002j_BDQ\u0001W\u0004A\u0002iCQ!]\u0004A\u0002i\u000bAa]3fI\u0006A1\u000f^1uK\u001a,H.F\u0001u!\t9U/\u0003\u0002w\u0011\n9!i\\8mK\u0006t\u0017AD:fK\u0012,\u0005\u0010\u001d:fgNLwN\\\u0001\fo&$\bNT3x'\u0016,G\r\u0006\u0002ju\")\u0011O\u0003a\u0001G\u0006yq/\u001b;i'\"Lg\r^3e'\u0016,G\r\u0006\u0002j{\")ap\u0003a\u0001G\u0006)1\u000f[5gi\u0006A!/Z:pYZ,G-\u0001\u0006j]B,H\u000fV=qKN,\"!!\u0002\u0011\u000b5\u000b9!a\u0003\n\u0007\u0005%qKA\u0002TKF\u0004B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#y\u0013!\u0002;za\u0016\u001c\u0018\u0002BA\u000b\u0003\u001f\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!a\u0007\u0011\t\u00055\u0011QD\u0005\u0005\u0003?\tyA\u0001\u0005ECR\fG+\u001f9f\u0003i\u0011Xm];mi\u0006\u0013(/Y=FY\u0016lWM\u001c;Ok2d\u0017M\u00197f\u0003-)G.Z7f]R$\u0016\u0010]3)\u0007A\t9\u0003E\u0002H\u0003SI1!a\u000bI\u0005%!(/\u00198tS\u0016tG/\u0001\u0004sC:$w.\u001c\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011QG\u0017\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003s\t\u0019D\u0001\fSC:$w.\\%oI&\u001cWm]$f]\u0016\u0014\u0018\r^8sQ\r\t\u0012qE\u0001\u0013S:LG/[1mSj,\u0017J\u001c;fe:\fG\u000e\u0006\u0003\u0002B\u0005\u001d\u0003cA$\u0002D%\u0019\u0011Q\t%\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0013\u0012\u0002\u0019AA&\u00039\u0001\u0018M\u001d;ji&|g.\u00138eKb\u00042aRA'\u0013\r\ty\u0005\u0013\u0002\u0004\u0013:$\u0018\u0001D3wC2Le\u000e^3s]\u0006dG\u0003BA+\u00037\u00022aRA,\u0013\r\tI\u0006\u0013\u0002\u0004\u0003:L\bbBA/'\u0001\u0007\u0011qL\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003C\n\u0019'D\u0001.\u0013\r\t)'\f\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR1\u00111NA<\u0003\u0003\u0003B!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0004\u0003cZ\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003k\nyG\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tI\b\u0006a\u0001\u0003w\n1a\u0019;y!\u0011\ti'! \n\t\u0005}\u0014q\u000e\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t\u0019\t\u0006a\u0001\u0003W\n!!\u001a<\u0002'MDWO\u001a4mK\u0006\u0013(/Y=D_\u0012,w)\u001a8\u0015\u0011\u0005%\u0015\u0011TAN\u0003;\u0003B!a#\u0002\u0014:!\u0011QRAH!\ty\u0005*C\u0002\u0002\u0012\"\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAK\u0003/\u0013aa\u0015;sS:<'bAAI\u0011\"9\u0011\u0011P\u000bA\u0002\u0005m\u0004bBAB+\u0001\u0007\u00111\u000e\u0005\b\u0003?+\u0002\u0019AAE\u0003%\u0019\u0007.\u001b7e\u001d\u0006lW-\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0004S\u0006\u0015\u0006BBAT-\u0001\u0007!,\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011\u0019w\u000e]=\u0015\u000b%\fi+a,\t\u000fa;\u0002\u0013!a\u00015\"9al\u0006I\u0001\u0002\u0004\u0001\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003kS3AWA\\W\t\tI\f\u0005\u0003\u0002<\u0006\u0015WBAA_\u0015\u0011\ty,!1\u0002\u0013Ut7\r[3dW\u0016$'bAAb\u0011\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0017Q\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u001bT3\u0001YA\\\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u001b\t\u0005\u0003+\fy.\u0004\u0002\u0002X*!\u0011\u0011\\An\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0017\u0001\u00026bm\u0006LA!!&\u0002X\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111J\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t)&!;\t\u0013\u0005-H$!AA\u0002\u0005-\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002rB1\u00111_A}\u0003+j!!!>\u000b\u0007\u0005]\b*\u0001\u0006d_2dWm\u0019;j_:LA!a?\u0002v\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r!(\u0011\u0001\u0005\n\u0003Wt\u0012\u0011!a\u0001\u0003+\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111\u001bB\u0004\u0011%\tYoHA\u0001\u0002\u0004\tY%\u0001\u0004fcV\fGn\u001d\u000b\u0004i\n5\u0001\"CAvA\u0005\u0005\t\u0019AA+Q]\u0001!\u0011\u0003B\f\u00053\u0011iBa\b\u0003$\t\u0015\"\u0011\u0006B\u0016\u0005_\u0011\t\u0004E\u0002;\u0005'I1A!\u0006,\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#Aa\u0007\u0002\u0001~3UKT\"`Q\u0005\u0014(/Y=*A5\u0002#+\u001a;ve:\u001c\b%\u0019\u0011sC:$w.\u001c\u0011qKJlW\u000f^1uS>t\u0007e\u001c4!i\",\u0007eZ5wK:\u0004\u0013M\u001d:bs:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005C\t\u00111\u0005\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00152Y\u0001\u0012\u0004\u0007\f\u00114Y\u0001*\u0014&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7Nb\u0013\u0007L\u001b-eAj&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\b&\r\u0017!eAb\u0003E\\;mY2\u00023'K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0013\u0004\u0007\f8vY2d3\u0007L\u0019^\u0015\u0001\u0002\u0013\u0001\u00028pi\u0016\f#Aa\n\u0002U)\u0001\u0003\u0005\t\u0011UQ\u0016\u0004c-\u001e8di&|g\u000eI5tA9|g.\f3fi\u0016\u0014X.\u001b8jgRL7M\f\u0006!A\u0005)qM]8va\u0006\u0012!QF\u0001\fCJ\u0014\u0018-_0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u00034\u0005)!G\f\u001b/a\u000591\u000b[;gM2,\u0007C\u0001\u001e#'\u0015\u0011#1\bB$!\u001d\u0011iDa\u0011[A&l!Aa\u0010\u000b\u0007\t\u0005\u0003*A\u0004sk:$\u0018.\\3\n\t\t\u0015#q\b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003\u0002B%\u0005\u001fj!Aa\u0013\u000b\t\t5\u00131\\\u0001\u0003S>L1A\u0016B&)\t\u00119$\u0001\u0005u_N#(/\u001b8h)\t\t\u0019.A\u0003baBd\u0017\u0010F\u0003j\u00057\u0012i\u0006C\u0003YK\u0001\u0007!\fC\u0004_KA\u0005\t\u0019\u00011\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003f\t5\u0004\u0003B$b\u0005O\u0002Ra\u0012B55\u0002L1Aa\u001bI\u0005\u0019!V\u000f\u001d7fe!A!qN\u0014\u0002\u0002\u0003\u0007\u0011.A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B<!\u0011\t)N!\u001f\n\t\tm\u0014q\u001b\u0002\u0007\u001f\nTWm\u0019;")
public class Shuffle
extends UnaryExpression
implements ExpectsInputTypes,
Nondeterministic,
ExpressionWithRandomSeed,
Serializable {
    private boolean resolved;
    private transient DataType elementType;
    private final Expression child;
    private final Option<Object> randomSeed;
    private transient RandomIndicesGenerator random;
    private Seq<Enumeration.Value> nodePatterns;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Object> $lessinit$greater$default$2() {
        return Shuffle$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Object>>> unapply(Shuffle x$0) {
        return Shuffle$.MODULE$.unapply(x$0);
    }

    public static Option<Object> apply$default$2() {
        return Shuffle$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Option<Object>>, Shuffle> tupled() {
        return Shuffle$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Object>, Shuffle>> curried() {
        return Shuffle$.MODULE$.curried();
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$ExpressionWithRandomSeed$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private boolean deterministic$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.deterministic$lzycompute();
        }
        return this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Option<Object> randomSeed() {
        return this.randomSeed;
    }

    @Override
    public boolean stateful() {
        return true;
    }

    @Override
    public Expression seedExpression() {
        return (Expression)this.randomSeed().map((Function1 & Serializable)v -> Literal$.MODULE$.apply(v)).getOrElse((Function0 & Serializable)() -> UnresolvedSeed$.MODULE$);
    }

    @Override
    public Shuffle withNewSeed(long seed) {
        Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)seed));
        Expression x$2 = this.copy$default$1();
        return this.copy(x$2, (Option<Object>)x$1);
    }

    @Override
    public Shuffle withShiftedSeed(long shift) {
        Option x$1 = this.randomSeed().map((Function1)(JFunction1.mcJJ.sp & Serializable)x$20 -> x$20 + shift);
        Expression x$2 = this.copy$default$1();
        return this.copy(x$2, (Option<Object>)x$1);
    }

    private boolean resolved$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = this.childrenResolved() && this.checkInputDataTypes().isSuccess() && this.randomSeed().isDefined();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)ArrayType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    private boolean resultArrayElementNullable() {
        return ((ArrayType)this.dataType()).containsNull();
    }

    private DataType elementType$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if (!this.bitmap$trans$0) {
                this.elementType = ((ArrayType)this.dataType()).elementType();
                this.bitmap$trans$0 = true;
            }
        }
        return this.elementType;
    }

    public DataType elementType() {
        if (!this.bitmap$trans$0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.random = new RandomIndicesGenerator(BoxesRunTime.unboxToLong((Object)this.randomSeed().get()) + (long)partitionIndex);
    }

    @Override
    public Object evalInternal(InternalRow input) {
        Object value = this.child().eval(input);
        if (value == null) {
            return null;
        }
        ArrayData source = (ArrayData)value;
        int numElements = source.numElements();
        int[] indices = this.random.getNextIndices(numElements);
        return new GenericArrayData((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(indices), (Function1 & Serializable)x$22 -> source.get(BoxesRunTime.unboxToInt((Object)x$22), this.elementType()), ClassTag$.MODULE$.apply(Object.class)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> this.shuffleArrayCodeGen(ctx, ev, (String)c));
    }

    private String shuffleArrayCodeGen(CodegenContext ctx, ExprCode ev, String childName) {
        String randomClass;
        String x$1 = randomClass = RandomIndicesGenerator.class.getName();
        String x$2 = "rand";
        boolean x$3 = true;
        Function1<String, String> x$4 = ctx.addMutableState$default$3();
        boolean x$5 = ctx.addMutableState$default$5();
        String rand = ctx.addMutableState(x$1, "rand", x$4, true, x$5);
        ctx.addPartitionInitializationStatement(rand + " = new " + randomClass + "(" + this.randomSeed().get() + "L + partitionIndex);");
        String numElements = ctx.freshName("numElements");
        String arrayData = ctx.freshName("arrayData");
        String indices = ctx.freshName("indices");
        String i = ctx.freshName("i");
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, this.elementType(), numElements, " " + this.prettyName() + " failed.");
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, this.elementType(), childName, i, indices + "[" + i + "]", this.resultArrayElementNullable());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |int " + numElements + " = " + childName + ".numElements();\n       |int[] " + indices + " = " + rand + ".getNextIndices(" + numElements + ");\n       |" + initialization + "\n       |for (int " + i + " = 0; " + i + " < " + numElements + "; " + i + "++) {\n       |  " + assignment + "\n       |}\n       |" + ev.value() + " = " + arrayData + ";\n     "));
    }

    @Override
    public Shuffle withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Shuffle copy(Expression child, Option<Object> randomSeed) {
        return new Shuffle(child, randomSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<Object> copy$default$2() {
        return this.randomSeed();
    }

    @Override
    public String productPrefix() {
        return "Shuffle";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.randomSeed();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Shuffle;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "randomSeed";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Shuffle)) return false;
        boolean bl = true;
        if (!bl) return false;
        Shuffle shuffle = (Shuffle)x$1;
        Expression expression = this.child();
        Expression expression2 = shuffle.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Object> option = this.randomSeed();
        Option<Object> option2 = shuffle.randomSeed();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!shuffle.canEqual(this)) return false;
        return true;
    }

    public Shuffle(Expression child, Option<Object> randomSeed) {
        this.child = child;
        this.randomSeed = randomSeed;
        ExpectsInputTypes.$init$(this);
        Nondeterministic.$init$(this);
        ExpressionWithRandomSeed.$init$(this);
        Statics.releaseFence();
    }

    public Shuffle(Expression child) {
        this(child, (Option<Object>)None$.MODULE$);
    }

    public Shuffle(Expression child, Expression seed) {
        this(child, ExpressionWithRandomSeed$.MODULE$.expressionToSeed(seed, "shuffle"));
    }
}

