/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.TimeTrunc$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyTimeType$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(unit, time) - Returns `time` truncated to the `unit`.\n  ", arguments="\n    Arguments:\n      * unit - the unit to truncate to\n          - \"HOUR\" - zero out the minutes and seconds with fraction part\n          - \"MINUTE\" - zero out the seconds with fraction part\n          - \"SECOND\" - zero out the fraction part of seconds\n          - \"MILLISECOND\" - zero out the microseconds\n          - \"MICROSECOND\" - zero out the nanoseconds\n      * time - a TIME expression\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('HOUR', TIME'09:32:05.359');\n       09:00:00\n      > SELECT _FUNC_('MILLISECOND', TIME'09:32:05.123456');\n       09:32:05.123\n  ", group="datetime_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005Ug\u0001\u0002\u0010 \u00012B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u00151\u0006\u0001\"\u0011K\u0011\u00159\u0006\u0001\"\u0011K\u0011\u0015A\u0006\u0001\"\u0011Z\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015\u0011\b\u0001\"\u0015t\u0011\u0015A\b\u0001\"\u0011K\u0011\u001dI\b!!A\u0005\u0002iDq! \u0001\u0012\u0002\u0013\u0005a\u0010\u0003\u0005\u0002\u0014\u0001\t\n\u0011\"\u0001\u007f\u0011%\t)\u0002AA\u0001\n\u0003\n9\u0002C\u0005\u0002(\u0001\t\t\u0011\"\u0001\u0002*!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00111\u0007\u0005\n\u0003\u007f\u0001\u0011\u0011!C!\u0003\u0003B\u0011\"a\u0014\u0001\u0003\u0003%\t!!\u0015\t\u0013\u0005m\u0003!!A\u0005B\u0005u\u0003\"CA1\u0001\u0005\u0005I\u0011IA2\u000f%\tiiHA\u0001\u0012\u0003\tyI\u0002\u0005\u001f?\u0005\u0005\t\u0012AAI\u0011\u0019\t\u0006\u0004\"\u0001\u0002*\"I\u00111\u0016\r\u0002\u0002\u0013\u0015\u0013Q\u0016\u0005\n\u0003_C\u0012\u0011!CA\u0003cC\u0011\"a.\u0019\u0003\u0003%\t)!/\t\u0013\u0005-\u0007$!A\u0005\n\u00055'!\u0003+j[\u0016$&/\u001e8d\u0015\t\u0001\u0013%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0012$\u0003!\u0019\u0017\r^1msN$(B\u0001\u0013&\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003M\u001d\nQa\u001d9be.T!\u0001K\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0013aA8sO\u000e\u00011C\u0002\u0001.cQ:T\b\u0005\u0002/_5\tq$\u0003\u00021?\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003]IJ!aM\u0010\u0003%I+h\u000e^5nKJ+\u0007\u000f\\1dK\u0006\u0014G.\u001a\t\u0003]UJ!AN\u0010\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002?\r:\u0011q\b\u0012\b\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005.\na\u0001\u0010:p_Rt\u0014\"\u0001\u001e\n\u0005\u0015K\u0014a\u00029bG.\fw-Z\u0005\u0003\u000f\"\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!!R\u001d\u0002\tUt\u0017\u000e^\u000b\u0002\u0017B\u0011a\u0006T\u0005\u0003\u001b~\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015)h.\u001b;!\u0003\u0011!\u0018.\\3\u0002\u000bQLW.\u001a\u0011\u0002\rqJg.\u001b;?)\r\u0019F+\u0016\t\u0003]\u0001AQ!S\u0003A\u0002-CQaT\u0003A\u0002-\u000bA\u0001\\3gi\u0006)!/[4ii\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003i\u00032AP.^\u0013\ta\u0006JA\u0002TKF\u0004\"AX1\u000e\u0003}S!\u0001Y\u0012\u0002\u000bQL\b/Z:\n\u0005\t|&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#A3\u0011\u0005y3\u0017BA4`\u0005!!\u0015\r^1UsB,\u0017A\u00039sKR$\u0018PT1nKV\t!\u000e\u0005\u0002l_:\u0011A.\u001c\t\u0003\u0001fJ!A\\\u001d\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0018O\u0001\u0004TiJLgn\u001a\u0006\u0003]f\nqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0007M#h\u000fC\u0003v\u0017\u0001\u00071*A\u0004oK^,f.\u001b;\t\u000b]\\\u0001\u0019A&\u0002\u000f9,w\u000fV5nK\u0006Y!/\u001a9mC\u000e,W.\u001a8u\u0003\u0011\u0019w\u000e]=\u0015\u0007M[H\u0010C\u0004J\u001bA\u0005\t\u0019A&\t\u000f=k\u0001\u0013!a\u0001\u0017\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A@+\u0007-\u000b\ta\u000b\u0002\u0002\u0004A!\u0011QAA\b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011!C;oG\",7m[3e\u0015\r\ti!O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\t\u0003\u000f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\r!\u0011\tY\"!\n\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\tA\u0001\\1oO*\u0011\u00111E\u0001\u0005U\u00064\u0018-C\u0002q\u0003;\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u000b\u0011\u0007a\ni#C\u0002\u00020e\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u000e\u0002<A\u0019\u0001(a\u000e\n\u0007\u0005e\u0012HA\u0002B]fD\u0011\"!\u0010\u0013\u0003\u0003\u0005\r!a\u000b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u0005\u0005\u0004\u0002F\u0005-\u0013QG\u0007\u0003\u0003\u000fR1!!\u0013:\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001b\n9E\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA*\u00033\u00022\u0001OA+\u0013\r\t9&\u000f\u0002\b\u0005>|G.Z1o\u0011%\ti\u0004FA\u0001\u0002\u0004\t)$\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\r\u0003?B\u0011\"!\u0010\u0016\u0003\u0003\u0005\r!a\u000b\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019&!\u001a\t\u0013\u0005ub#!AA\u0002\u0005U\u0002f\u0006\u0001\u0002j\u0005=\u0014\u0011OA;\u0003o\nY(! \u0002\u0002\u0006\r\u0015qQAE!\rq\u00131N\u0005\u0004\u0003[z\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003g\nAI\u0003\u0011!A\u0001zf)\u0016(D?\"*h.\u001b;-AQLW.Z\u0015![\u0001\u0012V\r^;s]N\u0004\u0003\r^5nK\u0002\u0004CO];oG\u0006$X\r\u001a\u0011u_\u0002\"\b.\u001a\u0011ak:LG\u000f\u0019\u0018\u000bA\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005e\u0014a!\u0006\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001*h.\u001b;![\u0001\"\b.\u001a\u0011v]&$\b\u0005^8!iJ,hnY1uK\u0002\"xN\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#\u0005S(V%\n\u0002S\u0006\t>fe>\u0004s.\u001e;!i\",\u0007%\\5okR,7\u000fI1oI\u0002\u001aXmY8oIN\u0004s/\u001b;iA\u0019\u0014\u0018m\u0019;j_:\u0004\u0003/\u0019:u\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#\u001b&sU\u000bV##A5\u0002#0\u001a:pA=,H\u000f\t;iK\u0002\u001aXmY8oIN\u0004s/\u001b;iA\u0019\u0014\u0018m\u0019;j_:\u0004\u0003/\u0019:u\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#'\u0016\u001buJ\u0014##A5\u0002#0\u001a:pA=,H\u000f\t;iK\u00022'/Y2uS>t\u0007\u0005]1si\u0002zg\rI:fG>tGm\u001d\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003EI'J\u00192K5+R\"P\u001d\u0012\u0013\u0003%\f\u0011{KJ|\u0007e\\;uAQDW\rI7jGJ|7/Z2p]\u0012\u001c(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012S*S\"S\u001fN+5i\u0014(EE\u0001j\u0003E_3s_\u0002zW\u000f\u001e\u0011uQ\u0016\u0004c.\u00198pg\u0016\u001cwN\u001c3t\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"\u0018.\\3![\u0001\n\u0007\u0005V%N\u000b\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002\u0000\u0005\tYE\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(\u0011>+&k\n\u0017!)&kUi\n\u0019:uM\u0012$\bM\u001b/gUJt%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!aeR\u0004\u0007\r\u001e1a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%T%M\u0019&\u001bViQ(O\t\u001eb\u0003\u0005V%N\u000b\u001e\u0002\u0014HO\u001a3uA*d&\r\u001a4iU2t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!aeR4G\r\u001e1k9\n$g\r\u0006!A\u0005)qM]8va\u0006\u0012\u0011QQ\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\tY)A\u00035]Er\u0003'A\u0005US6,GK];oGB\u0011a\u0006G\n\u00061\u0005M\u0015q\u0014\t\b\u0003+\u000bYjS&T\u001b\t\t9JC\u0002\u0002\u001af\nqA];oi&lW-\u0003\u0003\u0002\u001e\u0006]%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011\u0011UAT\u001b\t\t\u0019K\u0003\u0003\u0002&\u0006\u0005\u0012AA5p\u0013\r9\u00151\u0015\u000b\u0003\u0003\u001f\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00033\tQ!\u00199qYf$RaUAZ\u0003kCQ!S\u000eA\u0002-CQaT\u000eA\u0002-\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002<\u0006\u001d\u0007#\u0002\u001d\u0002>\u0006\u0005\u0017bAA`s\t1q\n\u001d;j_:\u0004R\u0001OAb\u0017.K1!!2:\u0005\u0019!V\u000f\u001d7fe!A\u0011\u0011\u001a\u000f\u0002\u0002\u0003\u00071+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a4\u0011\t\u0005m\u0011\u0011[\u0005\u0005\u0003'\fiB\u0001\u0004PE*,7\r\u001e")
public class TimeTrunc
extends BinaryExpression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
Serializable {
    private final Expression unit;
    private final Expression time;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(TimeTrunc x$0) {
        return TimeTrunc$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, TimeTrunc> tupled() {
        return TimeTrunc$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, TimeTrunc>> curried() {
        return TimeTrunc$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        TimeTrunc timeTrunc = this;
        synchronized (timeTrunc) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if (!this.bitmap$0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression unit() {
        return this.unit;
    }

    public Expression time() {
        return this.time;
    }

    @Override
    public Expression left() {
        return this.unit();
    }

    @Override
    public Expression right() {
        return this.time();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)AnyTimeType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return this.time().dataType();
    }

    @Override
    public String prettyName() {
        return "time_trunc";
    }

    @Override
    public TimeTrunc withNewChildrenInternal(Expression newUnit, Expression newTime) {
        return this.copy(newUnit, newTime);
    }

    @Override
    public Expression replacement() {
        return new StaticInvoke(DateTimeUtils$.class, this.dataType(), "timeTrunc", (Seq<Expression>)new .colon.colon((Object)this.unit(), (List)new .colon.colon((Object)this.time(), (List)Nil$.MODULE$)), (Seq<AbstractDataType>)new .colon.colon((Object)this.unit().dataType(), (List)new .colon.colon((Object)this.time().dataType(), (List)Nil$.MODULE$)), StaticInvoke$.MODULE$.apply$default$6(), StaticInvoke$.MODULE$.apply$default$7(), StaticInvoke$.MODULE$.apply$default$8(), StaticInvoke$.MODULE$.apply$default$9());
    }

    public TimeTrunc copy(Expression unit, Expression time) {
        return new TimeTrunc(unit, time);
    }

    public Expression copy$default$1() {
        return this.unit();
    }

    public Expression copy$default$2() {
        return this.time();
    }

    @Override
    public String productPrefix() {
        return "TimeTrunc";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.unit();
            }
            case 1: {
                return this.time();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TimeTrunc;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "unit";
            }
            case 1: {
                return "time";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TimeTrunc)) return false;
        boolean bl = true;
        if (!bl) return false;
        TimeTrunc timeTrunc = (TimeTrunc)x$1;
        Expression expression = this.unit();
        Expression expression2 = timeTrunc.unit();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.time();
        Expression expression4 = timeTrunc.time();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!timeTrunc.canEqual(this)) return false;
        return true;
    }

    public TimeTrunc(Expression unit, Expression time) {
        this.unit = unit;
        this.time = time;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }
}

