/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.Flow;
import org.apache.spark.sql.pipelines.graph.FlowFunction;
import org.apache.spark.sql.pipelines.graph.GraphIdentifierManager$;
import org.apache.spark.sql.pipelines.graph.GraphRegistrationContext$TableType$;
import org.apache.spark.sql.pipelines.graph.GraphRegistrationContext$ViewType$;
import org.apache.spark.sql.pipelines.graph.PersistedView;
import org.apache.spark.sql.pipelines.graph.QueryContext;
import org.apache.spark.sql.pipelines.graph.QueryOrigin;
import org.apache.spark.sql.pipelines.graph.Table;
import org.apache.spark.sql.pipelines.graph.TemporaryView;
import org.apache.spark.sql.pipelines.graph.UnresolvedFlow;
import org.apache.spark.sql.pipelines.graph.View;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e\u0001B\u0011#\u0001=B\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005q!AA\t\u0001BC\u0002\u0013\u0005q\u0007\u0003\u0005F\u0001\t\u0005\t\u0015!\u00039\u0011!1\u0005A!b\u0001\n\u00039\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u000b1\u0003A\u0011A'\t\u000fM\u0003!\u0019!C\t)\"1\u0001\r\u0001Q\u0001\nUCq!\u0019\u0001C\u0002\u0013E!\r\u0003\u0004h\u0001\u0001\u0006Ia\u0019\u0005\bQ\u0002\u0011\r\u0011\"\u0005j\u0011\u0019q\u0007\u0001)A\u0005U\")q\u000e\u0001C\u0001a\")a\u000f\u0001C\u0001o\")!\u0010\u0001C\u0001w\")a\u0010\u0001C\u0001\u007f\"9\u0011q\u0001\u0001\u0005\n\u0005%\u0001bBA\u0017\u0001\u0011%\u0011q\u0006\u0005\b\u0003\u000b\u0002A\u0011BA$\u000f\u001d\t)F\tE\u0001\u0003/2a!\t\u0012\t\u0002\u0005e\u0003B\u0002'\u0017\t\u0003\tYFB\u0005\u0002^Y\u0001\n1%\t\u0002`\u001d9\u00111\u0010\f\t\n\u00055daBA2-!%\u0011Q\r\u0005\u0007\u0019j!\t!a\u001b\t\u000f\u0005=$\u0004\"\u0011\u0002r\u001d9\u0011Q\u0010\f\t\n\u0005edaBA:-!%\u0011Q\u000f\u0005\u0007\u0019z!\t!a\u001e\t\u000f\u0005=d\u0004\"\u0011\u0002r\tArI]1qQJ+w-[:ue\u0006$\u0018n\u001c8D_:$X\r\u001f;\u000b\u0005\r\"\u0013!B4sCBD'BA\u0013'\u0003%\u0001\u0018\u000e]3mS:,7O\u0003\u0002(Q\u0005\u00191/\u001d7\u000b\u0005%R\u0013!B:qCJ\\'BA\u0016-\u0003\u0019\t\u0007/Y2iK*\tQ&A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001aA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t1\u0011I\\=SK\u001a\fa\u0002Z3gCVdGoQ1uC2|w-F\u00019!\tI\u0004I\u0004\u0002;}A\u00111HM\u0007\u0002y)\u0011QHL\u0001\u0007yI|w\u000e\u001e \n\u0005}\u0012\u0014A\u0002)sK\u0012,g-\u0003\u0002B\u0005\n11\u000b\u001e:j]\u001eT!a\u0010\u001a\u0002\u001f\u0011,g-Y;mi\u000e\u000bG/\u00197pO\u0002\nq\u0002Z3gCVdG\u000fR1uC\n\f7/Z\u0001\u0011I\u00164\u0017-\u001e7u\t\u0006$\u0018MY1tK\u0002\na\u0002Z3gCVdGoU9m\u0007>tg-F\u0001I!\u0011I\u0014\n\u000f\u001d\n\u0005)\u0013%aA'ba\u0006yA-\u001a4bk2$8+\u001d7D_:4\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005\u001dB\u000b&\u000b\u0005\u0002P\u00015\t!\u0005C\u00037\u000f\u0001\u0007\u0001\bC\u0003E\u000f\u0001\u0007\u0001\bC\u0003G\u000f\u0001\u0007\u0001*\u0001\u0004uC\ndWm]\u000b\u0002+B\u0019akW/\u000e\u0003]S!\u0001W-\u0002\u000f5,H/\u00192mK*\u0011!LM\u0001\u000bG>dG.Z2uS>t\u0017B\u0001/X\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\t\u0003\u001fzK!a\u0018\u0012\u0003\u000bQ\u000b'\r\\3\u0002\u000fQ\f'\r\\3tA\u0005)a/[3xgV\t1\rE\u0002W7\u0012\u0004\"aT3\n\u0005\u0019\u0014#\u0001\u0002,jK^\faA^5foN\u0004\u0013!\u00024m_^\u001cX#\u00016\u0011\u0007Y[6\u000e\u0005\u0002PY&\u0011QN\t\u0002\u000f+:\u0014Xm]8mm\u0016$g\t\\8x\u0003\u00191Gn\\<tA\u0005i!/Z4jgR,'\u000fV1cY\u0016$\"!\u001d;\u0011\u0005E\u0012\u0018BA:3\u0005\u0011)f.\u001b;\t\u000bUt\u0001\u0019A/\u0002\u0011Q\f'\r\\3EK\u001a\fAB]3hSN$XM\u001d,jK^$\"!\u001d=\t\u000be|\u0001\u0019\u00013\u0002\u000fYLWm\u001e#fM\u0006a!/Z4jgR,'O\u00127poR\u0011\u0011\u000f \u0005\u0006{B\u0001\ra[\u0001\bM2|w\u000fR3g\u0003=!x\u000eR1uC\u001adwn^$sCBDWCAA\u0001!\ry\u00151A\u0005\u0004\u0003\u000b\u0011#!\u0004#bi\u00064Gn\\<He\u0006\u0004\b.\u0001\nbgN,'\u000f\u001e(p\tV\u0004H.[2bi\u0016\u001cHcB9\u0002\f\u0005\u0005\u0012q\u0005\u0005\b\u0003\u001b\u0011\u0002\u0019AA\b\u0003=\tX/\u00197jM&,G\rV1cY\u0016\u001c\b#BA\t\u00037if\u0002BA\n\u0003/q1aOA\u000b\u0013\u0005\u0019\u0014bAA\re\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u000f\u0003?\u00111aU3r\u0015\r\tIB\r\u0005\b\u0003G\u0011\u0002\u0019AA\u0013\u000391\u0018\r\\5eCR,GMV5foN\u0004R!!\u0005\u0002\u001c\u0011Dq!!\u000b\u0013\u0001\u0004\tY#\u0001\brk\u0006d\u0017NZ5fI\u001acwn^:\u0011\u000b\u0005E\u00111D6\u0002?\u0005\u001c8/\u001a:u\t\u0006$\u0018m]3u\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018j]+oSF,X\rF\u0004r\u0003c\t\t%a\u0011\t\u000f\u0005M2\u00031\u0001\u00026\u0005Q\u0011\u000eZ3oi&4\u0017.\u001a:\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000f'\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA \u0003s\u0011q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM\u001d\u0005\u0007'N\u0001\r!a\u0004\t\r\u0005\u001c\u0002\u0019AA\u0013\u0003q\t7o]3si\u001acwn^%eK:$\u0018NZ5fe&\u001bXK\\5rk\u0016$r!]A%\u0003\u001b\ny\b\u0003\u0004\u0002LQ\u0001\ra[\u0001\u0005M2|w\u000fC\u0004\u0002PQ\u0001\r!!\u0015\u0002\u0017\u0011\fG/Y:fiRK\b/\u001a\t\u0004\u0003'BbBA(\u0016\u0003a9%/\u00199i%\u0016<\u0017n\u001d;sCRLwN\\\"p]R,\u0007\u0010\u001e\t\u0003\u001fZ\u0019\"A\u0006\u0019\u0015\u0005\u0005]#a\u0003#bi\u0006\u001cX\r\u001e+za\u0016\u001c\"\u0001\u0007\u0019*\u0007aQbDA\u0005UC\ndW\rV=qKN!!\u0004MA4!\r\tI\u0007G\u0007\u0002-Q\u0011\u0011Q\u000e\t\u0004\u0003SR\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003a\u0012\u0001BV5foRK\b/Z\n\u0005=A\n9\u0007\u0006\u0002\u0002zA\u0019\u0011\u0011\u000e\u0010\u0002\u0013Q\u000b'\r\\3UsB,\u0017\u0001\u0003,jK^$\u0016\u0010]3\t\r!$\u0002\u0019AA\u0016\u0001")
public class GraphRegistrationContext {
    private final String defaultCatalog;
    private final String defaultDatabase;
    private final Map<String, String> defaultSqlConf;
    private final ListBuffer<Table> tables;
    private final ListBuffer<View> views;
    private final ListBuffer<UnresolvedFlow> flows;

    public String defaultCatalog() {
        return this.defaultCatalog;
    }

    public String defaultDatabase() {
        return this.defaultDatabase;
    }

    public Map<String, String> defaultSqlConf() {
        return this.defaultSqlConf;
    }

    public ListBuffer<Table> tables() {
        return this.tables;
    }

    public ListBuffer<View> views() {
        return this.views;
    }

    public ListBuffer<UnresolvedFlow> flows() {
        return this.flows;
    }

    public void registerTable(Table tableDef) {
        this.tables().$plus$eq((Object)tableDef);
    }

    public void registerView(View viewDef) {
        this.views().$plus$eq((Object)viewDef);
    }

    public void registerFlow(UnresolvedFlow flowDef) {
        Map x$1 = (Map)this.defaultSqlConf().$plus$plus(flowDef.sqlConf());
        TableIdentifier x$2 = flowDef.copy$default$1();
        TableIdentifier x$3 = flowDef.copy$default$2();
        FlowFunction x$4 = flowDef.copy$default$3();
        QueryContext x$5 = flowDef.copy$default$4();
        boolean x$6 = flowDef.copy$default$6();
        QueryOrigin x$7 = flowDef.copy$default$7();
        this.flows().$plus$eq((Object)flowDef.copy(x$2, x$3, x$4, x$5, (Map<String, String>)x$1, x$6, x$7));
    }

    public DataflowGraph toDataflowGraph() {
        if (this.tables().isEmpty() && ((ListBuffer)this.views().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends View, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof PersistedView) {
                    PersistedView persistedView = (PersistedView)A1;
                    return (B1)persistedView;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(View x1) {
                View view = x1;
                return view instanceof PersistedView;
            }
        })).isEmpty()) {
            throw new AnalysisException("RUN_EMPTY_PIPELINE", Predef$.MODULE$.Map().empty());
        }
        Seq qualifiedTables = (Seq)this.tables().toSeq().map((Function1 & Serializable)t -> t.copy(GraphIdentifierManager$.MODULE$.parseAndQualifyTableIdentifier(t.identifier(), (Option<String>)new Some((Object)this.defaultCatalog()), (Option<String>)new Some((Object)this.defaultDatabase())).identifier(), t.copy$default$2(), t.copy$default$3(), t.copy$default$4(), t.copy$default$5(), t.copy$default$6(), t.copy$default$7(), t.copy$default$8(), t.copy$default$9()));
        Seq validatedViews = (Seq)this.views().toSeq().collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphRegistrationContext $outer;

            public final <A1 extends View, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof TemporaryView) {
                    TemporaryView temporaryView = (TemporaryView)A1;
                    return (B1)temporaryView.copy(GraphIdentifierManager$.MODULE$.parseAndValidateTemporaryViewIdentifier(temporaryView.identifier()), temporaryView.copy$default$2(), temporaryView.copy$default$3(), temporaryView.copy$default$4(), temporaryView.copy$default$5());
                }
                if (A1 instanceof PersistedView) {
                    PersistedView persistedView = (PersistedView)A1;
                    return (B1)persistedView.copy(GraphIdentifierManager$.MODULE$.parseAndValidatePersistedViewIdentifier(persistedView.identifier(), (Option<String>)new Some((Object)this.$outer.defaultCatalog()), (Option<String>)new Some((Object)this.$outer.defaultDatabase())), persistedView.copy$default$2(), persistedView.copy$default$3(), persistedView.copy$default$4(), persistedView.copy$default$5());
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(View x2) {
                View view = x2;
                if (view instanceof TemporaryView) {
                    return true;
                }
                return view instanceof PersistedView;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Seq qualifiedFlows = (Seq)this.flows().toSeq().map((Function1 & Serializable)f -> {
            TableIdentifier tableIdentifier = f.identifier();
            TableIdentifier tableIdentifier2 = f.destinationIdentifier();
            boolean isImplicitFlow = !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
            boolean flowWritesToView = ((IterableOnceOps)validatedViews.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GraphRegistrationContext.$anonfun$toDataflowGraph$4(x$1)))).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)GraphRegistrationContext.$anonfun$toDataflowGraph$5(f, x$2)));
            if (isImplicitFlow && flowWritesToView) {
                return f;
            }
            return f.copy(GraphIdentifierManager$.MODULE$.parseAndQualifyFlowIdentifier(f.identifier(), (Option<String>)new Some((Object)this.defaultCatalog()), (Option<String>)new Some((Object)this.defaultDatabase())).identifier(), GraphIdentifierManager$.MODULE$.parseAndQualifyFlowIdentifier(f.destinationIdentifier(), (Option<String>)new Some((Object)this.defaultCatalog()), (Option<String>)new Some((Object)this.defaultDatabase())).identifier(), f.copy$default$3(), f.copy$default$4(), f.copy$default$5(), f.copy$default$6(), f.copy$default$7());
        });
        this.assertNoDuplicates((Seq<Table>)qualifiedTables, (Seq<View>)validatedViews, (Seq<UnresolvedFlow>)qualifiedFlows);
        Seq x$1 = qualifiedTables;
        Seq x$2 = validatedViews;
        Seq x$3 = qualifiedFlows;
        return new DataflowGraph((Seq<Flow>)x$3, (Seq<Table>)x$1, (Seq<View>)x$2);
    }

    private void assertNoDuplicates(Seq<Table> qualifiedTables, Seq<View> validatedViews, Seq<UnresolvedFlow> qualifiedFlows) {
        ((IterableOnceOps)((IterableOps)qualifiedTables.map((Function1 & Serializable)x$3 -> x$3.identifier())).$plus$plus((IterableOnce)validatedViews.map((Function1 & Serializable)x$4 -> x$4.identifier()))).foreach((Function1 & Serializable)identifier -> {
            this.assertDatasetIdentifierIsUnique(identifier, (Seq<Table>)qualifiedTables, (Seq<View>)validatedViews);
            return BoxedUnit.UNIT;
        });
        qualifiedFlows.foreach((Function1 & Serializable)flow -> {
            this.assertFlowIdentifierIsUnique(flow, GraphRegistrationContext$TableType$.MODULE$, (Seq<UnresolvedFlow>)qualifiedFlows);
            return BoxedUnit.UNIT;
        });
    }

    private void assertDatasetIdentifierIsUnique(TableIdentifier identifier, Seq<Table> tables, Seq<View> views) {
        Seq allDatasets = (Seq)((IterableOps)tables.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.identifier()), (Object)GraphRegistrationContext$TableType$.MODULE$))).$plus$plus((IterableOnce)views.map((Function1 & Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)v.identifier()), (Object)GraphRegistrationContext$ViewType$.MODULE$)));
        Map grouped = allDatasets.groupBy((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TableIdentifier id = (TableIdentifier)tuple2._1();
                return id;
            }
            throw new MatchError((Object)tuple2);
        });
        List list = ((IterableOnceOps)grouped.apply((Object)identifier)).toList();
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Tuple2 tuple2 = (Tuple2)colon2.head();
            List list2 = colon2.next$access$1();
            if (tuple2 != null) {
                .colon.colon colon3;
                Tuple2 tuple22;
                DatasetType firstType = (DatasetType)tuple2._2();
                if (list2 instanceof .colon.colon && (tuple22 = (Tuple2)(colon3 = (.colon.colon)list2).head()) != null) {
                    DatasetType secondType = (DatasetType)tuple22._2();
                    Seq sortedTypes = (Seq)new .colon.colon((Object)firstType.toString(), (List)new .colon.colon((Object)secondType.toString(), (List)Nil$.MODULE$)).sorted((Ordering)Ordering.String$.MODULE$);
                    throw new AnalysisException("PIPELINE_DUPLICATE_IDENTIFIERS.DATASET", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetName"), (Object)identifier.quotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetType1"), sortedTypes.head()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetType2"), sortedTypes.last())})));
                }
            }
        }
    }

    private void assertFlowIdentifierIsUnique(UnresolvedFlow flow, DatasetType datasetType, Seq<UnresolvedFlow> flows) {
        flows.groupBy((Function1 & Serializable)i -> i.identifier()).get((Object)flow.identifier()).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)GraphRegistrationContext.$anonfun$assertFlowIdentifierIsUnique$2(x$5))).foreach((Function1 & Serializable)duplicateFlows -> {
            UnresolvedFlow duplicateFlow = (UnresolvedFlow)((IterableOps)duplicateFlows.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)GraphRegistrationContext.$anonfun$assertFlowIdentifierIsUnique$4(flow, x$6)))).head();
            throw new AnalysisException("PIPELINE_DUPLICATE_IDENTIFIERS.FLOW", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flowName"), (Object)flow.identifier().unquotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetNames"), (Object)((IterableOnceOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{flow.destinationIdentifier().quotedString(), duplicateFlow.destinationIdentifier().quotedString()}))).mkString(","))})));
        });
    }

    public static final /* synthetic */ boolean $anonfun$toDataflowGraph$4(View x$1) {
        return x$1 instanceof TemporaryView;
    }

    public static final /* synthetic */ boolean $anonfun$toDataflowGraph$5(UnresolvedFlow f$1, View x$2) {
        TableIdentifier tableIdentifier = x$2.identifier();
        TableIdentifier tableIdentifier2 = f$1.destinationIdentifier();
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$assertFlowIdentifierIsUnique$2(Seq x$5) {
        return x$5.size() > 1;
    }

    public static final /* synthetic */ boolean $anonfun$assertFlowIdentifierIsUnique$4(UnresolvedFlow flow$1, UnresolvedFlow x$6) {
        UnresolvedFlow unresolvedFlow = x$6;
        UnresolvedFlow unresolvedFlow2 = flow$1;
        return unresolvedFlow == null ? unresolvedFlow2 != null : !((Object)unresolvedFlow).equals(unresolvedFlow2);
    }

    public GraphRegistrationContext(String defaultCatalog, String defaultDatabase, Map<String, String> defaultSqlConf) {
        this.defaultCatalog = defaultCatalog;
        this.defaultDatabase = defaultDatabase;
        this.defaultSqlConf = defaultSqlConf;
        this.tables = new ListBuffer();
        this.views = new ListBuffer();
        this.flows = new ListBuffer();
    }

    public static interface DatasetType {
    }
}

