/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.server.BlockPushNonFatalFailure;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;

public class BlockPushReturnCode
extends BlockTransferMessage {
    public final byte returnCode;
    public final String failureBlockId;

    public BlockPushReturnCode(byte returnCode, String failureBlockId) {
        Objects.requireNonNull(BlockPushNonFatalFailure.getReturnCode((byte)returnCode));
        this.returnCode = returnCode;
        this.failureBlockId = failureBlockId;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.PUSH_BLOCK_RETURN_CODE;
    }

    public int hashCode() {
        return Objects.hash(this.returnCode, this.failureBlockId);
    }

    public String toString() {
        return "BlockPushReturnCode[returnCode=" + this.returnCode + ",failureBlockId=" + this.failureBlockId + "]";
    }

    public boolean equals(Object other) {
        if (other instanceof BlockPushReturnCode) {
            BlockPushReturnCode o = (BlockPushReturnCode)other;
            return this.returnCode == o.returnCode && Objects.equals(this.failureBlockId, o.failureBlockId);
        }
        return false;
    }

    public int encodedLength() {
        return 1 + Encoders.Strings.encodedLength((String)this.failureBlockId);
    }

    public void encode(ByteBuf buf) {
        buf.writeByte((int)this.returnCode);
        Encoders.Strings.encode((ByteBuf)buf, (String)this.failureBlockId);
    }

    public static BlockPushReturnCode decode(ByteBuf buf) {
        byte type = buf.readByte();
        String failureBlockId = Encoders.Strings.decode((ByteBuf)buf);
        return new BlockPushReturnCode(type, failureBlockId);
    }
}

