/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ClientSimpleScanner
extends ClientScanner {
    public ClientSimpleScanner(Configuration configuration, Scan scan, Scan scanForMetrics, TableName name, ClusterConnection connection, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcControllerFactory, ExecutorService pool, int scanReadRpcTimeout, int scannerTimeout, int replicaCallTimeoutMicroSecondScan, ConnectionConfiguration connectionConfiguration, Map<String, byte[]> requestAttributes) throws IOException {
        super(configuration, scan, scanForMetrics, name, connection, rpcCallerFactory, rpcControllerFactory, pool, scanReadRpcTimeout, scannerTimeout, replicaCallTimeoutMicroSecondScan, connectionConfiguration, requestAttributes);
    }

    @Override
    protected boolean setNewStartKey() {
        if (ConnectionUtils.noMoreResultsForScan(this.scan, this.currentRegion)) {
            return false;
        }
        this.scan.withStartRow(this.currentRegion.getEndKey(), true);
        return true;
    }

    @Override
    protected ScannerCallable createScannerCallable() {
        if (!this.scan.includeStartRow() && !ConnectionUtils.isEmptyStartRow(this.scan.getStartRow())) {
            this.scan.withStartRow(ConnectionUtils.createClosestRowAfter(this.scan.getStartRow()), true);
        }
        return new ScannerCallable(this.getConnection(), this.getTable(), this.scan, this.scanMetrics, this.rpcControllerFactory, this.getScanReplicaId(), this.requestAttributes);
    }
}

