/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.zookeeper.server.admin;

import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.storm.shade.org.apache.zookeeper.Environment;
import org.apache.storm.shade.org.apache.zookeeper.KeeperException;
import org.apache.storm.shade.org.apache.zookeeper.Version;
import org.apache.storm.shade.org.apache.zookeeper.data.ACL;
import org.apache.storm.shade.org.apache.zookeeper.data.Id;
import org.apache.storm.shade.org.apache.zookeeper.server.DataNode;
import org.apache.storm.shade.org.apache.zookeeper.server.DataTree;
import org.apache.storm.shade.org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.storm.shade.org.apache.zookeeper.server.ServerMetrics;
import org.apache.storm.shade.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.storm.shade.org.apache.zookeeper.server.ZooTrace;
import org.apache.storm.shade.org.apache.zookeeper.server.admin.AuthRequest;
import org.apache.storm.shade.org.apache.zookeeper.server.admin.Command;
import org.apache.storm.shade.org.apache.zookeeper.server.admin.CommandResponse;
import org.apache.storm.shade.org.apache.zookeeper.server.admin.GetCommand;
import org.apache.storm.shade.org.apache.zookeeper.server.admin.PostCommand;
import org.apache.storm.shade.org.apache.zookeeper.server.auth.ProviderRegistry;
import org.apache.storm.shade.org.apache.zookeeper.server.auth.ServerAuthenticationProvider;
import org.apache.storm.shade.org.apache.zookeeper.server.persistence.SnapshotInfo;
import org.apache.storm.shade.org.apache.zookeeper.server.persistence.Util;
import org.apache.storm.shade.org.apache.zookeeper.server.quorum.Follower;
import org.apache.storm.shade.org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.storm.shade.org.apache.zookeeper.server.quorum.Leader;
import org.apache.storm.shade.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.storm.shade.org.apache.zookeeper.server.quorum.MultipleAddresses;
import org.apache.storm.shade.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.storm.shade.org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;
import org.apache.storm.shade.org.apache.zookeeper.server.quorum.ReadOnlyZooKeeperServer;
import org.apache.storm.shade.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.storm.shade.org.apache.zookeeper.server.util.RateLimiter;
import org.apache.storm.shade.org.apache.zookeeper.server.util.ZxidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Commands {
    static final Logger LOG = LoggerFactory.getLogger(Commands.class);
    static final String ADMIN_RATE_LIMITER_INTERVAL = "zookeeper.admin.rateLimiterIntervalInMS";
    private static final long rateLimiterInterval = Integer.parseInt(System.getProperty("zookeeper.admin.rateLimiterIntervalInMS", "300000"));
    static final String AUTH_INFO_SEPARATOR = " ";
    static final String ROOT_PATH = "/";
    private static Map<String, Command> commands = new HashMap<String, Command>();
    private static Set<String> primaryNames = new HashSet<String>();

    public static void registerCommand(Command command) {
        for (String name : command.getNames()) {
            Command prev = commands.put(name, command);
            if (prev == null) continue;
            LOG.warn("Re-registering command {} (primary name = {})", (Object)name, (Object)command.getPrimaryName());
        }
        primaryNames.add(command.getPrimaryName());
    }

    public static CommandResponse runGetCommand(String cmdName, ZooKeeperServer zkServer, Map<String, String> kwargs, String authInfo, HttpServletRequest request) {
        return Commands.runCommand(cmdName, zkServer, kwargs, null, authInfo, request, true);
    }

    public static CommandResponse runPostCommand(String cmdName, ZooKeeperServer zkServer, InputStream inputStream, String authInfo, HttpServletRequest request) {
        return Commands.runCommand(cmdName, zkServer, null, inputStream, authInfo, request, false);
    }

    private static CommandResponse runCommand(String cmdName, ZooKeeperServer zkServer, Map<String, String> kwargs, InputStream inputStream, String authInfo, HttpServletRequest request, boolean isGet) {
        Command command = Commands.getCommand(cmdName);
        if (command == null) {
            LOG.warn("Unknown command");
            return new CommandResponse(cmdName, "Unknown command: " + cmdName, 200);
        }
        if (command.isServerRequired() && (zkServer == null || !zkServer.isRunning())) {
            LOG.warn("This ZooKeeper instance is not currently serving requests for command");
            return new CommandResponse(cmdName, "This ZooKeeper instance is not currently serving requests", 200);
        }
        AuthRequest authRequest = command.getAuthRequest();
        if (authRequest != null) {
            if (authInfo == null) {
                LOG.warn("Auth info is missing for command");
                return new CommandResponse(cmdName, "Auth info is missing for the command", 401);
            }
            try {
                List<Id> ids = Commands.handleAuthentication(request, authInfo);
                Commands.handleAuthorization(zkServer, ids, authRequest.getPermission(), authRequest.getPath());
            }
            catch (KeeperException.AuthFailedException e) {
                return new CommandResponse(cmdName, "Not authenticated", 401);
            }
            catch (KeeperException.NoAuthException e) {
                return new CommandResponse(cmdName, "Not authorized", 403);
            }
            catch (Exception e) {
                LOG.warn("Error occurred during auth for command", (Throwable)e);
                return new CommandResponse(cmdName, "Error occurred during auth", 500);
            }
        }
        return isGet ? command.runGet(zkServer, kwargs) : command.runPost(zkServer, inputStream);
    }

    private static List<Id> handleAuthentication(HttpServletRequest request, String authInfo) throws KeeperException.AuthFailedException {
        String[] authData = authInfo.split(AUTH_INFO_SEPARATOR);
        if (authData.length != 1 && authData.length != 2) {
            LOG.warn("Invalid auth info length");
            throw new KeeperException.AuthFailedException();
        }
        String schema = authData[0];
        ServerAuthenticationProvider authProvider = ProviderRegistry.getServerProvider(schema);
        if (authProvider != null) {
            try {
                byte[] auth = authData.length == 2 ? authData[1].getBytes(StandardCharsets.UTF_8) : null;
                List<Id> ids = authProvider.handleAuthentication(request, auth);
                if (ids.isEmpty()) {
                    LOG.warn("Auth Id list is empty");
                    throw new KeeperException.AuthFailedException();
                }
                return ids;
            }
            catch (RuntimeException e) {
                LOG.warn("Caught runtime exception from AuthenticationProvider", (Throwable)e);
                throw new KeeperException.AuthFailedException();
            }
        }
        LOG.warn("Auth provider not found for schema");
        throw new KeeperException.AuthFailedException();
    }

    private static void handleAuthorization(ZooKeeperServer zkServer, List<Id> ids, int perm, String path) throws KeeperException.NoNodeException, KeeperException.NoAuthException {
        DataNode dataNode = zkServer.getZKDatabase().getNode(path);
        if (dataNode == null) {
            throw new KeeperException.NoNodeException(path);
        }
        List<ACL> acls = zkServer.getZKDatabase().aclForNode(dataNode);
        zkServer.checkACL(null, acls, perm, ids, path, null);
    }

    public static Set<String> getPrimaryNames() {
        return primaryNames;
    }

    public static Command getCommand(String cmdName) {
        return commands.get(cmdName);
    }

    private Commands() {
    }

    static /* synthetic */ long access$000() {
        return rateLimiterInterval;
    }

    static {
        Commands.registerCommand(new CnxnStatResetCommand());
        Commands.registerCommand(new ConfCommand());
        Commands.registerCommand(new ConsCommand());
        Commands.registerCommand(new DigestCommand());
        Commands.registerCommand(new DirsCommand());
        Commands.registerCommand(new DumpCommand());
        Commands.registerCommand(new EnvCommand());
        Commands.registerCommand(new GetTraceMaskCommand());
        Commands.registerCommand(new InitialConfigurationCommand());
        Commands.registerCommand(new IsroCommand());
        Commands.registerCommand(new LastSnapshotCommand());
        Commands.registerCommand(new LeaderCommand());
        Commands.registerCommand(new MonitorCommand());
        Commands.registerCommand(new ObserverCnxnStatResetCommand());
        Commands.registerCommand(new RestoreCommand());
        Commands.registerCommand(new RuokCommand());
        Commands.registerCommand(new SetTraceMaskCommand());
        Commands.registerCommand(new SnapshotCommand());
        Commands.registerCommand(new SrvrCommand());
        Commands.registerCommand(new StatCommand());
        Commands.registerCommand(new StatResetCommand());
        Commands.registerCommand(new SyncedObserverConsCommand());
        Commands.registerCommand(new SystemPropertiesCommand());
        Commands.registerCommand(new VotingViewCommand());
        Commands.registerCommand(new WatchCommand());
        Commands.registerCommand(new WatchesByPathCommand());
        Commands.registerCommand(new WatchSummaryCommand());
        Commands.registerCommand(new ZabStateCommand());
    }

    public static class ZabStateCommand
    extends GetCommand {
        public ZabStateCommand() {
            super(Arrays.asList("zabstate"), false);
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            if (zkServer instanceof QuorumZooKeeperServer) {
                QuorumPeer peer = ((QuorumZooKeeperServer)zkServer).self;
                QuorumPeer.ZabState zabState = peer.getZabState();
                QuorumVerifier qv = peer.getQuorumVerifier();
                QuorumPeer.QuorumServer voter = qv.getVotingMembers().get(peer.getMyId());
                boolean voting = voter != null && voter.addr.equals(peer.getQuorumAddress()) && voter.electionAddr.equals(peer.getElectionAddress());
                response.put("myid", zkServer.getConf().getServerId());
                response.put("is_leader", zkServer instanceof LeaderZooKeeperServer);
                response.put("quorum_address", peer.getQuorumAddress());
                response.put("election_address", peer.getElectionAddress());
                response.put("client_address", peer.getClientAddress());
                response.put("voting", voting);
                long lastProcessedZxid = zkServer.getZKDatabase().getDataTreeLastProcessedZxid();
                response.put("last_zxid", "0x" + ZxidUtils.zxidToString(lastProcessedZxid));
                response.put("zab_epoch", ZxidUtils.getEpochFromZxid(lastProcessedZxid));
                response.put("zab_counter", ZxidUtils.getCounterFromZxid(lastProcessedZxid));
                response.put("zabstate", zabState.name().toLowerCase());
            } else {
                response.put("voting", false);
                response.put("zabstate", "");
            }
            return response;
        }
    }

    public static class WatchSummaryCommand
    extends GetCommand {
        public WatchSummaryCommand() {
            super(Arrays.asList("watch_summary", "wchs"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            DataTree dt = zkServer.getZKDatabase().getDataTree();
            CommandResponse response = this.initializeResponse();
            response.putAll(dt.getWatchesSummary().toMap());
            return response;
        }
    }

    public static class WatchesByPathCommand
    extends GetCommand {
        public WatchesByPathCommand() {
            super(Arrays.asList("watches_by_path", "wchp"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            DataTree dt = zkServer.getZKDatabase().getDataTree();
            CommandResponse response = this.initializeResponse();
            response.put("path_to_session_ids", dt.getWatchesByPath().toMap());
            return response;
        }
    }

    public static class WatchCommand
    extends GetCommand {
        public WatchCommand() {
            super(Arrays.asList("watches", "wchc"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            DataTree dt = zkServer.getZKDatabase().getDataTree();
            CommandResponse response = this.initializeResponse();
            response.put("session_id_to_watched_paths", dt.getWatches().toMap());
            return response;
        }
    }

    public static class VotingViewCommand
    extends GetCommand {
        public VotingViewCommand() {
            super(Arrays.asList("voting_view"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            if (zkServer instanceof QuorumZooKeeperServer) {
                QuorumPeer peer = ((QuorumZooKeeperServer)zkServer).self;
                Map<Long, QuorumServerView> votingView = peer.getVotingView().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new QuorumServerView((QuorumPeer.QuorumServer)e.getValue())));
                response.put("current_config", votingView);
            } else {
                response.put("current_config", Collections.emptyMap());
            }
            return response;
        }

        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="class is used only for JSON serialization")
        private static class QuorumServerView {
            @JsonProperty
            private List<String> serverAddresses;
            @JsonProperty
            private List<String> electionAddresses;
            @JsonProperty
            private String clientAddress;
            @JsonProperty
            private String learnerType;

            public QuorumServerView(QuorumPeer.QuorumServer quorumServer) {
                this.serverAddresses = QuorumServerView.getMultiAddressString(quorumServer.addr);
                this.electionAddresses = QuorumServerView.getMultiAddressString(quorumServer.electionAddr);
                this.learnerType = quorumServer.type.equals((Object)QuorumPeer.LearnerType.PARTICIPANT) ? "participant" : "observer";
                this.clientAddress = QuorumServerView.getAddressString(quorumServer.clientAddr);
            }

            private static List<String> getMultiAddressString(MultipleAddresses multipleAddresses) {
                if (multipleAddresses == null) {
                    return Collections.emptyList();
                }
                return multipleAddresses.getAllAddresses().stream().map(QuorumServerView::getAddressString).collect(Collectors.toList());
            }

            private static String getAddressString(InetSocketAddress address) {
                if (address == null) {
                    return "";
                }
                return String.format("%s:%d", QuorumPeer.QuorumServer.delimitedHostString(address), address.getPort());
            }
        }
    }

    public static class SystemPropertiesCommand
    extends GetCommand {
        public SystemPropertiesCommand() {
            super(Arrays.asList("system_properties", "sysp"), false);
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            Properties systemProperties = System.getProperties();
            TreeMap sortedSystemProperties = new TreeMap();
            systemProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> sortedSystemProperties.put(k.toString(), v.toString())));
            response.putAll(sortedSystemProperties);
            return response;
        }
    }

    public static class SyncedObserverConsCommand
    extends GetCommand {
        public SyncedObserverConsCommand() {
            super(Arrays.asList("observers", "obsr"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            Follower follower;
            Integer syncedObservers;
            CommandResponse response = this.initializeResponse();
            if (zkServer instanceof LeaderZooKeeperServer) {
                Leader leader = ((LeaderZooKeeperServer)zkServer).getLeader();
                response.put("synced_observers", leader.getObservingLearners().size());
                response.put("observers", leader.getObservingLearnersInfo());
                return response;
            }
            if (zkServer instanceof FollowerZooKeeperServer && (syncedObservers = (follower = ((FollowerZooKeeperServer)zkServer).getFollower()).getSyncedObserverSize()) != null) {
                response.put("synced_observers", syncedObservers);
                response.put("observers", follower.getSyncedObserversInfo());
                return response;
            }
            response.put("synced_observers", 0);
            response.put("observers", Collections.emptySet());
            return response;
        }
    }

    public static class StatResetCommand
    extends GetCommand {
        public StatResetCommand() {
            super(Arrays.asList("stat_reset", "srst"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            zkServer.serverStats().reset();
            return response;
        }
    }

    public static class StatCommand
    extends SrvrCommand {
        public StatCommand() {
            super(Arrays.asList("stats", "stat"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = super.runGet(zkServer, kwargs);
            Iterable<Object> connections = zkServer.getServerCnxnFactory() != null ? zkServer.getServerCnxnFactory().getAllConnectionInfo(true) : Collections.emptyList();
            response.put("connections", connections);
            Iterable<Object> secureConnections = zkServer.getSecureServerCnxnFactory() != null ? zkServer.getSecureServerCnxnFactory().getAllConnectionInfo(true) : Collections.emptyList();
            response.put("secure_connections", secureConnections);
            return response;
        }
    }

    public static class SrvrCommand
    extends GetCommand {
        public SrvrCommand() {
            super(Arrays.asList("server_stats", "srvr"));
        }

        protected SrvrCommand(List<String> names) {
            super(names);
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            LOG.info("running stat");
            response.put("version", Version.getFullVersion());
            response.put("read_only", zkServer instanceof ReadOnlyZooKeeperServer);
            response.put("server_stats", zkServer.serverStats());
            response.put("client_response", zkServer.serverStats().getClientResponseStats());
            if (zkServer instanceof LeaderZooKeeperServer) {
                Leader leader = ((LeaderZooKeeperServer)zkServer).getLeader();
                response.put("proposal_stats", leader.getProposalStats());
            }
            response.put("node_count", zkServer.getZKDatabase().getNodeCount());
            return response;
        }
    }

    public static class SnapshotCommand
    extends GetCommand {
        static final String REQUEST_QUERY_PARAM_STREAMING = "streaming";
        static final String RESPONSE_HEADER_LAST_ZXID = "last_zxid";
        static final String RESPONSE_HEADER_SNAPSHOT_SIZE = "snapshot_size";
        static final String ADMIN_SNAPSHOT_ENABLED = "zookeeper.admin.snapshot.enabled";
        private final RateLimiter rateLimiter = new RateLimiter(1, Commands.access$000(), TimeUnit.MICROSECONDS);

        public SnapshotCommand() {
            super(Arrays.asList("snapshot", "snap"), true, new AuthRequest(31, Commands.ROOT_PATH));
        }

        @Override
        @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="FileInputStream is passed to CommandResponse and closed in StreamOutputter")
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            boolean snapshotEnabled = Boolean.parseBoolean(System.getProperty(ADMIN_SNAPSHOT_ENABLED, "true"));
            if (!snapshotEnabled) {
                response.setStatusCode(503);
                LOG.warn("Snapshot command is disabled");
                return response;
            }
            if (!zkServer.isSerializeLastProcessedZxidEnabled()) {
                response.setStatusCode(500);
                LOG.warn("Snapshot command requires serializeLastProcessedZxidEnable flag is set to true");
                return response;
            }
            if (!this.rateLimiter.allow()) {
                response.setStatusCode(429);
                ServerMetrics.getMetrics().SNAPSHOT_RATE_LIMITED_COUNT.add(1L);
                LOG.warn("Snapshot request was rate limited");
                return response;
            }
            boolean streaming = true;
            if (kwargs.containsKey(REQUEST_QUERY_PARAM_STREAMING)) {
                streaming = Boolean.parseBoolean(kwargs.get(REQUEST_QUERY_PARAM_STREAMING));
            }
            try {
                File snapshotFile = zkServer.takeSnapshot(false, false, true);
                long lastZxid = Util.getZxidFromName(snapshotFile.getName(), "snapshot");
                response.addHeader(RESPONSE_HEADER_LAST_ZXID, "0x" + ZxidUtils.zxidToString(lastZxid));
                long size = snapshotFile.length();
                response.addHeader(RESPONSE_HEADER_SNAPSHOT_SIZE, String.valueOf(size));
                if (size == 0L) {
                    response.setStatusCode(500);
                    ServerMetrics.getMetrics().SNAPSHOT_ERROR_COUNT.add(1L);
                    LOG.warn("Snapshot file {} is empty", (Object)snapshotFile);
                } else if (streaming) {
                    response.setInputStream(new FileInputStream(snapshotFile));
                }
            }
            catch (Exception e) {
                response.setStatusCode(500);
                ServerMetrics.getMetrics().SNAPSHOT_ERROR_COUNT.add(1L);
                LOG.warn("Exception occurred when taking the snapshot via the snapshot admin command", (Throwable)e);
            }
            return response;
        }
    }

    public static class SetTraceMaskCommand
    extends GetCommand {
        public SetTraceMaskCommand() {
            super(Arrays.asList("set_trace_mask", "stmk"), false);
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            long traceMask;
            CommandResponse response = this.initializeResponse();
            if (!kwargs.containsKey("traceMask")) {
                response.put("error", "setTraceMask requires long traceMask argument");
                return response;
            }
            try {
                traceMask = Long.parseLong(kwargs.get("traceMask"));
            }
            catch (NumberFormatException e) {
                response.put("error", "setTraceMask requires long traceMask argument, got " + kwargs.get("traceMask"));
                return response;
            }
            ZooTrace.setTextTraceLevel(traceMask);
            response.put("tracemask", traceMask);
            return response;
        }
    }

    public static class RuokCommand
    extends GetCommand {
        public RuokCommand() {
            super(Arrays.asList("ruok"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            return this.initializeResponse();
        }
    }

    public static class RestoreCommand
    extends PostCommand {
        static final String RESPONSE_DATA_LAST_ZXID = "last_zxid";
        static final String ADMIN_RESTORE_ENABLED = "zookeeper.admin.restore.enabled";
        private RateLimiter rateLimiter = new RateLimiter(1, Commands.access$000(), TimeUnit.MILLISECONDS);

        public RestoreCommand() {
            super(Arrays.asList("restore", "rest"), true, new AuthRequest(31, Commands.ROOT_PATH));
        }

        @Override
        public CommandResponse runPost(ZooKeeperServer zkServer, InputStream inputStream) {
            CommandResponse response = this.initializeResponse();
            boolean restoreEnabled = Boolean.parseBoolean(System.getProperty(ADMIN_RESTORE_ENABLED, "true"));
            if (!restoreEnabled) {
                response.setStatusCode(503);
                LOG.warn("Restore command is disabled");
                return response;
            }
            if (!zkServer.isSerializeLastProcessedZxidEnabled()) {
                response.setStatusCode(500);
                LOG.warn("Restore command requires serializeLastProcessedZxidEnable flag is set to true");
                return response;
            }
            if (inputStream == null) {
                response.setStatusCode(400);
                LOG.warn("InputStream from restore request is null");
                return response;
            }
            if (!this.rateLimiter.allow()) {
                response.setStatusCode(429);
                ServerMetrics.getMetrics().RESTORE_RATE_LIMITED_COUNT.add(1L);
                LOG.warn("Restore request was rate limited");
                return response;
            }
            try {
                long lastZxid = zkServer.restoreFromSnapshot(inputStream);
                response.put(RESPONSE_DATA_LAST_ZXID, lastZxid);
            }
            catch (Exception e) {
                response.setStatusCode(500);
                ServerMetrics.getMetrics().RESTORE_ERROR_COUNT.add(1L);
                LOG.warn("Exception occurred when restore snapshot via the restore command", (Throwable)e);
            }
            return response;
        }
    }

    public static class ObserverCnxnStatResetCommand
    extends GetCommand {
        public ObserverCnxnStatResetCommand() {
            super(Arrays.asList("observer_connection_stat_reset", "orst"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            if (zkServer instanceof LeaderZooKeeperServer) {
                Leader leader = ((LeaderZooKeeperServer)zkServer).getLeader();
                leader.resetObserverConnectionStats();
            } else if (zkServer instanceof FollowerZooKeeperServer) {
                Follower follower = ((FollowerZooKeeperServer)zkServer).getFollower();
                follower.resetObserverConnectionStats();
            }
            return response;
        }
    }

    public static class MonitorCommand
    extends GetCommand {
        public MonitorCommand() {
            super(Arrays.asList("monitor", "mntr"), false);
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            zkServer.dumpMonitorValues(response::put);
            ServerMetrics.getMetrics().getMetricsProvider().dump(response::put);
            return response;
        }
    }

    public static class LeaderCommand
    extends GetCommand {
        public LeaderCommand() {
            super(Arrays.asList("leader", "lead"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            if (zkServer instanceof QuorumZooKeeperServer) {
                response.put("is_leader", zkServer instanceof LeaderZooKeeperServer);
                QuorumPeer peer = ((QuorumZooKeeperServer)zkServer).self;
                response.put("leader_id", peer.getLeaderId());
                String leaderAddress = peer.getLeaderAddress();
                response.put("leader_ip", leaderAddress != null ? leaderAddress : "");
            } else {
                response.put("error", "server is not initialized");
            }
            return response;
        }
    }

    public static class LastSnapshotCommand
    extends GetCommand {
        public LastSnapshotCommand() {
            super(Arrays.asList("last_snapshot", "lsnp"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            SnapshotInfo info = zkServer.getTxnLogFactory().getLastSnapshotInfo();
            response.put("zxid", Long.toHexString(info == null ? -1L : info.zxid));
            response.put("timestamp", info == null ? -1L : info.timestamp);
            return response;
        }
    }

    public static class IsroCommand
    extends GetCommand {
        public IsroCommand() {
            super(Arrays.asList("is_read_only", "isro"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            response.put("read_only", zkServer instanceof ReadOnlyZooKeeperServer);
            return response;
        }
    }

    public static class InitialConfigurationCommand
    extends GetCommand {
        public InitialConfigurationCommand() {
            super(Arrays.asList("initial_configuration", "icfg"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            response.put("initial_configuration", zkServer.getInitialConfig());
            return response;
        }
    }

    public static class GetTraceMaskCommand
    extends GetCommand {
        public GetTraceMaskCommand() {
            super(Arrays.asList("get_trace_mask", "gtmk"), false);
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            response.put("tracemask", ZooTrace.getTextTraceLevel());
            return response;
        }
    }

    public static class DigestCommand
    extends GetCommand {
        public DigestCommand() {
            super(Arrays.asList("hash"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            response.put("digests", zkServer.getZKDatabase().getDataTree().getDigestLog());
            return response;
        }
    }

    public static class EnvCommand
    extends GetCommand {
        public EnvCommand() {
            super(Arrays.asList("environment", "env", "envi"), false);
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            for (Environment.Entry e : Environment.list()) {
                response.put(e.getKey(), e.getValue());
            }
            return response;
        }
    }

    public static class DumpCommand
    extends GetCommand {
        public DumpCommand() {
            super(Arrays.asList("dump"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            response.put("expiry_time_to_session_ids", zkServer.getSessionExpiryMap());
            response.put("session_id_to_ephemeral_paths", zkServer.getEphemerals());
            return response;
        }
    }

    public static class DirsCommand
    extends GetCommand {
        public DirsCommand() {
            super(Arrays.asList("dirs"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            response.put("datadir_size", zkServer.getDataDirSize());
            response.put("logdir_size", zkServer.getLogDirSize());
            return response;
        }
    }

    public static class ConsCommand
    extends GetCommand {
        public ConsCommand() {
            super(Arrays.asList("connections", "cons"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            ServerCnxnFactory serverCnxnFactory = zkServer.getServerCnxnFactory();
            if (serverCnxnFactory != null) {
                response.put("connections", serverCnxnFactory.getAllConnectionInfo(false));
            } else {
                response.put("connections", Collections.emptyList());
            }
            ServerCnxnFactory secureServerCnxnFactory = zkServer.getSecureServerCnxnFactory();
            if (secureServerCnxnFactory != null) {
                response.put("secure_connections", secureServerCnxnFactory.getAllConnectionInfo(false));
            } else {
                response.put("secure_connections", Collections.emptyList());
            }
            return response;
        }
    }

    public static class ConfCommand
    extends GetCommand {
        public ConfCommand() {
            super(Arrays.asList("configuration", "conf", "config"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            response.putAll(zkServer.getConf().toMap());
            return response;
        }
    }

    public static class CnxnStatResetCommand
    extends GetCommand {
        public CnxnStatResetCommand() {
            super(Arrays.asList("connection_stat_reset", "crst"));
        }

        @Override
        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            CommandResponse response = this.initializeResponse();
            zkServer.getServerCnxnFactory().resetAllConnectionStats();
            return response;
        }
    }
}

