/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.storm.task.TopologyContext;

public interface IEventLogger {
    public void prepare(Map<String, Object> var1, Map<String, Object> var2, TopologyContext var3);

    public void log(EventInfo var1);

    public void close();

    public static class EventInfo {
        private long ts;
        private String component;
        private int task;
        private Object messageId;
        private List<Object> values;

        public EventInfo(long ts, String component, int task, Object messageId, List<Object> values) {
            this.ts = ts;
            this.component = component;
            this.task = task;
            this.messageId = messageId;
            this.values = values;
        }

        public long getTs() {
            return this.ts;
        }

        public String getComponent() {
            return this.component;
        }

        public int getTask() {
            return this.task;
        }

        public Object getMessageId() {
            return this.messageId;
        }

        public List<Object> getValues() {
            return this.values;
        }

        public String toString() {
            return new Date(this.ts).toString() + "," + this.component + "," + String.valueOf(this.task) + "," + (this.messageId == null ? "" : this.messageId.toString()) + "," + this.values.toString();
        }
    }
}

