/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.storm.security.auth.IGroupMappingServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedGroupsMapping
implements IGroupMappingServiceProvider {
    public static final String STORM_FIXED_GROUP_MAPPING = "storm.fixed.group.mapping";
    public static Logger LOG = LoggerFactory.getLogger(FixedGroupsMapping.class);
    public Map<String, Set<String>> cachedGroups = new HashMap<String, Set<String>>();

    @Override
    public void prepare(Map<String, Object> stormConf) {
        Map params = (Map)stormConf.get("storm.group.mapping.service.params");
        Map mapping = (Map)params.get(STORM_FIXED_GROUP_MAPPING);
        if (mapping != null) {
            this.cachedGroups.putAll(mapping);
        } else {
            LOG.warn("There is no initial group mapping");
        }
    }

    @Override
    public Set<String> getGroups(String user) throws IOException {
        if (this.cachedGroups.containsKey(user)) {
            return this.cachedGroups.get(user);
        }
        return new HashSet<String>();
    }
}

