/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.operation.builtin;

import java.math.BigDecimal;
import org.apache.storm.trident.operation.CombinerAggregator;
import org.apache.storm.trident.tuple.TridentTuple;

public class Sum
implements CombinerAggregator<Number> {
    private static BigDecimal asBigDecimal(Number val) {
        BigDecimal ret = val instanceof BigDecimal ? (BigDecimal)val : new BigDecimal(val.doubleValue());
        return ret;
    }

    @Override
    public Number init(TridentTuple tuple) {
        return (Number)tuple.getValue(0);
    }

    @Override
    public Number combine(Number val1, Number val2) {
        if (val1 instanceof BigDecimal || val2 instanceof BigDecimal) {
            BigDecimal v1 = Sum.asBigDecimal(val1);
            BigDecimal v2 = Sum.asBigDecimal(val2);
            return v1.add(v2);
        }
        if (val1 instanceof Double || val2 instanceof Double) {
            return val1.doubleValue() + val2.doubleValue();
        }
        return val1.longValue() + val2.longValue();
    }

    @Override
    public Number zero() {
        return 0;
    }
}

