/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.DaemonConfig;
import org.apache.storm.container.ResourceIsolationInterface;
import org.apache.storm.container.oci.OciContainerManager;
import org.apache.storm.daemon.nimbus.Nimbus;
import org.apache.storm.daemon.supervisor.AdvancedFSOps;
import org.apache.storm.daemon.supervisor.Container;
import org.apache.storm.daemon.supervisor.ContainerMemoryTracker;
import org.apache.storm.daemon.supervisor.ContainerRecoveryException;
import org.apache.storm.daemon.supervisor.ExitCodeCallback;
import org.apache.storm.daemon.supervisor.SupervisorUtils;
import org.apache.storm.generated.LocalAssignment;
import org.apache.storm.generated.ProfileAction;
import org.apache.storm.generated.ProfileRequest;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.generated.WorkerResources;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.shade.com.google.common.base.Joiner;
import org.apache.storm.shade.com.google.common.collect.Lists;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.LocalState;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ServerUtils;
import org.apache.storm.utils.SimpleVersion;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.apache.storm.utils.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicContainer
extends Container {
    static final TopoMetaLruCache TOPO_META_CACHE = new TopoMetaLruCache();
    private static final Logger LOG = LoggerFactory.getLogger(BasicContainer.class);
    private static final Joiner CPJ = Joiner.on((String)File.pathSeparator).skipNulls();
    protected final LocalState localState;
    protected final String profileCmd;
    protected final String stormHome = System.getProperty("storm.home");
    protected final double hardMemoryLimitMultiplier;
    protected final long hardMemoryLimitOver;
    protected final long lowMemoryThresholdMb;
    protected final long mediumMemoryThresholdMb;
    protected final long mediumMemoryGracePeriodMs;
    protected volatile boolean exitedEarly = false;
    protected volatile long memoryLimitMb;
    protected volatile long memoryLimitExceededStart = -1L;

    public BasicContainer(Container.ContainerType type, Map<String, Object> conf, String supervisorId, int supervisorPort, int port, LocalAssignment assignment, ResourceIsolationInterface resourceIsolationManager, LocalState localState, String workerId, StormMetricsRegistry metricsRegistry, ContainerMemoryTracker containerMemoryTracker) throws IOException {
        this(type, conf, supervisorId, supervisorPort, port, assignment, resourceIsolationManager, localState, workerId, metricsRegistry, containerMemoryTracker, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BasicContainer(Container.ContainerType type, Map<String, Object> conf, String supervisorId, int supervisorPort, int port, LocalAssignment assignment, ResourceIsolationInterface resourceIsolationManager, LocalState localState, String workerId, StormMetricsRegistry metricsRegistry, ContainerMemoryTracker containerMemoryTracker, Map<String, Object> topoConf, AdvancedFSOps ops, String profileCmd) throws IOException {
        super(type, conf, supervisorId, supervisorPort, port, assignment, resourceIsolationManager, workerId, topoConf, ops, metricsRegistry, containerMemoryTracker);
        if (localState == null) {
            throw new IOException("LocalState parameter value is null");
        }
        this.localState = localState;
        if (type.isRecovery() && !type.isOnlyKillable()) {
            LocalState localState2 = this.localState;
            synchronized (localState2) {
                String wid = null;
                Map workerToPort = this.localState.getApprovedWorkers();
                for (Map.Entry entry : workerToPort.entrySet()) {
                    if (port != (Integer)entry.getValue()) continue;
                    wid = (String)entry.getKey();
                }
                if (wid == null) {
                    throw new ContainerRecoveryException("Could not find worker id for " + port + " " + String.valueOf(assignment));
                }
                LOG.info("Recovered Worker {}", wid);
                this.workerId = wid;
            }
        } else if (this.workerId == null) {
            this.createNewWorkerId();
        }
        if (resourceIsolationManager instanceof OciContainerManager) {
            LOG.debug("Supervisor is using {} as the {}.The profiler set at worker.profiler.script.path in worker-launcher.cfg is the only profiler to be used. Please make sure it is configured properly", (Object)resourceIsolationManager.getClass().getName(), (Object)ResourceIsolationInterface.class.getName());
            this.profileCmd = "";
        } else {
            if (profileCmd == null) {
                profileCmd = this.stormHome + File.separator + "bin" + File.separator + String.valueOf(conf.get("worker.profiler.command"));
            }
            this.profileCmd = profileCmd;
        }
        this.hardMemoryLimitMultiplier = ObjectReader.getDouble((Object)conf.get(DaemonConfig.STORM_SUPERVISOR_HARD_MEMORY_LIMIT_MULTIPLIER), (Double)2.0);
        this.hardMemoryLimitOver = ObjectReader.getInt((Object)conf.get(DaemonConfig.STORM_SUPERVISOR_HARD_LIMIT_MEMORY_OVERAGE_MB), (Integer)0).intValue();
        this.lowMemoryThresholdMb = ObjectReader.getInt((Object)conf.get(DaemonConfig.STORM_SUPERVISOR_LOW_MEMORY_THRESHOLD_MB), (Integer)1024).intValue();
        this.mediumMemoryThresholdMb = ObjectReader.getInt((Object)conf.get(DaemonConfig.STORM_SUPERVISOR_MEDIUM_MEMORY_THRESHOLD_MB), (Integer)1536).intValue();
        this.mediumMemoryGracePeriodMs = ObjectReader.getInt((Object)conf.get(DaemonConfig.STORM_SUPERVISOR_MEDIUM_MEMORY_GRACE_PERIOD_MS), (Integer)20000).intValue();
        if (assignment != null) {
            WorkerResources resources = assignment.get_resources();
            this.memoryLimitMb = this.calculateMemoryLimit(resources, this.getMemOnHeap(resources));
        }
    }

    private static void removeWorkersOn(Map<String, Integer> workerToPort, int port) {
        Iterator<Map.Entry<String, Integer>> i = workerToPort.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Integer> found = i.next();
            if (port != found.getValue()) continue;
            LOG.warn("Deleting worker {} from state", (Object)found.getKey());
            i.remove();
        }
    }

    public static List<String> getDependencyLocationsFor(Map<String, Object> conf, String topologyId, AdvancedFSOps ops, String stormRoot) throws IOException {
        return TOPO_META_CACHE.get(conf, topologyId, ops, stormRoot).getDepLocs();
    }

    public static String getStormVersionFor(Map<String, Object> conf, String topologyId, AdvancedFSOps ops, String stormRoot) throws IOException {
        return TOPO_META_CACHE.get(conf, topologyId, ops, stormRoot).getStormVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createNewWorkerId() {
        this.type.assertFull();
        if (this.workerId != null) {
            String err = "Incorrect usage of createNewWorkerId(), current workerId is " + this.workerId + ", expecting null";
            LOG.error(err);
            throw new AssertionError((Object)err);
        }
        LocalState localState = this.localState;
        synchronized (localState) {
            this.workerId = Utils.uuid();
            HashMap<String, Integer> workerToPort = this.localState.getApprovedWorkers();
            if (workerToPort == null) {
                workerToPort = new HashMap<String, Integer>(1);
            }
            BasicContainer.removeWorkersOn((Map<String, Integer>)workerToPort, this.port);
            workerToPort.put(this.workerId, this.port);
            this.localState.setApprovedWorkers(workerToPort);
            LOG.info("Created Worker ID {}", (Object)this.workerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUpForRestart() throws IOException {
        String origWorkerId = this.workerId;
        super.cleanUpForRestart();
        LocalState localState = this.localState;
        synchronized (localState) {
            Map workersToPort = this.localState.getApprovedWorkers();
            if (workersToPort != null) {
                workersToPort.remove(origWorkerId);
                BasicContainer.removeWorkersOn(workersToPort, this.port);
                this.localState.setApprovedWorkers(workersToPort);
                LOG.info("Removed Worker ID {}", (Object)origWorkerId);
            } else {
                LOG.warn("No approved workers exists");
            }
        }
    }

    @Override
    public void relaunch() throws IOException {
        this.type.assertFull();
        this.type = Container.ContainerType.LAUNCH;
        this.createNewWorkerId();
        this.setup();
        this.launch();
    }

    @Override
    public boolean didMainProcessExit() {
        return this.exitedEarly;
    }

    @Override
    public boolean runProfiling(ProfileRequest request, boolean stop) throws IOException, InterruptedException {
        this.type.assertFull();
        String targetDir = ConfigUtils.workerArtifactsRoot((Map)this.conf, (String)this.topologyId, (Integer)this.port);
        HashMap<String, String> env = (HashMap<String, String>)this.topoConf.get("topology.environment");
        if (env == null) {
            env = new HashMap<String, String>();
        }
        String str = ConfigUtils.workerArtifactsPidPath((Map)this.conf, (String)this.topologyId, (Integer)this.port);
        String workerPid = this.ops.slurpString(new File(str)).trim();
        ProfileAction profileAction = request.get_action();
        String logPrefix = "ProfilerAction process " + this.topologyId + ":" + this.port + " PROFILER_ACTION: " + String.valueOf(profileAction) + " ";
        List<String> command = this.mkProfileCommand(profileAction, stop, workerPid, targetDir);
        File targetFile = new File(targetDir);
        if (command.size() > 0) {
            return this.resourceIsolationManager.runProfilingCommand(this.getWorkerUser(), this.workerId, command, env, logPrefix, targetFile);
        }
        LOG.warn("PROFILING REQUEST NOT SUPPORTED {} IGNORED...", (Object)request);
        return true;
    }

    private List<String> mkProfileCommand(ProfileAction action, boolean stop, String workerPid, String targetDir) {
        switch (action) {
            case JMAP_DUMP: {
                return this.jmapDumpCmd(workerPid, targetDir);
            }
            case JSTACK_DUMP: {
                return this.jstackDumpCmd(workerPid, targetDir);
            }
            case JPROFILE_DUMP: {
                return this.jprofileDump(workerPid, targetDir);
            }
            case JVM_RESTART: {
                return this.jprofileJvmRestart(workerPid);
            }
            case JPROFILE_STOP: {
                if (stop) {
                    return this.jprofileStop(workerPid, targetDir);
                }
                return this.jprofileStart(workerPid);
            }
        }
        return Lists.newArrayList();
    }

    private List<String> jmapDumpCmd(String pid, String targetDir) {
        return Lists.newArrayList((Object[])new String[]{this.profileCmd, pid, "jmap", targetDir});
    }

    private List<String> jstackDumpCmd(String pid, String targetDir) {
        return Lists.newArrayList((Object[])new String[]{this.profileCmd, pid, "jstack", targetDir});
    }

    private List<String> jprofileStart(String pid) {
        return Lists.newArrayList((Object[])new String[]{this.profileCmd, pid, "start"});
    }

    private List<String> jprofileStop(String pid, String targetDir) {
        return Lists.newArrayList((Object[])new String[]{this.profileCmd, pid, "stop", targetDir});
    }

    private List<String> jprofileDump(String pid, String targetDir) {
        return Lists.newArrayList((Object[])new String[]{this.profileCmd, pid, "dump", targetDir});
    }

    private List<String> jprofileJvmRestart(String pid) {
        return Lists.newArrayList((Object[])new String[]{this.profileCmd, pid, "kill"});
    }

    protected String javaLibraryPath(String stormRoot, Map<String, Object> conf) {
        String resourceRoot = stormRoot + File.separator + "resources";
        String os = System.getProperty("os.name").replaceAll("\\s+", "_");
        String arch = System.getProperty("os.arch");
        String archResourceRoot = resourceRoot + File.separator + os + "-" + arch;
        String ret = CPJ.join((Object)archResourceRoot, (Object)resourceRoot, new Object[]{conf.get("java.library.path")});
        return ret;
    }

    protected String getWildcardDir(File dir) {
        return dir.toString() + File.separator + "*";
    }

    protected List<String> frameworkClasspath(SimpleVersion topoVersion) {
        File stormWorkerLibDir = new File(this.stormHome, "lib-worker");
        String topoConfDir = System.getenv("STORM_CONF_DIR") != null ? System.getenv("STORM_CONF_DIR") : new File(this.stormHome, "conf").getAbsolutePath();
        File stormExtlibDir = new File(this.stormHome, "extlib");
        String extcp = System.getenv("STORM_EXT_CLASSPATH");
        LinkedList<String> pathElements = new LinkedList<String>();
        pathElements.add(this.getWildcardDir(stormWorkerLibDir));
        pathElements.add(this.getWildcardDir(stormExtlibDir));
        pathElements.add(extcp);
        pathElements.add(topoConfDir);
        NavigableMap classpaths = Utils.getConfiguredClasspathVersions((Map)this.conf, pathElements);
        return (List)Utils.getCompatibleVersion((NavigableMap)classpaths, (SimpleVersion)topoVersion, (String)"classpath", pathElements);
    }

    protected String getWorkerMain(SimpleVersion topoVersion) {
        String defaultWorkerGuess = "org.apache.storm.daemon.worker.Worker";
        if (topoVersion.getMajor() == 0) {
            defaultWorkerGuess = "backtype.storm.daemon.worker";
        } else if (topoVersion.getMajor() == 1) {
            defaultWorkerGuess = "org.apache.storm.daemon.worker";
        }
        NavigableMap mains = Utils.getConfiguredWorkerMainVersions((Map)this.conf);
        return (String)Utils.getCompatibleVersion((NavigableMap)mains, (SimpleVersion)topoVersion, (String)"worker main class", (Object)defaultWorkerGuess);
    }

    protected String getWorkerLogWriter(SimpleVersion topoVersion) {
        String defaultGuess = "org.apache.storm.LogWriter";
        if (topoVersion.getMajor() == 0) {
            defaultGuess = "backtype.storm.LogWriter";
        }
        NavigableMap mains = Utils.getConfiguredWorkerLogWriterVersions((Map)this.conf);
        return (String)Utils.getCompatibleVersion((NavigableMap)mains, (SimpleVersion)topoVersion, (String)"worker log writer class", (Object)defaultGuess);
    }

    private List<String> asStringList(Object o) {
        if (o instanceof String) {
            return Arrays.asList((String)o);
        }
        if (o instanceof List) {
            return (List)o;
        }
        return Collections.EMPTY_LIST;
    }

    protected String getWorkerClassPath(String stormJar, List<String> dependencyLocations, SimpleVersion topoVersion) {
        ArrayList<String> workercp = new ArrayList<String>();
        workercp.addAll(this.asStringList(this.topoConf.get("topology.classpath.beginning")));
        workercp.addAll(this.frameworkClasspath(topoVersion));
        workercp.add(stormJar);
        workercp.addAll(dependencyLocations);
        workercp.addAll(this.asStringList(this.topoConf.get("topology.classpath")));
        return CPJ.join(workercp);
    }

    private String substituteChildOptsInternal(String string, int memOnheap, int memOffheap) {
        if (StringUtils.isNotBlank((String)string)) {
            String p = String.valueOf(this.port);
            string = string.replace("%ID%", p);
            string = string.replace("%WORKER-ID%", this.workerId);
            string = string.replace("%TOPOLOGY-ID%", this.topologyId);
            string = string.replace("%WORKER-PORT%", p);
            if (memOnheap > 0) {
                string = string.replace("%HEAP-MEM%", String.valueOf(memOnheap));
            }
            if (memOffheap > 0) {
                string = string.replace("%OFF-HEAP-MEM%", String.valueOf(memOffheap));
            }
            if (this.memoryLimitMb > 0L) {
                string = string.replace("%LIMIT-MEM%", String.valueOf(this.memoryLimitMb));
            }
        }
        return string;
    }

    protected List<String> substituteChildopts(Object value) {
        return this.substituteChildopts(value, -1, -1);
    }

    protected List<String> substituteChildopts(Object value, int memOnheap, int memOffHeap) {
        ArrayList<String> rets;
        block4: {
            block3: {
                String[] strings;
                rets = new ArrayList<String>();
                if (!(value instanceof String)) break block3;
                String string = this.substituteChildOptsInternal((String)value, memOnheap, memOffHeap);
                if (!StringUtils.isNotBlank((String)string)) break block4;
                for (String s : strings = string.split("\\s+")) {
                    if (!StringUtils.isNotBlank((String)s)) continue;
                    rets.add(s);
                }
                break block4;
            }
            if (value instanceof List) {
                List objects = (List)value;
                for (String object : objects) {
                    String str = this.substituteChildOptsInternal(object, memOnheap, memOffHeap);
                    if (!StringUtils.isNotBlank((String)str)) continue;
                    rets.add(str);
                }
            }
        }
        return rets;
    }

    private String getWorkerLoggingConfigFile() {
        Object log4jConfigurationDir = (String)this.conf.get("storm.log4j2.conf.dir");
        if (StringUtils.isNotBlank((String)log4jConfigurationDir)) {
            if (!ServerUtils.isAbsolutePath((String)log4jConfigurationDir)) {
                log4jConfigurationDir = this.stormHome + File.separator + (String)log4jConfigurationDir;
            }
        } else {
            log4jConfigurationDir = this.stormHome + File.separator + "log4j2";
        }
        if (ServerUtils.IS_ON_WINDOWS && !((String)log4jConfigurationDir).startsWith("file:")) {
            log4jConfigurationDir = "file:///" + (String)log4jConfigurationDir;
        }
        return (String)log4jConfigurationDir + File.separator + "worker.xml";
    }

    private List<String> getClassPathParams(String stormRoot, SimpleVersion topoVersion) throws IOException {
        String stormJar = ConfigUtils.supervisorStormJarPath((String)stormRoot);
        List<String> dependencyLocations = BasicContainer.getDependencyLocationsFor(this.conf, this.topologyId, this.ops, stormRoot);
        String workerClassPath = this.getWorkerClassPath(stormJar, dependencyLocations, topoVersion);
        ArrayList<String> classPathParams = new ArrayList<String>();
        classPathParams.add("-cp");
        classPathParams.add(workerClassPath);
        return classPathParams;
    }

    private List<String> getCommonParams() {
        String workersArtifacts = ConfigUtils.workerArtifactsRoot((Map)this.conf);
        String stormLogDir = ConfigUtils.getLogDir();
        ArrayList<String> commonParams = new ArrayList<String>();
        commonParams.add("-Dlogging.sensitivity=" + (String)Utils.OR((Object)((String)this.topoConf.get("topology.logging.sensitivity")), (Object)"S3"));
        commonParams.add("-Dlogfile.name=worker.log");
        commonParams.add("-Dstorm.home=" + (String)Utils.OR((Object)this.stormHome, (Object)""));
        commonParams.add("-Dworkers.artifacts=" + workersArtifacts);
        commonParams.add("-Dstorm.id=" + this.topologyId);
        commonParams.add("-Dworker.id=" + this.workerId);
        commonParams.add("-Dworker.port=" + this.port);
        commonParams.add("-Dstorm.log.dir=" + stormLogDir);
        commonParams.add("-DLog4jContextSelector=org.apache.logging.log4j.core.selector.BasicContextSelector");
        commonParams.add("-Dstorm.local.dir=" + String.valueOf(this.conf.get("storm.local.dir")));
        if (this.memoryLimitMb > 0L) {
            commonParams.add("-Dworker.memory_limit_mb=" + this.memoryLimitMb);
        }
        return commonParams;
    }

    private int getMemOnHeap(WorkerResources resources) {
        int memOnheap = 0;
        memOnheap = resources != null && resources.is_set_mem_on_heap() && resources.get_mem_on_heap() > 0.0 ? (int)Math.ceil(resources.get_mem_on_heap()) : ObjectReader.getInt(this.topoConf.get("worker.heap.memory.mb"), (Integer)768);
        return memOnheap;
    }

    private int getMemOffHeap(WorkerResources resources) {
        int memOffheap = 0;
        if (resources != null && resources.is_set_mem_off_heap() && resources.get_mem_off_heap() > 0.0) {
            memOffheap = (int)Math.ceil(resources.get_mem_off_heap());
        }
        return memOffheap;
    }

    private List<String> getWorkerProfilerChildOpts(int memOnheap, int memOffheap) {
        List<String> workerProfilerChildopts = new ArrayList<String>();
        if (ObjectReader.getBoolean(this.conf.get("worker.profiler.enabled"), (boolean)false)) {
            workerProfilerChildopts = this.substituteChildopts(this.conf.get("worker.profiler.childopts"), memOnheap, memOffheap);
        }
        return workerProfilerChildopts;
    }

    protected String javaCmd(String cmd) {
        Object ret = null;
        String javaHome = System.getenv().get("JAVA_HOME");
        ret = StringUtils.isNotBlank((String)javaHome) ? javaHome + File.separator + "bin" + File.separator + cmd : cmd;
        return ret;
    }

    private List<String> mkLaunchCommand(int memOnheap, int memOffheap, String stormRoot, String jlp, String numaId) throws IOException {
        String javaCmd = this.javaCmd("java");
        String stormOptions = ConfigUtils.concatIfNotNull((String)System.getProperty("storm.options"));
        String topoConfFile = ConfigUtils.concatIfNotNull((String)System.getProperty("storm.conf.file"));
        String workerTmpDir = ConfigUtils.workerTmpRoot((Map)this.conf, (String)this.workerId);
        String topoVersionString = BasicContainer.getStormVersionFor(this.conf, this.topologyId, this.ops, stormRoot);
        if (topoVersionString == null) {
            topoVersionString = this.conf.getOrDefault("supervisor.worker.default.version", VersionInfo.getVersion());
        }
        SimpleVersion topoVersion = new SimpleVersion(topoVersionString);
        List<String> classPathParams = this.getClassPathParams(stormRoot, topoVersion);
        List<String> commonParams = this.getCommonParams();
        String log4jConfigurationFile = this.getWorkerLoggingConfigFile();
        Object workerLog4jConfig = log4jConfigurationFile;
        if (this.topoConf.get("topology.logging.config") != null) {
            workerLog4jConfig = (String)workerLog4jConfig + "," + String.valueOf(this.topoConf.get("topology.logging.config"));
        }
        ArrayList<String> commandList = new ArrayList<String>();
        String logWriter = this.getWorkerLogWriter(topoVersion);
        if (logWriter != null) {
            commandList.add(javaCmd);
            commandList.addAll(classPathParams);
            commandList.addAll(this.substituteChildopts(this.topoConf.get("topology.worker.logwriter.childopts")));
            commandList.addAll(commonParams);
            commandList.add("-Dlog4j.configurationFile=" + log4jConfigurationFile);
            commandList.add(logWriter);
        }
        commandList.add(javaCmd);
        commandList.add("-server");
        commandList.addAll(commonParams);
        commandList.add("-Dlog4j.configurationFile=" + (String)workerLog4jConfig);
        commandList.addAll(this.substituteChildopts(this.conf.get("worker.childopts"), memOnheap, memOffheap));
        commandList.addAll(this.substituteChildopts(this.topoConf.get("topology.worker.childopts"), memOnheap, memOffheap));
        commandList.addAll(this.substituteChildopts(Utils.OR(this.topoConf.get("topology.worker.gc.childopts"), this.conf.get("worker.gc.childopts")), memOnheap, memOffheap));
        commandList.addAll(this.getWorkerProfilerChildOpts(memOnheap, memOffheap));
        commandList.add("-Djava.library.path=" + jlp);
        commandList.add("-Dstorm.conf.file=" + topoConfFile);
        commandList.add("-Dstorm.options=" + stormOptions);
        commandList.add("-Djava.io.tmpdir=" + workerTmpDir);
        commandList.addAll(classPathParams);
        commandList.add(this.getWorkerMain(topoVersion));
        commandList.add(this.topologyId);
        Object supervisorId = this.supervisorId;
        if (numaId != null) {
            supervisorId = (String)supervisorId + "-numa-" + numaId;
        }
        commandList.add((String)supervisorId);
        if (topoVersion.getMajor() == -1 && topoVersion.getMinor() == -1 || topoVersion.compareTo(Nimbus.MIN_VERSION_SUPPORT_RPC_HEARTBEAT) >= 0) {
            commandList.add(String.valueOf(this.supervisorPort));
        }
        commandList.add(String.valueOf(this.port));
        commandList.add(this.workerId);
        return commandList;
    }

    @Override
    public boolean isMemoryLimitViolated(LocalAssignment withUpdatedLimits) throws IOException {
        if (super.isMemoryLimitViolated(withUpdatedLimits)) {
            return true;
        }
        if (this.resourceIsolationManager.isResourceManaged()) {
            String typeOfCheck;
            long hardMemoryLimitOver;
            long memoryLimitMb;
            long usageMb;
            if (withUpdatedLimits.is_set_total_node_shared()) {
                usageMb = this.getTotalTopologyMemoryUsed();
                memoryLimitMb = this.getTotalTopologyMemoryReserved(withUpdatedLimits);
                hardMemoryLimitOver = this.hardMemoryLimitOver * this.getTotalWorkersForThisTopology();
                typeOfCheck = "TOPOLOGY " + this.topologyId;
            } else {
                usageMb = this.getMemoryUsageMb();
                memoryLimitMb = this.memoryLimitMb;
                hardMemoryLimitOver = this.hardMemoryLimitOver;
                typeOfCheck = "WORKER " + this.workerId;
            }
            LOG.debug("Enforcing memory usage for {} with usage of {} out of {} total and a hard limit of {}", new Object[]{typeOfCheck, usageMb, memoryLimitMb, hardMemoryLimitOver});
            if (usageMb <= 0L) {
                return false;
            }
            long hardLimitMb = Math.max((long)((double)memoryLimitMb * this.hardMemoryLimitMultiplier), memoryLimitMb + hardMemoryLimitOver);
            if (usageMb > hardLimitMb) {
                LOG.warn("{} is using {} MB > adjusted hard limit {} MB", new Object[]{typeOfCheck, usageMb, hardLimitMb});
                return true;
            }
            if (usageMb > memoryLimitMb) {
                long systemFreeMemoryMb = 0L;
                try {
                    systemFreeMemoryMb = this.resourceIsolationManager.getSystemFreeMemoryMb();
                }
                catch (IOException e) {
                    LOG.warn("Error trying to calculate free memory on the system {}", (Throwable)e);
                }
                LOG.debug("SYSTEM MEMORY FREE {} MB", (Object)systemFreeMemoryMb);
                if (systemFreeMemoryMb <= this.lowMemoryThresholdMb) {
                    LOG.warn("{} is using {} MB > memory limit {} MB and system is low on memory {} free", new Object[]{typeOfCheck, usageMb, memoryLimitMb, systemFreeMemoryMb});
                    return true;
                }
                if (systemFreeMemoryMb < this.mediumMemoryThresholdMb) {
                    if (this.memoryLimitExceededStart < 0L) {
                        this.memoryLimitExceededStart = Time.currentTimeMillis();
                    } else {
                        long timeInViolation = Time.currentTimeMillis() - this.memoryLimitExceededStart;
                        if (timeInViolation > this.mediumMemoryGracePeriodMs) {
                            LOG.warn("{} is using {} MB > memory limit {} MB for {} seconds", new Object[]{typeOfCheck, usageMb, memoryLimitMb, timeInViolation / 1000L});
                            return true;
                        }
                    }
                } else {
                    LOG.debug("{} is using {} MB > memory limit {} MB", new Object[]{typeOfCheck, usageMb, memoryLimitMb});
                    this.memoryLimitExceededStart = -1L;
                }
            } else {
                this.memoryLimitExceededStart = -1L;
            }
        }
        return false;
    }

    @Override
    public long getMemoryUsageMb() {
        try {
            long usageBytes;
            long ret = 0L;
            if (this.resourceIsolationManager.isResourceManaged() && (usageBytes = this.resourceIsolationManager.getMemoryUsage(this.getWorkerUser(), this.workerId, this.port)) >= 0L) {
                ret = usageBytes / 1024L / 1024L;
            }
            return ret;
        }
        catch (IOException e) {
            LOG.warn("Error trying to calculate worker memory usage {}", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public long getMemoryReservationMb() {
        return this.memoryLimitMb;
    }

    private long calculateMemoryLimit(WorkerResources resources, int memOnHeap) {
        long ret = memOnHeap;
        if (this.resourceIsolationManager.isResourceManaged()) {
            int memoffheap = (int)Math.ceil(resources.get_mem_off_heap());
            int extraMem = (int)Math.ceil(ObjectReader.getDouble(this.conf.get(DaemonConfig.STORM_SUPERVISOR_MEMORY_LIMIT_TOLERANCE_MARGIN_MB), (Double)0.0));
            ret += (long)(memoffheap + extraMem);
        }
        return ret;
    }

    @Override
    public void launch() throws IOException {
        String ldLibraryPath;
        this.type.assertFull();
        String numaId = SupervisorUtils.getNumaIdForPort(this.port, this.conf);
        if (numaId == null) {
            LOG.info("Launching worker with assignment {} for this supervisor {} on port {} with id {}", new Object[]{this.assignment, this.supervisorId, this.port, this.workerId});
        } else {
            LOG.info("Launching worker with assignment {} for this supervisor {} on port {} with id {}  bound to numa zone {}", new Object[]{this.assignment, this.supervisorId, this.port, this.workerId, numaId});
        }
        this.exitedEarly = false;
        WorkerResources resources = this.assignment.get_resources();
        int memOnHeap = this.getMemOnHeap(resources);
        int memOffHeap = this.getMemOffHeap(resources);
        this.memoryLimitMb = this.calculateMemoryLimit(resources, memOnHeap);
        String stormRoot = ConfigUtils.supervisorStormDistRoot((Map)this.conf, (String)this.topologyId);
        Object jlp = this.javaLibraryPath(stormRoot, this.conf);
        HashMap<String, String> topEnvironment = new HashMap<String, String>();
        Map environment = (Map)this.topoConf.get("topology.environment");
        if (environment != null) {
            topEnvironment.putAll(environment);
        }
        if ((ldLibraryPath = (String)topEnvironment.get("LD_LIBRARY_PATH")) != null) {
            jlp = (String)jlp + System.getProperty("path.separator") + ldLibraryPath;
        }
        topEnvironment.put("LD_LIBRARY_PATH", (String)jlp);
        if (this.resourceIsolationManager.isResourceManaged()) {
            int cpu = (int)Math.ceil(resources.get_cpu());
            this.resourceIsolationManager.reserveResourcesForWorker(this.workerId, (int)this.memoryLimitMb, cpu, numaId);
        }
        List<String> commandList = this.mkLaunchCommand(memOnHeap, memOffHeap, stormRoot, (String)jlp, numaId);
        LOG.info("Launching worker with command: {}. ", (Object)ServerUtils.shellCmd(commandList));
        String workerDir = ConfigUtils.workerRoot((Map)this.conf, (String)this.workerId);
        String logPrefix = "Worker Process " + this.workerId;
        ProcessExitCallback processExitCallback = new ProcessExitCallback(logPrefix);
        this.resourceIsolationManager.launchWorkerProcess(this.getWorkerUser(), this.topologyId, this.topoConf, this.port, this.workerId, commandList, topEnvironment, logPrefix, processExitCallback, new File(workerDir));
    }

    static class TopoMetaLruCache {
        public final int maxSize = 100;
        private LinkedHashMap<String, TopologyMetaData> cache = new LinkedHashMap<String, TopologyMetaData>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, TopologyMetaData> eldest) {
                return this.size() > 100;
            }
        };

        TopoMetaLruCache() {
        }

        public synchronized TopologyMetaData get(Map<String, Object> conf, String topologyId, AdvancedFSOps ops, String stormRoot) {
            TopologyMetaData dl = this.cache.get(topologyId);
            if (dl == null) {
                this.cache.putIfAbsent(topologyId, new TopologyMetaData(conf, topologyId, ops, stormRoot));
                dl = this.cache.get(topologyId);
            }
            return dl;
        }

        public synchronized void clear() {
            this.cache.clear();
        }
    }

    private static class TopologyMetaData {
        private final Map<String, Object> conf;
        private final String topologyId;
        private final AdvancedFSOps ops;
        private final String stormRoot;
        private boolean dataCached = false;
        private List<String> depLocs = null;
        private String stormVersion = null;

        TopologyMetaData(Map<String, Object> conf, String topologyId, AdvancedFSOps ops, String stormRoot) {
            this.conf = conf;
            this.topologyId = topologyId;
            this.ops = ops;
            this.stormRoot = stormRoot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            String stormVersion;
            List<String> data;
            TopologyMetaData topologyMetaData = this;
            synchronized (topologyMetaData) {
                data = this.depLocs;
                stormVersion = this.stormVersion;
            }
            return "META for " + this.topologyId + " DEP_LOCS => " + String.valueOf(data) + " STORM_VERSION => " + stormVersion;
        }

        private synchronized void readData() throws IOException {
            StormTopology stormTopology = ConfigUtils.readSupervisorTopology(this.conf, (String)this.topologyId, (AdvancedFSOps)this.ops);
            ArrayList<String> dependencyLocations = new ArrayList<String>();
            if (stormTopology.get_dependency_jars() != null) {
                for (String dependency : stormTopology.get_dependency_jars()) {
                    dependencyLocations.add(new File(this.stormRoot, dependency).getAbsolutePath());
                }
            }
            if (stormTopology.get_dependency_artifacts() != null) {
                for (String dependency : stormTopology.get_dependency_artifacts()) {
                    dependencyLocations.add(new File(this.stormRoot, dependency).getAbsolutePath());
                }
            }
            this.depLocs = dependencyLocations;
            this.stormVersion = stormTopology.get_storm_version();
            this.dataCached = true;
        }

        public synchronized List<String> getDepLocs() throws IOException {
            if (!this.dataCached) {
                this.readData();
            }
            return this.depLocs;
        }

        public synchronized String getStormVersion() throws IOException {
            if (!this.dataCached) {
                this.readData();
            }
            return this.stormVersion;
        }
    }

    private class ProcessExitCallback
    implements ExitCodeCallback {
        private final String logPrefix;

        ProcessExitCallback(String logPrefix) {
            this.logPrefix = logPrefix;
        }

        public void call(int exitCode) {
            LOG.info("{} exited with code: {}", (Object)this.logPrefix, (Object)exitCode);
            BasicContainer.this.exitedEarly = true;
        }
    }
}

