/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.nimbus;

import java.util.Map;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.InvalidTopologyException;
import org.apache.storm.generated.SpoutSpec;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.nimbus.ITopologyValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTopologyValidator
implements ITopologyValidator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTopologyValidator.class);

    @Override
    public void prepare(Map<String, Object> stormConf) {
    }

    public void validate(String topologyName, Map topologyConf, StormTopology topology) throws InvalidTopologyException {
        if (topologyName.contains(".")) {
            LOG.warn("Metrics for topology name '{}' will be reported as '{}'.", (Object)topologyName, (Object)topologyName.replace('.', '_'));
        }
        Map spouts = topology.get_spouts();
        for (String spoutName : spouts.keySet()) {
            if (spoutName.contains(".")) {
                LOG.warn("Metrics for spout name '{}' will be reported as '{}'.", (Object)spoutName, (Object)spoutName.replace('.', '_'));
            }
            SpoutSpec spoutSpec = (SpoutSpec)spouts.get(spoutName);
            for (String streamName : spoutSpec.get_common().get_streams().keySet()) {
                if (!streamName.contains(".")) continue;
                LOG.warn("Metrics for stream name '{}' will be reported as '{}'.", (Object)streamName, (Object)streamName.replace('.', '_'));
            }
        }
        Map bolts = topology.get_bolts();
        for (String boltName : bolts.keySet()) {
            if (boltName.contains(".")) {
                LOG.warn("Metrics for bolt name '{}' will be reported as '{}'.", (Object)boltName, (Object)boltName.replace('.', '_'));
            }
            Bolt bolt = (Bolt)bolts.get(boltName);
            for (String streamName : bolt.get_common().get_streams().keySet()) {
                if (!streamName.contains(".")) continue;
                LOG.warn("Metrics for stream name '{}' will be reported as '{}'.", (Object)streamName, (Object)streamName.replace('.', '_'));
            }
        }
    }
}

