/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.storm.security.auth.IHttpCredentialsPlugin;
import org.apache.storm.security.auth.ReqContext;
import org.apache.storm.security.auth.SingleUserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpCredentialsPlugin
implements IHttpCredentialsPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpCredentialsPlugin.class);

    @Override
    public void prepare(Map<String, Object> topoConf) {
    }

    @Override
    public String getUserName(HttpServletRequest req) {
        String ret = null;
        if (req != null) {
            Principal princ = req.getUserPrincipal();
            if (princ != null) {
                ret = princ.getName();
            }
            if (ret != null && !ret.isEmpty()) {
                LOG.debug("Get user name {} from http request principal", (Object)ret);
            } else {
                ret = req.getRemoteUser();
                if (ret != null && !ret.isEmpty()) {
                    LOG.debug("Get user name {} from http request remote user", (Object)ret);
                }
            }
        }
        return ret;
    }

    @Override
    public ReqContext populateContext(ReqContext context, HttpServletRequest req) {
        String userName = this.getUserName(req);
        String doAsUser = req.getHeader("doAsUser");
        if (doAsUser == null) {
            doAsUser = req.getParameter("doAsUser");
        }
        if (doAsUser != null) {
            context.setRealPrincipal((Principal)new SingleUserPrincipal(userName));
            userName = doAsUser;
        } else {
            context.setRealPrincipal(null);
        }
        HashSet<SingleUserPrincipal> principals = new HashSet<SingleUserPrincipal>();
        if (userName != null) {
            SingleUserPrincipal p = new SingleUserPrincipal(userName);
            principals.add(p);
        }
        Subject s = new Subject(true, principals, new HashSet(), new HashSet());
        context.setSubject(s);
        return context;
    }
}

