/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.rules.AggregateFilterTransposeRule;
import org.apache.calcite.rel.rules.AggregateProjectMergeRule;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rel.rules.JoinProjectTransposeRule;
import org.apache.calcite.rel.rules.ProjectFilterTransposeRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.StarTable;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mappings;

public class RelOptMaterialization {
    public final RelNode tableRel;
    public final RelOptTable starRelOptTable;
    public final StarTable starTable;
    public final List<String> qualifiedTableName;
    public final RelNode queryRel;

    public RelOptMaterialization(RelNode tableRel, RelNode queryRel, RelOptTable starRelOptTable, List<String> qualifiedTableName) {
        this.tableRel = RelOptUtil.createCastRel(tableRel, queryRel.getRowType(), false);
        this.starRelOptTable = starRelOptTable;
        if (starRelOptTable == null) {
            this.starTable = null;
        } else {
            this.starTable = starRelOptTable.unwrap(StarTable.class);
            assert (this.starTable != null);
        }
        this.qualifiedTableName = qualifiedTableName;
        this.queryRel = queryRel;
    }

    public static RelNode tryUseStar(RelNode rel, final RelOptTable starRelOptTable) {
        final StarTable starTable = starRelOptTable.unwrap(StarTable.class);
        assert (starTable != null);
        RelNode rel2 = rel.accept(new RelShuttleImpl(){

            @Override
            public RelNode visit(TableScan scan) {
                RelOptTable relOptTable = scan.getTable();
                Table table = relOptTable.unwrap(Table.class);
                if (table.equals(starTable.tables.get(0))) {
                    Mappings.TargetMapping mapping = Mappings.createShiftMapping(starRelOptTable.getRowType().getFieldCount(), 0, 0, relOptTable.getRowType().getFieldCount());
                    RelOptCluster cluster = scan.getCluster();
                    RelNode scan2 = starRelOptTable.toRel(RelOptUtil.getContext(cluster));
                    return RelOptUtil.createProject(scan2, Mappings.asList(mapping.inverse()));
                }
                return scan;
            }

            @Override
            public RelNode visit(LogicalJoin join) {
                RelNode rel;
                while ((rel = super.visit(join)) != join && rel instanceof LogicalJoin) {
                    ProjectFilterTable right;
                    join = (LogicalJoin)rel;
                    ProjectFilterTable left = ProjectFilterTable.of(join.getLeft());
                    if (left == null || (right = ProjectFilterTable.of(join.getRight())) == null) continue;
                    try {
                        this.match(left, right, join.getCluster());
                    }
                    catch (Util.FoundOne e) {
                        return (RelNode)e.getNode();
                    }
                }
                return rel;
            }

            private void match(ProjectFilterTable left, ProjectFilterTable right, RelOptCluster cluster) {
                Mappings.TargetMapping leftMapping = left.mapping();
                Mappings.TargetMapping rightMapping = right.mapping();
                RelOptTable leftRelOptTable = left.getTable();
                Table leftTable = leftRelOptTable.unwrap(Table.class);
                int leftCount = leftRelOptTable.getRowType().getFieldCount();
                RelOptTable rightRelOptTable = right.getTable();
                Table rightTable = rightRelOptTable.unwrap(Table.class);
                if (leftTable instanceof StarTable && ((StarTable)leftTable).tables.contains((Object)rightTable)) {
                    int offset = ((StarTable)leftTable).columnOffset(rightTable);
                    Mappings.TargetMapping mapping = Mappings.merge(leftMapping, Mappings.offsetTarget(Mappings.offsetSource(rightMapping, offset), leftMapping.getTargetCount()));
                    RelNode project = RelOptUtil.createProject((RelNode)LogicalTableScan.create(cluster, leftRelOptTable), Mappings.asList(mapping.inverse()));
                    ArrayList conditions = Lists.newArrayList();
                    if (left.condition != null) {
                        conditions.add(left.condition);
                    }
                    if (right.condition != null) {
                        conditions.add(RexUtil.apply(mapping, RexUtil.shift(right.condition, offset)));
                    }
                    RelNode filter = RelOptUtil.createFilter(project, conditions);
                    throw new Util.FoundOne(filter);
                }
                if (rightTable instanceof StarTable && ((StarTable)rightTable).tables.contains((Object)leftTable)) {
                    int offset = ((StarTable)rightTable).columnOffset(leftTable);
                    Mappings.TargetMapping mapping = Mappings.merge(Mappings.offsetSource(leftMapping, offset), Mappings.offsetTarget(rightMapping, leftCount));
                    RelNode project = RelOptUtil.createProject((RelNode)LogicalTableScan.create(cluster, rightRelOptTable), Mappings.asList(mapping.inverse()));
                    ArrayList conditions = Lists.newArrayList();
                    if (left.condition != null) {
                        conditions.add(RexUtil.apply(mapping, RexUtil.shift(left.condition, offset)));
                    }
                    if (right.condition != null) {
                        conditions.add(RexUtil.apply(mapping, right.condition));
                    }
                    RelNode filter = RelOptUtil.createFilter(project, conditions);
                    throw new Util.FoundOne(filter);
                }
            }
        });
        if (rel2 == rel) {
            return null;
        }
        Program program = Programs.hep((Iterable<? extends RelOptRule>)ImmutableList.of((Object)ProjectFilterTransposeRule.INSTANCE, (Object)AggregateProjectMergeRule.INSTANCE, (Object)AggregateFilterTransposeRule.INSTANCE), false, DefaultRelMetadataProvider.INSTANCE);
        return program.run(null, rel2, null, (List<RelOptMaterialization>)ImmutableList.of(), (List<RelOptLattice>)ImmutableList.of());
    }

    public static RelNode toLeafJoinForm(RelNode rel) {
        Program program = Programs.hep((Iterable<? extends RelOptRule>)ImmutableList.of((Object)JoinProjectTransposeRule.RIGHT_PROJECT, (Object)JoinProjectTransposeRule.LEFT_PROJECT, (Object)FilterJoinRule.FilterIntoJoinRule.FILTER_ON_JOIN, (Object)ProjectRemoveRule.INSTANCE, (Object)ProjectMergeRule.INSTANCE), false, DefaultRelMetadataProvider.INSTANCE);
        if (CalcitePrepareImpl.DEBUG) {
            System.out.println(RelOptUtil.dumpPlan("before", rel, SqlExplainFormat.TEXT, SqlExplainLevel.DIGEST_ATTRIBUTES));
        }
        RelNode rel2 = program.run(null, rel, null, (List<RelOptMaterialization>)ImmutableList.of(), (List<RelOptLattice>)ImmutableList.of());
        if (CalcitePrepareImpl.DEBUG) {
            System.out.println(RelOptUtil.dumpPlan("after", rel2, SqlExplainFormat.TEXT, SqlExplainLevel.DIGEST_ATTRIBUTES));
        }
        return rel2;
    }

    private static class ProjectFilterTable {
        final RexNode condition;
        final Mappings.TargetMapping mapping;
        final TableScan scan;

        private ProjectFilterTable(RexNode condition, Mappings.TargetMapping mapping, TableScan scan) {
            this.condition = condition;
            this.mapping = mapping;
            this.scan = (TableScan)Preconditions.checkNotNull((Object)scan);
        }

        static ProjectFilterTable of(RelNode node) {
            if (node instanceof Filter) {
                Filter filter = (Filter)node;
                return ProjectFilterTable.of2(filter.getCondition(), filter.getInput());
            }
            return ProjectFilterTable.of2(null, node);
        }

        private static ProjectFilterTable of2(RexNode condition, RelNode node) {
            if (node instanceof Project) {
                Project project = (Project)node;
                return ProjectFilterTable.of3(condition, project.getMapping(), project.getInput());
            }
            return ProjectFilterTable.of3(condition, null, node);
        }

        private static ProjectFilterTable of3(RexNode condition, Mappings.TargetMapping mapping, RelNode node) {
            if (node instanceof TableScan) {
                return new ProjectFilterTable(condition, mapping, (TableScan)node);
            }
            return null;
        }

        public Mappings.TargetMapping mapping() {
            return this.mapping != null ? this.mapping : Mappings.createIdentity(this.scan.getRowType().getFieldCount());
        }

        public RelOptTable getTable() {
            return this.scan.getTable();
        }
    }
}

