/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.protobuf;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteBufferWriter;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteInput;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteOutput;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.RopeByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.Utf8;

final class ByteInputByteString
extends ByteString.LeafByteString {
    private final ByteInput buffer;
    private final int offset;
    private final int length;

    ByteInputByteString(ByteInput buffer, int offset, int length) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    private Object writeReplace() {
        return ByteString.wrap(this.toByteArray());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new InvalidObjectException("ByteInputByteString instances are not to be serialized directly");
    }

    @Override
    public byte byteAt(int index) {
        return this.buffer.read(this.getAbsoluteOffset(index));
    }

    @Override
    byte internalByteAt(int index) {
        return this.buffer.read(this.getAbsoluteOffset(index));
    }

    private int getAbsoluteOffset(int relativeOffset) {
        return this.offset + relativeOffset;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public ByteString substring(int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex >= this.size() || endIndex < beginIndex || endIndex >= this.size()) {
            throw new IllegalArgumentException(String.format("Invalid indices [%d, %d]", beginIndex, endIndex));
        }
        return new ByteInputByteString(this.buffer, this.getAbsoluteOffset(beginIndex), endIndex - beginIndex);
    }

    @Override
    protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        this.buffer.read(this.getAbsoluteOffset(sourceOffset), target, targetOffset, numberToCopy);
    }

    @Override
    public void copyTo(ByteBuffer target) {
        this.buffer.read(this.offset, target);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.toByteArray());
    }

    @Override
    boolean equalsRange(ByteString other, int offset, int length) {
        return this.substring(0, length).equals(other.substring(offset, offset + length));
    }

    @Override
    void writeToInternal(OutputStream out, int sourceOffset, int numberToWrite) throws IOException {
        byte[] buf = ByteBufferWriter.getOrCreateBuffer(numberToWrite);
        this.buffer.read(this.getAbsoluteOffset(sourceOffset), buf, 0, numberToWrite);
        out.write(buf, 0, numberToWrite);
    }

    @Override
    void writeTo(ByteOutput output) throws IOException {
        output.writeLazy(this.toByteArray(), 0, this.length);
    }

    @Override
    public ByteBuffer asReadOnlyByteBuffer() {
        return ByteBuffer.wrap(this.toByteArray()).asReadOnlyBuffer();
    }

    @Override
    public List<ByteBuffer> asReadOnlyByteBufferList() {
        return Collections.singletonList(this.asReadOnlyByteBuffer());
    }

    @Override
    protected String toStringInternal(Charset charset) {
        byte[] bytes = this.toByteArray();
        return new String(bytes, 0, bytes.length, charset);
    }

    @Override
    public boolean isValidUtf8() {
        return Utf8.isValidUtf8(this.buffer, this.offset, this.offset + this.length);
    }

    @Override
    protected int partialIsValidUtf8(int state, int offset, int length) {
        int off = this.getAbsoluteOffset(offset);
        return Utf8.partialIsValidUtf8(state, this.buffer, off, off + length);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ByteString)) {
            return false;
        }
        ByteString otherString = (ByteString)other;
        if (this.size() != otherString.size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        if (other instanceof RopeByteString) {
            return other.equals(this);
        }
        return Arrays.equals(this.toByteArray(), otherString.toByteArray());
    }

    @Override
    protected int partialHash(int h, int offset, int length) {
        offset = this.getAbsoluteOffset(offset);
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            h = h * 31 + this.buffer.read(i);
        }
        return h;
    }

    @Override
    public InputStream newInput() {
        return new InputStream(){
            private final ByteInput buf;
            private int pos;
            private int limit;
            private int mark;
            {
                this.buf = ByteInputByteString.this.buffer;
                this.pos = ByteInputByteString.this.offset;
                this.limit = this.pos + ByteInputByteString.this.length;
                this.mark = this.pos;
            }

            @Override
            public void mark(int readlimit) {
                this.mark = readlimit;
            }

            @Override
            public boolean markSupported() {
                return true;
            }

            @Override
            public void reset() throws IOException {
                this.pos = this.mark;
            }

            @Override
            public int available() throws IOException {
                return this.limit - this.pos;
            }

            @Override
            public int read() throws IOException {
                if (this.available() <= 0) {
                    return -1;
                }
                return this.buf.read(this.pos++) & 0xFF;
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                int remain = this.available();
                if (remain <= 0) {
                    return -1;
                }
                len = Math.min(len, remain);
                this.buf.read(this.pos, bytes, off, len);
                this.pos += len;
                return len;
            }
        };
    }

    @Override
    public CodedInputStream newCodedInput() {
        CodedInputStream cis = CodedInputStream.newInstance(this.buffer, this.offset, this.length, true);
        cis.enableAliasing(true);
        return cis;
    }
}

