/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime.serde.avro;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.storm.sql.runtime.IOutputSerializer;
import org.apache.storm.sql.runtime.serde.avro.CachedSchemas;

public class AvroSerializer
implements IOutputSerializer,
Serializable {
    private final String schemaString;
    private final List<String> fieldNames;
    private final CachedSchemas schemas;

    public AvroSerializer(String schemaString, List<String> fieldNames) {
        this.schemaString = schemaString;
        this.fieldNames = fieldNames;
        this.schemas = new CachedSchemas();
    }

    @Override
    public ByteBuffer write(List<Object> data, ByteBuffer buffer) {
        Preconditions.checkArgument((data != null && data.size() == this.fieldNames.size() ? 1 : 0) != 0, (Object)"Invalid schemas");
        try {
            Schema schema = this.schemas.getSchema(this.schemaString);
            GenericData.Record record = new GenericData.Record(schema);
            for (int i = 0; i < this.fieldNames.size(); ++i) {
                record.put(this.fieldNames.get(i), data.get(i));
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GenericDatumWriter writer = new GenericDatumWriter(record.getSchema());
            BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)out, null);
            writer.write((Object)record, (Encoder)encoder);
            encoder.flush();
            byte[] bytes = out.toByteArray();
            out.close();
            return ByteBuffer.wrap(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

