/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.io.netty.channel.uring;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.StringJoiner;
import org.apache.storm.shade.io.netty.channel.uring.CompletionCallback;

final class CompletionQueue {
    private static final VarHandle INT_HANDLE = MethodHandles.byteBufferViewVarHandle(int[].class, ByteOrder.nativeOrder());
    private static final int CQE_USER_DATA_FIELD = 0;
    private static final int CQE_RES_FIELD = 8;
    private static final int CQE_FLAGS_FIELD = 12;
    static final int CQE_SIZE = 16;
    private final ByteBuffer khead;
    private final ByteBuffer ktail;
    private final ByteBuffer completionQueueArray;
    final int ringSize;
    final long ringAddress;
    final int ringFd;
    final int ringEntries;
    final int ringCapacity;
    private final int ringMask;
    private int ringHead;
    private boolean closed;

    CompletionQueue(ByteBuffer kHead, ByteBuffer kTail, int ringMask, int ringEntries, ByteBuffer completionQueueArray, int ringSize, long ringAddress, int ringFd, int ringCapacity) {
        this.khead = kHead;
        this.ktail = kTail;
        this.completionQueueArray = completionQueueArray;
        this.ringSize = ringSize;
        this.ringAddress = ringAddress;
        this.ringFd = ringFd;
        this.ringCapacity = ringCapacity;
        this.ringEntries = ringEntries;
        this.ringMask = ringMask;
        this.ringHead = INT_HANDLE.getVolatile(kHead, 0);
    }

    void close() {
        this.closed = true;
    }

    boolean hasCompletions() {
        return !this.closed && this.ringHead != INT_HANDLE.getVolatile(this.ktail, 0);
    }

    int count() {
        if (this.closed) {
            return 0;
        }
        return INT_HANDLE.getVolatile(this.ktail, 0) - this.ringHead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int process(CompletionCallback callback) {
        if (this.closed) {
            return 0;
        }
        int tail = INT_HANDLE.getVolatile(this.ktail, 0);
        try {
            int i = 0;
            while (this.ringHead != tail) {
                int cqePosition = CompletionQueue.cqeIdx(this.ringHead, this.ringMask);
                long udata = this.completionQueueArray.getLong(cqePosition + 0);
                int res = this.completionQueueArray.getInt(cqePosition + 8);
                int flags = this.completionQueueArray.getInt(cqePosition + 12);
                ++this.ringHead;
                ++i;
                if (!callback.handle(res, flags, udata)) break;
                if (this.ringHead != tail) continue;
                tail = INT_HANDLE.getVolatile(this.ktail, 0);
            }
            int n = i;
            return n;
        }
        finally {
            INT_HANDLE.setRelease(this.khead, 0, this.ringHead);
        }
    }

    public String toString() {
        StringJoiner sb = new StringJoiner(", ", "CompletionQueue [", "]");
        if (this.closed) {
            sb.add("closed");
        } else {
            int tail = INT_HANDLE.getVolatile(this.ktail, 0);
            int head = this.ringHead;
            while (head != tail) {
                int cqePosition = CompletionQueue.cqeIdx(head++, this.ringMask);
                long udata = this.completionQueueArray.getLong(cqePosition + 0);
                int res = this.completionQueueArray.getInt(cqePosition + 8);
                int flags = this.completionQueueArray.getInt(cqePosition + 12);
                sb.add("(res=" + res).add(", flags=" + flags).add(", udata=" + udata).add(")");
            }
        }
        return sb.toString();
    }

    private static int cqeIdx(int ringHead, int ringMask) {
        return (ringHead & ringMask) * 16;
    }
}

