/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.storm.metric.api.IMetricsConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPointExpander
implements Serializable {
    public static final Logger LOG = LoggerFactory.getLogger(DataPointExpander.class);
    private final boolean expandMapType;
    private final String metricNameSeparator;

    public DataPointExpander(boolean expandMapType, String metricNameSeparator) {
        this.expandMapType = expandMapType;
        this.metricNameSeparator = metricNameSeparator;
    }

    public Collection<IMetricsConsumer.DataPoint> expandDataPoints(Collection<IMetricsConsumer.DataPoint> dataPoints) {
        if (!this.expandMapType) {
            return dataPoints;
        }
        ArrayList<IMetricsConsumer.DataPoint> expandedDataPoints = new ArrayList<IMetricsConsumer.DataPoint>();
        for (IMetricsConsumer.DataPoint dataPoint : dataPoints) {
            expandedDataPoints.addAll(this.expandDataPoint(dataPoint));
        }
        return expandedDataPoints;
    }

    public Collection<IMetricsConsumer.DataPoint> expandDataPoint(IMetricsConsumer.DataPoint dataPoint) {
        if (!this.expandMapType) {
            return Collections.singletonList(dataPoint);
        }
        ArrayList<IMetricsConsumer.DataPoint> dataPoints = new ArrayList<IMetricsConsumer.DataPoint>();
        if (dataPoint.value == null) {
            LOG.warn("Data point with name {} is null. Discarding.", (Object)dataPoint.name);
        } else if (dataPoint.value instanceof Map) {
            Map dataMap = (Map)dataPoint.value;
            for (Map.Entry entry : dataMap.entrySet()) {
                String expandedDataPointName = dataPoint.name + this.metricNameSeparator + String.valueOf(entry.getKey());
                dataPoints.add(new IMetricsConsumer.DataPoint(expandedDataPointName, entry.getValue()));
            }
        } else {
            dataPoints.add(dataPoint);
        }
        return dataPoints;
    }
}

