/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident;

import org.apache.storm.generated.SharedMemory;
import org.apache.storm.topology.ResourceDeclarer;
import org.apache.storm.trident.Stream;
import org.apache.storm.trident.TridentTopology;
import org.apache.storm.trident.planner.Node;

public class TridentState
implements ResourceDeclarer<TridentState> {
    TridentTopology topology;
    Node node;

    protected TridentState(TridentTopology topology, Node node) {
        this.topology = topology;
        this.node = node;
    }

    public Stream newValuesStream() {
        return new Stream(this.topology, this.node.name, this.node);
    }

    public TridentState parallelismHint(int parallelism) {
        this.node.parallelismHint = parallelism;
        return this;
    }

    @Override
    public TridentState setCPULoad(Number load) {
        this.node.setCPULoad(load);
        return this;
    }

    @Override
    public TridentState setMemoryLoad(Number onHeap) {
        this.node.setMemoryLoad(onHeap);
        return this;
    }

    @Override
    public TridentState setMemoryLoad(Number onHeap, Number offHeap) {
        this.node.setMemoryLoad(onHeap, offHeap);
        return this;
    }

    @Override
    public TridentState addSharedMemory(SharedMemory request) {
        this.node.addSharedMemory(request);
        return this;
    }
}

