/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.LinkedList;
import java.util.List;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.utils.TupleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchHelper {
    private static final Logger LOG = LoggerFactory.getLogger(BatchHelper.class);
    private int batchSize = 15000;
    private List<Tuple> tupleBatch;
    private boolean forceFlush = false;
    private OutputCollector collector;

    public BatchHelper(int batchSize, OutputCollector collector) {
        if (batchSize > 0) {
            this.batchSize = batchSize;
        }
        this.collector = collector;
        this.tupleBatch = new LinkedList<Tuple>();
    }

    public void fail(Exception e) {
        this.collector.reportError(e);
        for (Tuple t : this.tupleBatch) {
            this.collector.fail(t);
        }
        this.tupleBatch.clear();
        this.forceFlush = false;
    }

    public void ack() {
        for (Tuple t : this.tupleBatch) {
            this.collector.ack(t);
        }
        this.tupleBatch.clear();
        this.forceFlush = false;
    }

    public boolean shouldHandle(Tuple tuple) {
        if (TupleUtils.isTick(tuple)) {
            LOG.debug("TICK received! current batch status [{}/{}]", (Object)this.tupleBatch.size(), (Object)this.batchSize);
            this.forceFlush = true;
            return false;
        }
        return true;
    }

    public void addBatch(Tuple tuple) {
        this.tupleBatch.add(tuple);
        if (this.tupleBatch.size() >= this.batchSize) {
            this.forceFlush = true;
        }
    }

    public List<Tuple> getBatchTuples() {
        return this.tupleBatch;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean shouldFlush() {
        return this.forceFlush && !this.tupleBatch.isEmpty();
    }
}

