/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.windowing.persistence;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.storm.windowing.persistence.WindowPartitionCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleWindowPartitionCache<K, V>
implements WindowPartitionCache<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleWindowPartitionCache.class);
    private final ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap();
    private final Map<K, Long> pinned = new HashMap<K, Long>();
    private final long maximumSize;
    private final WindowPartitionCache.RemovalListener<K, V> removalListener;
    private final WindowPartitionCache.CacheLoader<K, V> cacheLoader;
    private final ReentrantLock lock = new ReentrantLock(true);
    private int size;

    private SimpleWindowPartitionCache(long maximumSize, WindowPartitionCache.RemovalListener<K, V> removalListener, WindowPartitionCache.CacheLoader<K, V> cacheLoader) {
        if (maximumSize <= 0L) {
            throw new IllegalArgumentException("maximumSize must be greater than 0");
        }
        Objects.requireNonNull(cacheLoader);
        this.maximumSize = maximumSize;
        this.removalListener = removalListener;
        this.cacheLoader = cacheLoader;
    }

    public static <K, V> SimpleWindowPartitionCacheBuilder<K, V> newBuilder() {
        return new SimpleWindowPartitionCacheBuilder();
    }

    @Override
    public V get(K key) {
        return this.getOrLoad(key, false);
    }

    @Override
    public V pinAndGet(K key) {
        return this.getOrLoad(key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unpin(K key) {
        LOG.debug("unpin '{}'", key);
        boolean res = false;
        try {
            this.lock.lock();
            Long val = this.pinned.computeIfPresent(key, (k, v) -> v - 1L);
            if (val != null) {
                if (val <= 0L) {
                    this.pinned.remove(key);
                }
                res = true;
            }
        }
        finally {
            this.lock.unlock();
        }
        LOG.debug("pinned '{}'", this.pinned);
        return res;
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        return this.map;
    }

    @Override
    public void invalidate(K key) {
        try {
            this.lock.lock();
            if (this.isPinned(key)) {
                LOG.debug("Entry '{}' is pinned, skipping invalidation", key);
            } else {
                LOG.debug("Invalidating entry '{}'", key);
                V val = this.map.remove(key);
                if (val != null) {
                    --this.size;
                    this.pinned.remove(key);
                    if (this.removalListener != null) {
                        this.removalListener.onRemoval(key, val, WindowPartitionCache.RemovalCause.EXPLICIT);
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getOrLoad(K key, boolean shouldPin) {
        V val;
        if (shouldPin) {
            try {
                this.lock.lock();
                val = this.load(key);
                this.pin(key);
            }
            finally {
                this.lock.unlock();
            }
        }
        val = this.map.get(key);
        if (val == null) {
            try {
                this.lock.lock();
                val = this.load(key);
            }
            finally {
                this.lock.unlock();
            }
        }
        return val;
    }

    private V load(K key) {
        V val = this.map.get(key);
        if (val == null) {
            val = this.cacheLoader.load(key);
            if (val == null) {
                throw new NullPointerException("Null value for key " + String.valueOf(key));
            }
            this.ensureCapacity();
            this.map.put(key, val);
            ++this.size;
        }
        return val;
    }

    private void ensureCapacity() {
        if ((long)this.size >= this.maximumSize) {
            Iterator it = this.map.descendingMap().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry next = it.next();
                if (this.isPinned(next.getKey())) continue;
                it.remove();
                if (this.removalListener != null) {
                    this.removalListener.onRemoval(next.getKey(), next.getValue(), WindowPartitionCache.RemovalCause.REPLACED);
                }
                --this.size;
                break;
            }
        }
    }

    private void pin(K key) {
        LOG.debug("pin '{}'", key);
        this.pinned.compute(key, (k, v) -> v == null ? 1L : v + 1L);
        LOG.debug("pinned '{}'", this.pinned);
    }

    private boolean isPinned(K key) {
        return this.pinned.getOrDefault(key, 0L) > 0L;
    }

    public static class SimpleWindowPartitionCacheBuilder<K, V>
    implements WindowPartitionCache.Builder<K, V> {
        private long maximumSize;
        private WindowPartitionCache.RemovalListener<K, V> removalListener;

        @Override
        public SimpleWindowPartitionCacheBuilder<K, V> maximumSize(long size) {
            this.maximumSize = size;
            return this;
        }

        @Override
        public SimpleWindowPartitionCacheBuilder<K, V> removalListener(WindowPartitionCache.RemovalListener<K, V> listener) {
            this.removalListener = listener;
            return this;
        }

        @Override
        public SimpleWindowPartitionCache<K, V> build(WindowPartitionCache.CacheLoader<K, V> loader) {
            return new SimpleWindowPartitionCache<K, V>(this.maximumSize, this.removalListener, loader);
        }
    }
}

