/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor.timer;

import java.util.Map;
import org.apache.storm.daemon.supervisor.Supervisor;
import org.apache.storm.healthcheck.HealthChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupervisorHealthCheck
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SupervisorHealthCheck.class);
    private final Supervisor supervisor;

    public SupervisorHealthCheck(Supervisor supervisor) {
        this.supervisor = supervisor;
    }

    @Override
    public void run() {
        Map<String, Object> conf = this.supervisor.getConf();
        LOG.info("Running supervisor healthchecks...");
        int healthCode = HealthChecker.healthCheck(conf, this.supervisor.getMetricsRegistry());
        if (healthCode != 0) {
            LOG.info("The supervisor healthchecks FAILED...");
            this.supervisor.shutdownAllWorkers(null, null);
            throw new RuntimeException("Supervisor failed health check. Exiting.");
        }
    }
}

